/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EStructuralFeatureTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeproxyFactory;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedContentProviderFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.TreeElementAdapter;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerListener;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedTreeContentProvider
implements ICustomizedTreeContentProvider {
    private final ICustomizationManager customManager;
    private final IContentPropertiesHandler contentHandler;
    private Object previousInput;
    private Object[] rootElements = new Object[0];
    private final List<TreeElementAdapter> adapters = new ArrayList<TreeElementAdapter>();
    private ICustomizedContentProviderFactory.IContentListener contentListener;

    public CustomizedTreeContentProvider(ICustomizationManager customManager, ICustomizedContentProviderFactory.IContentListener contentListener) {
        this.customManager = customManager;
        this.customManager.getFacetManager().addListener(new IFacetManagerListener(){

            public void facetManagerChanged() {
                CustomizedTreeContentProvider.this.dispose();
            }
        });
        this.contentHandler = IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(customManager);
        this.contentListener = contentListener;
    }

    private static Object[] getRootElements(Object inputElement) {
        Object[] result;
        if (inputElement == null) {
            result = new Object[]{};
        } else if (inputElement instanceof EObject) {
            result = new EObject[]{(EObject)inputElement};
        } else if (inputElement instanceof Collection) {
            result = ((Collection)inputElement).toArray();
        } else if (inputElement instanceof EObject[]) {
            result = (EObject[])inputElement;
        } else {
            throw new IllegalArgumentException("Unhandled input element type: " + inputElement.getClass().getSimpleName());
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (this.previousInput == inputElement) {
            result = this.rootElements;
        } else {
            this.previousInput = inputElement;
            Object[] elements = CustomizedTreeContentProvider.getRootElements(inputElement);
            ArrayList<Object> elementList = new ArrayList<Object>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.isVisible(element, null)) {
                    if (element instanceof EObject) {
                        EObjectTreeElement eObjectProxy = this.createEObjectProxy(element, null);
                        elementList.add(eObjectProxy);
                    } else {
                        elementList.add(element);
                    }
                }
                ++n2;
            }
            result = elementList.toArray();
            this.rootElements = result;
        }
        return result;
    }

    protected EObjectTreeElement createEObjectProxy(Object element, TreeElement parent) {
        EObject eObject = (EObject)element;
        EObjectTreeElement eObjectProxy = TreeproxyFactory.eINSTANCE.createEObjectTreeElement();
        eObjectProxy.setEObject(eObject);
        eObjectProxy.setParent(parent);
        TreeElementAdapter adapter = new TreeElementAdapter(eObjectProxy, this.contentListener);
        eObject.eAdapters().add((Object)adapter);
        this.adapters.add(adapter);
        return eObjectProxy;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = null;
        if (parentElement == null) {
            result = new Object[]{};
        } else if (parentElement instanceof TreeElement) {
            TreeElement treeElt = (TreeElement)parentElement;
            if (parentElement instanceof EAttributeTreeElement) {
                EAttributeTreeElement attributeProxy = (EAttributeTreeElement)parentElement;
                result = this.getChildren(attributeProxy);
            } else {
                EList cachedChildren = treeElt.getChildren();
                if (cachedChildren == null || cachedChildren.isEmpty()) {
                    if (parentElement instanceof EObjectTreeElement) {
                        EObjectTreeElement eObjectProxy = (EObjectTreeElement)parentElement;
                        result = this.filter(this.getChildren(eObjectProxy));
                    } else if (parentElement instanceof EReferenceTreeElement) {
                        EReferenceTreeElement referenceProxy = (EReferenceTreeElement)parentElement;
                        result = this.filter(this.getChildren(referenceProxy));
                    }
                } else {
                    result = this.filter((List<? extends TreeElement>)cachedChildren);
                }
            }
        }
        if (result == null) {
            Class<?> unexpectedClass = parentElement.getClass();
            Logger.logError((String)("Unknown element in tree: " + unexpectedClass), (Plugin)Activator.getDefault());
            result = new Object[]{};
        }
        return result;
    }

    private Object[] filter(List<? extends TreeElement> notFilteredResult) {
        ArrayList<TreeElement> filteredChildren = new ArrayList<TreeElement>();
        for (TreeElement treeElement : notFilteredResult) {
            EObject eObject = null;
            EStructuralFeature eStructFeature = null;
            if (treeElement instanceof EStructuralFeatureTreeElement) {
                EStructuralFeatureTreeElement sfTreeElt = (EStructuralFeatureTreeElement)treeElement;
                eObject = ((EObjectTreeElement)sfTreeElt.getParent()).getEObject();
                eStructFeature = sfTreeElt.getEStructuralFeature();
            } else if (treeElement instanceof EObjectTreeElement) {
                EObjectTreeElement eObjTreeElt = (EObjectTreeElement)treeElement;
                eObject = eObjTreeElt.getEObject();
            }
            if (!this.isVisible(eObject, (ETypedElement)eStructFeature)) continue;
            filteredChildren.add(treeElement);
        }
        return filteredChildren.toArray();
    }

    private List<TreeElement> getChildren(EObjectTreeElement treeElement) {
        Object children = treeElement.getChildren();
        children.clear();
        List<ETypedElement> customChildren = this.getCustomChildren(treeElement.getEObject(), null);
        if (customChildren == null) {
            children = new ArrayList();
            children.addAll(this.createAttributes(treeElement));
            children.addAll(this.createReferences(treeElement));
        } else {
            for (ETypedElement customChild : customChildren) {
                if (customChild instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)customChild;
                    children.add(CustomizedTreeContentProvider.createAttributeProxy(eAttribute, treeElement));
                    continue;
                }
                if (!(customChild instanceof EReference)) continue;
                EReference eReference = (EReference)customChild;
                children.addAll(this.getReferenceChildren((TreeElement)treeElement, eReference, treeElement.getEObject()));
            }
        }
        return children;
    }

    public Object[] getChildren(EAttributeTreeElement attributeProxy) {
        ArrayList<Object> children = new ArrayList<Object>();
        EAttribute eAttribute = attributeProxy.getEAttribute();
        if (eAttribute.isMany()) {
            TreeElement parent = attributeProxy.getParent();
            if (!(parent instanceof EObjectTreeElement)) {
                throw new IllegalStateException("An attribute should appear only under a model element");
            }
            EObjectTreeElement parentProxy = (EObjectTreeElement)parent;
            EObject eObject = parentProxy.getEObject();
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eAttribute, null);
                for (Object object : result) {
                    if (object instanceof EObject) {
                        EObject childEObject = (EObject)object;
                        children.add(this.createEObjectProxy(childEObject, (TreeElement)attributeProxy));
                    }
                    children.add(object);
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return children.toArray();
    }

    public List<? extends TreeElement> getChildren(EReferenceTreeElement referenceProxy) {
        EReference eReference = referenceProxy.getEReference();
        TreeElement parent = referenceProxy.getParent();
        if (!(parent instanceof EObjectTreeElement)) {
            throw new IllegalStateException("A reference should appear only under a model element");
        }
        EObjectTreeElement parentProxy = (EObjectTreeElement)parent;
        EObject eObject = parentProxy.getEObject();
        List<? extends TreeElement> result = this.getReferenceChildren((TreeElement)referenceProxy, eReference, eObject);
        return result;
    }

    private List<? extends TreeElement> getReferenceChildren(TreeElement parent, EReference eReference, EObject eObject) {
        EObjectTreeElement child;
        List<Object> result = eReference.isMany() ? this.getMultiValuedReferenceChildren(eReference, eObject, parent) : ((child = this.getSingleValuedReferenceChild(eReference, eObject, parent)) == null ? Collections.emptyList() : Collections.singletonList(child));
        return result;
    }

    private EObjectTreeElement getSingleValuedReferenceChild(EReference eReference, EObject eObject, TreeElement parent) {
        EObjectTreeElement child = null;
        try {
            IFacetManager facetManager = this.customManager.getFacetManager();
            EObject referedEObject = (EObject)facetManager.getOrInvoke(eObject, (ETypedElement)eReference, EObject.class);
            if (referedEObject != null) {
                child = this.createEObjectProxy(referedEObject, parent);
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return child;
    }

    private List<EObjectTreeElement> getMultiValuedReferenceChildren(EReference eReference, EObject eObject, TreeElement parent) {
        ArrayList<EObjectTreeElement> children = new ArrayList<EObjectTreeElement>();
        try {
            IFacetManager facetManager = this.customManager.getFacetManager();
            List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eReference, null);
            for (Object object : result) {
                if (!(object instanceof EObject)) continue;
                EObject childEObject = (EObject)object;
                children.add(this.createEObjectProxy(childEObject, parent));
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return children;
    }

    private Collection<EAttributeTreeElement> createAttributes(EObjectTreeElement treeElement) {
        EObject eObject = treeElement.getEObject();
        EClass eClass = eObject.eClass();
        IFacetManager facetManager = this.customManager.getFacetManager();
        ArrayList<EAttribute> allAttributes = new ArrayList<EAttribute>();
        allAttributes.addAll((Collection<EAttribute>)eClass.getEAllAttributes());
        try {
            Set facetAttributes = FacetUtils.getETypedElements((EObject)eObject, EAttribute.class, (IFacetManager)facetManager);
            allAttributes.addAll(facetAttributes);
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return CustomizedTreeContentProvider.createAttributeProxies(allAttributes, treeElement);
    }

    private static Collection<EAttributeTreeElement> createAttributeProxies(List<EAttribute> allAttributes, EObjectTreeElement parent) {
        ArrayList<EAttributeTreeElement> result = new ArrayList<EAttributeTreeElement>();
        for (EAttribute eAttribute : allAttributes) {
            result.add(CustomizedTreeContentProvider.createAttributeProxy(eAttribute, parent));
        }
        return result;
    }

    private static EAttributeTreeElement createAttributeProxy(EAttribute eAttribute, EObjectTreeElement parent) {
        EAttributeTreeElement attributeProxy = TreeproxyFactory.eINSTANCE.createEAttributeTreeElement();
        attributeProxy.setEStructuralFeature((EStructuralFeature)eAttribute);
        attributeProxy.setParent((TreeElement)parent);
        return attributeProxy;
    }

    private Collection<EReferenceTreeElement> createReferences(EObjectTreeElement treeElement) {
        EObject eObject = treeElement.getEObject();
        EClass eClass = eObject.eClass();
        IFacetManager facetManager = this.customManager.getFacetManager();
        ArrayList<EReference> allReferences = new ArrayList<EReference>();
        allReferences.addAll((Collection<EReference>)eClass.getEAllReferences());
        try {
            Set facetReferences = FacetUtils.getETypedElements((EObject)eObject, EReference.class, (IFacetManager)facetManager);
            allReferences.addAll(facetReferences);
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return CustomizedTreeContentProvider.createReferenceProxies(allReferences, treeElement);
    }

    private static Collection<EReferenceTreeElement> createReferenceProxies(List<EReference> allReferences, EObjectTreeElement parent) {
        ArrayList<EReferenceTreeElement> result = new ArrayList<EReferenceTreeElement>();
        for (EReference eReference : allReferences) {
            EReferenceTreeElement referenceProxy = TreeproxyFactory.eINSTANCE.createEReferenceTreeElement();
            referenceProxy.setEStructuralFeature((EStructuralFeature)eReference);
            referenceProxy.setParent((TreeElement)parent);
            result.add(referenceProxy);
        }
        return result;
    }

    public Object getParent(Object element) {
        EObject result = null;
        if (element instanceof TreeElement) {
            TreeElement treeElement = (TreeElement)element;
            result = treeElement.eContainer();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
        List<Object> rootList = Arrays.asList(this.rootElements);
        Collection<TreeElementAdapter> adaptersCopy = Collections.unmodifiableCollection(this.adapters);
        for (TreeElementAdapter adapter : adaptersCopy) {
            EObjectTreeElement treeElement = adapter.getTreeElement();
            if (!rootList.contains(treeElement)) {
                Notifier target = adapter.getTarget();
                EList eAdapters = target.eAdapters();
                eAdapters.remove((Object)adapter);
            }
            treeElement.getChildren().clear();
        }
        Object[] objectArray = this.rootElements;
        int n = this.rootElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object rootElt = objectArray[n2];
            this.contentListener.onUpdate(rootElt);
            ++n2;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null || !newInput.equals(newInput)) {
            this.dispose();
        }
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    public boolean isVisible(Object object, ETypedElement eTypedElement) {
        Boolean result = Boolean.TRUE;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                result = (Boolean)this.customManager.getCustomValueOf(eObject, eTypedElement, this.contentHandler.getIsVisible(), Boolean.class);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public List<ETypedElement> getCustomChildren(Object object, ETypedElement eTypedElement) {
        ArrayList<ETypedElement> result = null;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                List tmpresult = (List)this.customManager.getCustomValueOf(eObject, eTypedElement, this.contentHandler.getChildren(), List.class);
                if (tmpresult != null && !tmpresult.isEmpty()) {
                    result = new ArrayList<ETypedElement>();
                    for (Object tmpObject : tmpresult) {
                        if (!(tmpObject instanceof ETypedElement)) continue;
                        ETypedElement resultElt = (ETypedElement)tmpObject;
                        result.add(resultElt);
                    }
                }
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

