/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.junit.core.internal.exported;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.facet.util.junit.core.internal.Activator;
import org.junit.After;
import org.junit.Before;
import org.osgi.framework.Bundle;

public abstract class AbstractLogListenerTest {
    private ILogListener listener;
    private final List<IStatus> loggedStatus = new ArrayList<IStatus>();

    @Before
    public void initLogListener() {
        final List<IStatus> finalLoggedStatus = this.loggedStatus;
        this.listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getSeverity() != 0 && status.getSeverity() != 1) {
                    finalLoggedStatus.add(status);
                }
            }
        };
        Bundle[] bundleArray = this.getPluginsToListen();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Platform.getLog((Bundle)bundle).addLogListener(this.listener);
            ++n2;
        }
    }

    @After
    public void checkLogListener() throws CoreException {
        Bundle bundle;
        Bundle[] bundleArray = this.getPluginsToListen();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            Platform.getLog((Bundle)bundle).removeLogListener(this.listener);
            ++n2;
        }
        if (this.loggedStatus.size() > 0) {
            bundle = Activator.getDefault().getBundle();
            String bundleName = bundle.getSymbolicName();
            MultiStatus multiStatus = new MultiStatus(bundleName, 4, this.loggedStatus.toArray(new IStatus[0]), "Some error or warning messages have been logged.", (Throwable)new Exception());
            throw new CoreException((IStatus)multiStatus);
        }
    }

    protected abstract Bundle[] getPluginsToListen();
}

