/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.ILayerListener;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.layer.event.ILayerEvent;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.event.CellSelectionEvent;
import net.sourceforge.nattable.selection.event.ColumnSelectionEvent;
import net.sourceforge.nattable.selection.event.RowSelectionEvent;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCell;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCellSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableColumnSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRowSelection;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.selection.TableAllSelection;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.selection.TableCell;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridElementSelectionProvider
implements ISelectionProvider {
    private final Table table;
    private final List<ISelectionChangedListener> changedListeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private SelectionLayer selectionLayer;

    public GridElementSelectionProvider(Table table, NatTable natTable, SelectionLayer selectionLayer) {
        this.table = table;
        this.selectionLayer = selectionLayer;
        natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) {
                    GridElementSelectionProvider.this.onSelectionChanged();
                }
            }
        });
    }

    protected void onSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.changedListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public ISelection getSelection() {
        Object result = StructuredSelection.EMPTY;
        List<Object> gridSelection = this.computeGridSelection();
        final List<Row> selectedRows = GridElementSelectionProvider.getSelectedRows(gridSelection);
        final List<Column> selectedColumns = GridElementSelectionProvider.getSelectedColumns(gridSelection);
        final List<ITableCell> selectedCells = GridElementSelectionProvider.getSelectedCells(gridSelection);
        boolean isfullColumnSelection = this.isFullColumnSelection(selectedColumns, selectedCells);
        if (selectedRows.isEmpty() && isfullColumnSelection) {
            result = new ITableColumnSelection(){

                public boolean isEmpty() {
                    return false;
                }

                public List<Column> getSelectedFullColumns() {
                    return selectedColumns;
                }
            };
        } else {
            boolean isFullRowSelection = this.isFullRowSelection(selectedRows, selectedCells);
            result = selectedColumns.isEmpty() && isFullRowSelection ? new ITableRowSelection(){

                public boolean isEmpty() {
                    return false;
                }

                public List<Row> getSelectedFullRows() {
                    return selectedRows;
                }
            } : (isfullColumnSelection && isFullRowSelection && this.isAllSelection(selectedRows, selectedColumns) ? new TableAllSelection(selectedRows, selectedColumns) : new ITableCellSelection(){

                public boolean isEmpty() {
                    return false;
                }

                public List<ITableCell> getSelectedCells() {
                    return selectedCells;
                }
            });
        }
        return result;
    }

    private boolean isFullRowSelection(List<Row> selectedRows, List<ITableCell> selectedCells) {
        boolean result = false;
        EList columns = this.table.getColumns();
        if (selectedRows.size() > 0 && selectedCells.size() == selectedRows.size() * columns.size()) {
            List<ITableCell> expectedCell = GridElementSelectionProvider.getExpectedCells(selectedRows, (List<Column>)columns);
            result = expectedCell.containsAll(selectedCells);
        }
        return result;
    }

    private boolean isFullColumnSelection(List<Column> selectedColumns, List<ITableCell> selectedCells) {
        boolean result = false;
        EList rows = this.table.getRows();
        if (selectedColumns.size() > 0 && selectedCells.size() == selectedColumns.size() * rows.size()) {
            List<ITableCell> expectedCell = GridElementSelectionProvider.getExpectedCells((List<Row>)rows, selectedColumns);
            result = expectedCell.containsAll(selectedCells);
        }
        return result;
    }

    private static List<ITableCell> getExpectedCells(List<Row> rows, List<Column> columns) {
        ArrayList<ITableCell> expectedCell = new ArrayList<ITableCell>();
        for (Row row : rows) {
            for (Column column : columns) {
                expectedCell.add(new TableCell(row, column));
            }
        }
        return expectedCell;
    }

    private boolean isAllSelection(Collection<Row> selectedRows, Collection<Column> selectedColumns) {
        int nbRow = this.table.getRows().size();
        int nbColumn = this.table.getColumns().size();
        int nbSelectedRow = selectedRows.size();
        int nbSelectedColumns = selectedColumns.size();
        return nbRow == nbSelectedRow && nbColumn == nbSelectedColumns;
    }

    private static List<Row> getSelectedRows(List<Object> selectedElements) {
        ArrayList<Row> result = new ArrayList<Row>();
        for (Object element : selectedElements) {
            if (!(element instanceof Row)) continue;
            result.add((Row)element);
        }
        return result;
    }

    private static List<Column> getSelectedColumns(List<Object> selectedElements) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Object element : selectedElements) {
            if (!(element instanceof Column)) continue;
            result.add((Column)element);
        }
        return result;
    }

    private static List<ITableCell> getSelectedCells(List<Object> selectedElements) {
        ArrayList<ITableCell> result = new ArrayList<ITableCell>();
        for (Object element : selectedElements) {
            if (!(element instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)element;
            Column column = gridElement.getColumn();
            Row row = gridElement.getRow();
            TableCell cell = new TableCell(row, column);
            result.add(cell);
        }
        return result;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    protected List<Object> computeGridSelection() {
        PositionCoordinate[] selectedCells;
        ArrayList<Object> result = new ArrayList<Object>();
        EList rows = this.table.getRows();
        EList columns = this.table.getColumns();
        int[] fullySelectedRows = this.selectionLayer.getFullySelectedRowPositions();
        int[] fullySelectedColumns = this.selectionLayer.getFullySelectedColumnPositions();
        int nRows = rows.size();
        int[] nArray = fullySelectedRows;
        int n = fullySelectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i < nRows) {
                Row row = (Row)rows.get(i);
                result.add(row);
            } else {
                Logger.logError((Plugin)Activator.getDefault(), (String)"Wrong row offset : %s (%s rows)", (Object[])new Object[]{i, nRows});
            }
            ++n2;
        }
        int nColumns = columns.size();
        int[] nArray2 = fullySelectedColumns;
        int n3 = fullySelectedColumns.length;
        n = 0;
        while (n < n3) {
            int i = nArray2[n];
            if (i >= 0 && i < nColumns) {
                Column column = (Column)columns.get(i);
                result.add(column);
            } else {
                Logger.logError((Plugin)Activator.getDefault(), (String)"Wrong column offset : %s (%s columns)", (Object[])new Object[]{i, nColumns});
            }
            ++n;
        }
        PositionCoordinate[] positionCoordinateArray = selectedCells = this.selectionLayer.getSelectedCells();
        int n4 = selectedCells.length;
        n3 = 0;
        while (n3 < n4) {
            Object dataValue;
            PositionCoordinate positionCoordinate = positionCoordinateArray[n3];
            LayerCell cell = this.selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell != null && (dataValue = cell.getDataValue()) instanceof IGridElement) {
                IGridElement gridElement = (IGridElement)dataValue;
                result.add(gridElement);
            }
            ++n3;
        }
        return Collections.unmodifiableList(result);
    }

    public void resetListenedNatTable(NatTable natTable) {
        natTable.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) {
                    GridElementSelectionProvider.this.onSelectionChanged();
                }
            }
        });
    }

    public void setSelectionLayer(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    public void fireSelectionChanged() {
        this.onSelectionChanged();
    }
}

