/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetView;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCell;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableCellSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableColumnSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRectangleSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.ITableRowSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.StructuredTableSelection;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.TableWidgetException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWidgetSelectionProvider
implements ISelectionProvider {
    private final ISelectionProvider controlSelecP;
    private final ICustomizationManager customManager;
    private final List<ISelectionChangedListener> selecChangLstnrs = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private final Table table;

    public TableWidgetSelectionProvider(ITableWidgetView widgetComposite, ICustomizationManager customManager, Table table) {
        this.controlSelecP = (ISelectionProvider)widgetComposite.getAdapter(ISelectionProvider.class);
        this.customManager = customManager;
        this.controlSelecP.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableWidgetSelectionProvider.this.onSelectionChanged();
            }
        });
        this.table = table;
    }

    protected void onSelectionChanged() {
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener selectionChangedListener : this.selecChangLstnrs) {
            selectionChangedListener.selectionChanged(newEvent);
        }
    }

    public ISelection getSelection() {
        Object result = StructuredSelection.EMPTY;
        ISelection selection = this.controlSelecP.getSelection();
        try {
            List<?> selectedElements = this.getSelectedElements(selection);
            if (!selectedElements.isEmpty()) {
                result = new StructuredTableSelection(selection, selectedElements);
            }
        }
        catch (TableWidgetException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return result;
    }

    private List<?> getSelectedElements(ISelection selection) throws TableWidgetException {
        List<Object> result = Collections.EMPTY_LIST;
        if (selection instanceof ITableRectangleSelection) {
            result = this.getTableRectangleSelection((ITableRectangleSelection)selection);
        } else if (selection instanceof ITableCellSelection) {
            result = this.getTableCellSelection((ITableCellSelection)selection);
        } else if (selection instanceof ITableRowSelection) {
            result = this.getTableRowSelection((ITableRowSelection)selection);
        } else if (selection instanceof ITableColumnSelection) {
            result = this.getTableColumnSelection((ITableColumnSelection)selection);
        }
        return result;
    }

    private List<Object> getTableRectangleSelection(ITableRectangleSelection selection) throws TableWidgetException {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Row> rows = selection.getSelectedRows();
        List<Column> columns = selection.getSelectedColumns();
        for (Row row : rows) {
            for (Column column : columns) {
                List<Object> values = this.getCellValues(row, column);
                result.addAll(values);
            }
        }
        return result;
    }

    private List<Object> getTableCellSelection(ITableCellSelection selection) throws TableWidgetException {
        ArrayList<Object> result = new ArrayList<Object>();
        List<ITableCell> selectedCells = selection.getSelectedCells();
        for (ITableCell cell : selectedCells) {
            Row row = cell.getRow();
            Column column = cell.getColumn();
            List<Object> values = this.getCellValues(row, column);
            result.addAll(values);
        }
        return result;
    }

    private List<Object> getTableRowSelection(ITableRowSelection selection) throws TableWidgetException {
        List<Row> selectedRows = selection.getSelectedFullRows();
        EList columns = this.table.getColumns();
        return this.getRowColumnValues(selectedRows, (List<Column>)columns);
    }

    private List<Object> getTableColumnSelection(ITableColumnSelection selection) throws TableWidgetException {
        List<Column> selectedColumns = selection.getSelectedFullColumns();
        EList rows = this.table.getRows();
        return this.getRowColumnValues((List<Row>)rows, selectedColumns);
    }

    private List<Object> getRowColumnValues(List<Row> selectedRows, List<Column> columns) throws TableWidgetException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Row row : selectedRows) {
            for (Column column : columns) {
                List<Object> values = this.getCellValues(row, column);
                result.addAll(values);
            }
        }
        return result;
    }

    private List<Object> getCellValues(Row row, Column column) throws TableWidgetException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (column instanceof FeatureColumn) {
            ETypedElement feature = ((FeatureColumn)column).getFeature();
            EObject eObject = row.getElement();
            List<?> values = this.getValues(eObject, feature);
            if (values != null) {
                result.addAll(values);
            }
        }
        return result;
    }

    private List<?> getValues(EObject eObject, ETypedElement feature) throws TableWidgetException {
        List result = null;
        try {
            if (eObject != null && this.isApplicable(eObject, feature)) {
                FacetOperation selectionProperty = ISelectionPropertiesHandlerFactory.DEFAULT.createSelectionPropertiesHandler(this.customManager).getSelectionProperty();
                result = (List)this.customManager.getCustomValueOf(eObject, feature, selectionProperty, List.class);
            }
        }
        catch (Exception e) {
            String message = String.format("Can't evaluate the value of the feature %s on object %s", feature, eObject);
            throw new TableWidgetException(message, e);
        }
        return result;
    }

    private boolean isApplicable(EObject eObject, ETypedElement feature) throws FacetManagerException {
        boolean result = false;
        IFacetManager facetManager = this.customManager.getFacetManager();
        if (FacetsUtils.hasStructuralFeature(eObject, feature, facetManager)) {
            Object value = facetManager.getOrInvoke(eObject, feature, Object.class);
            result = value != null;
        }
        return result;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selecChangLstnrs.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selecChangLstnrs.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public ISelectionProvider getControlSelectionProvider() {
        return this.controlSelecP;
    }
}

