/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor base;
    private ImageDescriptor[] overlays;
    private Point size;

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor[] overlays) {
        this(base, overlays, new Point(base.getImageData().width, base.getImageData().height));
    }

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor overlay, int quadrant) {
        this(base, OverlayImageDescriptor.convertToArray(overlay, quadrant));
    }

    private static ImageDescriptor[] convertToArray(ImageDescriptor overlay, int quadrant) {
        ImageDescriptor[] overlays = new ImageDescriptor[6];
        overlays[quadrant] = overlay;
        return overlays;
    }

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor[] overlays, Point size) {
        if (base == null || overlays == null || size == null) {
            throw new NullPointerException();
        }
        this.base = base;
        this.overlays = overlays;
        this.size = size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor replace;
        ImageDescriptor underlay;
        if (this.overlays.length > 4 && (underlay = this.overlays[4]) != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        ImageDescriptor temp = this.base;
        if (this.overlays.length > 5 && (replace = this.overlays[5]) != null) {
            temp = replace;
        }
        this.drawImage(this.convertToImageData(temp), 0, 0);
        int i = 0;
        while (i < this.overlays.length) {
            ImageDescriptor overlay = this.overlays[i];
            if (overlay != null) {
                ImageData overlayData = this.convertToImageData(overlay);
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, this.size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    private ImageData convertToImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        return imageData != null ? imageData : ImageDescriptor.getMissingImageDescriptor().getImageData();
    }

    protected Point getSize() {
        return this.size;
    }

    protected int getTransparentPixel() {
        return this.base.getImageData().transparentPixel;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)o);
        return this.base.equals(other.base) && Arrays.equals(this.overlays, other.overlays) && this.size.equals((Object)other.size);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        ImageDescriptor[] imageDescriptorArray = this.overlays;
        int n = this.overlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                code ^= overlay.hashCode();
            }
            ++n2;
        }
        return code ^= this.size.hashCode();
    }
}

