/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.facet;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCoreTraceOptions;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FaceletChangeDelegate;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FacetChangeModel;
import org.eclipse.jst.jsf.facelet.core.internal.facet.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.facet.WebAppConfigurator;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FaceletUninstallDelegate
extends FaceletChangeDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        FacetChangeModel model = (FacetChangeModel)config;
        if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
            FaceletCoreTraceOptions.log("Uninstalling facet on project: " + project.getName());
            FaceletCoreTraceOptions.log(String.format("FaceletUninstallDelegate: Remove default selection %b", model.isChgDefaultSuffix()));
            FaceletCoreTraceOptions.log(String.format("FaceletUninstallDelegate: Remove view handler %b", model.isChgViewHandler()));
            FaceletCoreTraceOptions.log(String.format("FaceletUninstallDelegate: Remove configure listener %b", model.isChgConfigureListener()));
            FaceletCoreTraceOptions.log(String.format("FaceletUninstallDelegate: Remove web app lifecycle listener %b", model.isChgWebAppLifecycleListener()));
        }
        try {
            if (monitor != null) {
                monitor.beginTask("Uninstalling facelet facet", 1);
            }
            super.execute(project, fv, config, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void maybeChangeFaceletViewHandler(IProject project, IProgressMonitor monitor) {
        FacesConfigArtifactEdit edit;
        if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
            FaceletCoreTraceOptions.log("FaceletInstallDelegate: Uninstalling facelet view handler");
        }
        if ((edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml")) != null) {
            try {
                FacesConfigType root = edit.getFacesConfig();
                if (this.isViewHandlerPresent(root)) {
                    if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                        FaceletCoreTraceOptions.log("FaceletInstallDelegate: View Handler not already found in faces-config");
                    }
                    EList applications = root.getApplication();
                    for (ApplicationType application : applications) {
                        Iterator viewHandlerIt = application.getViewHandler().iterator();
                        while (viewHandlerIt.hasNext()) {
                            ViewHandlerType viewHandlerType = (ViewHandlerType)viewHandlerIt.next();
                            if (viewHandlerType == null || viewHandlerType.getTextContent() == null || !"com.sun.facelets.FaceletViewHandler".equals(viewHandlerType.getTextContent().trim())) continue;
                            viewHandlerIt.remove();
                            if (!FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) continue;
                            FaceletCoreTraceOptions.log("FaceletUninstallDelegate: Removed runtime view handler");
                        }
                    }
                    edit.save(monitor);
                    if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                        FaceletCoreTraceOptions.log("FaceletUninstallDelegate: Saved changes for facelet view handler");
                    }
                } else if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                    FaceletCoreTraceOptions.log("FaceletInstallDelegate: View Handler NOT already found in faces-config; not adding");
                }
            }
            finally {
                edit.dispose();
            }
        }
    }

    protected void handleDesignTimeViewHandler(IProject project) {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)project);
        manager.setViewHandlerId("org.eclipse.jst.jsf.designtime.view.jspviewhandler");
    }

    protected String getDisplayName() {
        return Messages.FaceletUninstallDelegate_FACET_INSTALLER_DELEGATE_DISPLAY_NAME;
    }

    protected void maybeChangeDefaultSuffix(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgDefaultSuffix()) {
            if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletUninstallDelegate: Removing DEFAULT_SUFFIX");
            }
            configurator.removeContextParam("javax.faces.DEFAULT_SUFFIX", ".xhtml");
        }
    }

    protected void maybeChangeConfigureListener(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgConfigureListener()) {
            if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletUninstallDelegate: Remove Configure Listener");
            }
            configurator.removeListener("com.sun.faces.config.ConfigureListener");
        }
    }

    protected void maybeChangeWebLifecycleListener(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgWebAppLifecycleListener()) {
            if (FaceletCoreTraceOptions.TRACE_FACETUNINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletUninstallDelegate: Remove WebappLifecycleListener");
            }
            configurator.removeListener("com.sun.faces.application.WebappLifecycleListener");
        }
    }
}

