/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.common;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.AppClientFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.UtilityFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.IFacetOperationDelegate;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class FacetUtils {
    private static IFacetOperationDelegate delegate;
    private static boolean failedToLoadDelegate;

    static {
        failedToLoadDelegate = false;
    }

    public static IProject[] getAllProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> validProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                IFacetedProject facProject = ProjectFacetsManager.create((IProject)projects[i]);
                if (facProject != null) {
                    validProjects.add(projects[i]);
                } else if (ResourceUtils.isJavaProject((IProject)projects[i])) {
                    validProjects.add(projects[i]);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return validProjects.toArray(new IProject[0]);
    }

    public static Set getFacetsForProject(String projectName) {
        Set facetVersions = null;
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project != null && project.exists()) {
            try {
                IFacetedProject fproject = ProjectFacetsManager.create((IProject)project);
                if (fproject != null) {
                    facetVersions = fproject.getProjectFacets();
                } else {
                    IJavaProject javaProject = null;
                    if (ResourceUtils.isJavaProject((IProject)project)) {
                        javaProject = JavaCore.create((IProject)project);
                        facetVersions = FacetUtils.getFacetsForJavaProject(javaProject);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return facetVersions;
    }

    public static IRuntime getFacetRuntimeForProject(String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project != null && project.exists()) {
            try {
                IFacetedProject fproject = ProjectFacetsManager.create((IProject)project);
                if (fproject != null) {
                    return fproject.getPrimaryRuntime();
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static Set[] getFacetCombinations(IProjectFacetVersion[][] arrayOfProjectFacetVersionArrays, boolean returnValidOnly) {
        ArrayList allCombinations = new ArrayList();
        int n = arrayOfProjectFacetVersionArrays.length;
        int[] maxCount = new int[n];
        int[] counter = new int[n];
        int i = 0;
        while (i < n) {
            maxCount[i] = arrayOfProjectFacetVersionArrays[i].length - 1;
            counter[i] = 0;
            ++i;
        }
        boolean done = false;
        block3: while (!done) {
            HashSet<IProjectFacetVersion> combination = new HashSet<IProjectFacetVersion>();
            int j = 0;
            while (j < n) {
                IProjectFacetVersion pfv = arrayOfProjectFacetVersionArrays[j][counter[j]];
                combination.add(pfv);
                ++j;
            }
            if (returnValidOnly) {
                Set actions = FacetUtils.getInstallActions(combination);
                try {
                    if (ProjectFacetsManager.check(new HashSet(), (Set)actions).getSeverity() == 0) {
                        allCombinations.add(combination);
                    }
                }
                catch (Throwable throwable) {}
            } else {
                allCombinations.add(combination);
            }
            int p = 0;
            while (p < n) {
                if (counter[p] + 1 <= maxCount[p]) {
                    int n2 = p;
                    counter[n2] = counter[n2] + 1;
                    continue block3;
                }
                counter[p] = 0;
                if (p == n - 1) {
                    done = true;
                }
                ++p;
            }
        }
        Set[] allCombinationsArray = allCombinations.toArray(new Set[0]);
        return allCombinationsArray;
    }

    public static Set getInitialFacetVersionsFromTemplate(String templateId) {
        IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
        Set fixedFacets = template.getFixedProjectFacets();
        HashSet<IProjectFacetVersion> initial = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet facet : fixedFacets) {
            IProjectFacetVersion highestFacetVersion = null;
            try {
                highestFacetVersion = FacetUtils.isJavaFacet(facet) ? facet.getVersion("1.4") : facet.getLatestVersion();
            }
            catch (VersionFormatException versionFormatException) {
            }
            catch (CoreException coreException) {}
            initial.add(highestFacetVersion);
        }
        return initial;
    }

    public static Set getDefaultFacetVersionsFromTemplate(String templateId) {
        HashSet<IProjectFacetVersion> defaultSet = new HashSet<IProjectFacetVersion>();
        try {
            IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
            Set fixedFacets = template.getFixedProjectFacets();
            for (IProjectFacet facet : fixedFacets) {
                IProjectFacetVersion defaultFacetVersion = null;
                defaultFacetVersion = facet.getDefaultVersion();
                defaultSet.add(defaultFacetVersion);
            }
            return defaultSet;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultSet;
        }
        catch (VersionFormatException versionFormatException) {
            return defaultSet;
        }
    }

    public static String[] getTemplateLabels(String[] templateIds) {
        String[] labels = new String[templateIds.length];
        int i = 0;
        while (i < templateIds.length) {
            IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateIds[i]);
            labels[i] = template.getLabel();
            ++i;
        }
        return labels;
    }

    public static String getTemplateIdByLabel(String templateLabel) {
        for (IFacetedProjectTemplate template : ProjectFacetsManager.getTemplates()) {
            if (!template.getLabel().equals(templateLabel)) continue;
            return template.getId();
        }
        return "";
    }

    public static String getTemplateLabelById(String templateId) {
        IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
        return template.getLabel();
    }

    public static Set getInstallActions(Set projectFacetVersions) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        for (IProjectFacetVersion fv : projectFacetVersions) {
            if (fv == null) continue;
            IProjectFacet pf = fv.getProjectFacet();
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, FacetUtils.getConfigObject(pf));
            actions.add(action);
        }
        return actions;
    }

    public static Object getConfigObject(IProjectFacet projectFacet) {
        String facetId;
        IDataModel dm = null;
        if (projectFacet != null && (facetId = projectFacet.getId()) != null) {
            if (facetId.equals("jst.web")) {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
                dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            } else if (facetId.equals("jst.ejb")) {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
                dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            } else if (facetId.equals("jst.appclient")) {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetInstallDataModelProvider());
                dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            } else if (facetId.equals("jst.utility")) {
                dm = DataModelFactory.createDataModel((IDataModelProvider)new UtilityFacetInstallDataModelProvider());
                dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            }
        }
        return dm;
    }

    public static FacetMatcher match(RequiredFacetVersion[] requiredFacetVersions, Set projectFacetVersions) {
        FacetMatcher fm = new FacetMatcher();
        fm.setFacetsTested(projectFacetVersions);
        HashSet<IProjectFacetVersion> facetsToAdd = new HashSet<IProjectFacetVersion>();
        HashSet<RequiredFacetVersion> requiredFacetVersionsToAdd = new HashSet<RequiredFacetVersion>();
        HashSet<IProjectFacetVersion> facetsThatMatched = new HashSet<IProjectFacetVersion>();
        int i = 0;
        while (i < requiredFacetVersions.length) {
            RequiredFacetVersion rfv = requiredFacetVersions[i];
            IProjectFacetVersion rpfv = rfv.getProjectFacetVersion();
            String rid = rpfv.getProjectFacet().getId();
            String rv = rpfv.getVersionString();
            boolean facetPresent = false;
            for (IProjectFacetVersion pfv : projectFacetVersions) {
                String id = pfv.getProjectFacet().getId();
                String version = pfv.getVersionString();
                if (!rid.equals(id)) continue;
                if (rv.equals(version)) {
                    facetPresent = true;
                    facetsThatMatched.add(pfv);
                    break;
                }
                if (!rfv.getAllowNewer() || !FacetUtils.greaterThan(version, rv)) break;
                facetPresent = true;
                facetsThatMatched.add(pfv);
                break;
            }
            if (!facetPresent) {
                facetsToAdd.add(rpfv);
                requiredFacetVersionsToAdd.add(rfv);
            }
            ++i;
        }
        if (requiredFacetVersionsToAdd.size() > 0) {
            boolean facetsCanBeAdded = false;
            Iterator itr = requiredFacetVersionsToAdd.iterator();
            ArrayList<IProjectFacetVersion[]> projectFacetVersionArrays = new ArrayList<IProjectFacetVersion[]>();
            while (itr.hasNext()) {
                RequiredFacetVersion reqFacetVersion = (RequiredFacetVersion)itr.next();
                IProjectFacetVersion[] versions = reqFacetVersion.getAllowedProjectFacetVersions();
                if (versions == null || versions.length <= 0) continue;
                projectFacetVersionArrays.add(versions);
            }
            IProjectFacetVersion[][] arrayOfProjectFacetVersionArrays = (IProjectFacetVersion[][])projectFacetVersionArrays.toArray((T[])new IProjectFacetVersion[0][0]);
            Set[] combinations = FacetUtils.getFacetCombinations(arrayOfProjectFacetVersionArrays, false);
            int i2 = 0;
            while (i2 < combinations.length) {
                Set actions = FacetUtils.getInstallActions(combinations[i2]);
                try {
                    if (ProjectFacetsManager.check((Set)projectFacetVersions, (Set)actions).getSeverity() == 0) {
                        facetsCanBeAdded = true;
                        fm.setMatch(true);
                        fm.setFacetsThatMatched(facetsThatMatched);
                        fm.setFacetsToAdd(combinations[i2]);
                        break;
                    }
                }
                catch (Throwable throwable) {}
                ++i2;
            }
            if (!facetsCanBeAdded) {
                fm.setMatch(false);
            }
        } else {
            fm.setMatch(true);
            fm.setFacetsThatMatched(facetsThatMatched);
            fm.setFacetsToAdd(facetsToAdd);
        }
        return fm;
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus addRequiredFacetsToProject(IProject project, RequiredFacetVersion[] rfvs, IProgressMonitor monitor) {
        block16: {
            status = Status.OK_STATUS;
            missingFacets = null;
            facetsToAdd = new HashSet<E>();
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject == null || !(projectFacetMatcher = FacetUtils.match(rfvs, projectFacetVersions = fProject.getProjectFacets())).isMatch() || (missingFacets = projectFacetMatcher.getFacetsToAdd()).size() <= 0) break block16;
                fRuntime = null;
                fRuntime = FacetUtils.getFacetRuntimeForProject(project.getName());
                if (fRuntime != null) {
                    missingFacetsItr = missingFacets.iterator();
                    block5: while (missingFacetsItr.hasNext()) {
                        block17: {
                            facet = ((IProjectFacetVersion)missingFacetsItr.next()).getProjectFacet();
                            versions = null;
                            try {
                                versions = facet.getSortedVersions(false);
                                break block17;
                            }
                            catch (VersionFormatException v0) {
                                versionSet = facet.getVersions();
                                itr = versionSet.iterator();
                                versions = new ArrayList<E>();
                                ** while (itr.hasNext())
                            }
lbl-1000:
                            // 1 sources

                            {
                                versions.add(itr.next());
                                continue;
lbl25:
                                // 1 sources

                                break block17;
                            }
                            catch (CoreException v1) {
                                versionSet = facet.getVersions();
                                itr = versionSet.iterator();
                                versions = new ArrayList<E>();
                                ** while (itr.hasNext())
                            }
lbl-1000:
                            // 1 sources

                            {
                                versions.add(itr.next());
                                continue;
                            }
                        }
                        versionsItr = versions.iterator();
                        while (versionsItr.hasNext()) {
                            match = false;
                            pfv = (IProjectFacetVersion)versionsItr.next();
                            pfvs = new HashSet<IProjectFacetVersion>();
                            pfvs.add(pfv);
                            j = 0;
                            while (j < rfvs.length) {
                                rfv = rfvs[j];
                                rpfv = rfv.getProjectFacetVersion();
                                if (rpfv.getProjectFacet().getId().equals(pfv.getProjectFacet().getId())) {
                                    if (rpfv.getVersionString().equals(pfv.getVersionString())) {
                                        match = true;
                                    } else if (rfv.getAllowNewer() && FacetUtils.greaterThan(pfv.getVersionString(), rpfv.getVersionString())) {
                                        match = true;
                                    }
                                }
                                ++j;
                            }
                            if (!match || !FacetUtils.doesRuntimeSupportFacets(fRuntime, pfvs)) continue;
                            facetsToAdd.add(pfv);
                            continue block5;
                        }
                    }
                } else {
                    facetsToAdd = missingFacets;
                }
                status = FacetUtils.addFacetsToProject(fProject, facetsToAdd);
            }
            catch (CoreException ce) {
                status = project.exists() == false ? StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_DOES_NOT_EXIST, (Object[])new String[]{project.getName()})) : (project.isOpen() == false ? StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_IS_NOT_OPEN, (Object[])new String[]{project.getName()})) : FacetUtils.getErrorStatusForAddingFacets(project.getName(), facetsToAdd, ce));
            }
        }
        return status;
    }

    public static IStatus addFacetsToProject(IFacetedProject fproject, Set projectFacetVersions) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        Set actions = FacetUtils.getInstallActions(projectFacetVersions);
        if (FacetUtils.isExtensionPresent()) {
            status[0] = delegate.addFacetsToProject(fproject, projectFacetVersions);
        } else {
            try {
                fproject.modify(actions, null);
            }
            catch (CoreException e) {
                status[0] = FacetUtils.getErrorStatusForAddingFacets(fproject.getProject().getName(), projectFacetVersions, e);
            }
        }
        return status[0];
    }

    private static IStatus getErrorStatusForAddingFacets(String projectName, Set projectFacetVersions, Throwable t) {
        IStatus status = Status.OK_STATUS;
        int size = projectFacetVersions.size();
        if (size > 0) {
            HashSet<IProjectFacet> facets = new HashSet<IProjectFacet>();
            for (IProjectFacetVersion projectFacet : projectFacetVersions) {
                IProjectFacet facet = projectFacet.getProjectFacet();
                facets.add(facet);
            }
            String facetList = FacetUtils.getFacetListMessageString(facets);
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADDING_FACETS_TO_PROJECT, (Object[])new String[]{projectName, facetList}), (Throwable)t);
        }
        return status;
    }

    public static IStatus createNewFacetedProject(String projectName) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (!project.exists()) {
            if (FacetUtils.isExtensionPresent()) {
                status[0] = delegate.createNewFacetedProject(projectName);
            } else {
                try {
                    IFacetedProject fProject = ProjectFacetsManager.create((String)projectName, null, null);
                    if (fProject == null) {
                        status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}));
                    }
                }
                catch (CoreException e) {
                    status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}), (Throwable)e);
                }
            }
        }
        return status[0];
    }

    public static IStatus setFixedFacetsOnProject(IFacetedProject fProject, Set fixedFacets) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (FacetUtils.isExtensionPresent()) {
            status[0] = delegate.setFixedFacetsOnProject(fProject, fixedFacets);
        } else {
            try {
                fProject.setFixedProjectFacets(fixedFacets);
            }
            catch (CoreException e) {
                status[0] = FacetUtils.getErrorStatusForSettingFixedFacets(fProject.getProject().getName(), fixedFacets, e);
            }
        }
        return status[0];
    }

    private static IStatus getErrorStatusForSettingFixedFacets(String projectName, Set facets, Throwable t) {
        IStatus status = Status.OK_STATUS;
        int size = facets.size();
        if (size > 0) {
            String facetList = FacetUtils.getFacetListMessageString(facets);
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_FIXED_FACETS, (Object[])new String[]{projectName, facetList}), (Throwable)t);
        }
        return status;
    }

    public static IStatus setFacetRuntimeOnProject(IFacetedProject fProject, IRuntime fRuntime) {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (FacetUtils.isExtensionPresent()) {
            status[0] = delegate.setFacetRuntimeOnProject(fProject, fRuntime);
        } else {
            try {
                fProject.setTargetedRuntimes(Collections.singleton(fRuntime), null);
            }
            catch (CoreException e) {
                status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_SETTING_RUNTIME, (Object[])new String[]{fProject.getProject().getName(), fRuntime.getName()}), (Throwable)e);
            }
        }
        return status[0];
    }

    private static String getFacetListMessageString(Set facets) {
        String facetListMessage = "";
        int size = facets.size();
        if (size > 0) {
            Iterator itr = facets.iterator();
            IProjectFacet firstProjectFacet = (IProjectFacet)itr.next();
            facetListMessage = firstProjectFacet.getLabel();
            while (itr.hasNext()) {
                IProjectFacet projectFacet = (IProjectFacet)itr.next();
                String pfLabel = projectFacet.getLabel();
                facetListMessage = NLS.bind((String)ConsumptionMessages.MSG_FACETS, (Object[])new String[]{facetListMessage, pfLabel});
            }
        }
        return facetListMessage;
    }

    public static Set getFacetsForJavaProject(IJavaProject javaProject) {
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        String jdkComplianceLevel = null;
        if (javaProject != null && (jdkComplianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", false)) == null && (jdkComplianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance")) == null) {
            jdkComplianceLevel = "1.4";
        }
        IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"java");
        IProjectFacetVersion javaFacetVersion = null;
        javaFacetVersion = jdkComplianceLevel.equals("1.3") ? javaFacet.getVersion("1.3") : (jdkComplianceLevel.equals("1.4") ? javaFacet.getVersion("1.4") : (jdkComplianceLevel.equals("1.5") ? JavaFacet.JAVA_50 : (jdkComplianceLevel.equals("1.6") ? JavaFacet.JAVA_60 : (jdkComplianceLevel.equals("1.7") ? JavaFacet.VERSION_1_7 : (jdkComplianceLevel.equals("1.8") ? JavaFacet.VERSION_1_8 : (jdkComplianceLevel.equals("9") ? JavaFacet.VERSION_9 : (jdkComplianceLevel.equals("10") ? JavaFacet.VERSION_10 : (jdkComplianceLevel.equals("11") ? JavaFacet.VERSION_11 : javaFacet.getVersion("1.4")))))))));
        facets.add(javaFacetVersion);
        IProjectFacet utilityFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
        IProjectFacetVersion utilityFacetVersion = null;
        try {
            utilityFacetVersion = utilityFacet.getLatestVersion();
        }
        catch (CoreException coreException) {}
        if (utilityFacetVersion != null) {
            facets.add(utilityFacetVersion);
        }
        return facets;
    }

    public static Set getRuntimes(RequiredFacetVersion[] requiredFacetVersions) {
        ArrayList listOfFacetSets = new ArrayList();
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        int javaFacetIndex = -1;
        int i = 0;
        while (i < requiredFacetVersions.length) {
            IProjectFacetVersion pfv = requiredFacetVersions[i].getProjectFacetVersion();
            if (FacetUtils.isJavaFacet(pfv.getProjectFacet())) {
                javaFacetIndex = i;
            }
            facets.add(requiredFacetVersions[i].getProjectFacetVersion());
            ++i;
        }
        listOfFacetSets.add(facets);
        if (javaFacetIndex > -1) {
            ArrayList<String> permittedJavaVersions = new ArrayList<String>();
            RequiredFacetVersion rfv = requiredFacetVersions[javaFacetIndex];
            if (rfv.getAllowNewer()) {
                String version = rfv.getProjectFacetVersion().getVersionString();
                Set allVersions = rfv.getProjectFacetVersion().getProjectFacet().getVersions();
                for (IProjectFacetVersion thisPfv : allVersions) {
                    String thisVersion = thisPfv.getVersionString();
                    if (!FacetUtils.greaterThan(thisVersion, version)) continue;
                    permittedJavaVersions.add(thisVersion);
                }
                String[] javaVersions = permittedJavaVersions.toArray(new String[0]);
                int j = 0;
                while (j < javaVersions.length) {
                    HashSet<IProjectFacetVersion> thisFacetSet = new HashSet<IProjectFacetVersion>();
                    int k = 0;
                    while (k < requiredFacetVersions.length) {
                        IProjectFacetVersion pfv;
                        if (k == javaFacetIndex) {
                            pfv = requiredFacetVersions[k].getProjectFacetVersion().getProjectFacet().getVersion(javaVersions[j]);
                            thisFacetSet.add(pfv);
                        } else {
                            pfv = requiredFacetVersions[k].getProjectFacetVersion();
                            thisFacetSet.add(pfv);
                        }
                        ++k;
                    }
                    listOfFacetSets.add(thisFacetSet);
                    ++j;
                }
            }
        }
        return FacetUtils.getRuntimes(listOfFacetSets.toArray(new Set[0]));
    }

    public static boolean isFacetRuntimeSupported(RequiredFacetVersion[] requiredFacetVersions, String fRuntimeName) {
        Set fRuntimes = FacetUtils.getRuntimes(requiredFacetVersions);
        for (IRuntime runtime : fRuntimes) {
            if (!runtime.getName().equals(fRuntimeName)) continue;
            return true;
        }
        return false;
    }

    public static Set getRuntimes(Set[] facetSets) {
        HashSet<IRuntime> unionSet = new HashSet<IRuntime>();
        int i = 0;
        while (i < facetSets.length) {
            Set facets = facetSets[i];
            Set runtimes = RuntimeManager.getRuntimes((Set)facets);
            for (IRuntime runtime : runtimes) {
                if (unionSet.contains(runtime)) continue;
                unionSet.add(runtime);
            }
            ++i;
        }
        return unionSet;
    }

    public static boolean doesRuntimeSupportFacets(IRuntime facetRuntime, Set projectFacetVersions) {
        if (facetRuntime == null || projectFacetVersions == null) {
            return false;
        }
        Set runtimes = RuntimeManager.getRuntimes((Set)projectFacetVersions);
        for (IRuntime runtime : runtimes) {
            if (!runtime.getName().equals(facetRuntime.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean greaterThan(String versionA, String versionB) {
        int sizeB;
        if (versionA == null || versionB == null) {
            return false;
        }
        StringTokenizer stA = new StringTokenizer(versionA, ".");
        StringTokenizer stB = new StringTokenizer(versionB, ".");
        int sizeA = stA.countTokens();
        int size = sizeA < (sizeB = stB.countTokens()) ? sizeA : sizeB;
        int i = 0;
        while (i < size) {
            int b;
            int a = Integer.parseInt(stA.nextToken());
            if (a != (b = Integer.parseInt(stB.nextToken()))) {
                return a > b;
            }
            ++i;
        }
        return sizeA > sizeB;
    }

    public static boolean isJavaFacet(IProjectFacet pf) {
        return pf != null && pf.equals(JavaFacet.FACET);
    }

    public static boolean isJavaProject(IProject project) {
        block9: {
            block7: {
                IProjectFacetVersion pfv;
                IFacetedProject fProject;
                block8: {
                    if (project == null) {
                        return false;
                    }
                    try {
                        fProject = ProjectFacetsManager.create((IProject)project);
                        if (fProject == null) break block7;
                        if (!J2EEUtils.isJavaComponent((IProject)project)) break block8;
                        return true;
                    }
                    catch (CoreException coreException) {}
                }
                Set facets = fProject.getProjectFacets();
                if (facets.size() == 1 && FacetUtils.isJavaFacet((pfv = (IProjectFacetVersion)facets.iterator().next()).getProjectFacet())) {
                    return true;
                }
                break block9;
            }
            if (ResourceUtils.isJavaProject((IProject)project)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUtilityTemplate(String templateId) {
        return templateId != null && ProjectFacetsManager.isTemplateDefined((String)templateId) && templateId.equals("template.jst.utility");
    }

    public static RequiredFacetVersion[] getRequiredEARFacetVersions(IProject project) {
        int version = 0;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            version = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            version = J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        } else if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project)) {
            version = J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        } else {
            return new RequiredFacetVersion[0];
        }
        IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion projectFacetVersion = projectFacet.getVersion(J2EEVersionUtil.convertVersionIntToString((int)version));
        RequiredFacetVersion[] rfv = new RequiredFacetVersion[]{new RequiredFacetVersion()};
        rfv[0].setAllowNewer(false);
        rfv[0].setProjectFacetVersion(projectFacetVersion);
        return rfv;
    }

    private static boolean isExtensionPresent() {
        IConfigurationElement[] elements;
        if (failedToLoadDelegate) {
            return false;
        }
        if (delegate != null) {
            return true;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.jst.ws.consumption.internalFacetOperationDelegate");
        if (point == null) {
            failedToLoadDelegate = true;
            return false;
        }
        IExtension[] extensions = point.getExtensions();
        if (extensions.length > 0 && extensions[0] != null && (elements = extensions[0].getConfigurationElements()).length > 0 && elements[0] != null) {
            try {
                delegate = (IFacetOperationDelegate)elements[0].createExecutableExtension("class");
                return true;
            }
            catch (CoreException coreException) {}
        }
        failedToLoadDelegate = true;
        return false;
    }
}

