/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.handler;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.alm.mylyn.ui.dialogs.InspectALMAttributesDialog;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.mylyn.utils.MylynAccess;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectAlmAttributes
extends AbstractSelectionBasedHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InspectAlmAttributes.class);
    private TaskAttribute m_attributes;

    protected Object executeImpl(ExecutionEvent event) {
        IStructuredSelection selection = this.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof ITask) {
            ITask task = (ITask)o;
            LoadAttributesFromAlm run = new LoadAttributesFromAlm(task);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)run);
                InspectALMAttributesDialog dialog = new InspectALMAttributesDialog(this.getActiveShell(), this.m_attributes);
                dialog.open();
            }
            catch (InterruptedException | InvocationTargetException e) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_ERROR_VIEW_TASK_ATTRIBUTES, null, (String[])new String[]{e.getMessage()});
            }
        }
        return null;
    }

    private class LoadAttributesFromAlm
    implements IRunnableWithProgress {
        private ITask m_task;

        public LoadAttributesFromAlm(ITask task) {
            this.m_task = task;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
            TaskRepository repo = repositoryManager.getRepository(this.m_task.getConnectorKind(), this.m_task.getRepositoryUrl());
            IStatus ok = MylynAccess.testConnection((String)repo.getRepositoryLabel());
            if (ok.getSeverity() != 0) {
                throw new InvocationTargetException(null, ok.getMessage());
            }
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
            TaskAttribute attribute = null;
            if (attribute == null) {
                try {
                    TaskData taskData = connector.getTaskData(repo, this.m_task.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
                    attribute = taskData.getRoot();
                    InspectAlmAttributes.this.m_attributes = taskData.getRoot();
                }
                catch (CoreException e) {
                    LOG.error("Unexpected error occurred", (Throwable)e);
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

