/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IDoWhilePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IWhileDoPO;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class CondStructGUIPropertySource
extends AbstractNodePropertySource {
    private static String[] negateOptions = new String[]{Boolean.FALSE.toString(), Boolean.TRUE.toString()};

    public CondStructGUIPropertySource(INodePO condition) {
        super(condition);
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        String name = "";
        if (this.getNode() instanceof IConditionalStatementPO) {
            name = Messages.ConditionGUIPropertySourceName;
        } else if (this.getNode() instanceof IDoWhilePO) {
            name = Messages.DoWhileGUIPropertySourceName;
        } else if (this.getNode() instanceof IWhileDoPO) {
            name = Messages.WhileDoGUIPropertySourceName;
        }
        this.addPropertyDescriptor((IPropertyDescriptor)new TextPropertyDescriptor((Object)new AbstractNodePropertySource.ElementNameController(this), name));
        super.initPropDescriptor();
        this.addPropertyDescriptor((IPropertyDescriptor)new ComboBoxPropertyDescriptor((Object)new ConditionNegateController(), Messages.ConditionGUIPropertySourceNegate, negateOptions));
    }

    public class ConditionNegateController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            if (value == null) {
                return false;
            }
            boolean isNegate = Boolean.parseBoolean(negateOptions[(Integer)value]);
            ((ICondStructPO)CondStructGUIPropertySource.this.getPoNode()).setNegate(isNegate);
            DataEventDispatcher.getInstance().firePropertyChanged(false);
            return true;
        }

        public Object getProperty() {
            boolean isNegate = ((ICondStructPO)CondStructGUIPropertySource.this.getPoNode()).isNegate();
            int i = 0;
            while (i < negateOptions.length) {
                if (negateOptions[i].equals(String.valueOf(isNegate))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
    }
}

