/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditParametersValueSetDialog
extends TitleAreaDialog {
    private static final int VALUE_COLUMN_INDEX = 0;
    private static final int COMMENT_COLUMN_INDEX = 1;
    private static final String COMMENT_COLUMN_NAME = Messages.EditValueSetDialogCommentTableColumnName;
    private static final String VALUE_COLUMN_NAME = Messages.EditValueSetDialogValueTableColumnName;
    private List<AbstractEditParametersDialog.ValueComment> m_valueSets = new ArrayList<AbstractEditParametersDialog.ValueComment>();
    private String m_defaultValue;
    private String m_parameterType;
    private Combo m_defaultValueCombo;
    private TableViewer m_tableViewer = null;

    public EditParametersValueSetDialog(Shell parentShell, AbstractEditParametersDialog.Parameter param) {
        super(parentShell);
        this.m_parameterType = param.getType();
        this.m_defaultValue = param.getDefaultValue();
        for (AbstractEditParametersDialog.ValueComment vc : param.getValueSet()) {
            this.m_valueSets.add(new AbstractEditParametersDialog.ValueComment(vc.getValue(), vc.getComment()));
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.y = 500;
        return initialSize;
    }

    public List<AbstractEditParametersDialog.ValueComment> getValueSets() {
        return this.m_valueSets;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        String dialogTitle = Messages.EditValueSetDialogTitle;
        this.setTitle(dialogTitle);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.editParameterValuesSetsDialogContextId");
        this.setHelpAvailable(true);
        this.setMessage(Messages.EditValueSetDialogMessage);
        this.getShell().setText(dialogTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout();
        area.setLayout((Layout)areaLayout);
        GridData areaGridData = new GridData();
        areaGridData.grabExcessVerticalSpace = true;
        areaGridData.grabExcessHorizontalSpace = true;
        areaGridData.horizontalAlignment = 4;
        areaGridData.verticalAlignment = 4;
        area.setLayoutData((Object)areaGridData);
        this.createTableComposite(area);
        this.createDefaultValueCombo(area);
        return parent;
    }

    private void createDefaultValueCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.EditValueSetDialogComboLabel);
        this.m_defaultValueCombo = new Combo(parent, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.minimumWidth = 150;
        gridData.widthHint = 150;
        this.m_defaultValueCombo.setLayoutData((Object)gridData);
        this.setComboBoxValues();
        this.m_defaultValueCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(c -> {
            String[] items = this.m_defaultValueCombo.getItems();
            int selectionIndex = this.m_defaultValueCombo.getSelectionIndex();
            if (selectionIndex >= 0 && selectionIndex < this.m_valueSets.size() + 1) {
                this.m_defaultValue = items[selectionIndex];
            }
        }));
    }

    private void setComboBoxValues() {
        int size = this.m_valueSets.size();
        Object[] values = (String[])ArrayUtils.add((Object[])this.m_valueSets.stream().map(AbstractEditParametersDialog.ValueComment::getValue).collect(Collectors.toList()).toArray(new String[size]), (int)0, (Object)"");
        this.m_defaultValueCombo.setItems((String[])values);
        int indexOf = ArrayUtils.indexOf((Object[])values, (Object)this.m_defaultValue);
        this.m_defaultValueCombo.select(indexOf == -1 ? 0 : indexOf);
    }

    private void createTableComposite(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.EditValueSetDialogTableLabel);
        Composite tableArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(2, false);
        tableArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.grabExcessVerticalSpace = true;
        tableAreaGridData.grabExcessHorizontalSpace = true;
        tableAreaGridData.horizontalAlignment = 4;
        tableAreaGridData.verticalAlignment = 4;
        tableArea.setLayoutData((Object)tableAreaGridData);
        this.createValueSetTable(tableArea);
        this.createTableButtons(tableArea);
    }

    private void createTableButtons(Composite parent) {
        Composite tableButtonArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(1, true);
        tableButtonArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.grabExcessVerticalSpace = true;
        tableAreaGridData.horizontalAlignment = 4;
        tableAreaGridData.verticalAlignment = 4;
        tableButtonArea.setLayoutData((Object)tableAreaGridData);
        GridData buttonsGridData = new GridData();
        buttonsGridData.grabExcessHorizontalSpace = true;
        buttonsGridData.horizontalAlignment = 4;
        this.createAddButton(tableButtonArea, buttonsGridData);
        this.createDeleteButton(tableButtonArea, buttonsGridData);
        LayoutUtil.createSeparator((Composite)tableButtonArea);
    }

    private void createDeleteButton(Composite parent, GridData layoutData) {
        Button deleteButton = new Button(parent, 0);
        deleteButton.setText(Messages.EditParametersDialogRemove);
        deleteButton.setLayoutData((Object)layoutData);
        deleteButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(c -> {
            IStructuredSelection selection = this.m_tableViewer.getStructuredSelection();
            for (AbstractEditParametersDialog.ValueComment valueComment : selection) {
                this.m_valueSets.remove(valueComment);
                this.m_tableViewer.refresh();
                this.checkOKButton();
            }
            String item = this.m_defaultValueCombo.getItem(this.m_defaultValueCombo.getSelectionIndex());
            if (!this.doesExist(item)) {
                this.setComboBoxValues();
                this.m_defaultValueCombo.select(0);
                this.m_defaultValue = null;
            }
        }));
    }

    private void createAddButton(Composite parent, GridData layoutData) {
        Button addButton = new Button(parent, 0);
        addButton.setText(Messages.EditParametersDialogAdd);
        addButton.setLayoutData((Object)layoutData);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(c -> {
            this.m_valueSets.add(new AbstractEditParametersDialog.ValueComment("", ""));
            this.m_tableViewer.refresh();
            this.checkOKButton();
        }));
    }

    private void createValueSetTable(Composite parent) {
        this.m_tableViewer = new TableViewer(parent, 67586);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        Table table = this.m_tableViewer.getTable();
        TableViewerColumn tvColumn1 = new TableViewerColumn(this.m_tableViewer, 0);
        tvColumn1.getColumn().setText(VALUE_COLUMN_NAME);
        tvColumn1.getColumn().setWidth(200);
        TableViewerColumn tvColumn2 = new TableViewerColumn(this.m_tableViewer, 0);
        tvColumn2.getColumn().setText(COMMENT_COLUMN_NAME);
        tvColumn2.getColumn().setWidth(200);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)gridData);
        this.m_tableViewer.setColumnProperties(new String[]{VALUE_COLUMN_NAME, COMMENT_COLUMN_NAME});
        this.m_tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.setLabelProvider();
        this.m_tableViewer.setInput(this.m_valueSets);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)table);
        ICellModifier cellModifier = this.createCellModifier();
        this.m_tableViewer.setCellModifier(cellModifier);
        this.m_tableViewer.setCellEditors(new CellEditor[]{textCellEditor, textCellEditor});
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.m_tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.m_tableViewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)50);
    }

    private ICellModifier createCellModifier() {
        ICellModifier cellModifier = new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TableItem ti = (TableItem)element;
                AbstractEditParametersDialog.ValueComment vc = (AbstractEditParametersDialog.ValueComment)ti.getData();
                if (property.equals(VALUE_COLUMN_NAME)) {
                    vc.setValue(value.toString());
                    EditParametersValueSetDialog.this.m_tableViewer.refresh();
                    int selectionIndex = EditParametersValueSetDialog.this.m_defaultValueCombo.getSelectionIndex();
                    EditParametersValueSetDialog.this.setComboBoxValues();
                    if (selectionIndex < 0 && selectionIndex > EditParametersValueSetDialog.this.m_defaultValueCombo.getItems().length) {
                        EditParametersValueSetDialog.this.m_defaultValueCombo.select(0);
                    } else {
                        String item = EditParametersValueSetDialog.this.m_defaultValueCombo.getItem(selectionIndex);
                        if (!EditParametersValueSetDialog.this.doesExist(item)) {
                            EditParametersValueSetDialog.this.m_defaultValueCombo.select(0);
                            EditParametersValueSetDialog.this.m_defaultValue = EditParametersValueSetDialog.this.m_defaultValueCombo.getItem(0);
                        } else {
                            EditParametersValueSetDialog.this.m_defaultValueCombo.select(selectionIndex);
                            EditParametersValueSetDialog.this.m_defaultValue = item;
                        }
                    }
                } else if (property.equals(COMMENT_COLUMN_NAME)) {
                    vc.setComment(value.toString());
                    EditParametersValueSetDialog.this.m_tableViewer.refresh();
                }
                EditParametersValueSetDialog.this.checkOKButton();
            }

            public Object getValue(Object element, String property) {
                AbstractEditParametersDialog.ValueComment vc = (AbstractEditParametersDialog.ValueComment)element;
                if (property.equals(VALUE_COLUMN_NAME)) {
                    return vc.getValue();
                }
                if (property.equals(COMMENT_COLUMN_NAME)) {
                    return vc.getComment();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        };
        return cellModifier;
    }

    private void setLabelProvider() {
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                AbstractEditParametersDialog.ValueComment valuecomment;
                String value;
                if (columnIndex == 0 && ("".equals((value = (valuecomment = (AbstractEditParametersDialog.ValueComment)element).getValue()).trim()) || EditParametersValueSetDialog.this.isDuplicate(valuecomment) || !EditParametersValueSetDialog.this.isValidBoolean(value) || !EditParametersValueSetDialog.this.isValidInteger(value))) {
                    return IconConstants.ERROR_IMAGE;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof AbstractEditParametersDialog.ValueComment) {
                    AbstractEditParametersDialog.ValueComment entry = (AbstractEditParametersDialog.ValueComment)element;
                    switch (columnIndex) {
                        case 0: {
                            return entry.getValue();
                        }
                        case 1: {
                            return entry.getComment();
                        }
                    }
                }
                return null;
            }
        });
    }

    private void checkOKButton() {
        this.getButton(0).setEnabled(this.isDataValid());
    }

    private boolean isDataValid() {
        HashSet<String> values = new HashSet<String>();
        for (AbstractEditParametersDialog.ValueComment valueComment : this.m_valueSets) {
            String value = valueComment.getValue();
            if (StringUtils.isBlank((String)value)) {
                this.setErrorMessage(Messages.EditValueSetDialogErrorEmpty);
                return false;
            }
            boolean contains = values.contains(value);
            if (contains) {
                this.setErrorMessage(Messages.EditValueSetDialogErrorDuplicate);
                return false;
            }
            if (!this.isValidBoolean(value)) {
                this.setErrorMessage(Messages.EditValueSetDialogErrorNoBoolean);
                return false;
            }
            if (!this.isValidInteger(value)) {
                this.setErrorMessage(Messages.EditValueSetDialogErrorNoInt);
                return false;
            }
            values.add(value);
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isValidInteger(String value) {
        if ("java.lang.Integer".equals(this.m_parameterType)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean isValidBoolean(String value) {
        if ("java.lang.Boolean".equals(this.m_parameterType)) {
            boolean valid;
            boolean bl = valid = StringUtils.equalsIgnoreCase((String)Boolean.TRUE.toString(), (String)value) || StringUtils.equalsIgnoreCase((String)Boolean.FALSE.toString(), (String)value);
            if (!valid) {
                return false;
            }
        }
        return true;
    }

    private boolean isDuplicate(AbstractEditParametersDialog.ValueComment vc) {
        for (AbstractEditParametersDialog.ValueComment valueComment : this.m_valueSets) {
            if (valueComment == null || vc == null || vc.equals(valueComment) || !StringUtils.equals((String)vc.getValue(), (String)valueComment.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean doesExist(String value) {
        for (AbstractEditParametersDialog.ValueComment valueComment : this.m_valueSets) {
            if (!StringUtils.equals((String)value, (String)valueComment.getValue())) continue;
            return true;
        }
        return false;
    }
}

