/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.parsers;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class CParser
implements IParserChangeLogContrib {
    public String parseCurrentFunction(IEditorInput input, int offset) throws CoreException {
        if (input instanceof IFileEditorInput) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            manager.connect(input);
            IWorkingCopy workingCopy = manager.getWorkingCopy(input);
            ICElement method = workingCopy.getElementAtOffset(offset);
            manager.disconnect(input);
            if (method == null) {
                return "";
            }
            String currentElementName = method.getElementName();
            if (currentElementName == null) {
                return "";
            }
            int elementType = method.getElementType();
            switch (elementType) {
                case 70: 
                case 72: 
                case 74: {
                    break;
                }
                case 10: {
                    return "";
                }
                default: {
                    ICElement tmpMethodType = method.getAncestor(74);
                    if (tmpMethodType == null && (tmpMethodType = method.getAncestor(70)) == null && (tmpMethodType = method.getAncestor(65)) == null) {
                        return "";
                    }
                    method = tmpMethodType;
                    currentElementName = method.getElementName();
                }
            }
            ICElement tmpParent = method.getParent();
            while (tmpParent != null) {
                String tmpParentClassName;
                ICElement tmpParentClass = tmpParent.getAncestor(65);
                if (tmpParentClass != null) {
                    tmpParentClassName = tmpParentClass.getElementName();
                    if (tmpParentClassName == null) {
                        return currentElementName;
                    }
                } else {
                    return currentElementName;
                }
                currentElementName = String.valueOf(tmpParentClassName) + "." + currentElementName;
                tmpParent = tmpParentClass.getParent();
            }
            return currentElementName;
        }
        if (input instanceof IStorageEditorInput) {
            String currentElementName = "";
            IStorageEditorInput sei = (IStorageEditorInput)input;
            IncludeFileContentProvider contentProvider = IncludeFileContentProvider.getEmptyFilesProvider();
            ScannerInfo scanInfo = new ScannerInfo();
            IStorage ancestorStorage = sei.getStorage();
            if (ancestorStorage == null) {
                return "";
            }
            InputStream stream = ancestorStorage.getContents();
            byte[] buffer = new byte[100];
            String data = "";
            int read = 0;
            try {
                do {
                    if ((read = stream.read(buffer)) <= 0) continue;
                    String tmp = new String(buffer, 0, read);
                    data = data.concat(tmp);
                } while (read == 100);
                stream.close();
            }
            catch (IOException tmp) {
                // empty catch block
            }
            FileContent content = FileContent.create((String)"<text>", (char[])data.toCharArray());
            GPPLanguage language = GPPLanguage.getDefault();
            try {
                int options = 0;
                IASTTranslationUnit ast = language.getASTTranslationUnit(content, (IScannerInfo)scanInfo, contentProvider, null, options, ParserUtil.getParserLogService());
                IASTNodeSelector n = ast.getNodeSelector(null);
                IASTNode node = n.findFirstContainedNode(offset, 100);
                while (node != null && !(node instanceof IASTTranslationUnit)) {
                    if (node instanceof IASTFunctionDefinition) {
                        IASTFunctionDefinition fd = (IASTFunctionDefinition)node;
                        IASTFunctionDeclarator d = fd.getDeclarator();
                        currentElementName = new String(d.getName().getSimpleID());
                        break;
                    }
                    node = node.getParent();
                }
            }
            catch (CoreException exc) {
                currentElementName = "";
                CUIPlugin.log((Throwable)exc);
            }
            return currentElementName;
        }
        return "";
    }

    public String parseCurrentFunction(IEditorPart editor) throws CoreException {
        if (!(editor instanceof AbstractTextEditor)) {
            return "";
        }
        AbstractTextEditor a_editor = (AbstractTextEditor)editor;
        ITextSelection selection = (ITextSelection)a_editor.getSelectionProvider().getSelection();
        IEditorInput input = a_editor.getEditorInput();
        return this.parseCurrentFunction(input, selection.getOffset());
    }
}

