/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EventIdCache {
    private static final String HELP_EVENTS = "help_events";
    private static final String HEADER = "header";
    private static final String SCHEMA = "schemaversion";
    private static final String CATEGORY = "category";
    private static final String OPHELP = "ophelp";
    private static final String EVENT = "event";
    private static final String EVENT_NAME = "event_name";
    private static final String LOCAL = "local";
    private Document eventDoc;
    private Element eventRoot;
    private HashMap<String, Element> nameMap;
    private static HashMap<String, EventIdCache> cacheMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventIdCache getInstance() {
        if (cacheMap == null) {
            cacheMap = new HashMap();
        }
        IProject project = Oprofile.OprofileProject.getProject();
        EventIdCache newCache = new EventIdCache();
        if (project != null) {
            EventIdCache eventIdCache = cacheMap.get(project.getLocationURI().getHost());
            if (eventIdCache != null) return eventIdCache;
            cacheMap.put(project.getLocationURI().getHost(), newCache);
            return newCache;
        } else {
            EventIdCache eventIdCache = cacheMap.get(LOCAL);
            if (eventIdCache != null) return eventIdCache;
            cacheMap.put(LOCAL, newCache);
        }
        return newCache;
    }

    public Element getElementWithName(String name) {
        IProject project = Oprofile.OprofileProject.getProject();
        EventIdCache eventIdCache = project != null ? cacheMap.get(project.getLocationURI().getHost()) : cacheMap.get(LOCAL);
        if (eventIdCache.nameMap == null) {
            this.readXML(eventIdCache);
            this.buildCache(eventIdCache);
        }
        return eventIdCache.nameMap.get(name) != null ? eventIdCache.nameMap.get(name) : null;
    }

    private void buildCache(EventIdCache eventId) {
        eventId.nameMap = new HashMap();
        NodeList eventList = eventId.eventRoot.getElementsByTagName(EVENT);
        int i = 0;
        while (i < eventList.getLength()) {
            Element elem = (Element)eventList.item(i);
            String eventName = elem.getAttribute(EVENT_NAME);
            eventId.nameMap.put(eventName, elem);
            ++i;
        }
    }

    private void readXML(EventIdCache eventId) {
        if (eventId.eventRoot != null) {
            return;
        }
        try {
            Process p = RuntimeProcessFactory.getFactory().exec("ophelp -X", Oprofile.OprofileProject.getProject());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                try {
                    Element elem;
                    eventId.eventDoc = builder.parse(p.getInputStream());
                    eventId.eventRoot = elem = (Element)eventId.eventDoc.getElementsByTagName(HELP_EVENTS).item(0);
                }
                catch (IOException | SAXException elem) {
                }
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public String getUnitMaskType(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 32[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCacheDoc(Element oldRoot) {
        this.eventRoot = oldRoot;
    }
}

