/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jdt;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.jdt.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleStringTokenizer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSourceFileJob
extends Job {
    private final String className;
    private String packageName;
    private String typeName;
    private Object[] innerTypes;
    private List<IType> matches;
    private Display display;

    public OpenSourceFileJob(String className, Display display) {
        super(MessageUtil.format((String)Messages.OpenSourceFileJob_LookingFor, (Object[])new Object[]{className}));
        this.className = className;
        this.setUser(true);
        this.display = display;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.preparePattern();
            this.collectMatches(monitor);
            this.displayResult();
            return Status.OK_STATUS;
        }
        catch (JavaModelException e) {
            return new Status(4, "org.eclipse.mat.jdt", 0, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void preparePattern() {
        int dot = this.className.lastIndexOf(46);
        int inner = this.className.indexOf(36);
        int end = this.className.indexOf(91);
        if (end < 0) {
            end = this.className.length();
        }
        String string = this.packageName = dot >= 0 ? this.className.substring(0, dot) : null;
        if (inner < 0) {
            this.typeName = dot >= 0 ? this.className.substring(dot + 1, end) : this.className;
        } else {
            String string2 = this.typeName = dot >= 0 ? this.className.substring(dot + 1, inner) : this.className.substring(0, inner);
        }
        if (inner >= 0) {
            String names = this.className.substring(inner + 1, end);
            String[] types = SimpleStringTokenizer.split((String)names, (char)'$');
            this.innerTypes = new Object[types.length];
            int ii = 0;
            while (ii < types.length) {
                try {
                    this.innerTypes[ii] = Integer.parseInt(types[ii]);
                }
                catch (NumberFormatException ignore) {
                    this.innerTypes[ii] = types[ii];
                }
                ++ii;
            }
        }
    }

    private void collectMatches(IProgressMonitor monitor) throws JavaModelException {
        this.matches = new ArrayList<IType>();
        new SearchEngine().searchAllTypeNames(this.packageName != null ? this.packageName.toCharArray() : null, 72, this.typeName.toCharArray(), 72, 0, SearchEngine.createWorkspaceScope(), new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                try {
                    IType type = match.getType();
                    type = OpenSourceFileJob.this.resolveInnerTypes(type);
                    OpenSourceFileJob.this.matches.add(type);
                }
                catch (JavaModelException e) {
                    throw new RuntimeException(e);
                }
            }
        }, 3, monitor);
    }

    private IType resolveInnerTypes(IType match) throws JavaModelException {
        if (this.innerTypes == null) {
            return match;
        }
        Object[] objectArray = this.innerTypes;
        int n = this.innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object innerType = objectArray[n2];
            Stack<Object> stack = new Stack<Object>();
            stack.push(match);
            while (!stack.isEmpty()) {
                IJavaElement subject = (IJavaElement)stack.pop();
                if (subject instanceof IType) {
                    IType type = (IType)subject;
                    if (innerType instanceof Integer) {
                        if (type.isAnonymous() && type.getOccurrenceCount() == ((Integer)innerType).intValue()) {
                            match = type;
                            break;
                        }
                    } else if (innerType.equals(type.getElementName())) {
                        match = type;
                        break;
                    }
                }
                if (!(subject instanceof IParent)) continue;
                IJavaElement[] iJavaElementArray = ((IParent)subject).getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement child = iJavaElementArray[n4];
                    stack.push(child);
                    ++n4;
                }
            }
            ++n2;
        }
        return match;
    }

    private void displayResult() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (OpenSourceFileJob.this.matches.isEmpty()) {
                    MessageBox box = new MessageBox(OpenSourceFileJob.this.display.getActiveShell(), 2);
                    box.setText(Messages.OpenSourceFileJob_NotFound);
                    box.setMessage(MessageUtil.format((String)Messages.OpenSourceFileJob_TypeNotFound, (Object[])new Object[]{OpenSourceFileJob.this.className}));
                    box.open();
                } else if (OpenSourceFileJob.this.matches.size() == 1) {
                    IType type = (IType)OpenSourceFileJob.this.matches.get(0);
                    OpenSourceFileJob.this.openSourceFile((IJavaElement)type);
                } else {
                    IType type = OpenSourceFileJob.this.selectType(OpenSourceFileJob.this.matches);
                    if (type != null) {
                        OpenSourceFileJob.this.openSourceFile((IJavaElement)type);
                    }
                }
            }
        });
    }

    private IType selectType(List<IType> matches) {
        ListDialog dialog = new ListDialog(this.display.getActiveShell());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IType type = (IType)element;
                StringBuilder buf = new StringBuilder(256);
                buf.append(type.getElementName());
                if (type.getPackageFragment() != null) {
                    buf.append(" - ").append(type.getPackageFragment().getElementName());
                }
                if (type.getJavaProject() != null) {
                    buf.append(" - ").append(type.getJavaProject().getElementName());
                }
                return buf.toString();
            }
        });
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setInput(matches);
        dialog.setTitle(Messages.OpenSourceFileJob_SelectFile);
        dialog.setMessage(Messages.OpenSourceFileJob_SelectFileToOpen);
        dialog.open();
        Object[] result = dialog.getResult();
        return result == null ? null : (IType)result[0];
    }

    private boolean openSourceFile(IJavaElement element) {
        if (element == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        try {
            StructuredSelection ss = new StructuredSelection((Object)element);
            OpenAction openAction = new OpenAction((IWorkbenchSite)page.getActivePart().getSite());
            openAction.run((IStructuredSelection)ss);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

