/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.IterableTypeImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class CollectionTypeImpl
extends IterableTypeImpl
implements CollectionType {
    protected static final boolean IS_NULL_FREE_EDEFAULT = false;
    protected static final int IS_NULL_FREE_EFLAG = 4096;
    protected static final Number LOWER_EDEFAULT = (Number)PivotFactory.eINSTANCE.createFromString(PivotPackage.eINSTANCE.getInteger(), "0");
    protected Number lower = LOWER_EDEFAULT;
    protected static final Number UPPER_EDEFAULT = (Number)PivotFactory.eINSTANCE.createFromString(PivotPackage.eINSTANCE.getUnlimitedNatural(), "*");
    protected Number upper = UPPER_EDEFAULT;
    @Deprecated
    protected Type elementType = null;

    protected CollectionTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.COLLECTION_TYPE;
    }

    @Override
    public boolean isIsNullFree() {
        return (this.eFlags & 0x1000) != 0;
    }

    @Override
    public void setIsNullFree(boolean newIsNullFree) {
        boolean oldIsNullFree;
        boolean bl = oldIsNullFree = (this.eFlags & 0x1000) != 0;
        this.eFlags = newIsNullFree ? (this.eFlags |= 0x1000) : (this.eFlags &= 0xFFFFEFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, oldIsNullFree, newIsNullFree));
        }
    }

    @Override
    public Number getLower() {
        return this.lower;
    }

    @Override
    public void setLower(Number newLower) {
        Number oldLower = this.lower;
        this.lower = newLower;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, (Object)oldLower, (Object)this.lower));
        }
    }

    @Override
    public Number getUpper() {
        return this.upper;
    }

    @Override
    public void setUpper(Number newUpper) {
        Number oldUpper = this.upper;
        this.upper = newUpper;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 26, (Object)oldUpper, (Object)this.upper));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getOwnedConstraints();
            }
            case 6: {
                return this.getOwnedBindings();
            }
            case 7: {
                return this.getOwnedSignature();
            }
            case 8: {
                return this.getUnspecializedElement();
            }
            case 9: {
                return this.getExtenders();
            }
            case 10: {
                return this.getInstanceClassName();
            }
            case 11: {
                return this.isIsAbstract();
            }
            case 12: {
                return this.isIsActive();
            }
            case 13: {
                return this.isIsInterface();
            }
            case 14: {
                return this.getOwnedBehaviors();
            }
            case 15: {
                return this.getOwnedInvariants();
            }
            case 16: {
                return this.getOwnedOperations();
            }
            case 17: {
                return this.getOwnedProperties();
            }
            case 18: {
                return this.getOwningPackage();
            }
            case 19: {
                return this.getSuperClasses();
            }
            case 20: {
                if (resolve) {
                    return this.getBehavioralClass();
                }
                return this.basicGetBehavioralClass();
            }
            case 21: {
                return this.isIsSerializable();
            }
            case 22: {
                return this.getValue();
            }
            case 23: {
                return this.getElementType();
            }
            case 24: {
                return this.isIsNullFree();
            }
            case 25: {
                return this.getLower();
            }
            case 26: {
                return this.getUpper();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.getOwnedConstraints().clear();
                this.getOwnedConstraints().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getOwnedBindings().clear();
                this.getOwnedBindings().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setOwnedSignature((TemplateSignature)newValue);
                return;
            }
            case 8: {
                this.setUnspecializedElement((TemplateableElement)newValue);
                return;
            }
            case 9: {
                this.getExtenders().clear();
                this.getExtenders().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 11: {
                this.setIsAbstract((Boolean)newValue);
                return;
            }
            case 12: {
                this.setIsActive((Boolean)newValue);
                return;
            }
            case 13: {
                this.setIsInterface((Boolean)newValue);
                return;
            }
            case 14: {
                this.getOwnedBehaviors().clear();
                this.getOwnedBehaviors().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getOwnedInvariants().clear();
                this.getOwnedInvariants().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getOwnedOperations().clear();
                this.getOwnedOperations().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getOwnedProperties().clear();
                this.getOwnedProperties().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setOwningPackage((Package)newValue);
                return;
            }
            case 19: {
                this.getSuperClasses().clear();
                this.getSuperClasses().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setBehavioralClass((Class)newValue);
                return;
            }
            case 21: {
                this.setIsSerializable((Boolean)newValue);
                return;
            }
            case 23: {
                this.setElementType((Type)newValue);
                return;
            }
            case 24: {
                this.setIsNullFree((Boolean)newValue);
                return;
            }
            case 25: {
                this.setLower((Number)newValue);
                return;
            }
            case 26: {
                this.setUpper((Number)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.getOwnedConstraints().clear();
                return;
            }
            case 6: {
                this.getOwnedBindings().clear();
                return;
            }
            case 7: {
                this.setOwnedSignature(null);
                return;
            }
            case 8: {
                this.setUnspecializedElement(null);
                return;
            }
            case 9: {
                this.getExtenders().clear();
                return;
            }
            case 10: {
                this.setInstanceClassName(INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setIsAbstract(false);
                return;
            }
            case 12: {
                this.setIsActive(false);
                return;
            }
            case 13: {
                this.setIsInterface(false);
                return;
            }
            case 14: {
                this.getOwnedBehaviors().clear();
                return;
            }
            case 15: {
                this.getOwnedInvariants().clear();
                return;
            }
            case 16: {
                this.getOwnedOperations().clear();
                return;
            }
            case 17: {
                this.getOwnedProperties().clear();
                return;
            }
            case 18: {
                this.setOwningPackage(null);
                return;
            }
            case 19: {
                this.getSuperClasses().clear();
                return;
            }
            case 20: {
                this.setBehavioralClass(null);
                return;
            }
            case 21: {
                this.setIsSerializable(true);
                return;
            }
            case 23: {
                this.setElementType(null);
                return;
            }
            case 24: {
                this.setIsNullFree(false);
                return;
            }
            case 25: {
                this.setLower(LOWER_EDEFAULT);
                return;
            }
            case 26: {
                this.setUpper(UPPER_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.ownedConstraints != null && !this.ownedConstraints.isEmpty();
            }
            case 6: {
                return this.ownedBindings != null && !this.ownedBindings.isEmpty();
            }
            case 7: {
                return this.ownedSignature != null;
            }
            case 8: {
                return this.unspecializedElement != null;
            }
            case 9: {
                return this.extenders != null && !this.extenders.isEmpty();
            }
            case 10: {
                return INSTANCE_CLASS_NAME_EDEFAULT == null ? this.instanceClassName != null : !INSTANCE_CLASS_NAME_EDEFAULT.equals(this.instanceClassName);
            }
            case 11: {
                return (this.eFlags & 0x100) != 0;
            }
            case 12: {
                return (this.eFlags & 0x200) != 0;
            }
            case 13: {
                return (this.eFlags & 0x400) != 0;
            }
            case 14: {
                return this.ownedBehaviors != null && !this.ownedBehaviors.isEmpty();
            }
            case 15: {
                return this.ownedInvariants != null && !this.ownedInvariants.isEmpty();
            }
            case 16: {
                return this.ownedOperations != null && !this.ownedOperations.isEmpty();
            }
            case 17: {
                return this.ownedProperties != null && !this.ownedProperties.isEmpty();
            }
            case 18: {
                return this.getOwningPackage() != null;
            }
            case 19: {
                return this.superClasses != null && !this.superClasses.isEmpty();
            }
            case 20: {
                return this.behavioralClass != null;
            }
            case 21: {
                return (this.eFlags & 0x800) == 0;
            }
            case 22: {
                return "" == null ? this.getValue() != null : !"".equals(this.getValue());
            }
            case 23: {
                return this.getElementType() != null;
            }
            case 24: {
                return (this.eFlags & 0x1000) != 0;
            }
            case 25: {
                return LOWER_EDEFAULT == null ? this.lower != null : !LOWER_EDEFAULT.equals(this.lower);
            }
            case 26: {
                return UPPER_EDEFAULT == null ? this.upper != null : !UPPER_EDEFAULT.equals(this.upper);
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCollectionType(this);
    }

    @Deprecated
    public Type basicGetElementType() {
        return this.getElementType();
    }

    @Override
    public @NonNull TypeId computeId() {
        if (this.getUnspecializedElement() == null) {
            if ("Collection".equals(this.name)) {
                return TypeId.COLLECTION;
            }
            if ("UniqueCollection".equals(this.name)) {
                return TypeId.UNIQUE_COLLECTION;
            }
            String name2 = this.name;
            assert (name2 != null);
            return IdManager.getCollectionTypeId(name2);
        }
        return TypeId.COLLECTION.getSpecializedId(this.getElementType().getTypeId());
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (type instanceof CollectionType) {
            return TypeUtil.conformsToCollectionType(standardLibrary, this, (CollectionType)type);
        }
        if (this.getUnspecializedElement() != null) {
            return ((Type)((Object)this.getUnspecializedElement())).conformsTo(standardLibrary, type);
        }
        return super.conformsTo(standardLibrary, type);
    }

    @Override
    public Type flattenedType() {
        return this.getElementType();
    }

    @Override
    public @NonNull Class getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        CompleteEnvironment environment = idResolver.getEnvironment();
        StandardLibrary standardLibrary = environment.getOwnedStandardLibrary();
        CompleteInheritance thisInheritance = this.getInheritance(standardLibrary);
        CompleteInheritance thatInheritance = type.getInheritance(standardLibrary);
        CompleteInheritance commonInheritance = thisInheritance.getCommonInheritance(thatInheritance);
        Class commonType = commonInheritance.getPivotClass();
        if (type instanceof CollectionType) {
            CollectionType thatCollectionType = (CollectionType)type;
            Type thisElementType = this.getElementType();
            Type thatElementType = ClassUtil.nonNullEMF(thatCollectionType.getElementType());
            boolean commonIsNullFree = this.isIsNullFree() && thatCollectionType.isIsNullFree();
            Type commonElementType = thisElementType.getCommonType(idResolver, thatElementType);
            if (commonInheritance instanceof CompleteInheritanceImpl && !((CompleteInheritanceImpl)commonInheritance).isIsAbstract()) {
                CollectionType commonCollectionType = (CollectionType)commonType;
                return environment.getCollectionType(commonCollectionType, commonElementType, commonIsNullFree, null, null);
            }
            if (this.isOrdered() && thatCollectionType.isOrdered()) {
                if (this.isUnique() && thatCollectionType.isUnique()) {
                    return environment.getOrderedSetType(commonElementType, commonIsNullFree, null, null);
                }
                return environment.getSequenceType(commonElementType, commonIsNullFree, null, null);
            }
            if (this.isUnique() && thatCollectionType.isUnique()) {
                return environment.getSetType(commonElementType, commonIsNullFree, null, null);
            }
            return environment.getBagType(commonElementType, commonIsNullFree, null, null);
        }
        return commonType;
    }

    @Override
    public @NonNull CollectionType getContainerType() {
        TemplateableElement unspecializedElement2 = this.unspecializedElement;
        return unspecializedElement2 != null ? (CollectionType)unspecializedElement2 : this;
    }

    @Override
    public @NonNull CollectionTypeId getTypeId() {
        return (CollectionTypeId)super.getTypeId();
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof CollectionType)) {
            return false;
        }
        return TypeUtil.isEqualToCollectionType(standardLibrary, this, (CollectionType)type);
    }

    @Override
    public Type getElementType() {
        TemplateSignature templateSignature = this.getOwnedSignature();
        if (templateSignature != null) {
            List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
            return templateParameters.get(0);
        }
        List<TemplateBinding> templateBindings = this.getOwnedBindings();
        List<TemplateParameterSubstitution> templateParameterSubstitutions = templateBindings.get(0).getOwnedSubstitutions();
        return templateParameterSubstitutions.get(0).getActual();
    }

    @Override
    public @NonNull IntegerValue getLowerValue() {
        Number lower2 = this.lower;
        assert (lower2 != null);
        return ValueUtil.integerValueOf(lower2);
    }

    @Override
    public @NonNull UnlimitedNaturalValue getUpperValue() {
        Number upper2 = this.upper;
        assert (upper2 != null);
        return ValueUtil.unlimitedNaturalValueOf(upper2);
    }

    @Override
    public void setElementType(Type newElementType) {
        System.err.println(String.valueOf(this.eClass().getName()) + ".setElementType() is ignored");
    }

    @Override
    public void setLowerValue(@NonNull IntegerValue lower) {
        this.setLower(lower.intValue());
    }

    @Override
    public void setUpperValue(@NonNull UnlimitedNaturalValue upper) {
        this.setUpper(upper.isUnlimited() ? Unlimited.INSTANCE : Integer.valueOf(upper.intValue()));
    }
}

