/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.LoopExpImpl;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.pivot.library.iterator.SortedByIteration;
import org.eclipse.ocl.pivot.library.logical.BooleanAndOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanNotOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanOrOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.validation.ValidationWarning;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OCLValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class IteratorExpImpl
extends LoopExpImpl
implements IteratorExp {
    protected IteratorExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.ITERATOR_EXP;
    }

    @Override
    public boolean validateClosureBodyTypeIsConformanttoIteratorType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateSortedByIteratorTypeIsComparable(DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationWarning diagnostic;
        block11: {
            if (this.getReferredIteration().getImplementation() != SortedByIteration.INSTANCE) {
                return true;
            }
            diagnostic = null;
            Resource asResource = ClassUtil.nonNullState(this.eResource());
            EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(asResource);
            StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
            try {
                Class oclComparableType = standardLibrary.getOclComparableType();
                CompleteInheritance comparableInheritance = oclComparableType.getInheritance(standardLibrary);
                CompleteInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
                Operation staticOperation = comparableInheritance.lookupLocalOperation(standardLibrary, "compareTo", selfType);
                if (staticOperation == null) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(PivotMessagesInternal.UnresolvedOperation_ERROR_, String.valueOf(comparableInheritance), "compareTo");
                    break block11;
                }
                OCLExpression source2 = this.getOwnedSource();
                OCLExpression body2 = this.getOwnedBody();
                Type sourceType = source2.getType();
                Type sourceTypeValue = source2.getTypeValue();
                Type bodyType = body2.getType();
                Type specializedBodyType = bodyType != null ? TemplateParameterSubstitutionVisitor.specializeType(bodyType, this, environmentFactory, sourceType, sourceTypeValue) : null;
                boolean isOk = false;
                if (bodyType != null) {
                    PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
                    Type type = specializedBodyType = specializedBodyType != null ? PivotUtilInternal.getBehavioralType(specializedBodyType) : null;
                    if (specializedBodyType != null && metamodelManager.conformsTo(specializedBodyType, TemplateParameterSubstitutions.EMPTY, oclComparableType, TemplateParameterSubstitutions.EMPTY)) {
                        isOk = true;
                    }
                }
                if (!isOk) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(PivotMessagesInternal.UnresolvedOperation_ERROR_, String.valueOf(specializedBodyType), "compareTo");
                }
            }
            catch (Exception e) {
                if (diagnostics == null) {
                    return false;
                }
                diagnostic = new ValidationWarning(e.getLocalizedMessage(), new Object[0]);
            }
        }
        if (diagnostic == null) {
            return true;
        }
        diagnostics.add((Diagnostic)diagnostic);
        return false;
    }

    @Override
    public boolean validateUnsafeSourceCanNotBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::UnsafeSourceCanNotBeNull");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                Serializable CAUGHT_isNullFree;
                Serializable CAUGHT_and;
                try {
                    boolean exists;
                    boolean isSafe = this.isIsSafe();
                    @Nullable Boolean not = BooleanNotOperation.INSTANCE.evaluate(isSafe);
                    @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                    @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    @Nullable Comparable<Boolean> accumulator = ValueUtil.FALSE_VALUE;
                    @NonNull Iterator<Object> ITERATOR__1 = BOXED_ownedIterators.iterator();
                    while (true) {
                        if (!ITERATOR__1.hasNext()) {
                            if (accumulator == ValueUtil.FALSE_VALUE) {
                                exists = ValueUtil.FALSE_VALUE;
                                break;
                            }
                            throw (InvalidValueException)accumulator;
                        }
                        @NonNull Variable _1 = (Variable)ITERATOR__1.next();
                        boolean isRequired = _1.isIsRequired();
                        if (isRequired == ValueUtil.TRUE_VALUE) {
                            exists = ValueUtil.TRUE_VALUE;
                            break;
                        }
                        if (isRequired == ValueUtil.FALSE_VALUE) continue;
                        accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
                    }
                    @Nullable Boolean and = BooleanAndOperation.INSTANCE.evaluate(not, exists);
                    CAUGHT_and = and;
                }
                catch (Exception e) {
                    CAUGHT_and = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type safe_type_source;
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    @NonNull Boolean type = ownedSource == null;
                    if (type == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_CollectionType_0));
                    boolean isNullFree = oclAsType.isIsNullFree();
                    CAUGHT_isNullFree = Boolean.valueOf(isNullFree);
                }
                catch (Exception e) {
                    CAUGHT_isNullFree = ValueUtil.createInvalidValue(e);
                }
                @Nullable Boolean result = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_and, CAUGHT_isNullFree);
                CAUGHT_result = result;
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::UnsafeSourceCanNotBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateAnyHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateAnyTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateClosureBodyElementTypeIsIteratorType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::ClosureBodyElementTypeIsIteratorType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "closure".equals(name);
                if (eq) {
                    boolean conformsTo;
                    Type bodyElementType;
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @NonNull OCLExpression ownedBody_1 = this.getOwnedBody();
                    @Nullable Type type_1 = ownedBody_1.getType();
                    boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_1, (Object)TYP_CollectionType_0);
                    if (oclIsKindOf) {
                        Type elementType;
                        @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)type_1, (Object)TYP_CollectionType_0));
                        bodyElementType = elementType = oclAsType.getElementType();
                    } else {
                        bodyElementType = type_1;
                    }
                    @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                    @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    @Nullable Variable at = (Variable)OrderedCollectionAtOperation.INSTANCE.evaluate(BOXED_ownedIterators, PivotTables.INT_1);
                    if (at == null) {
                        throw new InvalidValueException("Null source for 'TypedElement::type'", new Object[0]);
                    }
                    @Nullable Type iteratorType = at.getType();
                    result = conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)bodyElementType, (Object)iteratorType).booleanValue();
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::ClosureBodyElementTypeIsIteratorType", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateAnyBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateClosureHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateClosureResultElementTypeIsIteratorType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::ClosureResultElementTypeIsIteratorType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "closure".equals(name);
                if (eq) {
                    boolean conformsTo;
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @Nullable Type type = this.getType();
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)type, (Object)TYP_CollectionType_0));
                    @NonNull Type resultElementType = oclAsType.getElementType();
                    @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                    @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    @Nullable Variable at = (Variable)OrderedCollectionAtOperation.INSTANCE.evaluate(BOXED_ownedIterators, PivotTables.INT_1);
                    if (at == null) {
                        throw new InvalidValueException("Null source for 'TypedElement::type'", new Object[0]);
                    }
                    @Nullable Type iteratorType = at.getType();
                    result = conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)iteratorType, (Object)resultElementType).booleanValue();
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::ClosureResultElementTypeIsIteratorType", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateClosureTypeIsUniqueCollection(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::ClosureTypeIsUniqueCollection");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "closure".equals(name);
                if (eq) {
                    boolean symbol_0;
                    Serializable CAUGHT_oclIsKindOf_1;
                    InvalidValueException CAUGHT_safe_oclIsKindOf_source;
                    @Nullable Type type_4 = this.getType();
                    try {
                        Boolean safe_oclIsKindOf_source;
                        OCLValue CAUGHT_safe_type_source;
                        Type safe_type_source;
                        @Nullable OCLExpression ownedSource = this.getOwnedSource();
                        @NonNull Boolean type = ownedSource == null;
                        if (type == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type_0;
                            assert (ownedSource != null);
                            safe_type_source = type_0 = ownedSource.getType();
                        }
                        try {
                            CAUGHT_safe_type_source = safe_type_source;
                        }
                        catch (Exception e) {
                            CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                        }
                        @NonNull Boolean oclIsKindOf = CAUGHT_safe_type_source == null;
                        if (oclIsKindOf == Boolean.TRUE) {
                            safe_oclIsKindOf_source = null;
                        } else {
                            @NonNull Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                            boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_SequenceType_0);
                            safe_oclIsKindOf_source = oclIsKindOf_0;
                        }
                        CAUGHT_safe_oclIsKindOf_source = safe_oclIsKindOf_source;
                    }
                    catch (Exception e) {
                        CAUGHT_safe_oclIsKindOf_source = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        @NonNull Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                        @NonNull Boolean type_1 = ownedSource_0 == null;
                        if (type_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_2;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_2 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source_0, (Object)TYP_OrderedSetType_0);
                        CAUGHT_oclIsKindOf_1 = Boolean.valueOf(oclIsKindOf_1);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_1 = ValueUtil.createInvalidValue(e);
                    }
                    @Nullable Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_safe_oclIsKindOf_source, CAUGHT_oclIsKindOf_1);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_2;
                        @NonNull Class TYP_OrderedSetType_1 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_OrderedSetType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_3;
                        @NonNull Class TYP_SetType_0 = idResolver.getClass(PivotTables.CLSSid_SetType, null);
                        symbol_0 = oclIsKindOf_3 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_SetType_0).booleanValue();
                    }
                    result = symbol_0;
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::ClosureTypeIsUniqueCollection", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateCollectElementTypeIsFlattenedBodyType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::CollectElementTypeIsFlattenedBodyType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "collect".equals(name);
                if (eq) {
                    boolean eq_0;
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @Nullable Type type = this.getType();
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)type, (Object)TYP_CollectionType_0));
                    @NonNull Type elementType = oclAsType.getElementType();
                    @NonNull OCLExpression ownedBody = this.getOwnedBody();
                    @Nullable Type type_0 = ownedBody.getType();
                    if (type_0 == null) {
                        throw new InvalidValueException("Null source for 'pivot::Type::flattenedType() : Type[?]'", new Object[0]);
                    }
                    @NonNull Type flattenedType = type_0.flattenedType();
                    result = eq_0 = elementType.getTypeId() == flattenedType.getTypeId();
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::CollectElementTypeIsFlattenedBodyType", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateClosureSourceElementTypeIsBodyElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateClosureElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ValueUtil.TRUE_VALUE;
    }

    @Override
    public boolean validateCollectTypeIsUnordered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::CollectTypeIsUnordered");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "collect".equals(name);
                if (eq) {
                    boolean symbol_0;
                    Serializable CAUGHT_oclIsKindOf_0;
                    Serializable CAUGHT_oclIsKindOf;
                    @Nullable Type type_4 = this.getType();
                    try {
                        Type safe_type_source;
                        @NonNull Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        @Nullable OCLExpression ownedSource = this.getOwnedSource();
                        @NonNull Boolean type = ownedSource == null;
                        if (type == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type_0;
                            assert (ownedSource != null);
                            safe_type_source = type_0 = ownedSource.getType();
                        }
                        boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_SequenceType_0);
                        CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        @NonNull Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                        @NonNull Boolean type_1 = ownedSource_0 == null;
                        if (type_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_2;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_2 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source_0, (Object)TYP_OrderedSetType_0);
                        CAUGHT_oclIsKindOf_0 = Boolean.valueOf(oclIsKindOf_0);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_0 = ValueUtil.createInvalidValue(e);
                    }
                    @Nullable Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_1;
                        @NonNull Class TYP_SequenceType_1 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        symbol_0 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_SequenceType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_2;
                        @NonNull Class TYP_BagType_0 = idResolver.getClass(PivotTables.CLSSid_BagType, null);
                        symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_BagType_0).booleanValue();
                    }
                    result = symbol_0;
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::CollectTypeIsUnordered", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateSortedByIsOrderedIfSourceIsOrdered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::SortedByIsOrderedIfSourceIsOrdered");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "sortedBy".equals(name);
                if (eq) {
                    boolean symbol_0;
                    Serializable CAUGHT_oclIsKindOf_0;
                    Serializable CAUGHT_oclIsKindOf;
                    @Nullable Type type_4 = this.getType();
                    try {
                        Type safe_type_source;
                        @NonNull Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        @Nullable OCLExpression ownedSource = this.getOwnedSource();
                        @NonNull Boolean type = ownedSource == null;
                        if (type == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type_0;
                            assert (ownedSource != null);
                            safe_type_source = type_0 = ownedSource.getType();
                        }
                        boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_SequenceType_0);
                        CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        @NonNull Class TYP_BagType_0 = idResolver.getClass(PivotTables.CLSSid_BagType, null);
                        @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                        @NonNull Boolean type_1 = ownedSource_0 == null;
                        if (type_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_2;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_2 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)safe_type_source_0, (Object)TYP_BagType_0);
                        CAUGHT_oclIsKindOf_0 = Boolean.valueOf(oclIsKindOf_0);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_0 = ValueUtil.createInvalidValue(e);
                    }
                    @Nullable Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_1;
                        @NonNull Class TYP_SequenceType_1 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        symbol_0 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_SequenceType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_2;
                        @NonNull Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)type_4, (Object)TYP_OrderedSetType_0).booleanValue();
                    }
                    result = symbol_0;
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::SortedByIsOrderedIfSourceIsOrdered", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateSortedByElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::SortedByElementTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_result;
            try {
                boolean result;
                @Nullable String name = this.getName();
                boolean eq = "sortedBy".equals(name);
                if (eq) {
                    boolean eq_0;
                    Type safe_type_source;
                    @NonNull Class TYP_CollectionType_1 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @Nullable Type type = this.getType();
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)type, (Object)TYP_CollectionType_1));
                    @NonNull Type elementType = oclAsType.getElementType();
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    @NonNull Boolean type_0 = ownedSource == null;
                    if (type_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_1;
                        assert (ownedSource != null);
                        safe_type_source = type_1 = ownedSource.getType();
                    }
                    @NonNull CollectionType oclAsType_0 = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_CollectionType_1));
                    @NonNull Type elementType_0 = oclAsType_0.getElementType();
                    result = eq_0 = elementType.getTypeId() == elementType_0.getTypeId();
                } else {
                    result = ValueUtil.TRUE_VALUE;
                }
                CAUGHT_result = Boolean.valueOf(result);
            }
            catch (Exception e) {
                CAUGHT_result = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::SortedByElementTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateIteratorTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::IteratorTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_implies;
            try {
                Serializable CAUGHT_forAll;
                Serializable CAUGHT_oclIsKindOf;
                InvalidValueException CAUGHT_safe_type_source;
                try {
                    Type safe_type_source;
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    @NonNull Boolean type = ownedSource == null;
                    if (type == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    CAUGHT_safe_type_source = safe_type_source;
                }
                catch (Exception e) {
                    CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                }
                try {
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                        throw CAUGHT_safe_type_source;
                    }
                    boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)CAUGHT_safe_type_source, (Object)TYP_CollectionType_0);
                    CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean forAll;
                    @NonNull Class TYP_CollectionType_1 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                        throw CAUGHT_safe_type_source;
                    }
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)CAUGHT_safe_type_source, (Object)TYP_CollectionType_1));
                    @NonNull Type sourceElementType = oclAsType.getElementType();
                    @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                    @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                    @NonNull Iterator<Object> ITERATOR_p = BOXED_ownedIterators.iterator();
                    while (true) {
                        Serializable CAUGHT_conformsTo;
                        if (!ITERATOR_p.hasNext()) {
                            if (accumulator == ValueUtil.TRUE_VALUE) {
                                forAll = ValueUtil.TRUE_VALUE;
                                break;
                            }
                            throw (InvalidValueException)accumulator;
                        }
                        @NonNull Variable p = (Variable)ITERATOR_p.next();
                        try {
                            @Nullable Type type_1 = p.getType();
                            boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)sourceElementType, (Object)type_1);
                            CAUGHT_conformsTo = Boolean.valueOf(conformsTo);
                        }
                        catch (Exception e) {
                            CAUGHT_conformsTo = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_conformsTo == ValueUtil.FALSE_VALUE) {
                            forAll = ValueUtil.FALSE_VALUE;
                            break;
                        }
                        if (CAUGHT_conformsTo == ValueUtil.TRUE_VALUE) continue;
                        if (CAUGHT_conformsTo instanceof InvalidValueException) {
                            accumulator = CAUGHT_conformsTo;
                            continue;
                        }
                        accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                    }
                    CAUGHT_forAll = Boolean.valueOf(forAll);
                }
                catch (Exception e) {
                    CAUGHT_forAll = ValueUtil.createInvalidValue(e);
                }
                @Nullable Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_forAll);
                CAUGHT_implies = implies;
            }
            catch (Exception e) {
                CAUGHT_implies = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::IteratorTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_implies, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateIteratorTypeIsSourceKeyType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::IteratorTypeIsSourceKeyType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_implies;
            try {
                Serializable CAUGHT_forAll;
                Serializable CAUGHT_oclIsKindOf;
                InvalidValueException CAUGHT_safe_type_source;
                try {
                    Type safe_type_source;
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    @NonNull Boolean type = ownedSource == null;
                    if (type == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    CAUGHT_safe_type_source = safe_type_source;
                }
                catch (Exception e) {
                    CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                }
                try {
                    @NonNull Class TYP_MapType_0 = idResolver.getClass(PivotTables.CLSSid_MapType, null);
                    if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                        throw CAUGHT_safe_type_source;
                    }
                    boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(executor, (Object)CAUGHT_safe_type_source, (Object)TYP_MapType_0);
                    CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean forAll;
                    @NonNull Class TYP_MapType_1 = idResolver.getClass(PivotTables.CLSSid_MapType, null);
                    if (CAUGHT_safe_type_source instanceof InvalidValueException) {
                        throw CAUGHT_safe_type_source;
                    }
                    @NonNull MapType oclAsType = ClassUtil.nonNullState((MapType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)CAUGHT_safe_type_source, (Object)TYP_MapType_1));
                    @NonNull Type sourceKeyType = oclAsType.getKeyType();
                    @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                    @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                    @NonNull Iterator<Object> ITERATOR_p = BOXED_ownedIterators.iterator();
                    while (true) {
                        Serializable CAUGHT_conformsTo;
                        if (!ITERATOR_p.hasNext()) {
                            if (accumulator == ValueUtil.TRUE_VALUE) {
                                forAll = ValueUtil.TRUE_VALUE;
                                break;
                            }
                            throw (InvalidValueException)accumulator;
                        }
                        @NonNull Variable p = (Variable)ITERATOR_p.next();
                        try {
                            @Nullable Type type_1 = p.getType();
                            boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)sourceKeyType, (Object)type_1);
                            CAUGHT_conformsTo = Boolean.valueOf(conformsTo);
                        }
                        catch (Exception e) {
                            CAUGHT_conformsTo = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_conformsTo == ValueUtil.FALSE_VALUE) {
                            forAll = ValueUtil.FALSE_VALUE;
                            break;
                        }
                        if (CAUGHT_conformsTo == ValueUtil.TRUE_VALUE) continue;
                        if (CAUGHT_conformsTo instanceof InvalidValueException) {
                            accumulator = CAUGHT_conformsTo;
                            continue;
                        }
                        accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                    }
                    CAUGHT_forAll = Boolean.valueOf(forAll);
                }
                catch (Exception e) {
                    CAUGHT_forAll = ValueUtil.createInvalidValue(e);
                }
                @Nullable Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_forAll);
                CAUGHT_implies = implies;
            }
            catch (Exception e) {
                CAUGHT_implies = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::IteratorTypeIsSourceKeyType", this, null, diagnostics, context, null, severity_0, CAUGHT_implies, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateSafeIteratorIsRequired(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::SafeIteratorIsRequired");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            boolean result;
            boolean isSafe = this.isIsSafe();
            if (isSafe) {
                boolean forAll;
                @NonNull List<Variable> ownedIterators = this.getOwnedIterators();
                @NonNull OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                @NonNull Iterator<Object> ITERATOR__1 = BOXED_ownedIterators.iterator();
                while (true) {
                    if (!ITERATOR__1.hasNext()) {
                        if (accumulator == ValueUtil.TRUE_VALUE) {
                            forAll = ValueUtil.TRUE_VALUE;
                            break;
                        }
                        throw (InvalidValueException)accumulator;
                    }
                    @NonNull Variable _1 = (Variable)ITERATOR__1.next();
                    boolean isRequired = _1.isIsRequired();
                    if (isRequired == ValueUtil.FALSE_VALUE) {
                        forAll = ValueUtil.FALSE_VALUE;
                        break;
                    }
                    if (isRequired == ValueUtil.TRUE_VALUE) continue;
                    accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                }
                result = forAll;
            } else {
                result = ValueUtil.TRUE_VALUE;
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::SafeIteratorIsRequired", this, null, diagnostics, context, null, severity_0, result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"IteratorExp::SafeSourceCanBeNull");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Boolean result;
            boolean isSafe = this.isIsSafe();
            if (isSafe) {
                Boolean not;
                Serializable CAUGHT_isNullFree;
                try {
                    Type safe_type_source;
                    @NonNull Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    @NonNull Boolean type = ownedSource == null;
                    if (type == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    @NonNull CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)TYP_CollectionType_0));
                    boolean isNullFree = oclAsType.isIsNullFree();
                    CAUGHT_isNullFree = Boolean.valueOf(isNullFree);
                }
                catch (Exception e) {
                    CAUGHT_isNullFree = ValueUtil.createInvalidValue(e);
                }
                result = not = BooleanNotOperation.INSTANCE.evaluate(CAUGHT_isNullFree);
            } else {
                result = ValueUtil.TRUE_VALUE;
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "IteratorExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, result, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.isNonNull();
            }
            case 4: {
                return this.isNull();
            }
            case 5: {
                return this.validateTypeIsNotNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 31: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateSafeSourceCannotBeMap((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.validateMatchingMapCoIterators((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 10: {
                return this.validateNoCoInitializers((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 11: {
                return this.validateNoCollectionCoIterators((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 12: {
                return this.validateNoInitializers((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 13: {
                return this.validateSourceIsCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 14: {
                return this.validateSourceIsIterable((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 15: {
                return this.getReferredElement();
            }
            case 16: {
                return this.validateAnyBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 17: {
                return this.validateAnyHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 18: {
                return this.validateAnyTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 19: {
                return this.validateClosureBodyElementTypeIsIteratorType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 20: {
                return this.validateClosureBodyTypeIsConformanttoIteratorType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 21: {
                return this.validateClosureElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 22: {
                return this.validateClosureHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 23: {
                return this.validateClosureResultElementTypeIsIteratorType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 24: {
                return this.validateClosureSourceElementTypeIsBodyElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 25: {
                return this.validateClosureTypeIsUniqueCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 26: {
                return this.validateCollectElementTypeIsFlattenedBodyType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 27: {
                return this.validateCollectTypeIsUnordered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 28: {
                return this.validateIteratorTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 29: {
                return this.validateIteratorTypeIsSourceKeyType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 30: {
                return this.validateSafeIteratorIsRequired((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 32: {
                return this.validateSortedByElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 33: {
                return this.validateSortedByIsOrderedIfSourceIsOrdered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 34: {
                return this.validateSortedByIteratorTypeIsComparable((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 35: {
                return this.validateUnsafeSourceCanNotBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitIteratorExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredIteration();
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == CallExp.class) {
            switch (baseOperationID) {
                case 6: {
                    return 31;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 15;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }
}

