/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.NumericLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionRangeNode;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyEdge;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EnumLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.IfNode;
import org.eclipse.qvtd.pivot.qvtschedule.IncludesEdge;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratorNode;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MapLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.MapPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.MapPartNode;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MergedPartition;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NonPartition;
import org.eclipse.qvtd.pivot.qvtschedule.NullLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NumericLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationParameterEdge;
import org.eclipse.qvtd.pivot.qvtschedule.OperationSelfEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PatternTypedNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternVariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowNode;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.StringLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.TupleLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.TuplePartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.TypeLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionHelper<R extends Region>
extends QVTscheduleUtil
implements Nameable {
    public static final @NonNull String EQUALS_NAME = "\u00abequals\u00bb";
    public static final @NonNull String INCLUDES_NAME = "\u00abincludes\u00bb";
    public static final @NonNull String LOOP_ITERATOR_NAME = "\u00abiterator\u00bb";
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull R region;

    public RegionHelper(@NonNull ScheduleManager scheduleManager, @NonNull R region) {
        this.scheduleManager = scheduleManager;
        this.region = region;
    }

    public @NonNull BasicPartition createBasicPartition(@NonNull String name, @NonNull Iterable<@NonNull Node> headNodes) {
        BasicPartition basicPartition = QVTscheduleFactory.eINSTANCE.createBasicPartition();
        basicPartition.setName(name);
        ((MappingRegion)this.region).getMappingPartitions().add(basicPartition);
        Iterables.addAll((Collection)QVTscheduleUtil.Internal.getHeadNodesList((BasicPartition)basicPartition), headNodes);
        return basicPartition;
    }

    public @NonNull BooleanLiteralNode createBooleanLiteralNode(boolean isTrue) {
        ClassDatum classDatum = this.scheduleManager.getBooleanClassDatum();
        BooleanLiteralNode booleanLiteralNode = QVTscheduleFactory.eINSTANCE.createBooleanLiteralNode();
        booleanLiteralNode.initialize(Role.CONSTANT, this.region, Boolean.toString(isTrue), classDatum);
        booleanLiteralNode.setMatched(true);
        booleanLiteralNode.setBooleanValue(isTrue);
        return booleanLiteralNode;
    }

    public @NonNull BooleanLiteralNode createBooleanLiteralNode(boolean isMatched, boolean booleanValue, @NonNull BooleanLiteralExp booleanLiteralExp) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)booleanLiteralExp, (Node[])new Node[0]);
        BooleanLiteralNode booleanLiteralNode = QVTscheduleFactory.eINSTANCE.createBooleanLiteralNode();
        booleanLiteralNode.initialize(nodeRole, this.region, Boolean.toString(booleanValue), this.scheduleManager.getClassDatum((TypedElement)booleanLiteralExp));
        booleanLiteralNode.setMatched(isMatched);
        booleanLiteralNode.setBooleanValue(booleanValue);
        booleanLiteralNode.setOriginatingElement((Element)booleanLiteralExp);
        return booleanLiteralNode;
    }

    public @NonNull NavigableEdge createCastEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        Role phase;
        Role edgeRole = phase = RegionHelper.mergeToLessKnownPhase((Role)RegionHelper.getNodeRole((Node)sourceNode), (Role)RegionHelper.getNodeRole((Node)targetNode));
        CastEdge castEdge = QVTscheduleFactory.eINSTANCE.createCastEdge();
        castEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        castEdge.initializeProperty(source2targetProperty);
        return castEdge;
    }

    public @NonNull CollectionLiteralNode createCollectionLiteralNode(boolean isMatched, @NonNull String name, @NonNull CollectionLiteralExp collectionLiteralExp, @NonNull Node @NonNull [] partNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)collectionLiteralExp, (Node[])partNodes);
        CollectionLiteralNode node = QVTscheduleFactory.eINSTANCE.createCollectionLiteralNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)collectionLiteralExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)collectionLiteralExp);
        return node;
    }

    public @NonNull Edge createCollectionPartEdge(@NonNull Node sourceNode, @NonNull CollectionLiteralPart collectionPart, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        CollectionPartEdge edge = QVTscheduleFactory.eINSTANCE.createCollectionPartEdge();
        edge.setReferredPart(collectionPart);
        String label = "\u00ab" + collectionPart.getName() + "\u00bb";
        edge.initialize(edgeRole, sourceNode, label, targetNode);
        return edge;
    }

    public @NonNull CollectionRangeNode createCollectionRangeNode(boolean isMatched, @NonNull String name, @NonNull CollectionRange collectionRange, @NonNull Node @NonNull [] argNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)collectionRange, (Node[])argNodes);
        CollectionRangeNode node = QVTscheduleFactory.eINSTANCE.createCollectionRangeNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)collectionRange));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)collectionRange);
        return node;
    }

    public static @NonNull CyclicPartition createCyclicPartition(@NonNull String name, @NonNull Object scheduleManager) {
        CyclicPartition cyclicPartition = QVTscheduleFactory.eINSTANCE.createCyclicPartition();
        cyclicPartition.setName(name);
        return cyclicPartition;
    }

    public @NonNull Node createDataTypeNode(@NonNull String name, @NonNull Node sourceNode, @NonNull NavigationCallExp navigationCallExp) {
        Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        boolean isMatched = sourceNode.isMatched() && RegionHelper.isMatched((Element)property);
        Role nodeRole = this.getPatternNodeRole(sourceNode, property);
        assert (sourceNode.isClass() || property.getOpposite() != null);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)navigationCallExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)navigationCallExp);
        return node;
    }

    public @NonNull Node createDataTypeNode(@NonNull Node targetNode, @NonNull NavigationAssignment navigationAssignment) {
        Role nodeRole = RegionHelper.getNodeRole((Node)targetNode);
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        String name = property.getName();
        assert (name != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionHelper.getTypedModel((Node)targetNode);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(true);
        node.setOriginatingElement((Element)property);
        return node;
    }

    public @NonNull Node createDataTypeNode(@NonNull Node sourceNode, @NonNull Property property) {
        Role nodeRole = this.getPatternNodeRole(sourceNode, property);
        return this.createPatternNode(nodeRole, sourceNode, property, sourceNode.isMatched() && RegionHelper.isMatched((Element)property));
    }

    public @NonNull Node createDependencyClassNode(@NonNull Node parentNode, @NonNull NavigationAssignment navigationAssignment) {
        assert (parentNode.isClass());
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        assert (property != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionHelper.getTypedModel((Node)parentNode);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        String name = property.getName();
        assert (name != null);
        return this.createDependencyNode(name, classDatum);
    }

    public @NonNull Edge createDependencyEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        DependencyEdge edge = QVTscheduleFactory.eINSTANCE.createDependencyEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createDependencyNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        Role nodeRole = Role.PREDICATED;
        DependencyNode node = QVTscheduleFactory.eINSTANCE.createDependencyNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull EnumLiteralNode createEnumLiteralNode(boolean isMatched, @NonNull EnumerationLiteral enumValue, @NonNull EnumLiteralExp enumLiteralExp) {
        ClassDatum classDatum = this.scheduleManager.getClassDatum((TypedElement)enumLiteralExp);
        String typeName = PrettyPrinter.printType((Element)enumValue);
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)enumLiteralExp, (Node[])new Node[0]);
        EnumLiteralNode enumLiteralNode = QVTscheduleFactory.eINSTANCE.createEnumLiteralNode();
        enumLiteralNode.initialize(nodeRole, this.region, typeName, classDatum);
        enumLiteralNode.setMatched(isMatched);
        enumLiteralNode.setEnumValue(enumValue);
        enumLiteralNode.setOriginatingElement((Element)enumLiteralExp);
        return enumLiteralNode;
    }

    public @NonNull Edge createEqualsEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        System.err.println("Unexpected \u00abequals\u00bb edge in " + this.region + " from " + sourceNode + " to " + targetNode);
        return this.createPredicateEdge(sourceNode, EQUALS_NAME, targetNode);
    }

    public @NonNull Node createErrorNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        Role nodeRole = Role.OTHER;
        ErrorNode node = QVTscheduleFactory.eINSTANCE.createErrorNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull IfNode createIfNode(boolean isMatched, @NonNull String name, @NonNull IfExp ifExp, @NonNull Node @NonNull [] argNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)ifExp, (Node[])argNodes);
        IfNode node = QVTscheduleFactory.eINSTANCE.createIfNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)ifExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)ifExp);
        return node;
    }

    public @NonNull IfNode createIfNode2(boolean isMatched, @NonNull String name, @NonNull ClassDatum classDatum, @NonNull Node @NonNull [] argNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, null, (Node[])argNodes);
        IfNode node = QVTscheduleFactory.eINSTANCE.createIfNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull Node createInputNode(@NonNull Role nodeRole, @NonNull String name, @NonNull ClassDatum classDatum) {
        InputNode node = QVTscheduleFactory.eINSTANCE.createInputNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull Edge createIteratedEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        IteratedEdge edge = QVTscheduleFactory.eINSTANCE.createIteratedEdge();
        edge.initialize(edgeRole, sourceNode, LOOP_ITERATOR_NAME, targetNode);
        return edge;
    }

    public @NonNull VariableNode createIteratorNode(@NonNull VariableDeclaration iterator, @NonNull Node sourceNode) {
        Role nodeRole = RegionHelper.getNodeRole((Node)sourceNode);
        IteratorNode node = QVTscheduleFactory.eINSTANCE.createIteratorNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)iterator), this.scheduleManager.getClassDatum((TypedElement)iterator));
        node.initializeVariable(this.region, iterator);
        return node;
    }

    public @NonNull Edge createKeyPartEdge(@NonNull Node sourceNode, @NonNull PropertyDatum propertyDatum, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        KeyPartEdge edge = QVTscheduleFactory.eINSTANCE.createKeyPartEdge();
        edge.setReferredPart(propertyDatum);
        Property referredProperty = QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum);
        String name = "\u00ab" + QVTrelationUtil.getName((NamedElement)referredProperty) + "\u00bb";
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createKeyedNode(boolean isMatched, @NonNull String name, @NonNull VariableDeclaration templateVariable) {
        ClassDatum classDatum = this.scheduleManager.getClassDatum((TypedElement)templateVariable);
        KeyedValueNode node = QVTscheduleFactory.eINSTANCE.createKeyedValueNode();
        node.setClassDatumValue(classDatum);
        node.initialize(Role.REALIZED, this.region, name, classDatum);
        this.region.addVariableNode(templateVariable, (Node)node);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull VariableNode createLetVariableNode(@NonNull VariableDeclaration letVariable, @NonNull Node inNode) {
        Role nodeRole = RegionHelper.getNodeRole((Node)inNode);
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)letVariable), this.scheduleManager.getClassDatum((TypedElement)letVariable));
        node.initializeVariable(this.region, letVariable);
        node.setMatched(inNode.isMatched());
        return node;
    }

    public @NonNull VariableNode createLoadedStepNode(@NonNull VariableDeclaration stepVariable) {
        Role nodeRole = Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)stepVariable), this.scheduleManager.getClassDatum((TypedElement)stepVariable));
        node.initializeVariable(this.region, stepVariable);
        node.setMatched(true);
        return node;
    }

    public @NonNull LoadingPartition createLoadingPartition() {
        LoadingPartition loadingPartition = QVTscheduleFactory.eINSTANCE.createLoadingPartition();
        loadingPartition.setName(this.region.getName());
        ((LoadingRegion)this.region).setLoadingPartition(loadingPartition);
        return loadingPartition;
    }

    public @NonNull MapLiteralNode createMapLiteralNode(boolean isMatched, @NonNull String name, @NonNull MapLiteralExp mapLiteralExp, @NonNull Node @NonNull [] partNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)mapLiteralExp, (Node[])partNodes);
        MapLiteralNode node = QVTscheduleFactory.eINSTANCE.createMapLiteralNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)mapLiteralExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)mapLiteralExp);
        return node;
    }

    public @NonNull Edge createMapPartEdge(@NonNull Node sourceNode, @NonNull MapLiteralPart mapPart, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        MapPartEdge edge = QVTscheduleFactory.eINSTANCE.createMapPartEdge();
        edge.setReferredPart(mapPart);
        String label = "\u00ab" + mapPart.toString() + "\u00bb";
        edge.initialize(edgeRole, sourceNode, label, targetNode);
        return edge;
    }

    public @NonNull Node createMapPartNode(boolean isMatched, @NonNull String name, @NonNull MapLiteralPart mapLiteralPart, @NonNull Node @NonNull [] argNodes) {
        OCLExpression typedElement = QVTbaseUtil.getOwnedValue((MapLiteralPart)mapLiteralPart);
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)typedElement, (Node[])argNodes);
        MapPartNode node = QVTscheduleFactory.eINSTANCE.createMapPartNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)typedElement));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)mapLiteralPart);
        return node;
    }

    public @NonNull MergedPartition createMergedPartition(@NonNull String name, @NonNull Iterable<@NonNull Node> headNodes) {
        MergedPartition mergedPartition = QVTscheduleFactory.eINSTANCE.createMergedPartition();
        mergedPartition.setName(name);
        ((MappingRegion)this.region).getMappingPartitions().add(mergedPartition);
        Iterables.addAll((Collection)QVTscheduleUtil.Internal.getHeadNodesList((BasicPartition)mergedPartition), headNodes);
        return mergedPartition;
    }

    public @NonNull NavigableEdge createNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role phase;
        Role edgeRole = phase = RegionHelper.mergeToLessKnownPhase((Role)RegionHelper.getNodeRole((Node)sourceNode), (Role)RegionHelper.getNodeRole((Node)targetNode));
        NavigationEdge edge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        edge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        edge.initializeProperty(source2targetProperty, isPartial);
        return edge;
    }

    public @NonNull NonPartition createNonPartition(@NonNull String name) {
        NonPartition nonPartition = QVTscheduleFactory.eINSTANCE.createNonPartition();
        nonPartition.setName(name);
        ((MappingRegion)this.region).getMappingPartitions().add(nonPartition);
        return nonPartition;
    }

    public @NonNull Node createNullLiteralNode(boolean isMatched, @Nullable NullLiteralExp nullLiteralExp) {
        Role nodeRole = Role.CONSTANT;
        ClassDatum classDatum = nullLiteralExp != null ? this.scheduleManager.getClassDatum((TypedElement)nullLiteralExp) : this.scheduleManager.getOclVoidClassDatum();
        NullLiteralNode node = QVTscheduleFactory.eINSTANCE.createNullLiteralNode();
        node.initialize(nodeRole, this.region, "\u00abnull\u00bb", classDatum);
        node.setMatched(isMatched);
        if (nullLiteralExp != null) {
            node.setOriginatingElement((Element)nullLiteralExp);
        }
        return node;
    }

    public @NonNull NumericLiteralNode createNumericLiteralNode(boolean isMatched, @NonNull Number numericValue, @NonNull NumericLiteralExp numericLiteralExp) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)numericLiteralExp, (Node[])new Node[0]);
        NumericLiteralNode node = QVTscheduleFactory.eINSTANCE.createNumericLiteralNode();
        node.initialize(nodeRole, this.region, numericValue.toString(), this.scheduleManager.getClassDatum((TypedElement)numericLiteralExp));
        node.setMatched(isMatched);
        node.setNumericValue(numericValue);
        node.setOriginatingElement((Element)numericLiteralExp);
        return node;
    }

    public @NonNull VariableNode createOldNode(@NonNull VariableDeclaration variable) {
        Role phase;
        DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)variable);
        boolean isEnforceable = domainUsage.isOutput() || domainUsage.isMiddle();
        Role nodeRole = phase = isEnforceable ? Role.PREDICATED : Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)variable), this.scheduleManager.getClassDatum((TypedElement)variable));
        node.initializeVariable(this.region, variable);
        node.setMatched(true);
        return node;
    }

    public @NonNull OperationCallNode createOperationCallNode(boolean isMatched, @Nullable String nameHint, @NonNull Operation operation, @NonNull TypedElement callExpOrCollectionTemplateExp, Node ... argNodes) {
        String name = nameHint;
        if (name == null) {
            name = QVTbaseUtil.getName((NamedElement)operation);
        }
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)callExpOrCollectionTemplateExp, (Node[])argNodes);
        OperationCallNode node = QVTscheduleFactory.eINSTANCE.createOperationCallNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum(callExpOrCollectionTemplateExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)callExpOrCollectionTemplateExp);
        node.setReferredOperation(operation);
        return node;
    }

    public @NonNull OperationCallNode createOperationCallNode2(@NonNull Role nodeRole, boolean isMatched, @Nullable String nameHint, @NonNull Operation operation, @NonNull ClassDatum classDatum, Node ... argNodes) {
        String name = nameHint;
        if (name == null) {
            name = QVTbaseUtil.getName((NamedElement)operation);
        }
        assert (nodeRole != null);
        OperationCallNode node = QVTscheduleFactory.eINSTANCE.createOperationCallNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(isMatched);
        node.setReferredOperation(operation);
        return node;
    }

    public @NonNull Edge createOperationParameterEdge(@NonNull Node sourceNode, @NonNull Parameter parameter, int parameterIndex, @NonNull Node targetNode) {
        String name;
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        OperationParameterEdge edge = QVTscheduleFactory.eINSTANCE.createOperationParameterEdge();
        edge.setReferredParameter(parameter);
        if (parameterIndex >= 0) {
            edge.setParameterIndex(parameterIndex);
            name = "\u00ab" + parameter.getName() + "-" + parameterIndex + "\u00bb";
        } else {
            name = "\u00ab" + parameter.getName() + "\u00bb";
        }
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Edge createOperationSelfEdge(@NonNull Node sourceNode, @NonNull Type type, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        OperationSelfEdge edge = QVTscheduleFactory.eINSTANCE.createOperationSelfEdge();
        edge.setReferredType(type);
        String name = "\u00abself\u00bb";
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createPatternNode(@NonNull Role nodeRole, @NonNull Node sourceNode, @NonNull Property source2targetProperty, boolean isMatched) {
        TypedModel typedModel;
        assert (sourceNode.isClass());
        Class type = (Class)source2targetProperty.getType();
        assert (type != null);
        Type elementType = PivotUtil.getElementalType((Type)type);
        TypedModel typedModel2 = typedModel = elementType instanceof DataType ? this.scheduleManager.getDomainUsageAnalysis().getPrimitiveTypeModel() : sourceNode.getClassDatum().getReferredTypedModel();
        assert (typedModel != null);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        String name = source2targetProperty.getName();
        assert (name != null);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull Edge createPredicateEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        PredicateEdge edge = QVTscheduleFactory.eINSTANCE.createPredicateEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createPredicatedNode(@NonNull String name, @NonNull ClassDatum classDatum, boolean isMatched) {
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(Role.PREDICATED, this.region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull Node createPredicatedStepNode(@NonNull Node typedNode, boolean isMatched) {
        String name = RegionHelper.getName((Nameable)typedNode);
        ClassDatum classDatum = RegionHelper.getClassDatum((Node)typedNode);
        return this.createPredicatedNode(name, classDatum, isMatched);
    }

    public @NonNull SuccessEdge createPredicatedSuccess(@NonNull Node sourceNode, @NonNull Property source2targetProperty, boolean isSuccess) {
        BooleanLiteralNode successNode = this.createBooleanLiteralNode(isSuccess);
        SuccessEdge edge = QVTscheduleFactory.eINSTANCE.createSuccessEdge();
        edge.initialize(Role.PREDICATED, sourceNode, source2targetProperty.getName(), (Node)successNode);
        edge.initializeProperty(source2targetProperty, Boolean.valueOf(false));
        return edge;
    }

    public @NonNull Node createRealizedDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        Role nodeRole = Role.REALIZED;
        return this.createPatternNode(nodeRole, sourceNode, source2targetProperty, sourceNode.isMatched());
    }

    public @NonNull Edge createRealizedIncludesEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        Role edgeRole = Role.REALIZED;
        IncludesEdge edge = QVTscheduleFactory.eINSTANCE.createIncludesEdge();
        edge.initialize(edgeRole, sourceNode, INCLUDES_NAME, targetNode);
        return edge;
    }

    public @NonNull NavigableEdge createRealizedNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role edgeRole = Role.REALIZED;
        NavigationEdge forwardEdge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        forwardEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        forwardEdge.initializeProperty(source2targetProperty, isPartial);
        return forwardEdge;
    }

    public @NonNull VariableNode createRealizedNode(@NonNull String name, @NonNull ClassDatum classDatum, boolean isMatched) {
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(Role.REALIZED, this.region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull VariableNode createRealizedStepNode(@NonNull VariableDeclaration stepVariable) {
        VariableNode node = this.createRealizedNode(RegionHelper.getName((Nameable)stepVariable), this.scheduleManager.getClassDatum((TypedElement)stepVariable), true);
        node.initializeVariable(this.region, stepVariable);
        return node;
    }

    public @NonNull SuccessEdge createRealizedSuccess(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @Nullable Boolean isSuccess) {
        BooleanLiteralNode node;
        ClassDatum classDatum = this.scheduleManager.getBooleanClassDatum();
        if (isSuccess != null) {
            node = this.createBooleanLiteralNode(isSuccess);
        } else {
            SuccessNode successNode = QVTscheduleFactory.eINSTANCE.createSuccessNode();
            successNode.initialize(Role.REALIZED, this.region, "\u00absuccess\u00bb", classDatum);
            node = successNode;
        }
        SuccessEdge edge = QVTscheduleFactory.eINSTANCE.createSuccessEdge();
        edge.initialize(Role.REALIZED, sourceNode, source2targetProperty.getName(), (Node)node);
        edge.initializeProperty(source2targetProperty, Boolean.valueOf(false));
        return edge;
    }

    public static @NonNull RootPartition createRootPartition(@NonNull String name, @NonNull Object scheduleManager) {
        RootPartition rootPartition = QVTscheduleFactory.eINSTANCE.createRootPartition();
        rootPartition.setName(name);
        return rootPartition;
    }

    public @NonNull ShadowNode createShadowNode(boolean isMatched, @NonNull String name, @NonNull ShadowExp shadowExp, @NonNull Node @NonNull [] partNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)shadowExp, (Node[])partNodes);
        ShadowNode node = QVTscheduleFactory.eINSTANCE.createShadowNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)shadowExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)shadowExp);
        return node;
    }

    public @NonNull Edge createShadowPartEdge(@NonNull Node sourceNode, @NonNull ShadowPart shadowPart, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        ShadowPartEdge edge = QVTscheduleFactory.eINSTANCE.createShadowPartEdge();
        edge.setReferredPart(shadowPart);
        String label = "\u00ab" + shadowPart.getName() + "\u00bb";
        edge.initialize(edgeRole, sourceNode, label, targetNode);
        return edge;
    }

    public @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode, boolean isMatched) {
        Role phase;
        DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)callExp);
        boolean isMiddleOrOutput = domainUsage.isOutput() || domainUsage.isMiddle();
        boolean isDirty = false;
        if (callExp instanceof NavigationCallExp) {
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp));
            isDirty = this.scheduleManager.isDirty(referredProperty);
        }
        Role stepNodeRole = phase = isMiddleOrOutput || isDirty ? Role.PREDICATED : Role.LOADED;
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(stepNodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)callExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)callExp);
        return node;
    }

    public @NonNull StringLiteralNode createStringLiteralNode(boolean isMatched, @NonNull String stringValue, @NonNull StringLiteralExp stringLiteralExp) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)stringLiteralExp, (Node[])new Node[0]);
        StringLiteralNode node = QVTscheduleFactory.eINSTANCE.createStringLiteralNode();
        node.initialize(nodeRole, this.region, stringValue, this.scheduleManager.getClassDatum((TypedElement)stringLiteralExp));
        node.setMatched(isMatched);
        node.setStringValue(stringValue);
        node.setOriginatingElement((Element)stringLiteralExp);
        return node;
    }

    public @NonNull TupleLiteralNode createTupleLiteralNode(boolean isMatched, @NonNull String name, @NonNull TupleLiteralExp tupleLiteralExp, @NonNull Node @NonNull [] partNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)tupleLiteralExp, (Node[])partNodes);
        TupleLiteralNode node = QVTscheduleFactory.eINSTANCE.createTupleLiteralNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)tupleLiteralExp));
        node.setMatched(isMatched);
        node.setOriginatingElement((Element)tupleLiteralExp);
        return node;
    }

    public @NonNull Edge createTuplePartEdge(@NonNull Node sourceNode, @NonNull TupleLiteralPart tuplePart, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        TuplePartEdge edge = QVTscheduleFactory.eINSTANCE.createTuplePartEdge();
        edge.setReferredPart(tuplePart);
        String label = "\u00ab" + tuplePart.getName() + "\u00bb";
        edge.initialize(edgeRole, sourceNode, label, targetNode);
        return edge;
    }

    public @NonNull TypeLiteralNode createTypeLiteralNode(boolean isMatched, @NonNull Type typeValue, @NonNull TypeExp typeExp) {
        ClassDatum classDatum = this.scheduleManager.getClassDatum((TypedElement)typeExp);
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)typeExp, (Node[])new Node[0]);
        TypeLiteralNode typeLiteralNode = QVTscheduleFactory.eINSTANCE.createTypeLiteralNode();
        typeLiteralNode.initialize(nodeRole, this.region, String.valueOf(typeValue), classDatum);
        typeLiteralNode.setMatched(isMatched);
        typeLiteralNode.setTypeValue(typeValue);
        typeLiteralNode.setOriginatingElement((Element)typeExp);
        return typeLiteralNode;
    }

    public @NonNull Node createUnknownNode(@NonNull String name, @NonNull TypedElement typedElement) {
        Role nodeRole = Role.OTHER;
        UnknownNode node = QVTscheduleFactory.eINSTANCE.createUnknownNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum(typedElement));
        return node;
    }

    public @NonNull String getName() {
        return QVTscheduleUtil.getName(this.region);
    }

    protected @NonNull Role getPatternNodeRole(@NonNull Node sourceNode, @NonNull Property property) {
        Role phase;
        switch (RegionHelper.getNodeRole((Node)sourceNode)) {
            case REALIZED: {
                phase = Role.REALIZED;
                break;
            }
            case PREDICATED: {
                phase = Role.PREDICATED;
                break;
            }
            case LOADED: {
                boolean isDirty = this.scheduleManager.isDirty(property);
                phase = isDirty ? Role.PREDICATED : Role.LOADED;
                break;
            }
            case CONSTANT: 
            case CONSTANT_SUCCESS_FALSE: 
            case CONSTANT_SUCCESS_TRUE: {
                phase = Role.CONSTANT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return phase;
    }

    public @NonNull R getRegion() {
        return this.region;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }
}

