/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.AbstractNlsFile;
import org.eclipse.scout.sdk.s2e.util.WeakResourceChangeListener;

public class WorkspaceNlsFile
extends AbstractNlsFile {
    private final IFile m_file;
    private final IResourceChangeListener m_translationFileChangedListener;

    public WorkspaceNlsFile(IFile file) {
        super(file);
        this.m_file = file;
        this.m_translationFileChangedListener = new P_NlsFileChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WeakResourceChangeListener(this.m_translationFileChangedListener), 1);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private class P_NlsFileChangeListener
    implements IResourceChangeListener {
        private P_NlsFileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getBuildKind() != 0) {
                return;
            }
            try {
                IResourceDelta delta = event.getDelta();
                final boolean[] myFileFound = new boolean[1];
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta d) throws CoreException {
                        if (myFileFound[0]) {
                            return false;
                        }
                        myFileFound[0] = WorkspaceNlsFile.this.m_file.equals((Object)d.getResource());
                        return !myFileFound[0];
                    }
                });
                if (myFileFound[0]) {
                    WorkspaceNlsFile.this.parseInput(WorkspaceNlsFile.this.m_file);
                }
            }
            catch (CoreException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
        }
    }
}

