/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.importexport;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.s2e.nls.importexport.AbstractImportExportWizard;
import org.eclipse.scout.sdk.s2e.nls.importexport.NlsExportImportExtensionPoints;
import org.eclipse.scout.sdk.s2e.nls.importexport.WizardExtension;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ImportExportWizardPage
extends WizardPage {
    private IWizardPage m_nextPage;
    private final String m_extensionPointId;
    private final INlsProject m_project;

    public ImportExportWizardPage(String title, String description, INlsProject project, String extensionPointId) {
        super(ImportExportWizardPage.class.getName());
        this.m_project = project;
        this.m_extensionPointId = extensionPointId;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Table table = new Table(parent, 68100);
        TableViewer viewer = new TableViewer(table);
        P_TableContentProvider provider = new P_TableContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        viewer.setContentProvider((IContentProvider)provider);
        viewer.setInput((Object)provider);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                WizardExtension extension = null;
                if (!selection.isEmpty()) {
                    extension = (WizardExtension)selection.getFirstElement();
                }
                ImportExportWizardPage.this.handleWizardExtensionSelected(extension);
                IWizardPage page = ImportExportWizardPage.this.getNextPage();
                if (page != null && (container = ImportExportWizardPage.this.getWizard().getContainer()) != null) {
                    container.showPage(page);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                WizardExtension extension = null;
                if (!selection.isEmpty()) {
                    extension = (WizardExtension)selection.getFirstElement();
                }
                ImportExportWizardPage.this.handleWizardExtensionSelected(extension);
            }
        });
        this.setControl((Control)table);
    }

    private void handleWizardExtensionSelected(WizardExtension extension) {
        boolean pageComplete = false;
        if (extension != null) {
            AbstractImportExportWizard wizard = extension.createWizard();
            wizard.setNlsProject(this.m_project);
            wizard.addPages();
            if (wizard.getPageCount() > 0) {
                this.setNextPage(wizard.getPages()[0]);
                pageComplete = true;
            }
        }
        this.setPageComplete(pageComplete);
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    private void setNextPage(IWizardPage nextPage) {
        this.m_nextPage = nextPage;
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private P_TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List<WizardExtension> exts = NlsExportImportExtensionPoints.getExtensions(ImportExportWizardPage.this.m_extensionPointId);
            return exts.toArray(new WizardExtension[exts.size()]);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((WizardExtension)element).getName();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

