/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.ordering;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractEdgeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.SimpleCompositeEdgeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.SimpleCompositeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;

public final class ViewOrderingHint {
    private static ViewOrderingHint instance = new ViewOrderingHint();
    private Map<View, ViewOrdering> viewOrderingsStock = new WeakHashMap<View, ViewOrdering>();
    private Map<View, AbstractEdgeViewOrdering> edgeViewOrderingsStock = new WeakHashMap<View, AbstractEdgeViewOrdering>();

    private ViewOrderingHint() {
    }

    public static ViewOrderingHint getInstance() {
        return instance;
    }

    public void putViewOrdering(View view, ViewOrdering viewOrdering) {
        ViewOrdering oldOrdering = this.viewOrderingsStock.get(view);
        if (oldOrdering == null) {
            this.viewOrderingsStock.put(view, viewOrdering);
        } else if (oldOrdering instanceof SimpleCompositeViewOrdering) {
            SimpleCompositeViewOrdering compositeViewOrdering = (SimpleCompositeViewOrdering)oldOrdering;
            compositeViewOrdering.addViewOrdering(viewOrdering);
        } else if (oldOrdering != viewOrdering) {
            SimpleCompositeViewOrdering compositeViewOrdering = new SimpleCompositeViewOrdering();
            compositeViewOrdering.addViewOrdering(oldOrdering);
            compositeViewOrdering.addViewOrdering(viewOrdering);
            this.viewOrderingsStock.put(view, compositeViewOrdering);
        }
    }

    public void putEdgeViewOrdering(View view, AbstractEdgeViewOrdering edgeViewOrdering) {
        ViewOrdering oldOrdering = this.edgeViewOrderingsStock.get(view);
        if (oldOrdering == null) {
            this.edgeViewOrderingsStock.put(view, edgeViewOrdering);
        } else if (oldOrdering instanceof SimpleCompositeEdgeViewOrdering) {
            SimpleCompositeEdgeViewOrdering compositeViewOrdering = (SimpleCompositeEdgeViewOrdering)oldOrdering;
            compositeViewOrdering.addEdgeViewOrdering(edgeViewOrdering);
        } else if (oldOrdering instanceof AbstractEdgeViewOrdering) {
            SimpleCompositeEdgeViewOrdering compositeViewOrdering = new SimpleCompositeEdgeViewOrdering();
            compositeViewOrdering.addEdgeViewOrdering((AbstractEdgeViewOrdering)oldOrdering);
            compositeViewOrdering.addEdgeViewOrdering(edgeViewOrdering);
            this.edgeViewOrderingsStock.put(view, compositeViewOrdering);
        }
    }

    public ViewOrdering consumeViewOrdering(View view) {
        ViewOrdering result = this.viewOrderingsStock.get(view);
        this.viewOrderingsStock.remove(view);
        return result;
    }

    public AbstractEdgeViewOrdering consumeEdgeViewOrdering(View view) {
        AbstractEdgeViewOrdering result = this.edgeViewOrderingsStock.get(view);
        this.edgeViewOrderingsStock.remove(view);
        return result;
    }

    public void removeAllHints(View view) {
        this.removeHints(view);
    }

    private void removeHints(View view) {
        if (this.viewOrderingsStock.get(view) != null) {
            this.viewOrderingsStock.remove(view);
        }
        if (this.edgeViewOrderingsStock.get(view) != null) {
            this.edgeViewOrderingsStock.remove(view);
        }
        for (Object child : view.getChildren()) {
            if (!(child instanceof View)) continue;
            this.removeHints((View)child);
        }
    }
}

