/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.internal.helper.task.DnDTasksOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DropinForNodeTaskCommand
extends AbstractCommandTask {
    private DragAndDropTarget target;
    private NodeMapping mapping;
    private DDiagramElement droppedDiagramElement;
    private EObject droppedElement;
    private EObject semanticContainer;
    private boolean moveEdges;

    public DropinForNodeTaskCommand(DragAndDropTarget target, NodeMapping mapping, DDiagramElement droppedDiagramElement, EObject droppedElement, EObject semanticContainer, boolean moveEdges) {
        this.target = target;
        this.mapping = mapping;
        this.droppedDiagramElement = droppedDiagramElement;
        this.droppedElement = droppedElement;
        this.semanticContainer = semanticContainer;
        this.moveEdges = moveEdges;
    }

    public void execute() {
        DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(this.target);
        if (this.target instanceof DNodeList) {
            this.handleDNodeListCase(parentDiagram);
        } else if (this.target instanceof DNodeContainer) {
            this.handleDNodeContainerCase(parentDiagram);
        } else if (this.target instanceof DNode) {
            this.handleDNodeCase(parentDiagram);
        } else if (this.target instanceof DDiagram) {
            this.handleDDiagramCase(parentDiagram);
        }
    }

    private void handleDNodeListCase(DDiagram parentDiagram) {
        AbstractDNode abstractDNode = null;
        boolean isBorderNode = DropinForNodeTaskCommand.isBorderNodeMapping(this.mapping, ((DNodeList)this.target).getActualMapping());
        if (this.droppedDiagramElement != null && this.mapping.equals(this.droppedDiagramElement.getMapping())) {
            if (isBorderNode && this.droppedDiagramElement instanceof DNode || !isBorderNode && this.droppedDiagramElement instanceof DNodeListElement) {
                abstractDNode = (AbstractDNode)this.droppedDiagramElement;
            }
        } else if (abstractDNode == null) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.droppedElement);
            abstractDNode = isBorderNode ? this.mapping.createNode(this.droppedElement, this.semanticContainer, parentDiagram) : new NodeMappingHelper(interpreter).createListElement(this.mapping, this.droppedElement, parentDiagram);
        }
        if (abstractDNode instanceof DNodeListElement) {
            ((DNodeList)this.target).getOwnedElements().add((Object)((DNodeListElement)abstractDNode));
        } else if (abstractDNode instanceof DNode) {
            ((DNodeList)this.target).getOwnedBorderedNodes().add((Object)((DNode)abstractDNode));
        }
        if (!Objects.equal(abstractDNode, (Object)this.droppedDiagramElement)) {
            if (this.moveEdges) {
                DnDTasksOperations.moveEdges(this.target, this.semanticContainer, this.droppedDiagramElement, abstractDNode);
            }
            DnDTasksOperations.deletePreviousEdges(this.target, this.droppedDiagramElement);
        }
    }

    private static boolean isBorderNodeMapping(NodeMapping nodeMapping, AbstractNodeMapping abstractNodeMapping) {
        return abstractNodeMapping.getAllBorderedNodeMappings().contains((Object)nodeMapping);
    }

    private void handleDNodeContainerCase(DDiagram parentDiagram) {
        DNode dNode = this.droppedDiagramElement != null && this.mapping.equals(this.droppedDiagramElement.getMapping()) && this.droppedDiagramElement instanceof DNode ? (DNode)this.droppedDiagramElement : this.mapping.createNode(this.droppedElement, this.semanticContainer, parentDiagram);
        DNodeContainer dNodeContainer = (DNodeContainer)this.target;
        if (DropinForNodeTaskCommand.isBorderNodeMapping(this.mapping, dNodeContainer.getActualMapping())) {
            dNodeContainer.getOwnedBorderedNodes().add((Object)dNode);
        } else {
            dNodeContainer.getOwnedDiagramElements().add((Object)dNode);
        }
        if (!dNode.equals(this.droppedDiagramElement)) {
            if (this.moveEdges) {
                DnDTasksOperations.moveEdges(this.target, this.semanticContainer, this.droppedDiagramElement, dNode);
            }
            DnDTasksOperations.deletePreviousEdges(this.target, this.droppedDiagramElement);
        }
    }

    private void handleDNodeCase(DDiagram parentDiagram) {
        DNode dNode = this.droppedDiagramElement != null && this.mapping.equals(this.droppedDiagramElement.getMapping()) && this.droppedDiagramElement instanceof DNode ? (DNode)this.droppedDiagramElement : this.mapping.createNode(this.droppedElement, this.semanticContainer, parentDiagram);
        ((DNode)this.target).getOwnedBorderedNodes().add((Object)dNode);
        if (!dNode.equals(this.droppedDiagramElement)) {
            if (this.moveEdges) {
                DnDTasksOperations.moveEdges(this.target, this.semanticContainer, this.droppedDiagramElement, dNode);
            }
            DnDTasksOperations.deletePreviousEdges(this.target, this.droppedDiagramElement);
        }
    }

    private void handleDDiagramCase(DDiagram parentDiagram) {
        DNode dNode = this.droppedDiagramElement != null && this.mapping.equals(this.droppedDiagramElement.getMapping()) && this.droppedDiagramElement instanceof DNode ? (DNode)this.droppedDiagramElement : this.mapping.createNode(this.droppedElement, this.semanticContainer, parentDiagram);
        parentDiagram.getOwnedDiagramElements().add((Object)dNode);
        if (!dNode.equals(this.droppedDiagramElement)) {
            if (this.moveEdges) {
                DnDTasksOperations.moveEdges(this.target, this.semanticContainer, this.droppedDiagramElement, dNode);
            }
            DnDTasksOperations.deletePreviousEdges(this.target, this.droppedDiagramElement);
        }
    }

    public String getLabel() {
        return Messages.DropinForNodeTaskCommand_taskLabel;
    }
}

