/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.filter.spec;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.filter.impl.MappingFilterImpl;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class MappingFilterSpec
extends MappingFilterImpl {
    private boolean checkExpression(EObject element, EStructuralFeature eFeature) {
        IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(element);
        boolean valid = true;
        String expression = (String)this.eGet(eFeature);
        if (expression != null) {
            try {
                valid = acceleoInterpreter.evaluateBoolean(element, expression);
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this, eFeature, (Throwable)e);
            }
        }
        return valid;
    }

    @Override
    public boolean isVisible(DDiagramElement element) {
        Boolean visible = null;
        if (this.getMappings().size() == 0) {
            if (this.getSemanticConditionExpression() != null && !StringUtil.isEmpty((String)this.getSemanticConditionExpression().trim()) && !this.checkExpression((EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_SemanticConditionExpression())) {
                visible = Boolean.FALSE;
            }
            if (this.getViewConditionExpression() != null && !StringUtil.isEmpty((String)this.getViewConditionExpression().trim()) && !this.checkExpression((EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_ViewConditionExpression())) {
                visible = Boolean.FALSE;
            }
        } else {
            RepresentationElementMapping mapping = element.getMapping();
            if (mapping != null && this.doManage((EObject)mapping)) {
                EObject semantic;
                boolean hasViewExpression;
                boolean hasSemanticExpression = this.getSemanticConditionExpression() != null && !StringUtil.isEmpty((String)this.getSemanticConditionExpression().trim());
                boolean bl = hasViewExpression = this.getViewConditionExpression() != null && !StringUtil.isEmpty((String)this.getViewConditionExpression().trim());
                if (!hasSemanticExpression && !hasViewExpression) {
                    visible = Boolean.FALSE;
                }
                if (hasSemanticExpression && (semantic = element.getTarget()) != null && !this.checkExpression(semantic, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_SemanticConditionExpression())) {
                    visible = Boolean.FALSE;
                }
                if (hasViewExpression && !this.checkExpression((EObject)element, (EStructuralFeature)FilterPackage.eINSTANCE.getMappingFilter_ViewConditionExpression())) {
                    visible = Boolean.FALSE;
                }
            }
        }
        if (visible == null) {
            visible = Boolean.TRUE;
        }
        return visible;
    }

    private boolean doManage(EObject mapping) {
        boolean result = false;
        if (this.getMappings().contains((Object)mapping)) {
            result = true;
        } else {
            EObject importedMapping = this.getImportedMapping(mapping);
            if (importedMapping != null) {
                result = this.doManage(importedMapping) && this.isInheritsAncestorFilters(mapping);
            }
        }
        return result;
    }

    private EObject getImportedMapping(EObject mapping) {
        Object result = null;
        if (mapping instanceof NodeMappingImport) {
            result = ((NodeMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof ContainerMappingImport) {
            result = ((ContainerMappingImport)mapping).getImportedMapping();
        } else if (mapping instanceof EdgeMappingImport) {
            result = ((EdgeMappingImport)mapping).getImportedMapping();
        }
        return result;
    }

    private boolean isInheritsAncestorFilters(EObject mapping) {
        boolean result = false;
        if (mapping instanceof AbstractMappingImport) {
            result = ((AbstractMappingImport)mapping).isInheritsAncestorFilters();
        } else if (mapping instanceof EdgeMappingImport) {
            result = ((EdgeMappingImport)mapping).isInheritsAncestorFilters();
        }
        return result;
    }
}

