/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.preprocessor;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.AbstractPageDescription;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PageValidationSetDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.WizardModelOperation;
import org.eclipse.sirius.properties.core.api.IDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.PreconfiguredPreprocessor;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;
import org.eclipse.sirius.properties.core.internal.converter.SiriusInitialOperationAdapter;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFactory;
import org.eclipse.sirius.viewpoint.description.validation.ValidationFix;

public class PageDescriptionPreprocessor
extends PreconfiguredPreprocessor<AbstractPageDescription> {
    protected static final EReference VALIDATIONSET_FEATURE = PropertiesPackage.Literals.ABSTRACT_PAGE_DESCRIPTION__VALIDATION_SET;

    public PageDescriptionPreprocessor() {
        super(AbstractPageDescription.class, PropertiesPackage.Literals.PAGE_DESCRIPTION);
    }

    @Override
    protected void processMonoValuedEReference(EReference eReference, AbstractPageDescription processedDescription, AbstractPageDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (!eReference.equals(VALIDATIONSET_FEATURE)) {
            super.processMonoValuedEReference(eReference, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        } else {
            this.processValidationSet(processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        }
    }

    private void processValidationSet(AbstractPageDescription processedDescription, AbstractPageDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (currentDescription.eIsSet((EStructuralFeature)VALIDATIONSET_FEATURE)) {
            PageValidationSetDescription validationSet = Optional.ofNullable(processedDescription.getValidationSet()).orElse(PropertiesFactory.eINSTANCE.createPageValidationSetDescription());
            processedDescription.setValidationSet(validationSet);
            ArrayList newValue = new ArrayList();
            currentDescription.getValidationSet().getSemanticValidationRules().forEach(rule -> {
                if (!this.isFiltered((EStructuralFeature)PropertiesPackage.eINSTANCE.getPageValidationSetDescription_SemanticValidationRules(), (EObject)processedDescription, (EObject)rule, cache, interpreter, variableManager, overridesProvider)) {
                    newValue.add(this.processSemanticValidationRule((SemanticValidationRule)rule));
                }
            });
            processedDescription.getValidationSet().getSemanticValidationRules().stream().map(this::processSemanticValidationRule).forEach(newValue::add);
            processedDescription.getValidationSet().getSemanticValidationRules().clear();
            processedDescription.getValidationSet().getSemanticValidationRules().addAll(newValue);
        }
    }

    private SemanticValidationRule processSemanticValidationRule(SemanticValidationRule unprocessedValidationRule) {
        SemanticValidationRule processedValidationRule = ValidationFactory.eINSTANCE.createSemanticValidationRule();
        processedValidationRule.setLabel(unprocessedValidationRule.getLabel());
        processedValidationRule.setLevel(unprocessedValidationRule.getLevel());
        processedValidationRule.setName(unprocessedValidationRule.getName());
        processedValidationRule.setMessage(unprocessedValidationRule.getMessage());
        processedValidationRule.setTargetClass(unprocessedValidationRule.getTargetClass());
        unprocessedValidationRule.getAudits().stream().map(EcoreUtil::copy).forEach(arg_0 -> processedValidationRule.getAudits().add(arg_0));
        unprocessedValidationRule.getFixes().stream().map(this::processValidationFix).forEach(arg_0 -> processedValidationRule.getFixes().add(arg_0));
        return processedValidationRule;
    }

    private ValidationFix processValidationFix(ValidationFix unprocessedValidationFix) {
        ValidationFix processedValidationFix = ValidationFactory.eINSTANCE.createValidationFix();
        processedValidationFix.setName(unprocessedValidationFix.getName());
        Optional.ofNullable(unprocessedValidationFix.getInitialOperation()).map(unprocessedInitialOperation -> {
            InitialOperation processedInitialOperation = (InitialOperation)EcoreUtil.copy((EObject)unprocessedInitialOperation);
            SiriusInitialOperationAdapter adapter = new SiriusInitialOperationAdapter(EcoreUtil.getURI((EObject)unprocessedInitialOperation));
            processedInitialOperation.eAdapters().add((Object)adapter);
            return processedInitialOperation;
        }).ifPresent(arg_0 -> ((ValidationFix)processedValidationFix).setInitialOperation(arg_0));
        return processedValidationFix;
    }

    @Override
    protected void processMultiValuedEReference(EReference eReference, AbstractPageDescription processedDescription, AbstractPageDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        if (!eReference.equals(PropertiesPackage.Literals.ABSTRACT_PAGE_DESCRIPTION__GROUPS)) {
            super.processMultiValuedEReference(eReference, processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        } else {
            this.processGroups(processedDescription, currentDescription, cache, interpreter, variableManager, overridesProvider);
        }
    }

    private void processGroups(AbstractPageDescription processedDescription, AbstractPageDescription currentDescription, TransformationCache cache, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        currentDescription.getGroups().forEach(groupDescription -> {
            Optional<Object> inputDescription = cache.getInput(processedDescription);
            Optional<PageDescription> optionalInputPageDescription = inputDescription.filter(PageDescription.class::isInstance).map(PageDescription.class::cast);
            Optional<IDescriptionPreprocessor> optionalDescriptionPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)groupDescription);
            if (!this.isFiltered((EStructuralFeature)PropertiesPackage.eINSTANCE.getAbstractPageDescription_Groups(), (EObject)processedDescription, (EObject)groupDescription, cache, interpreter, variableManager, overridesProvider) && optionalInputPageDescription.isPresent() && this.shouldProcessGroup(optionalInputPageDescription.get(), (GroupDescription)groupDescription)) {
                optionalDescriptionPreprocessor.map(descriptionPreprocessor -> descriptionPreprocessor.convert((EObject)groupDescription, cache, interpreter, variableManager, overridesProvider)).filter(GroupDescription.class::isInstance).map(GroupDescription.class::cast).map(arg_0 -> processedDescription.getGroups().add(arg_0));
            } else {
                processedDescription.getGroups().add(groupDescription);
            }
        });
    }

    private boolean shouldProcessGroup(PageDescription inputPageDescription, GroupDescription groupDescription) {
        Optional<EObject> optionalPageDescriptionContainer = this.getPropertiesRootContainer((EObject)inputPageDescription);
        Optional<EObject> optionalGroupDescriptionContainer = this.getPropertiesRootContainer((EObject)groupDescription);
        if (optionalPageDescriptionContainer.isPresent() && optionalGroupDescriptionContainer.isPresent()) {
            return !optionalPageDescriptionContainer.get().equals(optionalGroupDescriptionContainer.get());
        }
        return true;
    }

    private Optional<EObject> getPropertiesRootContainer(EObject eObject) {
        EObject eContainer = eObject;
        while (!(eContainer == null || eContainer instanceof ViewExtensionDescription || eContainer instanceof DialogModelOperation || eContainer instanceof WizardModelOperation)) {
            eContainer = eContainer.eContainer();
        }
        return Optional.ofNullable(eContainer);
    }
}

