/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.Let;
import org.eclipse.sirius.viewpoint.description.tool.MoveElement;
import org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SetValue;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.util.ToolSwitch;
import org.eclipse.sirius.viewpoint.description.util.DescriptionSwitch;

public class ExistingExpressionVariablesConstraint
extends AbstractConstraint {
    private static final Set<String> VPE_MAPPING_PRECONDITION_VARIABLES = new HashSet<String>(2);
    private static final Set<String> VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES;
    private static final Set<String> EDGE_MAPPING_TARGET_FINDER_VARIABLES;
    private static final Set<String> EDGE_MAPPING_SOURCE_FINDER_VARIABLES;
    private static final Set<String> EDGE_MAPPING_TARGET_VARIABLES;
    private static final Set<String> EDGE_MAPPING_PATH_VARIABLES;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DEF;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_EDGE;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DELETE;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLE_SMEW;
    private static final Set<String> TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL;
    private static final Set<String> COND_STYLE_PREDICATE_VARIABLES;

    static {
        VPE_MAPPING_PRECONDITION_VARIABLES.add("container");
        VPE_MAPPING_PRECONDITION_VARIABLES.add("containerView");
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES = new HashSet<String>(2);
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES.add("viewpoint");
        VPE_MAPPING_SEMANTIC_CANDIDATES_VARIABLES.add("diagram");
        EDGE_MAPPING_TARGET_FINDER_VARIABLES = new HashSet<String>(1);
        EDGE_MAPPING_TARGET_FINDER_VARIABLES.add("viewPoint");
        EDGE_MAPPING_SOURCE_FINDER_VARIABLES = new HashSet<String>(1);
        EDGE_MAPPING_SOURCE_FINDER_VARIABLES.add("viewPoint");
        EDGE_MAPPING_TARGET_VARIABLES = new HashSet<String>(3);
        EDGE_MAPPING_TARGET_VARIABLES.add("viewpoint");
        EDGE_MAPPING_TARGET_VARIABLES.add("diagram");
        EDGE_MAPPING_TARGET_VARIABLES.add("targetSemanticNode");
        EDGE_MAPPING_PATH_VARIABLES = new HashSet<String>(5);
        EDGE_MAPPING_PATH_VARIABLES.add("viewpoint");
        EDGE_MAPPING_PATH_VARIABLES.add("diagram");
        EDGE_MAPPING_PATH_VARIABLES.add("element");
        EDGE_MAPPING_PATH_VARIABLES.add("source");
        EDGE_MAPPING_PATH_VARIABLES.add("target");
        COND_STYLE_PREDICATE_VARIABLES = new HashSet<String>(2);
        COND_STYLE_PREDICATE_VARIABLES.add("container");
        COND_STYLE_PREDICATE_VARIABLES.add("view");
        TOOL_DESC_PRECONDITION_VARIABLES_DEF = new HashSet<String>(1);
        TOOL_DESC_PRECONDITION_VARIABLES_DEF.add("container");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE = new HashSet<String>(5);
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preSource");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preTarget");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preSourceView");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("preTargetView");
        TOOL_DESC_PRECONDITION_VARIABLES_EDGE.add("container");
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE = new HashSet<String>(2);
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE.add("containerView");
        TOOL_DESC_PRECONDITION_VARIABLES_DELETE.add("element");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG = new HashSet<String>(4);
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("oldContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("newContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("newViewContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDDIAG.add("element");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL = new HashSet<String>(3);
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("newContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("newViewContainer");
        TOOL_DESC_PRECONDITION_VARIABLES_DDPEXPL.add("element");
        TOOL_DESC_PRECONDITION_VARIABLE_SMEW = new HashSet<String>(1);
        TOOL_DESC_PRECONDITION_VARIABLE_SMEW.add("containerView");
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (this.shouldValidate(eObj) && eventType == EMFEventType.NULL) {
            IStatus status = ctx.createSuccessStatus();
            DescriptionSwitchValidator descriptionSwitchValidator = new DescriptionSwitchValidator(ctx, status);
            IStatus result = descriptionSwitchValidator.doSwitch(eObj);
            result = this.validateTool(eObj, ctx, result);
            return result;
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateTool(EObject eObj, IValidationContext ctx, IStatus statusInput) {
        ToolSwitchValidator toolSwitchValidator = new ToolSwitchValidator(ctx, statusInput);
        IStatus status = toolSwitchValidator.doSwitch(eObj);
        return status;
    }

    protected IStatus checkAbstractToolDescriptionPrecondition(IValidationContext ctx, AbstractToolDescription abstractToolDescription) {
        Set<String> variables = TOOL_DESC_PRECONDITION_VARIABLES_DEF;
        if (abstractToolDescription instanceof SelectionWizardDescription) {
            variables = TOOL_DESC_PRECONDITION_VARIABLE_SMEW;
        }
        return this.checkVariables(ctx, abstractToolDescription.getPrecondition(), variables, abstractToolDescription, ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition().getName());
    }

    protected IStatus checkConditionalStylePredicate(IValidationContext ctx, ConditionalStyleDescription conditionalStyle) {
        return this.checkVariables(ctx, conditionalStyle.getPredicateExpression(), COND_STYLE_PREDICATE_VARIABLES, conditionalStyle, DescriptionPackage.eINSTANCE.getConditionalStyleDescription_PredicateExpression().getName());
    }

    protected IStatus checkSelectModelElementCandidates(IValidationContext ctx, SelectModelElementVariable selectModelElementVariableOp) {
        return this.checkVariables(ctx, selectModelElementVariableOp.getCandidatesExpression(), Collections.emptySet(), selectModelElementVariableOp, DescriptionPackage.eINSTANCE.getSelectionDescription_CandidatesExpression().getName());
    }

    protected IStatus checkCreateInstanceReferenceName(IValidationContext ctx, CreateInstance createInstanceOp) {
        if (createInstanceOp.getReferenceName() != null) {
            return this.checkVariables(ctx, createInstanceOp.getReferenceName(), this.getDeclaredVariables(createInstanceOp), createInstanceOp, ToolPackage.eINSTANCE.getCreateInstance_ReferenceName().getName());
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus checkChangeContextBrowse(IValidationContext ctx, ChangeContext changeContextOp) {
        return this.checkVariables(ctx, changeContextOp.getBrowseExpression(), this.getDeclaredVariables(changeContextOp), changeContextOp, ToolPackage.eINSTANCE.getChangeContext_BrowseExpression().getName());
    }

    protected IStatus checkSetValueValue(IValidationContext ctx, SetValue setValueOp) {
        return this.checkVariables(ctx, setValueOp.getValueExpression(), this.getDeclaredVariables(setValueOp), setValueOp, ToolPackage.eINSTANCE.getSetValue_ValueExpression().getName());
    }

    protected IStatus checkLetValue(IValidationContext ctx, Let letOp) {
        return this.checkVariables(ctx, letOp.getValueExpression(), this.getDeclaredVariables(letOp), letOp, ToolPackage.eINSTANCE.getLet_ValueExpression().getName());
    }

    protected IStatus checkMoveElementNewContainer(IValidationContext ctx, MoveElement moveElementOp) {
        return this.checkVariables(ctx, moveElementOp.getNewContainerExpression(), this.getDeclaredVariables(moveElementOp), moveElementOp, ToolPackage.eINSTANCE.getMoveElement_NewContainerExpression().getName());
    }

    protected IStatus checkFor(IValidationContext ctx, For forOp) {
        return this.checkVariables(ctx, forOp.getExpression(), this.getDeclaredVariables(forOp), forOp, ToolPackage.eINSTANCE.getFor_Expression().getName());
    }

    protected IStatus checkAcceleoVariableComputation(IValidationContext ctx, AcceleoVariable acceleoVariableOp) {
        return this.checkVariables(ctx, acceleoVariableOp.getComputationExpression(), this.getDeclaredVariables(acceleoVariableOp), acceleoVariableOp, ToolPackage.eINSTANCE.getAcceleoVariable_ComputationExpression().getName());
    }

    protected Set<String> getDeclaredVariables(EObject context) {
        HashSet<String> result = new HashSet<String>();
        AbstractToolDescription tool = null;
        EObject current = context;
        while (tool == null && current.eContainer() != null) {
            if (current instanceof AbstractToolDescription) {
                tool = (AbstractToolDescription)current;
            }
            current = current.eContainer();
        }
        if (tool != null) {
            TreeIterator iterAllContents = tool.eAllContents();
            while (iterAllContents.hasNext()) {
                String name;
                EObject next = (EObject)iterAllContents.next();
                if (next instanceof AbstractVariable) {
                    result.add(((AbstractVariable)next).getName());
                    continue;
                }
                if (next instanceof For) {
                    result.add(((For)next).getIteratorName());
                    continue;
                }
                if (next instanceof CreateInstance) {
                    name = ((CreateInstance)next).getVariableName();
                    if (StringUtil.isEmpty((String)name)) continue;
                    result.add(name);
                    continue;
                }
                if (!(next instanceof Let) || StringUtil.isEmpty((String)(name = ((Let)next).getVariableName()))) continue;
                result.add(name);
            }
        }
        return result;
    }

    public class DescriptionSwitchValidator
    extends DescriptionSwitch<IStatus> {
        private IStatus currentStatus;
        private final IValidationContext ctx;

        public DescriptionSwitchValidator(IValidationContext ctx, IStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.ctx = ctx;
            if (this.currentStatus == null) {
                this.currentStatus = ctx.createSuccessStatus();
            }
        }

        @Override
        public IStatus caseConditionalStyleDescription(ConditionalStyleDescription object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseConditionalStyleDescription(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkConditionalStylePredicate(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus doSwitch(EObject theEObject) {
            if (this.currentStatus.isOK()) {
                this.currentStatus = (IStatus)super.doSwitch(theEObject);
            }
            return this.currentStatus;
        }
    }

    public class ToolSwitchValidator
    extends ToolSwitch<IStatus> {
        private IStatus currentStatus;
        private final IValidationContext ctx;

        public ToolSwitchValidator(IValidationContext ctx, IStatus currentStatus) {
            this.currentStatus = currentStatus;
            this.ctx = ctx;
            if (this.currentStatus == null) {
                this.currentStatus = ctx.createSuccessStatus();
            }
        }

        @Override
        public IStatus caseAbstractToolDescription(AbstractToolDescription object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseAbstractToolDescription(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkAbstractToolDescriptionPrecondition(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseSelectModelElementVariable(SelectModelElementVariable object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseSelectModelElementVariable(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkSelectModelElementCandidates(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseCreateInstance(CreateInstance object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseCreateInstance(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkCreateInstanceReferenceName(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseChangeContext(ChangeContext object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseChangeContext(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkChangeContextBrowse(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseSetValue(SetValue object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseSetValue(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkSetValueValue(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseMoveElement(MoveElement object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseMoveElement(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkMoveElementNewContainer(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseFor(For object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseFor(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkFor(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseLet(Let object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseLet(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkLetValue(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus caseAcceleoVariable(AcceleoVariable object) {
            if (this.currentStatus.isOK()) {
                IStatus superStatus = (IStatus)super.caseAcceleoVariable(object);
                this.currentStatus = superStatus == null || superStatus.isOK() ? ExistingExpressionVariablesConstraint.this.checkAcceleoVariableComputation(this.ctx, object) : superStatus;
            }
            return this.currentStatus;
        }

        @Override
        public IStatus doSwitch(EObject theEObject) {
            if (this.currentStatus == null || this.currentStatus.isOK()) {
                this.currentStatus = (IStatus)super.doSwitch(theEObject);
            }
            return this.currentStatus;
        }
    }
}

