/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.snapshot.StateSnapshot;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.trim.ITmfTrimmableTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.TrimTraceDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

@NonNullByDefault
public class TrimTraceHandler
extends AbstractHandler {
    private static boolean isValid(@Nullable Object element) {
        if (element instanceof ITmfTrimmableTrace) {
            return true;
        }
        if (!(element instanceof ITmfTrace)) {
            return false;
        }
        ITmfTrace trace = (ITmfTrace)element;
        if (trace.getChildren().isEmpty()) {
            return false;
        }
        for (ITmfEventProvider child : trace.getChildren()) {
            if (TrimTraceHandler.isValid(child)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IHandlerService service = (IHandlerService)workbench.getService(IHandlerService.class);
        ExecutionEvent executionEvent = new ExecutionEvent(null, Collections.emptyMap(), null, (Object)service.getCurrentState());
        ISelection element = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (!(element instanceof TreeSelection)) {
            return false;
        }
        Object firstElement = ((TreeSelection)element).getFirstElement();
        ITmfTrace trace = null;
        if (firstElement instanceof TmfCommonProjectElement) {
            TmfCommonProjectElement traceElem = (TmfCommonProjectElement)firstElement;
            if (traceElem instanceof TmfTraceElement) {
                traceElem = ((TmfTraceElement)traceElem).getElementUnderTraceFolder();
            }
            trace = traceElem.getTrace();
        }
        if (trace == null || !TrimTraceHandler.isValid(trace)) {
            return false;
        }
        TmfTraceManager tm = TmfTraceManager.getInstance();
        TmfTimeRange selectionRange = tm.getTraceContext(trace).getSelectionRange();
        return !selectionRange.getStartTime().equals(selectionRange.getEndTime());
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        final TmfCommonProjectElement traceElem = firstElement instanceof TmfTraceElement ? ((TmfTraceElement)firstElement).getElementUnderTraceFolder() : (TmfCommonProjectElement)firstElement;
        ITmfTrace trace = traceElem.getTrace();
        if (trace == null || !TrimTraceHandler.isValid(trace)) {
            return null;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TmfTraceManager tm = TmfTraceManager.getInstance();
        TmfTimeRange timeRange = tm.getTraceContext(trace).getSelectionRange();
        if (Objects.equals(timeRange.getStartTime(), timeRange.getEndTime())) {
            MessageDialog.openError((Shell)shell, (String)Messages.TrimTraces_InvalidTimeRange_DialogTitle, (String)Messages.TrimTraces_InvalidTimeRange_DialogText);
            return null;
        }
        final TmfTimeRange tr = timeRange.getStartTime().compareTo(timeRange.getEndTime()) > 0 ? new TmfTimeRange(timeRange.getEndTime(), timeRange.getStartTime()) : timeRange;
        TrimTraceDialog dialog = new TrimTraceDialog(shell, traceElem);
        if (dialog.open() != 0) {
            return null;
        }
        Object result = dialog.getFirstResult();
        if (result == null) {
            return null;
        }
        java.nio.file.Path destinationPath = (java.nio.file.Path)NonNullUtils.checkNotNull((Object)Paths.get(result.toString(), new String[0]));
        if (destinationPath.toFile().exists()) {
            MessageDialog.openError((Shell)shell, (String)Messages.TrimTraces_InvalidDirectory_DialogTitle, (String)Messages.TrimTraces_InvalidDirectory_DialogText);
            return null;
        }
        final TraceToTrim toTrim = TraceToTrim.create(traceElem, destinationPath);
        if (toTrim == null) {
            return null;
        }
        try {
            toTrim.createDir();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        TmfWorkspaceModifyOperation trimOperation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(@Nullable IProgressMonitor monitor) throws CoreException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                toTrim.trim(tr, (IProgressMonitor)mon);
                TmfProjectElement currentProjectElement = traceElem.getProject();
                TmfTraceFolder traceFolder = currentProjectElement.getTracesFolder();
                toTrim.importTrace((IProgressMonitor)mon);
                if (mon.isCanceled()) {
                    return;
                }
                if (traceFolder != null) {
                    Display.getDefault().asyncExec(toTrim::open);
                } else {
                    Activator.getDefault().logWarning("Trace folder does not exist: " + toTrim.fDestinationPath);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)trimOperation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            TraceUtils.displayErrorMsg(Messages.TrimTraceHandler_failMsg, e.getMessage(), e);
            return null;
        }
        return null;
    }

    private static final class TraceToTrim {
        private ITmfTrace fTrace;
        private @Nullable ITmfTrimmableTrace fTrimmable;
        private java.nio.file.Path fDestinationPath;
        private Collection<TraceToTrim> fChildren = new ArrayList<TraceToTrim>();
        private TmfCommonProjectElement fElement;
        private @Nullable IFolder fFolder = null;
        private @Nullable ITmfProjectModelElement fDestElement = null;
        private TmfCommonProjectElement fSourceElement;

        public static @Nullable TraceToTrim create(TmfCommonProjectElement element, java.nio.file.Path destination) {
            TmfTraceElement traceElement;
            ITmfTrace trace = element.getTrace();
            if (trace != null) {
                return new TraceToTrim(trace, element, element, destination);
            }
            if (element instanceof TmfTraceElement && (trace = (traceElement = (TmfTraceElement)element).getTrace()) != null) {
                return new TraceToTrim(trace, element, element, destination);
            }
            return null;
        }

        private static final @Nullable TraceToTrim create(TraceToTrim parent, final TmfTraceElement traceElement) {
            TmfTraceElement elementUnderTraceFolder = traceElement.getElementUnderTraceFolder();
            ITmfTrace trace = elementUnderTraceFolder.getTrace();
            if (trace != null) {
                List<String> elems = new ArrayList<String>();
                ITmfProjectModelElement tempTraceElement = elementUnderTraceFolder;
                while (tempTraceElement != null) {
                    elems.add(Objects.requireNonNull(tempTraceElement.getName()));
                    tempTraceElement = tempTraceElement.getParent();
                }
                TraceTypeHelper traceType = TmfTraceType.getTraceType((String)elementUnderTraceFolder.getTraceType());
                String end = (String)elems.remove(0);
                elems = Lists.reverse(elems);
                TmfTraceFolder tracesFolder = elementUnderTraceFolder.getProject().getTracesFolder();
                if (tracesFolder == null) {
                    return null;
                }
                IFolder folder = tracesFolder.getResource();
                elems.remove(0);
                elems.set(0, String.valueOf(parent.fDestinationPath.getFileName()));
                for (String elem : elems) {
                    if ((folder = folder.getFolder(elem)).exists()) continue;
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        return null;
                    }
                }
                folder = folder.getFolder(end);
                if (!traceType.isDirectoryTraceType() && !folder.exists()) {
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                        folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        return null;
                    }
                }
                TmfTraceElement te = new TmfTraceElement(elementUnderTraceFolder.getName(), (IResource)folder, tracesFolder){

                    @Override
                    public String getTraceType() {
                        return String.valueOf(traceElement.getTraceType());
                    }

                    @Override
                    public void refreshTraceType() {
                    }

                    @Override
                    public IResource[] getSupplementaryResources() {
                        return traceElement.getSupplementaryResources();
                    }
                };
                return new TraceToTrim(trace, elementUnderTraceFolder, te, new File(te.getName()).toPath());
            }
            return null;
        }

        public TraceToTrim(ITmfTrace trace, TmfCommonProjectElement sourceElement, TmfCommonProjectElement element, java.nio.file.Path destination) {
            this.fTrace = trace;
            this.fSourceElement = sourceElement;
            this.fElement = element;
            this.fTrimmable = trace instanceof ITmfTrimmableTrace ? (ITmfTrimmableTrace)trace : null;
            this.fFolder = (IFolder)element.getResource();
            this.fDestinationPath = this.fFolder != null ? this.fFolder.getParent().getLocation().append(destination.toString()).toFile().toPath() : destination;
            for (TmfTraceElement childElement : element.getTraces()) {
                TraceToTrim create = TraceToTrim.create(this, childElement);
                if (create == null) continue;
                this.fChildren.add(create);
            }
        }

        public IStatus trim(TmfTimeRange tr, IProgressMonitor mon) {
            if (mon.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)3);
            ArrayList<@NonNull ITmfAnalysisModuleWithStateSystems> statesystemModules = new ArrayList<ITmfAnalysisModuleWithStateSystems>();
            for (IAnalysisModule module : this.fTrace.getAnalysisModules()) {
                if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
                statesystemModules.add((ITmfAnalysisModuleWithStateSystems)module);
            }
            monitor.worked(1);
            long snapshotTime = tr.getStartTime().toNanos();
            java.nio.file.Path returnPath = this.fDestinationPath;
            if (this.fTrimmable != null) {
                try {
                    returnPath = this.fTrimmable.trim(tr, returnPath, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.tracecompass.tmf.ui", "An error occurred writing the state systems snapshots", (Throwable)e);
                }
            }
            if (returnPath == null) {
                return new Status(4, "org.eclipse.tracecompass.tmf.ui", "Failed to trim trace. " + this.fTrimmable);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(1);
            SubMonitor ssMon = SubMonitor.convert((IProgressMonitor)mon, (int)statesystemModules.size());
            try {
                for (ITmfAnalysisModuleWithStateSystems module : statesystemModules) {
                    ssMon.split(1);
                    Map versions = module.getProviderVersions();
                    Iterable sss = module.getStateSystems();
                    for (ITmfStateSystem ss : sss) {
                        Integer version = (Integer)versions.get(ss.getSSID());
                        long currentEndTime = ss.getCurrentEndTime();
                        if (snapshotTime > currentEndTime || version == null) continue;
                        StateSnapshot snapshot = new StateSnapshot(ss, Math.max(snapshotTime, ss.getStartTime()), Math.min(currentEndTime, tr.getEndTime().toNanos()), version.intValue());
                        snapshot.write(returnPath);
                    }
                }
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.tracecompass.tmf.ui", "An error occurred writing the state systems snapshots", (Throwable)e);
            }
            for (TraceToTrim child : this.fChildren) {
                IStatus status = child.trim(tr, (IProgressMonitor)monitor);
                if (status.isOK()) continue;
                return status;
            }
            return Status.OK_STATUS;
        }

        public IStatus importTrace(IProgressMonitor monitor) {
            try {
                IFolder folder = this.fFolder;
                if (folder == null) {
                    return new Status(4, "org.eclipse.tracecompass.tmf.ui", "Folder is null");
                }
                for (TraceToTrim child : this.fChildren) {
                    IStatus status = child.importTrace(monitor);
                    if (status.isOK()) continue;
                    return status;
                }
                TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType((String)this.fElement.getTraceType());
                if (this.fElement instanceof TmfExperimentElement) {
                    TmfExperimentElement experimentElement = (TmfExperimentElement)this.fElement;
                    TmfExperimentFolder experimentsFolder = experimentElement.getProject().getExperimentsFolder();
                    if (experimentsFolder == null) {
                        return new Status(4, "org.eclipse.tracecompass.tmf.ui", "Error getting experiment folder");
                    }
                    ArrayList<TmfTraceElement> children = new ArrayList<TmfTraceElement>();
                    for (TraceToTrim child : this.fChildren) {
                        ITmfProjectModelElement childDest = child.fDestElement;
                        if (!(childDest instanceof TmfTraceElement)) continue;
                        children.add((TmfTraceElement)childDest);
                    }
                    String name = this.fDestinationPath.getFileName().toString();
                    if (name == null) {
                        return new Status(4, "org.eclipse.tracecompass.tmf.ui", "could not create element");
                    }
                    NewExperimentOperation newExperimentOperation = new NewExperimentOperation(experimentsFolder, name, null, children);
                    newExperimentOperation.run(monitor);
                    experimentsFolder.refresh();
                    ITmfProjectModelElement destElement = experimentsFolder.getChild(name);
                    if (destElement == null) {
                        return new Status(4, "org.eclipse.tracecompass.tmf.ui", "could not create element");
                    }
                    TmfTraceTypeUIUtils.setTraceType(destElement.getResource(), traceTypeHelper);
                    if (destElement instanceof TmfExperimentElement) {
                        TmfExperimentElement expElement = (TmfExperimentElement)destElement;
                        for (TraceToTrim child : this.fChildren) {
                            ITmfProjectModelElement childDest = child.fDestElement;
                            if (!(childDest instanceof TmfTraceElement) || expElement.getChild(childDest.getName()) != null) continue;
                            expElement.addTrace((TmfTraceElement)childDest, false);
                        }
                        this.fSourceElement.copySupplementaryFolder(destElement.getName());
                        destElement.refresh();
                        this.fDestElement = destElement;
                    }
                } else if (this.fElement instanceof TmfTraceElement) {
                    String path = (traceTypeHelper.isDirectoryTraceType() ? this.fDestinationPath : this.fDestinationPath.getParent()).toAbsolutePath().toString();
                    IPath destinationPath = Path.fromOSString((String)path);
                    IResource traceResource = null;
                    String lastSegment = destinationPath.lastSegment();
                    IContainer tempFolder = folder.getParent();
                    tempFolder.refreshLocal(2, monitor);
                    while (tempFolder != null && traceResource == null) {
                        traceResource = tempFolder.findMember(lastSegment);
                        tempFolder = tempFolder.getParent();
                    }
                    if (traceResource == null) {
                        return new Status(4, "org.eclipse.tracecompass.tmf.ui", "Error finding common parent");
                    }
                    IStatus ret = TmfTraceTypeUIUtils.setTraceType(traceResource, traceTypeHelper);
                    if (!ret.isOK()) {
                        return ret;
                    }
                    ITmfProjectModelElement findElement = TmfProjectRegistry.findElement(traceResource, true);
                    if (findElement instanceof TmfCommonProjectElement) {
                        this.fSourceElement.copySupplementaryFolder(((TmfCommonProjectElement)findElement).getElementPath());
                    }
                    this.fDestElement = findElement;
                }
            }
            catch (CoreException e) {
                return new Status(4, "org.eclipse.tracecompass.tmf.ui", "Error creating link", (Throwable)e);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public void open() {
            if (this.fDestElement instanceof TmfCommonProjectElement) {
                TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)this.fDestElement);
            }
        }

        public void createDir() throws IOException {
            if (this.fElement instanceof TmfExperimentElement) {
                for (TraceToTrim child : this.fChildren) {
                    child.createDir();
                }
            } else {
                this.fDestinationPath.toAbsolutePath().toFile().mkdirs();
            }
        }
    }
}

