/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.registry.ExtensionBasedQuerySpecificationLoader;
import org.eclipse.viatra.query.runtime.ui.ViatraQueryRuntimeUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdater;

@SuppressWarnings("all")
public class QueryRegistryTreeLabelProvider extends ColumnLabelProvider {
  private final ImageRegistry imageRegistry = ViatraQueryRuntimeUIPlugin.getDefault().getImageRegistry();
  
  @Override
  public Image getImage(final Object element) {
    return this.getImageInternal(element);
  }
  
  protected Image _getImageInternal(final QueryRegistryTreeEntry element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_VQL);
  }
  
  protected Image _getImageInternal(final QueryRegistryTreeSource element) {
    final String sourceId = element.getSourceIdentifier();
    boolean _startsWith = sourceId.startsWith(XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX);
    if (_startsWith) {
      final IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceId.replace(XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX, ""));
      if ((member instanceof IProject)) {
        return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_PROJECT);
      }
    }
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_ROOT);
  }
  
  protected Image _getImageInternal(final QueryRegistryTreePackage element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_EPACKAGE);
  }
  
  protected Image _getImageInternal(final Object element) {
    return super.getImage(element);
  }
  
  @Override
  public String getText(final Object element) {
    return this.getTextInternal(element);
  }
  
  protected String _getTextInternal(final QueryRegistryTreeEntry element) {
    return element.getSimpleName();
  }
  
  protected String _getTextInternal(final QueryRegistryTreeSource element) {
    final String sourceId = element.getSourceIdentifier();
    boolean _equals = Objects.equal(sourceId, ExtensionBasedQuerySpecificationLoader.CONNECTOR_ID);
    if (_equals) {
      return "Registered queries";
    } else {
      boolean _startsWith = sourceId.startsWith(XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX);
      if (_startsWith) {
        final String label = sourceId.replace(XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX, "");
        return label;
      }
    }
    return sourceId;
  }
  
  protected String _getTextInternal(final QueryRegistryTreePackage element) {
    return element.getPackageName();
  }
  
  protected String _getTextInternal(final Object element) {
    return super.getText(element);
  }
  
  public Image getImageInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _getImageInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _getImageInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _getImageInternal((QueryRegistryTreeSource)element);
    } else if (element != null) {
      return _getImageInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public String getTextInternal(final Object element) {
    if (element instanceof QueryRegistryTreeEntry) {
      return _getTextInternal((QueryRegistryTreeEntry)element);
    } else if (element instanceof QueryRegistryTreePackage) {
      return _getTextInternal((QueryRegistryTreePackage)element);
    } else if (element instanceof QueryRegistryTreeSource) {
      return _getTextInternal((QueryRegistryTreeSource)element);
    } else if (element != null) {
      return _getTextInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
