/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleValueProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.eval.IEvaluatorNode;

public abstract class EvaluatorCore {
    protected Logger logger;
    protected IExpressionEvaluator evaluator;
    int sourceTupleWidth;
    private Map<String, Integer> parameterPositions;
    protected IQueryRuntimeContext runtimeContext;
    protected IEvaluatorNode evaluatorNode;

    public abstract Tuple tupleFromResult(Tuple var1, Object var2);

    protected abstract String evaluationKind();

    public EvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
        this.logger = logger;
        this.evaluator = evaluator;
        this.parameterPositions = parameterPositions;
        this.sourceTupleWidth = sourceTupleWidth;
    }

    public void init(IEvaluatorNode evaluatorNode) {
        this.evaluatorNode = evaluatorNode;
        this.runtimeContext = evaluatorNode.getReteContainer().getNetwork().getEngine().getRuntimeContext();
    }

    public Tuple performEvaluation(Tuple inputTuple) {
        return this.tupleFromResult(inputTuple, this.evaluateTerm(inputTuple));
    }

    public Object evaluateTerm(Tuple ps) {
        Object result = null;
        try {
            TupleValueProvider tupleParameters = new TupleValueProvider((ITuple)this.runtimeContext.unwrapTuple(ps), this.parameterPositions);
            result = this.evaluator.evaluateExpression((IValueProvider)tupleParameters);
        }
        catch (Exception e) {
            this.logger.warn((Object)String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.evaluationKind(), this.evaluatorNode.prettyPrintTraceInfoPatternList(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this.evaluatorNode), (Throwable)e);
            result = this.errorResult();
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    protected Object errorResult() {
        return null;
    }

    public static class FunctionEvaluatorCore
    extends EvaluatorCore {
        public FunctionEvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
            super(logger, evaluator, parameterPositions, sourceTupleWidth);
        }

        @Override
        public Tuple tupleFromResult(Tuple incoming, Object evaluationresult) {
            if (evaluationresult == null) {
                return null;
            }
            return Tuples.staticArityLeftInheritanceTupleOf((Tuple)incoming, (Object)this.runtimeContext.wrapElement(evaluationresult));
        }

        @Override
        protected String evaluationKind() {
            return "eval()";
        }
    }

    public static class PredicateEvaluatorCore
    extends EvaluatorCore {
        public PredicateEvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
            super(logger, evaluator, parameterPositions, sourceTupleWidth);
        }

        @Override
        public Tuple tupleFromResult(Tuple incoming, Object evaluationresult) {
            return Boolean.TRUE.equals(evaluationresult) ? incoming : null;
        }

        @Override
        protected String evaluationKind() {
            return "check()";
        }
    }
}

