/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;

public class OutputCachingEvaluatorNode
extends AbstractEvaluatorNode
implements Clearable {
    Map<Tuple, Tuple> outputCache = CollectionsFactory.createMap();

    public OutputCachingEvaluatorNode(ReteContainer reteContainer, EvaluatorCore core) {
        super(reteContainer, core);
        reteContainer.registerClearable(this);
    }

    public void clear() {
        this.outputCache.clear();
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple output : this.outputCache.values()) {
            collector.add(output);
        }
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        switch (direction) {
            case INSERT: {
                Tuple insertedOutput = this.core.performEvaluation(updateElement);
                if (insertedOutput == null) break;
                Tuple previous = this.outputCache.put(updateElement, insertedOutput);
                if (previous != null) {
                    throw new IllegalStateException(String.format("Duplicate insertion of tuple %s into node %s", updateElement, this));
                }
                this.propagateUpdate(direction, insertedOutput);
                break;
            }
            case REVOKE: {
                Tuple revokedOutput = this.outputCache.remove(updateElement);
                if (revokedOutput == null) break;
                this.propagateUpdate(direction, revokedOutput);
            }
        }
    }
}

