/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.tabular;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFQueryMetaContext;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.emf.types.BaseEMFTypeKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassExactInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.IStorageBackend;
import org.eclipse.viatra.query.runtime.matchers.scopes.SimpleRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.TabularRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.DisjointUnionTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterBinary;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterUnary;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.tabular.TabularIndexHost;

public class EcoreIndexHost
extends TabularIndexHost {
    private Map<EClassifier, ITableWriterUnary.Table<Object>> tableDirectInstances = CollectionsFactory.createMap();
    private Map<EClass, DisjointUnionTable> tableTransitiveInstances = CollectionsFactory.createMap();
    private Map<EStructuralFeature, ITableWriterBinary.Table<Object, Object>> tableFeatures = CollectionsFactory.createMap();

    public EcoreIndexHost(IStorageBackend storage, EPackage ... packages) {
        super(storage, (TabularRuntimeContext)new SimpleRuntimeContext((IQueryMetaContext)EMFQueryMetaContext.DEFAULT_SURROGATE));
        this.initTables(packages);
    }

    @Override
    protected boolean isQueryScopeEmulated(Class<? extends QueryScope> queryScopeClass) {
        return EMFScope.class.equals(queryScopeClass);
    }

    private void initTables(EPackage[] packages) {
        ITableWriterUnary.Table<Object> directTable;
        EPackage[] ePackageArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                BaseEMFTypeKey classifierKey;
                boolean unique;
                if (eClassifier instanceof EClass) {
                    EClass eClass = (EClass)eClassifier;
                    EClassTransitiveInstancesKey transitiveKey = new EClassTransitiveInstancesKey(eClass);
                    DisjointUnionTable transitiveTable = this.registerNewTable(new DisjointUnionTable((IInputKey)transitiveKey, (ITableContext)this.runtimeContext));
                    this.tableTransitiveInstances.put(eClass, transitiveTable);
                    for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                        EStructuralFeatureInstancesKey featureKey = new EStructuralFeatureInstancesKey(feature);
                        ITableWriterBinary.Table<Object, Object> featureTable = this.newBinaryInputTable((IInputKey)featureKey, feature.isUnique());
                        this.tableFeatures.put(feature, featureTable);
                    }
                    unique = true;
                    classifierKey = new EClassExactInstancesKey(eClass);
                } else {
                    unique = false;
                    classifierKey = new EDataTypeInSlotsKey((EDataType)eClassifier);
                }
                ITableWriterUnary.Table<Object> directTable2 = this.newUnaryInputTable((IInputKey)classifierKey, unique);
                this.tableDirectInstances.put(eClassifier, directTable2);
            }
            ++n2;
        }
        EClass eObjectClass = EcorePackage.eINSTANCE.getEObject();
        DisjointUnionTable eObjectAllInstancesTable = this.tableTransitiveInstances.get(eObjectClass);
        if (eObjectAllInstancesTable == null) {
            EClassTransitiveInstancesKey eClassTransitiveInstancesKey = new EClassTransitiveInstancesKey(eObjectClass);
            eObjectAllInstancesTable = this.registerNewTable(new DisjointUnionTable((IInputKey)eClassTransitiveInstancesKey, (ITableContext)this.runtimeContext));
            this.tableTransitiveInstances.put(eObjectClass, eObjectAllInstancesTable);
            boolean unique = true;
            EClassExactInstancesKey classifierKey = new EClassExactInstancesKey(eObjectClass);
            directTable = this.newUnaryInputTable((IInputKey)classifierKey, unique);
            this.tableDirectInstances.put((EClassifier)eObjectClass, directTable);
        }
        for (Map.Entry entry : this.tableTransitiveInstances.entrySet()) {
            EClass eClass = (EClass)entry.getKey();
            directTable = this.tableDirectInstances.get(eClass);
            ((DisjointUnionTable)entry.getValue()).addChildTable(directTable);
            for (EClass superClass : eClass.getEAllSuperTypes()) {
                DisjointUnionTable transitiveTable = this.tableTransitiveInstances.get(superClass);
                if (transitiveTable == null) {
                    throw new IllegalStateException(String.format("No index table found for EClass %s, supertype of %s", superClass.getName(), eClass.getName()));
                }
                transitiveTable.addChildTable(directTable);
            }
            if (eClass.equals(eObjectClass)) continue;
            eObjectAllInstancesTable.addChildTable(directTable);
        }
    }

    public ITableWriterUnary.Table<Object> getTableDirectInstances(EClassifier classifier) {
        return this.tableDirectInstances.get(classifier);
    }

    public ITableWriterBinary.Table<Object, Object> getTableFeatureSlots(EStructuralFeature feature) {
        return this.tableFeatures.get(feature);
    }

    public Set<Map.Entry<EClassifier, ITableWriterUnary.Table<Object>>> getAllCurrentTablesDirectInstances() {
        return Collections.unmodifiableSet(this.tableDirectInstances.entrySet());
    }

    public Set<Map.Entry<EStructuralFeature, ITableWriterBinary.Table<Object, Object>>> getAllCurrentTablesFeatures() {
        return Collections.unmodifiableSet(this.tableFeatures.entrySet());
    }
}

