/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchEMFBackendFactory;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.IPlanNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationStatus;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.PatternBodyNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.ViewModelFactory;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views.LocalSearchDebugView;

public class LocalSearchDebugger
implements ILocalSearchAdapter {
    public volatile Object notifier = new Object();
    private final LocalSearchDebugView localSearchDebugView;
    private volatile boolean isDisposed = false;
    private boolean hasFinished = false;
    private Deque<IPlanNode> currentOperation;
    private boolean suspended = true;
    private final AdvancedViatraQueryEngine queryEngine;
    private final IQuerySpecification<?> rootSpecification;
    private final Object[] adornment;
    private final ViewModelFactory factory = new ViewModelFactory(this);
    private final IPlanNode viewModel;

    public LocalSearchDebugger(LocalSearchDebugView localSearchDebugView, AdvancedViatraQueryEngine queryEngine, IQuerySpecification<?> rootSpecification, Object[] adornment) {
        this.localSearchDebugView = localSearchDebugView;
        this.queryEngine = queryEngine;
        this.rootSpecification = rootSpecification;
        this.adornment = adornment;
        this.viewModel = this.getSearchPlan().map(this.factory::createViewModel).orElse(null);
        this.currentOperation = new ArrayDeque<IPlanNode>();
    }

    public Optional<IPlanDescriptor> getSearchPlan() {
        HashSet<PParameter> boundParameters = new HashSet<PParameter>();
        int i = 0;
        while (i < this.adornment.length) {
            if (this.adornment[i] != null) {
                boundParameters.add((PParameter)this.rootSpecification.getParameters().get(i));
            }
            ++i;
        }
        return this.getSearchPlan(this.rootSpecification.getInternalQueryRepresentation(), boundParameters);
    }

    public IPlanNode getViewModel() {
        return this.viewModel;
    }

    public Optional<IPlanDescriptor> getSearchPlan(PQuery specification, Set<PParameter> boundParameters) {
        IQueryBackend lsBackend = this.queryEngine.getQueryBackend((IQueryBackendFactory)LocalSearchEMFBackendFactory.INSTANCE);
        if (lsBackend instanceof LocalSearchBackend) {
            LocalSearchBackend localSearchBackend = (LocalSearchBackend)lsBackend;
            return Optional.ofNullable(localSearchBackend.getSearchPlan(specification, boundParameters));
        }
        return Optional.empty();
    }

    public void patternMatchingStarted(LocalSearchMatcher lsMatcher) {
        if (this.isDisposed) {
            return;
        }
        IEvaluationService service = (IEvaluationService)this.localSearchDebugView.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("org.eclipse.viatra.query.tooling.localsearch.ui.debugger.operational");
        TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(lsMatcher.getQuerySpecification());
        List storedFrames = (List)matchesViewer.getData("key");
        storedFrames.clear();
    }

    private void setCurrentOperation(PBody body) {
        IPlanNode childNode = null;
        if (this.currentOperation.isEmpty()) {
            childNode = this.viewModel.getChildByKey(body);
        } else {
            IPlanNode current = this.currentOperation.peek();
            if (current instanceof SearchOperationNode && current.isMatcherCall() && current.getChildByKey(body) != null) {
                childNode = current.getChildByKey(body);
            }
            if (current instanceof PatternBodyNode && Objects.equals(((PatternBodyNode)current).getRelatedBody().getPattern(), body.getPattern())) {
                current.setOperationStatus(OperationStatus.EXECUTED);
                this.currentOperation.pop();
                childNode = this.currentOperation.peek().getChildByKey(body);
            }
        }
        this.currentOperation.push(Objects.requireNonNull(childNode, "Child node not found"));
        childNode.setOperationStatus(OperationStatus.CURRENT);
    }

    private void setCurrentOperation(SearchPlan plan, ISearchOperation operation, boolean isBacktrack) {
        IPlanNode node = this.currentOperation.peek();
        if (node instanceof SearchOperationNode) {
            if (Objects.equals(((PatternBodyNode)node.getParent()).getRelatedBody(), plan.getSourceBody())) {
                this.currentOperation.pop();
                IPlanNode currentParent = this.currentOperation.peek();
                currentParent.setOperationStatus(OperationStatus.CURRENT);
                IPlanNode childNode = currentParent.getChildByKey(operation);
                this.currentOperation.push(childNode);
            }
        } else if (node instanceof PatternBodyNode && Objects.equals(((PatternBodyNode)node).getRelatedBody(), plan.getSourceBody())) {
            IPlanNode childNode = node.getChildByKey(operation);
            this.currentOperation.push(childNode);
        }
    }

    public void noMoreMatchesAvailable(LocalSearchMatcher matcher) {
        if (this.isDisposed) {
            return;
        }
        if (this.currentOperation.isEmpty()) {
            this.suspended = true;
            this.hasFinished = true;
            this.localSearchDebugView.refreshView(this.rootSpecification.getInternalQueryRepresentation(), null);
        } else {
            PatternBodyNode node = (PatternBodyNode)this.currentOperation.pop();
            node.setOperationStatus(OperationStatus.EXECUTED);
            this.waitForMatchingToContinue();
        }
    }

    public void planChanged(Optional<SearchPlan> oldPlanOptional, Optional<SearchPlan> newPlanOptional) {
        if (this.isDisposed) {
            return;
        }
        newPlanOptional.ifPresent(newPlan -> {
            this.setCurrentOperation(newPlan.getSourceBody());
            PQuery querySpecification = newPlan.getSourceBody().getPattern();
            int keySize = querySpecification.getParameters().size();
            TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(querySpecification);
            List storedFrames = (List)matchesViewer.getData("key");
            if (!storedFrames.isEmpty()) {
                storedFrames.remove(storedFrames.size() - 1);
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                Map variableMapping = newPlan.getVariableMapping();
                ArrayList<String> columnNames = new ArrayList<String>();
                int i = 0;
                while (i < variableMapping.size()) {
                    columnNames.add(((PVariable)variableMapping.get(i)).getName());
                    ++i;
                }
                this.localSearchDebugView.recreateColumns(columnNames, keySize, matchesViewer);
            });
        });
    }

    public void executorInitializing(SearchPlan searchPlan, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(searchPlan.getSourceBody().getPattern());
        List storedFrames = (List)matchesViewer.getData("key");
        if (!storedFrames.contains(frame)) {
            storedFrames.add(frame);
        }
    }

    public void operationSelected(SearchPlan plan, ISearchOperation operation, MatchingFrame frame, boolean isBacktrack) {
        if (this.isDisposed) {
            return;
        }
        this.setCurrentOperation(plan, operation, isBacktrack);
        IPlanNode node = this.currentOperation.peek();
        if (isBacktrack) {
            PatternBodyNode bodyNode = this.getCurrentlyExecutedBodyNode();
            bodyNode.getChildren().stream().skip(plan.getOperationIndex(operation)).forEach(n -> n.setOperationStatus(OperationStatus.QUEUED));
        }
        node.setOperationStatus(OperationStatus.CURRENT);
        this.waitForMatchingToContinue();
    }

    public void operationExecuted(SearchPlan plan, ISearchOperation operation, MatchingFrame frame, boolean isSuccessful) {
        if (this.isDisposed) {
            return;
        }
        IPlanNode node = this.currentOperation.pop();
        Preconditions.checkState((node instanceof SearchOperationNode && Objects.equals(operation, ((SearchOperationNode)node).getSearchOperation()) ? 1 : 0) != 0);
        if (isSuccessful) {
            node.setOperationStatus(OperationStatus.EXECUTED);
        } else {
            node.setOperationStatusTransitively(OperationStatus.QUEUED);
        }
    }

    public void matchFound(SearchPlan plan, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        MatchingFrame frameToStore = new MatchingFrame(frame);
        TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(plan.getSourceBody().getPattern());
        List storedFrames = (List)matchesViewer.getData("key");
        storedFrames.add(storedFrames.size() - 1, frameToStore);
        PatternBodyNode node = this.getCurrentlyExecutedBodyNode();
        node.setOperationStatus(OperationStatus.CURRENT);
        this.waitForMatchingToContinue();
        node.setOperationStatus(OperationStatus.EXECUTED);
    }

    public void continueMatching() {
        this.suspended = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMatchingToContinue() {
        if (this.localSearchDebugView != null) {
            if (!this.currentOperation.isEmpty() && this.currentOperation.peek().isBreakpointSet()) {
                this.suspended = true;
            }
            if (this.suspended) {
                this.localSearchDebugView.refreshView(this.getCurrentlyExecutedQuery(), this.currentOperation.peek());
                Object object = this.notifier;
                synchronized (object) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException e) {
                        this.dispose();
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public boolean isPatternMatchingRunning() {
        return !this.hasFinished;
    }

    private PatternBodyNode getCurrentlyExecutedBodyNode() {
        IPlanNode node = this.currentOperation.peek();
        while (node != null && !(node instanceof PatternBodyNode)) {
            node = node.getParent();
        }
        return (PatternBodyNode)node;
    }

    private PQuery getCurrentlyExecutedQuery() {
        PatternBodyNode node = this.getCurrentlyExecutedBodyNode();
        if (node != null) {
            return node.getRelatedBody().getPattern();
        }
        return this.rootSpecification.getInternalQueryRepresentation();
    }

    public void dispose() {
        this.isDisposed = true;
    }
}

