/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.wst.css.core.internal.contenttype.CSSResourceEncodingDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public final class ContentDescriberForCSS
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK, IContentDescriptionExtended.DETECTED_CHARSET, IContentDescriptionExtended.UNSUPPORTED_CHARSET, IContentDescriptionExtended.APPROPRIATE_DEFAULT};

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int result = 1;
        if (description == null) {
            result = this.computeValidity(contents);
        } else {
            this.calculateSupportedOptions(contents, description);
            result = this.computeValidity(contents);
        }
        return result;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        int result = 1;
        if (description == null) {
            result = this.computeValidity(contents);
        } else {
            this.calculateSupportedOptions(contents, description);
            result = this.computeValidity(contents);
        }
        return result;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    private void calculateSupportedOptions(InputStream contents, IContentDescription description) throws IOException {
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
        }
    }

    private void calculateSupportedOptions(Reader contents, IContentDescription description) throws IOException {
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
        }
    }

    private int computeValidity(InputStream inputStream) {
        return 1;
    }

    private int computeValidity(Reader reader) {
        return 1;
    }

    private IResourceCharsetDetector getDetector() {
        return new CSSResourceEncodingDetector();
    }

    private void handleCalculations(IContentDescription description, IResourceCharsetDetector detector) throws IOException {
        Object existingByteOrderMark;
        EncodingMemento encodingMemento = ((CSSResourceEncodingDetector)detector).getEncodingMemento();
        byte[] detectedByteOrderMark = encodingMemento.getUnicodeBOM();
        if (detectedByteOrderMark != null && !detectedByteOrderMark.equals(existingByteOrderMark = description.getProperty(IContentDescription.BYTE_ORDER_MARK))) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)detectedByteOrderMark);
        }
        if (!encodingMemento.isValid()) {
            description.setProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET, (Object)encodingMemento.getInvalidEncoding());
            description.setProperty(IContentDescriptionExtended.APPROPRIATE_DEFAULT, (Object)encodingMemento.getAppropriateDefault());
        }
        String detectedCharset = encodingMemento.getDetectedCharsetName();
        String javaCharset = encodingMemento.getJavaCharsetName();
        this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
        if (javaCharset != null) {
            Object existingCharset = description.getProperty(IContentDescription.CHARSET);
            if (javaCharset.equals(existingCharset)) {
                this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
            } else {
                String defaultCharset = this.getDetector().getSpecDefaultEncoding();
                if (defaultCharset != null) {
                    if (!defaultCharset.equals(javaCharset)) {
                        description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                    }
                } else {
                    description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                }
            }
        }
    }

    private void handleDetectedSpecialCase(IContentDescription description, Object detectedCharset, Object javaCharset) {
        if (detectedCharset != null) {
            description.setProperty(IContentDescriptionExtended.DETECTED_CHARSET, detectedCharset);
        }
    }

    private boolean isRelevent(IContentDescription description) {
        boolean result = false;
        if (description == null) {
            result = false;
        } else if (description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            result = true;
        } else if (description.isRequested(IContentDescription.CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.APPROPRIATE_DEFAULT)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.DETECTED_CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.UNSUPPORTED_CHARSET)) {
            result = true;
        }
        return result;
    }
}

