/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.ui.PluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.ChromiumRemoteTab;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.LaunchTabGroup;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.TabBase;
import org.eclipse.wst.jsdt.chromium.wip.WipBackend;
import org.eclipse.wst.jsdt.chromium.wip.eclipse.BackendRegistry;

class WipRemoteTab
extends ChromiumRemoteTab<WipTabElements> {
    private final Map<String, WipBackend> backendMap = new LinkedHashMap<String, WipBackend>();
    private static final TabBase.TabFieldList<? super WipTabElements, ? super LaunchTabGroup.Params> WIP_TAB_FIELDS;
    private static final LaunchTabGroup.Params PARAMS;

    static {
        TabBase.TabField<String, String, WipTabElements, LaunchTabGroup.Params> backendChooser = new TabBase.TabField<String, String, WipTabElements, LaunchTabGroup.Params>("wip_backend_id", TabBase.TypedMethods.STRING, new TabBase.FieldAccess<String, WipTabElements>(){

            @Override
            void setValue(String value, WipTabElements tabElements) {
                tabElements.getBackendSelector().setId(value);
            }

            @Override
            String getValue(WipTabElements tabElements) {
                return tabElements.getBackendSelector().getId();
            }
        }, new TabBase.DefaultsProvider<String, LaunchTabGroup.Params>(){

            @Override
            String getFallbackValue() {
                return null;
            }

            @Override
            String getInitialConfigValue(LaunchTabGroup.Params context) {
                return null;
            }
        }, LaunchParams.ValueConverter.getTrivial());
        ArrayList<TabBase.TabFieldList<WipTabElements, Object>> list = new ArrayList<TabBase.TabFieldList<WipTabElements, Object>>(2);
        list.add(WipRemoteTab.createFieldListAdapting(BASIC_TAB_FIELDS, new TabBase.Adapter<WipTabElements, ChromiumRemoteTab.TabElements>(){

            @Override
            public ChromiumRemoteTab.TabElements get(WipTabElements from) {
                return from.getBase();
            }
        }));
        list.add(WipRemoteTab.createFieldListImpl(Collections.singletonList(backendChooser)));
        WIP_TAB_FIELDS = WipRemoteTab.createCompositeFieldList(list);
        PARAMS = new LaunchTabGroup.Params(ChromiumRemoteTab.HostChecker.LOCAL_ONLY, Messages.ChromiumRemoteTab_URL, false);
    }

    WipRemoteTab() {
        super(PARAMS);
        for (WipBackend b : BackendRegistry.INSTANCE.getBackends()) {
            this.backendMap.put(b.getId(), b);
        }
    }

    @Override
    protected String getWarning(ILaunchConfiguration config) throws CoreException {
        String result = super.getWarning(config);
        if (result != null) {
            return result;
        }
        String backendId = config.getAttribute("wip_backend_id", null);
        if (backendId == null) {
            return "Wip backend should be selected";
        }
        if (this.backendMap.get(backendId) == null) {
            return "Unknown Wip backend id";
        }
        return null;
    }

    @Override
    protected WipTabElements createDialogElements(Composite composite, Runnable modifyListener, PreferenceStore store) {
        final ChromiumRemoteTab.TabElements basicElements = WipRemoteTab.createBasicTabElements(composite, modifyListener, store, (LaunchTabGroup.Params)this.getParams());
        final BackendSelectorControl backendSelector = new BackendSelectorControl(composite, this.backendMap, modifyListener);
        backendSelector.getMainControl().setLayoutData((Object)new GridData(768));
        return new WipTabElements(){

            @Override
            public BackendSelectorControl getBackendSelector() {
                return backendSelector;
            }

            @Override
            public ChromiumRemoteTab.TabElements getBase() {
                return basicElements;
            }
        };
    }

    @Override
    protected TabBase.TabFieldList<? super WipTabElements, ? super LaunchTabGroup.Params> getTabFields() {
        return WIP_TAB_FIELDS;
    }

    private static class BackendSelectorControl {
        private final Group mainControl;
        private final Combo combo;
        private final Text text;
        private final List<WipBackend> elements;
        private final String[] labelArray;

        BackendSelectorControl(Composite composite, Map<String, WipBackend> backendMap, final Runnable modifyListener) {
            Group backendGroup = new Group(composite, 0);
            backendGroup.setText("Wip backend");
            backendGroup.setLayout((Layout)new GridLayout(1, false));
            this.elements = new ArrayList<WipBackend>();
            this.elements.add(null);
            this.elements.addAll(backendMap.values());
            this.labelArray = new String[this.elements.size()];
            this.labelArray[0] = "Select backend";
            int i = 1;
            while (i < this.labelArray.length) {
                this.labelArray[i] = this.elements.get(i).getId();
                ++i;
            }
            this.combo = new Combo((Composite)backendGroup, 8);
            this.combo.setLayoutData((Object)new GridData(768));
            this.combo.setFont(composite.getFont());
            this.combo.setItems(this.labelArray);
            this.combo.select(0);
            this.text = new Text((Composite)backendGroup, 522);
            Font font = composite.getFont();
            this.text.setFont(font);
            GridData textLayoutData = new GridData(768);
            int fontHeight = PluginUtil.getFontMetrics((Drawable)this.text, null).getHeight();
            textLayoutData.minimumHeight = fontHeight * 3;
            this.text.setLayoutData((Object)textLayoutData);
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    modifyListener.run();
                    BackendSelectorControl.this.updateTextField();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.mainControl = backendGroup;
        }

        public String getId() {
            WipBackend backend = this.elements.get(this.combo.getSelectionIndex());
            if (backend == null) {
                return null;
            }
            return backend.getId();
        }

        public void setId(String id) {
            int index = Arrays.asList(this.labelArray).indexOf(id);
            if (index == -1) {
                index = 0;
            }
            this.combo.select(index);
            this.updateTextField();
        }

        private void updateTextField() {
            WipBackend backend = this.elements.get(this.combo.getSelectionIndex());
            String textContent = backend == null ? "" : backend.getDescription();
            this.text.setText(textContent);
        }

        Group getMainControl() {
            return this.mainControl;
        }
    }

    static interface WipTabElements {
        public BackendSelectorControl getBackendSelector();

        public ChromiumRemoteTab.TabElements getBase();
    }
}

