/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class LaunchClientJob
extends ChainedJob {
    protected IModule[] module;
    protected IClient client;
    protected ILaunchableAdapter launchableAdapter;
    protected String launchMode;
    protected IModuleArtifact moduleArtifact;

    public LaunchClientJob(IServer server, IModule[] module, String launchMode, IModuleArtifact moduleArtifact, ILaunchableAdapter launchableAdapter, IClient client) {
        super(Messages.launchingClientTask, server);
        this.module = module;
        this.launchMode = launchMode;
        this.moduleArtifact = moduleArtifact;
        this.launchableAdapter = launchableAdapter;
        this.client = client;
        this.setRule((ISchedulingRule)server);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (Trace.FINER) {
            Trace.trace("/finer", "LaunchClient job");
        }
        final Server server = (Server)this.getServer();
        int state = server.getModuleState(this.module);
        int count = ServerPreferences.getInstance().getModuleStartTimeout();
        while (state == 1 && count > 0) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            count -= 2000;
            state = server.getModuleState(this.module);
        }
        if (Trace.FINER) {
            Trace.trace("/finer", "LaunchClient job 2 " + state);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (state == 1) {
            return Status.OK_STATUS;
        }
        if (Trace.FINER) {
            Trace.trace("/finer", "LaunchClient job 3");
        }
        final IStatus[] resultingStatus = new IStatus[]{Status.OK_STATUS};
        final Object[] launchable = new Object[1];
        try {
            launchable[0] = this.launchableAdapter.getLaunchable((IServer)server, this.moduleArtifact);
        }
        catch (CoreException ce) {
            resultingStatus[0] = ce.getStatus();
            EclipseUtil.openError(null, resultingStatus[0]);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (launchable[0] != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    block7: {
                        if (Trace.FINEST) {
                            Trace.trace("/finest", "Attempting to load client: " + LaunchClientJob.this.client.getId());
                        }
                        try {
                            resultingStatus[0] = LaunchClientJob.this.client.launch((IServer)server, launchable[0], LaunchClientJob.this.launchMode, server.getLaunch());
                            if (resultingStatus[0] != null && resultingStatus[0].getSeverity() == 4) {
                                EclipseUtil.openError(null, resultingStatus[0]);
                            } else if (resultingStatus[0] == null) {
                                resultingStatus[0] = Status.OK_STATUS;
                            }
                        }
                        catch (Exception e) {
                            if (Trace.SEVERE) {
                                Trace.trace("/severe", "Server client failed", e);
                            }
                            if (resultingStatus[0] != null) break block7;
                            resultingStatus[0] = new Status(4, "org.eclipse.wst.server.ui", e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        if (Trace.FINER) {
            Trace.trace("/finer", "LaunchClient job 4");
        }
        return resultingStatus[0];
    }
}

