/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ChangeDetail {
    protected AccountInfoCache accounts;
    protected boolean allowsAnonymous;
    protected boolean canAbandon;
    protected boolean canRestore;
    protected Change change;
    protected boolean starred;
    protected List<ChangeInfo> dependsOn;
    protected List<ChangeInfo> neededBy;
    protected List<PatchSet> patchSets;
    protected List<ApprovalDetail> approvals;
    protected Set<ApprovalCategory.Id> missingApprovals;
    protected List<ChangeMessage> messages;
    protected PatchSet.Id currentPatchSetId;
    protected PatchSetDetail currentDetail;
    protected Set<ApprovalCategory.Id> currentActions;

    public AccountInfoCache getAccounts() {
        return this.accounts;
    }

    public void setAccounts(AccountInfoCache aic) {
        this.accounts = aic;
    }

    public boolean isAllowsAnonymous() {
        return this.allowsAnonymous;
    }

    public void setAllowsAnonymous(boolean anon) {
        this.allowsAnonymous = anon;
    }

    public boolean canAbandon() {
        return this.canAbandon;
    }

    public void setCanAbandon(boolean a) {
        this.canAbandon = a;
    }

    public boolean canRestore() {
        return this.canRestore;
    }

    public void setCanRestore(boolean a) {
        this.canRestore = a;
    }

    public Change getChange() {
        return this.change;
    }

    public void setChange(Change change) {
        this.change = change;
        this.currentPatchSetId = change.currentPatchSetId();
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean s) {
        this.starred = s;
    }

    public List<ChangeInfo> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<ChangeInfo> d) {
        this.dependsOn = d;
    }

    public List<ChangeInfo> getNeededBy() {
        return this.neededBy;
    }

    public void setNeededBy(List<ChangeInfo> d) {
        this.neededBy = d;
    }

    public List<ChangeMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChangeMessage> m) {
        this.messages = m;
    }

    public List<PatchSet> getPatchSets() {
        return this.patchSets;
    }

    public void setPatchSets(List<PatchSet> s) {
        this.patchSets = s;
    }

    public List<ApprovalDetail> getApprovals() {
        return this.approvals;
    }

    public void setApprovals(Collection<ApprovalDetail> list) {
        this.approvals = new ArrayList<ApprovalDetail>(list);
        Collections.sort(this.approvals, ApprovalDetail.SORT);
    }

    public Set<ApprovalCategory.Id> getMissingApprovals() {
        return this.missingApprovals;
    }

    public void setMissingApprovals(Set<ApprovalCategory.Id> a) {
        this.missingApprovals = a;
    }

    public Set<ApprovalCategory.Id> getCurrentActions() {
        return this.currentActions;
    }

    public void setCurrentActions(Set<ApprovalCategory.Id> a) {
        this.currentActions = a;
    }

    public boolean isCurrentPatchSet(PatchSetDetail detail) {
        return this.currentPatchSetId != null && detail.getPatchSet().getId().equals((Object)this.currentPatchSetId);
    }

    public PatchSet getCurrentPatchSet() {
        if (this.currentPatchSetId != null) {
            for (int i = this.patchSets.size() - 1; i >= 0; --i) {
                PatchSet ps = this.patchSets.get(i);
                if (!ps.getId().equals((Object)this.currentPatchSetId)) continue;
                return ps;
            }
        }
        return null;
    }

    public PatchSetDetail getCurrentPatchSetDetail() {
        return this.currentDetail;
    }

    public void setCurrentPatchSetDetail(PatchSetDetail d) {
        this.currentDetail = d;
    }

    public String getDescription() {
        return this.currentDetail != null ? this.currentDetail.getInfo().getMessage() : "";
    }
}

