/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.oda.pojo.querymodel.ConstantParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.OdaType;

public class ColumnDefinition
implements Cloneable {
    private IMappingSource[] mappingPath;
    private String name;
    private OdaType type;

    public void setName(String name) {
        this.name = name;
    }

    public ColumnDefinition(IMappingSource[] mappingPath, String name, OdaType type) {
        assert (mappingPath != null && mappingPath.length > 0 && name != null && type != null);
        this.mappingPath = mappingPath;
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public OdaType getType() {
        return this.type;
    }

    public List<VariableParameter> getVariableParameters() {
        ArrayList<VariableParameter> paramList = new ArrayList<VariableParameter>();
        IMappingSource[] sources = this.getMappingPath();
        int i = 0;
        while (i < sources.length) {
            if (sources[i] instanceof MethodSource) {
                IMethodParameter[] params = ((MethodSource)sources[i]).getParameters();
                int j = 0;
                while (j < params.length) {
                    if (params[j] instanceof VariableParameter) {
                        paramList.add((VariableParameter)params[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return paramList;
    }

    public IMappingSource[] getMappingPath() {
        return this.mappingPath;
    }

    public String getMappingPathText() {
        StringBuffer sb = new StringBuffer();
        IMappingSource[] iMappingSourceArray = this.mappingPath;
        int n = this.mappingPath.length;
        int n2 = 0;
        while (n2 < n) {
            IMappingSource m = iMappingSourceArray[n2];
            sb.append(m.getName());
            if (m instanceof MethodSource) {
                sb.append("(");
                int i = 0;
                IMethodParameter[] iMethodParameterArray = ((MethodSource)m).getParameters();
                int n3 = iMethodParameterArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethodParameter p = iMethodParameterArray[n4];
                    if (i > 0) {
                        sb.append(',').append(" ");
                    }
                    if (p instanceof ConstantParameter) {
                        ConstantParameter cp = (ConstantParameter)p;
                        if (cp.getStringValue() != null) {
                            String value = cp.getStringValue().replace(String.valueOf('\"'), "\\\"");
                            sb.append('\"').append(value).append('\"').append(':');
                        }
                        sb.append(cp.getDataType());
                    } else if (p instanceof VariableParameter) {
                        VariableParameter vp = (VariableParameter)p;
                        sb.append(vp.getName()).append(':').append(vp.getDataType());
                        if (vp.getStringValue() != null && vp.getStringValue().trim().length() > 0) {
                            sb.append(':').append('\"').append(vp.getStringValue()).append('\"');
                        }
                    }
                    ++i;
                    ++n4;
                }
                sb.append(")");
            }
            sb.append('#');
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public ColumnDefinition clone() {
        try {
            return (ColumnDefinition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mappingPath);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)obj;
        if (!Arrays.equals(this.mappingPath, other.mappingPath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }
}

