/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.util;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.pojo.querymodel.ClassColumnMappings;
import org.eclipse.birt.data.oda.pojo.querymodel.Column;
import org.eclipse.birt.data.oda.pojo.querymodel.ColumnReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.ConstantParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.FieldSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.OneColumnMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceGraph;
import org.eclipse.birt.data.oda.pojo.querymodel.RelayReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.Activator;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ColumnDefinition;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.OdaType;
import org.eclipse.birt.data.oda.pojo.util.PojoQueryWriter;
import org.eclipse.birt.data.oda.pojo.util.URLParser;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class.getName());
    private static final String METHOD_FLAG = ".+\\(.*\\)$";
    private static final String BEAN_NAME_REGEX = "^(get|is)[A-Z].*";
    private static final String CLASS_IMG_FLAG = "classImgFlag";
    private static final String FIELD_IMG_FLAG = "fieldImgFlag";
    private static final String METHOD_IMG_FLAG = "methodImgFlag";
    private static final String WARNING_IMG_FLAG = "warningImgFlag";
    private static final String DESIGNTIME_IMG_FLAG = "DesignTimeImgFlag";
    private static final String RUNTIME_IMG_FLAG = "RunTimeImgFlag";
    private static final String FOLDER_ICON = "FolderIcon";
    private static final String JAR_ICON = "JarIcon";
    private static final String OK_DISABLE_ICON = "OKDisableIcon";
    private static final String FAIL_DISABLE_ICON = "FailDisableIcon";

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(CLASS_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/class_obj.gif"));
        reg.put(FIELD_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/field_public_obj.gif"));
        reg.put(METHOD_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/method_public_obj.gif"));
        reg.put(WARNING_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/warning_obj.gif"));
        reg.put(DESIGNTIME_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/icon_designtime.gif"));
        reg.put(RUNTIME_IMG_FLAG, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/icon_runtime.gif"));
        reg.put(FOLDER_ICON, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/folder_icon.gif"));
        reg.put(JAR_ICON, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/jar_icon.gif"));
        reg.put(OK_DISABLE_ICON, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/ok_tbl_disabled.gif"));
        reg.put(FAIL_DISABLE_ICON, ImageDescriptor.createFromFile(Activator.class, (String)"/icons/fail_tbl_disabled.gif"));
    }

    private Utils() {
    }

    public static URLParser createURLParser(ResourceIdentifiers ri) {
        if (ri == null) {
            return new URLParser(null);
        }
        return new URLParser(DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)ri));
    }

    public static OdaType getSuggestOdaType(Member m) {
        if (m instanceof Method) {
            return Utils.getSuggerstOdaType(((Method)m).getReturnType());
        }
        if (m instanceof Field) {
            return Utils.getSuggerstOdaType(((Field)m).getType());
        }
        assert (false);
        return OdaType.String;
    }

    private static OdaType getSuggerstOdaType(Class type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return OdaType.Boolean;
        }
        if (type == Character.TYPE || type == Character.class) {
            return OdaType.String;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return OdaType.Integer;
        }
        if (type == Short.TYPE || type == Short.class) {
            return OdaType.Integer;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return OdaType.Integer;
        }
        if (type == Long.TYPE || type == Long.class) {
            return OdaType.Double;
        }
        if (type == Float.TYPE || type == Float.class) {
            return OdaType.Double;
        }
        if (type == Double.TYPE || type == Double.class) {
            return OdaType.Double;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return OdaType.Decimal;
        }
        if (Blob.class.isAssignableFrom(type)) {
            return OdaType.Blob;
        }
        if (Clob.class.isAssignableFrom(type)) {
            return OdaType.String;
        }
        if (Time.class.isAssignableFrom(type)) {
            return OdaType.Time;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return OdaType.Timestamp;
        }
        if (Date.class.isAssignableFrom(type)) {
            return OdaType.Date;
        }
        if (type == String.class) {
            return OdaType.String;
        }
        return OdaType.Object;
    }

    public static String getSuggestName(Member m) {
        String name = m.getName();
        if (m instanceof Method) {
            if (name.matches(BEAN_NAME_REGEX)) {
                if (name.startsWith("get")) {
                    return name.substring(3);
                }
                return name.substring(2);
            }
            return Utils.upperFirstChar(name);
        }
        if (m instanceof Field) {
            return Utils.upperFirstChar(name);
        }
        assert (false);
        return m.getName();
    }

    private static String upperFirstChar(String name) {
        assert (name != null && name.length() > 0);
        if (Character.isLowerCase(name.charAt(0))) {
            return name.replaceFirst(String.valueOf(name.charAt(0)), String.valueOf(Character.toUpperCase(name.charAt(0))));
        }
        return name;
    }

    public static void updateColumnMappings(PojoQuery pq, ColumnDefinition[] cds) {
        assert (pq != null && cds != null);
        pq.clearColumnMappings();
        int i = 0;
        while (i < cds.length) {
            IMappingSource[] mss = cds[i].getMappingPath();
            ClassColumnMappings parent = null;
            int j = 0;
            while (j <= mss.length - 2) {
                ClassColumnMappings ccm = new ClassColumnMappings(mss[j]);
                parent = parent == null ? Utils.addClassColumnMappings(pq, ccm) : Utils.addClassColumnMappings(parent, ccm);
                ++j;
            }
            Column c = new Column(cds[i].getName(), cds[i].getType().getName(), i + 1);
            assert (mss.length >= 1);
            OneColumnMapping cm = new OneColumnMapping(mss[mss.length - 1], c);
            if (parent == null) {
                pq.addColumnsMapping((IColumnsMapping)cm);
            } else {
                parent.addColumnsMapping((IColumnsMapping)cm);
            }
            ++i;
        }
    }

    public static ColumnDefinition[] getColumnDefinitions(PojoQuery pq) throws OdaException {
        assert (pq != null);
        ReferenceGraph rg = ReferenceGraph.create((PojoQuery)pq);
        ColumnDefinition[] cds = new ColumnDefinition[rg.getColumnReferences().length];
        int index = 0;
        ColumnReferenceNode[] columnReferenceNodeArray = rg.getColumnReferences();
        int n = columnReferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnReferenceNode crn = columnReferenceNodeArray[n2];
            String name = crn.getColumn().getName();
            OdaType type = OdaType.getInstance(crn.getColumn().getOdaType());
            if (type == null) {
                logger.log(Level.WARNING, "Unkown Oda type: " + crn.getColumn().getOdaType());
                type = OdaType.String;
            }
            Stack<IMappingSource> mss = new Stack<IMappingSource>();
            mss.push(crn.getReference());
            RelayReferenceNode rrn = crn.getParent();
            while (rrn != null) {
                mss.push(rrn.getReference());
                rrn = rrn.getParent();
            }
            IMappingSource[] mappingPath = new IMappingSource[mss.size()];
            int i = 0;
            while (i < mappingPath.length) {
                mappingPath[i] = (IMappingSource)mss.pop();
                ++i;
            }
            cds[index] = new ColumnDefinition(mappingPath, name, type);
            ++index;
            ++n2;
        }
        return cds;
    }

    private static ClassColumnMappings addClassColumnMappings(PojoQuery pq, ClassColumnMappings ccm) {
        IColumnsMapping[] iColumnsMappingArray = pq.getColumnsMappings();
        int n = iColumnsMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnsMapping cm = iColumnsMappingArray[n2];
            if (cm instanceof ClassColumnMappings && cm.getSource().equals(ccm.getSource())) {
                return (ClassColumnMappings)cm;
            }
            ++n2;
        }
        pq.addColumnsMapping((IColumnsMapping)ccm);
        return ccm;
    }

    private static ClassColumnMappings addClassColumnMappings(ClassColumnMappings source, ClassColumnMappings ccm) {
        IColumnsMapping[] iColumnsMappingArray = source.getColumnsMappings();
        int n = iColumnsMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnsMapping cm = iColumnsMappingArray[n2];
            if (cm instanceof ClassColumnMappings && cm.getSource().equals(ccm.getSource())) {
                return (ClassColumnMappings)cm;
            }
            ++n2;
        }
        source.addColumnsMapping((IColumnsMapping)ccm);
        return ccm;
    }

    public static void savePrivateProperty(DataSetDesign design, String name, String value) throws OdaException {
        if (design.getPrivateProperties() != null) {
            if (value.length() == 0 && design.getPrivateProperties().getProperty(name) == null) {
                return;
            }
            if (!value.equals(design.getPrivateProperties().getProperty(name))) {
                design.getPrivateProperties().setProperty(name, value);
            }
        } else {
            Properties p = new Properties();
            p.put(name, value);
            design.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)design.getOdaExtensionDataSourceId(), (String)design.getOdaExtensionDataSetId(), (Properties)p));
        }
    }

    public static String getPrivateProperty(DataSetDesign design, String name) {
        if (design.getPrivateProperties() != null) {
            return design.getPrivateProperties().getProperty(name);
        }
        return null;
    }

    public static String getPublicProperty(DataSourceDesign ds, String name) {
        if (ds.getPublicProperties() != null) {
            return ds.getPublicProperties().getProperty(name);
        }
        return null;
    }

    public static String getPrivateProperty(DataSourceDesign ds, String name) {
        if (ds.getPrivateProperties() != null) {
            return ds.getPrivateProperties().getProperty(name);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMappingSource[] getMappingSource(String mappingPath) throws OdaException {
        assert (mappingPath != null);
        String[] mappingParts = Utils.splitBy(mappingPath, '#');
        if (mappingParts == null) {
            throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
        }
        ArrayList<Object> sources = new ArrayList<Object>();
        String[] stringArray = mappingParts;
        int n = mappingParts.length;
        int n2 = 0;
        while (n2 < n) {
            String mappingPart = stringArray[n2];
            String part = mappingPart.trim();
            if (part.equals("")) {
                throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
            }
            if (part.matches(METHOD_FLAG)) {
                int last = part.lastIndexOf(40);
                String methodName = part.substring(0, last).trim();
                if (!Utils.isValidIdentifier(methodName)) throw new OdaException(Messages.getFormattedString("DataSet.InvalidMethodName", new Object[]{methodName}));
                String paramParts = part.substring(last + 1, part.length() - 1).trim();
                ArrayList<Object> params = new ArrayList<Object>();
                if (paramParts.length() > 0) {
                    String[] ps = Utils.splitBy(paramParts, ',');
                    if (ps == null) {
                        throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
                    }
                    String[] stringArray2 = ps;
                    int n3 = ps.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String p = stringArray2[n4];
                        String param = p.trim();
                        if (param.length() == 0) {
                            throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
                        }
                        String[] nameOrValueAndType = Utils.splitBy(param, ':');
                        if (nameOrValueAndType == null || nameOrValueAndType.length != 1 && nameOrValueAndType.length != 2) {
                            throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
                        }
                        if (nameOrValueAndType.length == 1) {
                            String type = nameOrValueAndType[0].trim();
                            if (type.length() == 0) {
                                throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
                            }
                            params.add(new ConstantParameter(null, type));
                        } else {
                            String nameOrValue = nameOrValueAndType[0].trim();
                            String type = nameOrValueAndType[1].trim();
                            if (nameOrValue.length() == 0 || type.length() == 0) {
                                throw new OdaException(Messages.getFormattedString("DataSet.InvalidColumnMappingPath", new Object[]{mappingPath}));
                            }
                            if (nameOrValue.startsWith(String.valueOf('\"')) && nameOrValue.endsWith(String.valueOf('\"'))) {
                                String value = nameOrValue.substring(1, nameOrValue.length() - 1);
                                String regex = "\\Q\\\"\\E";
                                value = value.replaceAll(regex, String.valueOf('\"'));
                                params.add(new ConstantParameter(value, type));
                            } else {
                                params.add(new VariableParameter(nameOrValue, type));
                            }
                        }
                        ++n4;
                    }
                }
                sources.add(new MethodSource(methodName, params.toArray(new IMethodParameter[0])));
            } else {
                if (!Utils.isValidIdentifier(part)) throw new OdaException(Messages.getFormattedString("DataSet.InvalidFieldName", new Object[]{part}));
                sources.add(new FieldSource(part));
            }
            ++n2;
        }
        return sources.toArray(new IMappingSource[0]);
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String[] splitBy(String s, char separator) throws OdaException {
        assert (s != null);
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        int curIndex = 0;
        boolean isWaitingForEndQuote = false;
        while (curIndex < s.length()) {
            char c = s.charAt(curIndex);
            if (isWaitingForEndQuote) {
                if (c == '\"' && s.charAt(curIndex - 1) != '\\') {
                    isWaitingForEndQuote = false;
                }
            } else if (c == separator) {
                result.add(s.substring(startIndex, curIndex));
                startIndex = curIndex + 1;
            } else if (c == '\"') {
                isWaitingForEndQuote = true;
            }
            ++curIndex;
        }
        if (isWaitingForEndQuote) {
            return null;
        }
        result.add(s.substring(startIndex, curIndex));
        return result.toArray(new String[0]);
    }

    private static boolean isValidIdentifier(String s) {
        assert (s.length() > 0);
        char[] chars = s.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void savePojoQuery(PojoQuery pq, DataSetDesign design, Shell shell) {
        try {
            design.setQueryText(PojoQueryWriter.write((PojoQuery)pq));
        }
        catch (OdaException e) {
            ExceptionHandler.showException((Shell)shell, (String)Messages.getString("DataSet.FailedToSaveTitle"), (String)Messages.getString("DataSet.FailedToSaveMsg"), (Throwable)e);
        }
    }

    public static boolean isColumnDefinitionsEqual(PojoQuery pq, ColumnDefinition[] cds) {
        try {
            return Arrays.equals(Utils.getColumnDefinitions(pq), cds);
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, "Failed to get column definitions from pq", e);
            return false;
        }
    }

    public static Image getClassFlagImg() {
        return JFaceResources.getImageRegistry().get(CLASS_IMG_FLAG);
    }

    public static Image getFieldFlagImg() {
        return JFaceResources.getImageRegistry().get(FIELD_IMG_FLAG);
    }

    public static Image getMethodFlagImg() {
        return JFaceResources.getImageRegistry().get(METHOD_IMG_FLAG);
    }

    public static Image getWarningFlagImg() {
        return JFaceResources.getImageRegistry().get(WARNING_IMG_FLAG);
    }

    public static Image getFolderIcon() {
        return JFaceResources.getImageRegistry().get(FOLDER_ICON);
    }

    public static Image getJarIcon() {
        return JFaceResources.getImageRegistry().get(JAR_ICON);
    }

    public static Image getOKIcon() {
        return JFaceResources.getImageRegistry().get(OK_DISABLE_ICON);
    }

    public static Image getFailIcon() {
        return JFaceResources.getImageRegistry().get(FAIL_DISABLE_ICON);
    }

    public static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isFile() && o2.isFile()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            return 1;
        }
    }
}

