/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.navigator;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceCloseManagement {
    public static boolean saveDirtyAndCloseOpenFile(File file) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String sFilePath = file.getAbsolutePath();
        Path filePath = new Path(sFilePath);
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int offset = workspacePath.segmentCount();
        IPath fileRelativePath = filePath.removeFirstSegments(offset);
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile(fileRelativePath);
        resources.add((IResource)res);
        return ResourceCloseManagement.saveDirtyAndCloseOpenFiles(resources);
    }

    public static boolean saveDirtyAndCloseOpenFiles(List<IResource> resources) {
        if (resources.isEmpty()) {
            return true;
        }
        ArrayList<IEditorPart> openedDirtyFiles = new ArrayList<IEditorPart>();
        ArrayList<IEditorPart> openedFiles = new ArrayList<IEditorPart>();
        try {
            ResourceCloseManagement.checkOpenResources(resources, openedFiles, openedDirtyFiles);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e, (boolean)true);
        }
        if (openedFiles.isEmpty()) {
            return true;
        }
        if (ResourceCloseManagement.showClosingFileMessage(resources, openedFiles)) {
            if (!ResourceCloseManagement.checkAndSaveDirtyFiles(openedDirtyFiles)) {
                return false;
            }
            ResourceCloseManagement.closeAllOpenFiles(openedFiles);
            return true;
        }
        return false;
    }

    private static boolean showClosingFileMessage(List<IResource> resources, List<IEditorPart> openedFiles) {
        String msg = ResourceCloseManagement.getResourceType(resources, openedFiles);
        return MessageDialog.openQuestion(null, (String)Messages.getString((String)"renameChecker.closeResourceTitle"), (String)(String.valueOf(msg) + "  " + Messages.getString((String)"renameChecker.closeResourceMessage.proceed")));
    }

    private static String getResourceType(List<IResource> resources, List<IEditorPart> openedFiles) {
        IResource currentResource = resources.get(0);
        IEditorInput editorInput = openedFiles.get(0).getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            currentResource = ((FileEditorInput)editorInput).getFile();
        }
        switch (currentResource.getType()) {
            case 1: {
                return openedFiles.size() != 1 ? Messages.getString((String)"renameChecker.closeResourceMessage.forManyFile") : String.valueOf(currentResource.getName()) + " " + Messages.getString((String)"renameChecker.closeResourceMessage.forOneFile");
            }
            case 4: {
                return Messages.getString((String)"renameChecker.closeResourceMessage.forProject");
            }
        }
        return Messages.getString((String)"renameChecker.closeResourceMessage.forFolder");
    }

    public static boolean checkAndSaveAllFiles() {
        ArrayList<IEditorPart> editorsToSave = new ArrayList<IEditorPart>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int currWindow = 0;
        while (currWindow < windows.length) {
            IWorkbenchPage[] pages = windows[currWindow].getPages();
            int currPage = 0;
            while (currPage < pages.length) {
                IEditorReference[] editors;
                IEditorReference[] iEditorReferenceArray = editors = pages[currPage].getEditorReferences();
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference currEditorRef = iEditorReferenceArray[n2];
                    IEditorPart currEditor = currEditorRef.getEditor(false);
                    if (currEditor != null && currEditor.isDirty()) {
                        editorsToSave.add(currEditor);
                    }
                    ++n2;
                }
                ++currPage;
            }
            ++currWindow;
        }
        return ResourceCloseManagement.checkAndSaveDirtyFiles(editorsToSave);
    }

    public static void closeAllOpenFiles(List<IEditorPart> openedFiles) {
        for (IEditorPart part : openedFiles) {
            part.getSite().getPage().closeEditor(part, false);
        }
    }

    public static boolean checkAndSaveDirtyFiles(List<IEditorPart> openedDirtyFiles) {
        if (openedDirtyFiles.isEmpty()) {
            return true;
        }
        if (!ResourceCloseManagement.showSaveDirtyFileDialog(openedDirtyFiles)) {
            return false;
        }
        final List<IEditorPart> finalEditors = openedDirtyFiles;
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("", finalEditors.size());
                for (IEditorPart part : finalEditors) {
                    part.doSave((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog ctx = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            ctx.run(false, false, progressOp);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((Throwable)e, (boolean)true);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static boolean showSaveDirtyFileDialog(List<IEditorPart> dirtyEditors) {
        AdaptableList input = new AdaptableList(dirtyEditors);
        ListDialog dlg = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dlg.setContentProvider((IStructuredContentProvider)new BaseWorkbenchContentProvider());
        dlg.setLabelProvider((ILabelProvider)new WorkbenchPartLabelProvider());
        dlg.setInput((Object)input);
        dlg.setMessage(Messages.getString((String)"renameChecker.saveResourcesMessage"));
        dlg.setTitle(Messages.getString((String)"renameChecker.saveResourcesTitle"));
        return dlg.open() == 0;
    }

    private static IEditorReference getEditorRefInOpenFileList(IFile resourceToCheck) {
        IEditorReference[] editors = ResourceCloseManagement.getOpenedFileRefs();
        int i = 0;
        while (i < editors.length) {
            IFile file = ResourceCloseManagement.getEditorFile(editors[i]);
            if (file != null && file.equals((Object)resourceToCheck)) {
                return editors[i];
            }
            ++i;
        }
        return null;
    }

    private static IFile getEditorFile(IEditorReference fileRef) {
        IEditorInput input;
        IEditorPart part;
        if (fileRef != null && (part = (IEditorPart)fileRef.getPart(false)) != null && (input = part.getEditorInput()) != null && input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private static void checkOpenResources(List<IResource> itemsToCheck, List<IEditorPart> openedEditorRefs, List<IEditorPart> openedDirtyEditorRefs) throws CoreException {
        for (IResource resourceToCheck : itemsToCheck) {
            switch (resourceToCheck.getType()) {
                case 1: {
                    IEditorReference fileRef = ResourceCloseManagement.getEditorRefInOpenFileList((IFile)resourceToCheck);
                    ResourceCloseManagement.checkAndAddToEditorLists(openedEditorRefs, openedDirtyEditorRefs, fileRef);
                    break;
                }
                case 4: {
                    ResourceCloseManagement.getOpenedFileInProject((IProject)resourceToCheck, openedEditorRefs, openedDirtyEditorRefs);
                    break;
                }
                default: {
                    ResourceCloseManagement.checkOpenResources(Arrays.asList(((IContainer)resourceToCheck).members()), openedEditorRefs, openedDirtyEditorRefs);
                }
            }
        }
    }

    private static void checkAndAddToEditorLists(List<IEditorPart> openedEditorRefs, List<IEditorPart> openedDirtyEditorRefs, IEditorReference fileRef) {
        IEditorPart part;
        if (fileRef != null && (part = (IEditorPart)fileRef.getPart(false)) != null) {
            if (part.isDirty()) {
                openedDirtyEditorRefs.add(part);
            }
            openedEditorRefs.add(part);
        }
    }

    private static void getOpenedFileInProject(IProject project, List<IEditorPart> openedEditorRefs, List<IEditorPart> openedDirtyEditorRefs) {
        IEditorReference[] editors = ResourceCloseManagement.getOpenedFileRefs();
        int i = 0;
        while (i < editors.length) {
            IFile file = ResourceCloseManagement.getEditorFile(editors[i]);
            if (file != null && file.getProject() != null && file.getProject().equals((Object)project)) {
                ResourceCloseManagement.checkAndAddToEditorLists(openedEditorRefs, openedDirtyEditorRefs, editors[i]);
            }
            ++i;
        }
    }

    private static IEditorReference[] getOpenedFileRefs() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        return page.getEditorReferences();
    }
}

