/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.actions.ResourceFileFolderSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseElementTreeSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.IResourceContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceLocator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ResourceFileFolderSelectionDialog
extends BaseElementTreeSelectionDialog {
    protected static final String[] DEFAULT_FILTER = new String[]{"*.*"};
    private File rootFile;
    private IResourceContentProvider provider;
    private TreeViewerBackup treeViewerBackup;
    private MenuManager menuManager;
    private ToolItem toolItem;
    private ToolBar toolBar;
    private Button importButton;
    private String[] fileNamePattern;
    private Object input;
    private boolean isShowEmptyFolderFilter = true;
    private boolean allowImportFile = false;

    public ResourceFileFolderSelectionDialog() {
        this(true, false, null);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles) {
        this(showFiles, false, null);
    }

    public ResourceFileFolderSelectionDialog(String[] fileNamePattern) {
        this(true, false, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean includeFragments, String[] fileNamePattern) {
        this(true, includeFragments, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles, boolean includeFragments, String[] fileNamePattern) {
        this(showFiles, includeFragments, fileNamePattern, new ResourceFileContentProvider(showFiles));
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles, boolean includeFragments, String[] fileNamePattern, IResourceContentProvider contentProvider) {
        this(UIUtil.getDefaultShell(), (ILabelProvider)new ResourceFileLabelProvider(), contentProvider);
        this.fileNamePattern = fileNamePattern;
        this.input = includeFragments ? ResourceLocator.getRootEntries(fileNamePattern) : ResourceLocator.getResourceFolder(fileNamePattern);
        this.setInput(this.input);
    }

    protected ResourceFileFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, IResourceContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator(new FileViewerComparator());
        this.provider = contentProvider;
    }

    public void refreshRoot() {
        this.getTreeViewer().remove(this.input);
        this.getTreeViewer().setInput(this.input);
        this.handleTreeViewerRefresh();
    }

    private void handleTreeViewerRefresh() {
        if (this.treeViewerBackup != null) {
            this.treeViewerBackup.restoreBackup(this.getTreeViewer());
        } else {
            this.treeViewerBackup = new TreeViewerBackup();
            this.getTreeViewer().expandToLevel(2);
            this.treeViewerBackup.updateStatus(this.getTreeViewer());
        }
    }

    public void setInput(Object input) {
        this.rootFile = new File(input.toString());
        this.input = input;
        super.setInput(input);
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0 && this.rootFile != null) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            if (entry == null || entry.getURL() == null) {
                return null;
            }
            return ResourceLocator.relativize(entry.getURL());
        }
        return null;
    }

    public String getPath(int index) {
        Object[] selected = this.getResult();
        if (index < 0 || index >= selected.length || this.rootFile == null) {
            return null;
        }
        ResourceEntry entry = (ResourceEntry)selected[index];
        return ResourceLocator.relativize(entry.getURL());
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceSelectDialog_ID");
        Control control = super.createDialogArea(parent);
        if (this.allowImportFile()) {
            this.createImportFileArea((Composite)control);
        }
        this.getTreeViewer().getTree().setFocus();
        TreeListener treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                Item item = (Item)e.item;
                if (ResourceFileFolderSelectionDialog.this.treeViewerBackup != null) {
                    ResourceFileFolderSelectionDialog.this.treeViewerBackup.updateCollapsedStatus(ResourceFileFolderSelectionDialog.this.getTreeViewer(), item.getData());
                }
            }

            public void treeExpanded(TreeEvent e) {
                Item item = (Item)e.item;
                if (ResourceFileFolderSelectionDialog.this.treeViewerBackup != null) {
                    ResourceFileFolderSelectionDialog.this.treeViewerBackup.updateExpandedStatus(ResourceFileFolderSelectionDialog.this.getTreeViewer(), item.getData());
                }
            }
        };
        this.getTreeViewer().getTree().addTreeListener(treeListener);
        this.addToolTip();
        return control;
    }

    protected Label createMessageArea(Composite composite) {
        Composite infoContent = new Composite(composite, 0);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        infoContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.numColumns = 2;
        infoContent.setLayout((Layout)layout);
        Label label = new Label(infoContent, 0);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(768));
        this.createViewMenu(infoContent);
        return label;
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        if (this.importButton != null) {
            this.importButton.setEnabled(this.getSelectedFolder() != null);
        }
    }

    protected void createImportFileArea(Composite parent) {
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages.getString((String)"ResourceFileFolderSelectionDialog.button.importFile"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ResourceFileFolderSelectionDialog.this.getShell());
                dialog.setFilterExtensions(ResourceFileFolderSelectionDialog.this.fileNamePattern == null ? DEFAULT_FILTER : ResourceFileFolderSelectionDialog.this.fileNamePattern);
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    Object[] selection;
                    File srcFile;
                    File targetFolder = ResourceFileFolderSelectionDialog.this.getSelectedFolder();
                    File targetFile = new File(targetFolder, (srcFile = new File(selectedLocation)).getName());
                    if (targetFile.exists() && !MessageDialog.openConfirm((Shell)ResourceFileFolderSelectionDialog.this.getShell(), (String)Messages.getString((String)"ResourceFileFolderSelectionDialog.title.overwrite"), (String)Messages.getString((String)"ResourceFileFolderSelectionDialog.overwrite.msg"))) {
                        return;
                    }
                    ResourceFileFolderSelectionDialog.this.importFile(targetFile, srcFile);
                    IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                    if (synchronizer != null) {
                        synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, Path.fromOSString((String)targetFile.getAbsolutePath()), 1));
                    }
                    if ((selection = ResourceFileFolderSelectionDialog.this.getResult()) != null && selection.length > 0 && selection[0] instanceof PathResourceEntry) {
                        PathResourceEntry entry = (PathResourceEntry)selection[0];
                        if (entry.isFile() && entry.getParent() instanceof PathResourceEntry) {
                            entry = (PathResourceEntry)entry.getParent();
                        }
                        entry.refresh();
                        ResourceFileFolderSelectionDialog.this.getTreeViewer().refresh((Object)entry);
                        ResourceFileFolderSelectionDialog.this.getTreeViewer().expandToLevel((Object)entry, 1);
                    }
                }
            }
        });
    }

    private void importFile(final File target, final File src) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString((String)"ResourceFileFolderSelectionDialog.import.msg"), 1);
                    try {
                        try {
                            ResourceFileFolderSelectionDialog.this.doImport(target, src);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceFileFolderSelectionDialog.title.error"), (String)e.getLocalizedMessage());
        }
    }

    private void doImport(File target, File src) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(target);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fcin != null) {
                fcin.close();
            }
            if (fcout != null) {
                fcout.close();
            }
        }
    }

    protected File getSelectedFolder() {
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0) {
            File f;
            PathResourceEntry re;
            String path;
            if (selection[0] instanceof File) {
                File f2 = (File)selection[0];
                if (f2.isFile()) {
                    return f2.getParentFile();
                }
                return f2;
            }
            if (selection[0] instanceof PathResourceEntry && (path = (re = (PathResourceEntry)selection[0]).getPath()) != null && (f = new File(path)).exists()) {
                if (f.isFile()) {
                    return f.getParentFile();
                }
                return f;
            }
        }
        return null;
    }

    protected boolean allowImportFile() {
        return this.allowImportFile;
    }

    public void setAllowImportFile(boolean value) {
        this.allowImportFile = value;
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ResourceFileFolderSelectionDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(ReportPlatformUIImages.getImage("view menu"));
        this.toolItem.setToolTipText(Messages.getString((String)"ResourceFileFolderSelectionDialog.Text.Menu"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFileFolderSelectionDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        ResourceFileFolderSelectionAction action = new ResourceFileFolderSelectionAction(this);
        menuManager.add((IAction)action);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected void addToolTip() {
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null) {
                        tree.setToolTipText(null);
                    } else if (ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider() instanceof ResourceFileLabelProvider) {
                        tree.setToolTipText(((ResourceFileLabelProvider)ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider()).getToolTip(item.getData()));
                    } else {
                        tree.setToolTipText(null);
                    }
                }
            }
        });
        this.refreshRoot();
    }

    public boolean isShowEmptyFolderFilter() {
        return this.isShowEmptyFolderFilter;
    }

    public int getEmptyFolderShowStatus() {
        return this.provider.getEmptyFolderShowStatus();
    }

    public void setEmptyFolderShowStatus(int showStatus) {
        this.provider.setEmptyFolderShowStatus(showStatus);
        this.isShowEmptyFolderFilter = showStatus != 1 && showStatus != 2;
    }

    protected static class FileViewerComparator
    extends ViewerComparator {
        public FileViewerComparator() {
            super((Comparator)Collator.getInstance());
        }

        public int category(Object element) {
            if (element instanceof File) {
                if (((File)element).isDirectory()) {
                    return 0;
                }
                return 1;
            }
            if (element instanceof ResourceEntry) {
                if (((ResourceEntry)element).isFile()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public void sort(final Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    if (a instanceof FragmentResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return FileViewerComparator.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    if (a instanceof PathResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return 1;
                        }
                        if (b instanceof PathResourceEntry) {
                            return FileViewerComparator.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    return FileViewerComparator.this.compare(viewer, a, b);
                }
            });
        }
    }
}

