/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BorderUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorderHelper;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.TableBorderCollisionArbiter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class TableBorderLayer
extends FreeformLayer {
    private AbstractTableEditPart source;
    private int rowCount;
    private int colCount;
    private int[][] borderData;

    public TableBorderLayer(AbstractTableEditPart source) {
        this.source = source;
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
    }

    protected void paintFigure(Graphics graphics) {
        IFigure figure = this.source.getLayer("Primary Layer");
        TableBorderHelper helper = ((TableLayout)figure.getLayoutManager()).getBorderHelper();
        if (helper == null) {
            return;
        }
        this.borderData = helper.getBorderData();
        this.rowCount = this.source.getRowCount();
        this.colCount = this.source.getColumnCount();
        if (this.borderData == null || this.borderData.length != 2 * this.colCount * this.rowCount + this.colCount + this.rowCount) {
            return;
        }
        int i = 0;
        while (i < this.rowCount) {
            int y = TableUtil.caleY(this.source, i + 1);
            int h = this.caleVisualHeight(i + 1);
            int j = 0;
            while (j < this.colCount) {
                int bottomIndex = (i + 1) * (2 * this.colCount + 1) + j;
                int rightIndex = i * (2 * this.colCount + 1) + this.colCount + j + 1;
                int topIndex = i * (2 * this.colCount + 1) + j;
                int leftIndex = i * (2 * this.colCount + 1) + this.colCount + j;
                int x = TableUtil.caleX(this.source, j + 1);
                int w = this.caleVisualWidth(j + 1);
                if (j == 0) {
                    this.drawLeft(graphics, i, j, x, y, w, h, this.borderData[leftIndex]);
                }
                this.drawRight(graphics, i, j, x, y, w, h, this.borderData[rightIndex]);
                if (i == 0) {
                    this.drawTop(graphics, i, j, x, y, w, h, this.borderData[topIndex]);
                }
                this.drawBottom(graphics, i, j, x, y, w, h, this.borderData[bottomIndex]);
                ++j;
            }
            ++i;
        }
    }

    private int caleVisualWidth(int columnIndex) {
        IFigure figure = this.source.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (columnIndex <= data.columnWidths.length) {
            return data.findColumnData((int)columnIndex).width;
        }
        return 0;
    }

    private int caleVisualHeight(int rowIndex) {
        IFigure figure = this.source.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (rowIndex <= data.rowHeights.length) {
            return data.findRowData((int)rowIndex).height;
        }
        return 0;
    }

    private void drawBottom(Graphics g, int rowIndex, int colIndex, int x, int y, int w, int h, int[] data) {
        int rw;
        if (data[0] == 0 && data[1] == 0) {
            return;
        }
        int nLeftWidth = 0;
        int nLeftStyle = 0;
        int nLeftX = -1;
        int nLeftY = -1;
        if (colIndex > 0) {
            int[] nLeft = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex - 1];
            nLeftWidth = nLeft[1];
            nLeftStyle = nLeft[0];
            nLeftX = nLeft[3];
            nLeftY = nLeft[4];
        }
        int nRightWidth = 0;
        int nRightStyle = 0;
        int nRightX = -1;
        int nRightY = -1;
        if (colIndex < this.colCount - 1) {
            int[] nRight = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex + 1];
            nRightWidth = nRight[1];
            nRightStyle = nRight[0];
            nRightX = nRight[3];
            nRightY = nRight[4];
        }
        int nLeftTopWidth = 0;
        int nLeftTopStyle = 0;
        int nLeftTopX = -1;
        int nLeftTopY = -1;
        if (rowIndex >= 0 && colIndex >= 0) {
            int[] nLeftTop = this.borderData[rowIndex * (2 * this.colCount + 1) + this.colCount + colIndex];
            nLeftTopWidth = nLeftTop[1];
            nLeftTopStyle = nLeftTop[0];
            nLeftTopX = nLeftTop[3];
            nLeftTopY = nLeftTop[4];
        }
        int nLeftBottomWidth = 0;
        int nLeftBottomStyle = 0;
        int nLeftBottomX = -1;
        int nLeftBottomY = -1;
        if (rowIndex < this.rowCount - 1 && colIndex >= 0) {
            int[] nLeftBottom = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + this.colCount + colIndex];
            nLeftBottomWidth = nLeftBottom[1];
            nLeftBottomStyle = nLeftBottom[0];
            nLeftBottomX = nLeftBottom[3];
            nLeftBottomY = nLeftBottom[4];
        }
        int nRightTopWidth = 0;
        int nRightTopStyle = 0;
        int nRightTopX = -1;
        int nRightTopY = -1;
        if (rowIndex >= 0 && colIndex <= this.colCount - 1) {
            int[] nRightTop = this.borderData[rowIndex * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nRightTopWidth = nRightTop[1];
            nRightTopStyle = nRightTop[0];
            nRightTopX = nRightTop[3];
            nRightTopY = nRightTop[4];
        }
        int nRightBottomWidth = 0;
        int nRightBottomStyle = 0;
        int nRightBottomX = -1;
        int nRightBottomY = -1;
        if (rowIndex < this.rowCount - 1 && colIndex <= this.colCount - 1) {
            int[] nRightBottom = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nRightBottomWidth = nRightBottom[1];
            nRightBottomStyle = nRightBottom[0];
            nRightBottomX = nRightBottom[3];
            nRightBottomY = nRightBottom[4];
        }
        int nlexWidth = Math.max(nLeftTopWidth, nLeftBottomWidth);
        boolean exLeft = false;
        boolean exRight = false;
        int rx = colIndex == 0 ? x + nlexWidth : x + nlexWidth / 2;
        int n = rw = colIndex == 0 ? w - nlexWidth : w - nlexWidth / 2;
        if ((TableBorderCollisionArbiter.canExtend((int[])data, (int)nLeftWidth, (int)nLeftStyle, (int)nLeftBottomWidth, (int)nLeftBottomStyle, (int)nLeftBottomX, (int)nLeftBottomY, (int)nLeftTopWidth, (int)nLeftTopStyle, (int)nLeftTopX, (int)nLeftTopY, (boolean)true, (boolean)false) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nLeftWidth, (int)nLeftStyle, (int)nLeftX, (int)nLeftY, (int)nLeftBottomWidth, (int)nLeftBottomStyle, (int)nLeftBottomX, (int)nLeftBottomY, (int)nLeftTopWidth, (int)nLeftTopStyle, (int)nLeftTopX, (int)nLeftTopY, (boolean)true, (boolean)false)) && nLeftTopX != -2 && nLeftBottomX != -2 || data[3] == -2) {
            rx = colIndex == 0 ? x : x - nlexWidth / 2 - nlexWidth % 2;
            rw = colIndex == 0 ? w : w + nlexWidth / 2 + nlexWidth % 2;
            exLeft = true;
        }
        int nrexWidth = Math.max(nRightTopWidth, nRightBottomWidth);
        if ((TableBorderCollisionArbiter.canExtend((int[])data, (int)nRightWidth, (int)nRightStyle, (int)nRightTopWidth, (int)nRightTopStyle, (int)nRightTopX, (int)nRightTopY, (int)nRightBottomWidth, (int)nRightBottomStyle, (int)nRightBottomX, (int)nRightBottomY, (boolean)false, (boolean)false) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nRightWidth, (int)nRightStyle, (int)nRightX, (int)nRightY, (int)nRightTopWidth, (int)nRightTopStyle, (int)nRightTopX, (int)nRightTopY, (int)nRightBottomWidth, (int)nRightBottomStyle, (int)nRightBottomX, (int)nRightBottomY, (boolean)false, (boolean)false)) && nRightTopX != -2 && nRightBottomX != -2 || data[3] == -2) {
            rw += colIndex == this.colCount - 1 ? 0 : nrexWidth / 2;
            exRight = true;
        } else {
            rw -= colIndex == this.colCount - 1 ? nrexWidth : nrexWidth / 2 + nrexWidth % 2;
        }
        int direction = 1;
        int[] nArray = new int[4];
        nArray[1] = data[1];
        int[] widths = nArray;
        if (data[3] == nLeftTopX && data[4] == nLeftTopY && data[3] == nRightTopX && data[4] == nRightTopY) {
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = exLeft ? nLeftTopWidth : 0;
            widths[3] = exRight ? nRightTopWidth : 0;
        } else if (data[3] == nLeftTopX && data[4] == nLeftTopY) {
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = exLeft ? nLeftTopWidth : 0;
            widths[3] = 0;
        } else if (data[3] == nRightTopX && data[4] == nRightTopY) {
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = 0;
            widths[3] = exRight ? nRightTopWidth : 0;
        } else if (data[3] == nLeftBottomX && data[4] == nLeftBottomY && data[3] == nRightBottomX && data[4] == nRightBottomY) {
            direction = 0;
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = exLeft ? nLeftBottomWidth : 0;
            widths[3] = exRight ? nRightBottomWidth : 0;
        } else if (data[3] == nLeftBottomX && data[4] == nLeftBottomY) {
            direction = 0;
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = exLeft ? nLeftBottomWidth : 0;
            widths[3] = 0;
        } else if (data[3] == nRightBottomX && data[4] == nRightBottomY) {
            direction = 0;
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = exRight ? nRightBottomWidth : 0;
        } else if (data[3] != rowIndex || data[4] != colIndex) {
            direction = 0;
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = 0;
        }
        Rectangle r = new Rectangle(rx, y + h - data[1] / 2 - data[1] % 2, rw, data[1]);
        if (rowIndex == this.rowCount - 1) {
            r.y = y + h - data[1];
        }
        if (data[0] != 0) {
            g.setForegroundColor(ColorManager.getColor((int)data[2]));
            BorderUtil.drawBorderLine(g, direction, data[0], widths, r);
        } else if (data[1] > 0) {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, direction, r);
        }
    }

    private void drawRight(Graphics g, int rowIndex, int colIndex, int x, int y, int w, int h, int[] data) {
        int rh;
        if (data[0] == 0 && data[1] == 0) {
            return;
        }
        int nTopWidth = 0;
        int nTopStyle = 0;
        int nTopX = -1;
        int nTopY = -1;
        if (rowIndex > 0) {
            int[] nTop = this.borderData[(rowIndex - 1) * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nTopWidth = nTop[1];
            nTopStyle = nTop[0];
            nTopX = nTop[3];
            nTopY = nTop[4];
        }
        int nBottomWidth = 0;
        int nBottomStyle = 0;
        int nBottomX = -1;
        int nBottomY = -1;
        if (rowIndex < this.rowCount - 1) {
            int[] nBottom = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nBottomWidth = nBottom[1];
            nBottomStyle = nBottom[0];
            nBottomX = nBottom[3];
            nBottomY = nBottom[4];
        }
        int nTopLeftWidth = 0;
        int nTopLeftStyle = 0;
        int nTopLeftX = -1;
        int nTopLeftY = -1;
        if (colIndex <= this.colCount - 1 && rowIndex >= 0) {
            int[] nTopLeft = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex];
            nTopLeftWidth = nTopLeft[1];
            nTopLeftStyle = nTopLeft[0];
            nTopLeftX = nTopLeft[3];
            nTopLeftY = nTopLeft[4];
        }
        int nTopRightWidth = 0;
        int nTopRightStyle = 0;
        int nTopRightX = -1;
        int nTopRightY = -1;
        if (colIndex < this.colCount - 1 && rowIndex >= 0) {
            int[] nTopRight = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex + 1];
            nTopRightWidth = nTopRight[1];
            nTopRightStyle = nTopRight[0];
            nTopRightX = nTopRight[3];
            nTopRightY = nTopRight[4];
        }
        int nBottomLeftWidth = 0;
        int nBottomLeftStyle = 0;
        int nBottomLeftX = -1;
        int nBottomLeftY = -1;
        if (colIndex <= this.colCount - 1 && rowIndex <= this.rowCount - 1) {
            int[] nBottomLeft = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex];
            nBottomLeftWidth = nBottomLeft[1];
            nBottomLeftStyle = nBottomLeft[0];
            nBottomLeftX = nBottomLeft[3];
            nBottomLeftY = nBottomLeft[4];
        }
        int nBottomRightWidth = 0;
        int nBottomRightStyle = 0;
        int nBottomRightX = -1;
        int nBottomRightY = -1;
        if (colIndex < this.colCount - 1 && rowIndex <= this.rowCount - 1) {
            int[] nBottomRight = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex + 1];
            nBottomRightWidth = nBottomRight[1];
            nBottomRightStyle = nBottomRight[0];
            nBottomRightX = nBottomRight[3];
            nBottomRightY = nBottomRight[4];
        }
        int ntexWidth = Math.max(nTopLeftWidth, nTopRightWidth);
        boolean exTop = false;
        boolean exBottom = false;
        int ry = rowIndex == 0 ? y + ntexWidth : y + ntexWidth / 2;
        int n = rh = rowIndex == 0 ? h - ntexWidth : h - ntexWidth / 2;
        if ((TableBorderCollisionArbiter.canExtend((int[])data, (int)nTopWidth, (int)nTopStyle, (int)nTopLeftWidth, (int)nTopLeftStyle, (int)nTopLeftX, (int)nTopLeftY, (int)nTopRightWidth, (int)nTopRightStyle, (int)nTopRightX, (int)nTopRightY, (boolean)true, (boolean)true) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nTopWidth, (int)nTopStyle, (int)nTopX, (int)nTopY, (int)nTopLeftWidth, (int)nTopLeftStyle, (int)nTopLeftX, (int)nTopLeftY, (int)nTopRightWidth, (int)nTopRightStyle, (int)nTopRightX, (int)nTopRightY, (boolean)true, (boolean)true)) && nTopLeftX != -2 && nTopRightX != -2 || data[3] == -2) {
            ry = rowIndex == 0 ? y : y - ntexWidth / 2 - ntexWidth % 2;
            rh = rowIndex == 0 ? h : h + ntexWidth / 2 + ntexWidth % 2;
            exTop = true;
        }
        int nbexWidth = Math.max(nBottomLeftWidth, nBottomRightWidth);
        if ((TableBorderCollisionArbiter.canExtend((int[])data, (int)nBottomWidth, (int)nBottomStyle, (int)nBottomRightWidth, (int)nBottomRightStyle, (int)nBottomRightX, (int)nBottomRightY, (int)nBottomLeftWidth, (int)nBottomLeftStyle, (int)nBottomLeftX, (int)nBottomLeftY, (boolean)false, (boolean)true) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nBottomWidth, (int)nBottomStyle, (int)nBottomX, (int)nBottomY, (int)nBottomRightWidth, (int)nBottomRightStyle, (int)nBottomRightX, (int)nBottomRightY, (int)nBottomLeftWidth, (int)nBottomLeftStyle, (int)nBottomLeftX, (int)nBottomLeftY, (boolean)false, (boolean)true)) && nBottomLeftX != -2 && nBottomRightX != -2 || data[3] == -2) {
            rh += rowIndex == this.rowCount - 1 ? 0 : nbexWidth / 2;
            exBottom = true;
        } else {
            rh -= rowIndex == this.rowCount - 1 ? nbexWidth : nbexWidth / 2 + nbexWidth % 2;
        }
        int direction = 3;
        int[] nArray = new int[4];
        nArray[3] = data[1];
        int[] widths = nArray;
        if (data[3] == nTopLeftX && data[4] == nTopLeftY && data[3] == nBottomLeftX && data[4] == nBottomLeftY) {
            widths[0] = exTop ? nTopLeftWidth : 0;
            widths[1] = exBottom ? nBottomLeftWidth : 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nTopLeftX && data[4] == nTopLeftY) {
            widths[0] = exTop ? nTopLeftWidth : 0;
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nBottomLeftX && data[4] == nBottomLeftY) {
            widths[0] = 0;
            widths[1] = exBottom ? nBottomLeftWidth : 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nTopRightX && data[4] == nTopRightY && data[3] == nBottomRightX && data[4] == nBottomRightY) {
            direction = 2;
            widths[0] = exTop ? nTopRightWidth : 0;
            widths[1] = exBottom ? nBottomRightWidth : 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] == nTopRightX && data[4] == nTopRightY) {
            direction = 2;
            widths[0] = exTop ? nTopRightWidth : 0;
            widths[1] = 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] == nBottomRightX && data[4] == nBottomRightY) {
            direction = 2;
            widths[0] = 0;
            widths[1] = exBottom ? nBottomRightWidth : 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] != rowIndex || data[4] != colIndex) {
            direction = 2;
            widths[0] = 0;
            widths[1] = 0;
            widths[2] = data[1];
            widths[3] = 0;
        }
        Rectangle r = new Rectangle(x + w - data[1] / 2 - data[1] % 2, ry, data[1], rh);
        if (colIndex == this.colCount - 1) {
            r.x = x + w - data[1];
        }
        if (data[0] != 0) {
            g.setForegroundColor(ColorManager.getColor((int)data[2]));
            BorderUtil.drawBorderLine(g, direction, data[0], widths, r);
        } else if (data[1] > 0) {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, direction, r);
        }
    }

    private void drawTop(Graphics g, int rowIndex, int colIndex, int x, int y, int w, int h, int[] data) {
        int rw;
        if (data[0] == 0 && data[1] == 0) {
            return;
        }
        int nLeftWidth = 0;
        int nLeftStyle = 0;
        int nLeftX = -1;
        int nLeftY = -1;
        if (colIndex > 0) {
            int[] nLeft = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex - 1];
            nLeftWidth = nLeft[1];
            nLeftStyle = nLeft[0];
            nLeftX = nLeft[3];
            nLeftY = nLeft[4];
        }
        int nRightWidth = 0;
        int nRightStyle = 0;
        int nRightX = -1;
        int nRightY = -1;
        if (colIndex < this.colCount - 1) {
            int[] nRight = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex + 1];
            nRightWidth = nRight[1];
            nRightStyle = nRight[0];
            nRightX = nRight[3];
            nRightY = nRight[4];
        }
        int nLeftTopWidth = 0;
        int nLeftTopStyle = 0;
        int nLeftTopX = -1;
        int nLeftTopY = -1;
        if (rowIndex > 0 && colIndex >= 0) {
            int[] nLeftTop = this.borderData[(rowIndex - 1) * (2 * this.colCount + 1) + this.colCount + colIndex];
            nLeftTopWidth = nLeftTop[1];
            nLeftTopStyle = nLeftTop[0];
            nLeftTopX = nLeftTop[3];
            nLeftTopY = nLeftTop[4];
        }
        int nLeftBottomWidth = 0;
        int nLeftBottomStyle = 0;
        int nLeftBottomX = -1;
        int nLeftBottomY = -1;
        if (rowIndex <= this.rowCount - 1 && colIndex >= 0) {
            int[] nLeftBottom = this.borderData[rowIndex * (2 * this.colCount + 1) + this.colCount + colIndex];
            nLeftBottomWidth = nLeftBottom[1];
            nLeftBottomStyle = nLeftBottom[0];
            nLeftBottomX = nLeftBottom[3];
            nLeftBottomY = nLeftBottom[4];
        }
        int nRightTopWidth = 0;
        int nRightTopStyle = 0;
        int nRightTopX = -1;
        int nRightTopY = -1;
        if (rowIndex > 0 && colIndex <= this.colCount - 1) {
            int[] nRightTop = this.borderData[(rowIndex - 1) * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nRightTopWidth = nRightTop[1];
            nRightTopStyle = nRightTop[0];
            nRightTopX = nRightTop[3];
            nRightTopY = nRightTop[4];
        }
        int nRightBottomWidth = 0;
        int nRightBottomStyle = 0;
        int nRightBottomX = -1;
        int nRightBottomY = -1;
        if (rowIndex <= this.rowCount - 1 && colIndex <= this.colCount - 1) {
            int[] nRightBottom = this.borderData[rowIndex * (2 * this.colCount + 1) + this.colCount + colIndex + 1];
            nRightBottomWidth = nRightBottom[1];
            nRightBottomStyle = nRightBottom[0];
            nRightBottomX = nRightBottom[3];
            nRightBottomY = nRightBottom[4];
        }
        int nlexWidth = Math.max(nLeftTopWidth, nLeftBottomWidth);
        boolean exLeft = false;
        boolean exRight = false;
        int rx = colIndex == 0 ? x + nlexWidth : x + nlexWidth / 2;
        int n = rw = colIndex == 0 ? w - nlexWidth : w - nlexWidth / 2;
        if (TableBorderCollisionArbiter.canExtend((int[])data, (int)nLeftWidth, (int)nLeftStyle, (int)nLeftBottomWidth, (int)nLeftBottomStyle, (int)nLeftBottomX, (int)nLeftBottomY, (int)nLeftTopWidth, (int)nLeftTopStyle, (int)nLeftTopX, (int)nLeftTopY, (boolean)true, (boolean)false) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nLeftWidth, (int)nLeftStyle, (int)nLeftX, (int)nLeftY, (int)nLeftBottomWidth, (int)nLeftBottomStyle, (int)nLeftBottomX, (int)nLeftBottomY, (int)nLeftTopWidth, (int)nLeftTopStyle, (int)nLeftTopX, (int)nLeftTopY, (boolean)true, (boolean)false) || data[3] == -2) {
            rx = colIndex == 0 ? x : x - nlexWidth / 2 - nlexWidth % 2;
            rw = colIndex == 0 ? w : w + nlexWidth / 2 + nlexWidth % 2;
            exLeft = true;
        }
        int nrexWidth = Math.max(nRightTopWidth, nRightBottomWidth);
        if (TableBorderCollisionArbiter.canExtend((int[])data, (int)nRightWidth, (int)nRightStyle, (int)nRightTopWidth, (int)nRightTopStyle, (int)nRightTopX, (int)nRightTopY, (int)nRightBottomWidth, (int)nRightBottomStyle, (int)nRightBottomX, (int)nRightBottomY, (boolean)false, (boolean)false) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nRightWidth, (int)nRightStyle, (int)nRightX, (int)nRightY, (int)nRightTopWidth, (int)nRightTopStyle, (int)nRightTopX, (int)nRightTopY, (int)nRightBottomWidth, (int)nRightBottomStyle, (int)nRightBottomX, (int)nRightBottomY, (boolean)false, (boolean)false) || data[3] == -2 && rowIndex == this.colCount - 1) {
            rw += colIndex == this.colCount - 1 ? 0 : nrexWidth / 2;
            exRight = true;
        } else {
            rw -= colIndex == this.colCount - 1 ? nrexWidth : nrexWidth / 2 + nrexWidth % 2;
        }
        int direction = 0;
        int[] nArray = new int[4];
        nArray[0] = data[1];
        int[] widths = nArray;
        if (data[3] == nLeftTopX && data[4] == nLeftTopY && data[3] == nRightTopX && data[4] == nRightTopY) {
            direction = 1;
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = exLeft ? nLeftTopWidth : 0;
            widths[3] = exRight ? nRightTopWidth : 0;
        } else if (data[3] == nLeftTopX && data[4] == nLeftTopY) {
            direction = 1;
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = exLeft ? nLeftTopWidth : 0;
            widths[3] = 0;
        } else if (data[3] == nRightTopX && data[4] == nRightTopY) {
            direction = 1;
            widths[0] = 0;
            widths[1] = data[1];
            widths[2] = 0;
            widths[3] = exRight ? nRightTopWidth : 0;
        } else if (data[3] == nLeftBottomX && data[4] == nLeftBottomY && data[3] == nRightBottomX && data[4] == nRightBottomY) {
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = exLeft ? nLeftBottomWidth : 0;
            widths[3] = exRight ? nRightBottomWidth : 0;
        } else if (data[3] == nLeftBottomX && data[4] == nLeftBottomY) {
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = exLeft ? nLeftBottomWidth : 0;
            widths[3] = 0;
        } else if (data[3] == nRightBottomX && data[4] == nRightBottomY) {
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = exRight ? nRightBottomWidth : 0;
        } else if (data[3] != rowIndex || data[4] != colIndex) {
            direction = 0;
            widths[0] = data[1];
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = 0;
        }
        Rectangle r = new Rectangle(rx, y + h - data[1] / 2 - data[1] % 2, rw, data[1]);
        if (rowIndex == 0) {
            r.y = y;
        }
        if (data[0] != 0) {
            g.setForegroundColor(ColorManager.getColor((int)data[2]));
            BorderUtil.drawBorderLine(g, direction, data[0], widths, r);
        } else if (data[1] > 0) {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, direction, r);
        }
    }

    private void drawLeft(Graphics g, int rowIndex, int colIndex, int x, int y, int w, int h, int[] data) {
        int rh;
        if (data[0] == 0 && data[1] == 0) {
            return;
        }
        int nTopWidth = 0;
        int nTopStyle = 0;
        int nTopX = -1;
        int nTopY = -1;
        if (rowIndex > 0) {
            int[] nTop = this.borderData[(rowIndex - 1) * (2 * this.colCount + 1) + this.colCount + colIndex];
            nTopWidth = nTop[1];
            nTopStyle = nTop[0];
            nTopX = nTop[3];
            nTopY = nTop[4];
        }
        int nBottomWidth = 0;
        int nBottomStyle = 0;
        int nBottomX = -1;
        int nBottomY = -1;
        if (rowIndex < this.rowCount - 1) {
            int[] nBottom = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + this.colCount + colIndex];
            nBottomWidth = nBottom[1];
            nBottomStyle = nBottom[0];
            nBottomX = nBottom[3];
            nBottomY = nBottom[4];
        }
        int nTopLeftWidth = 0;
        int nTopLeftStyle = 0;
        int nTopLeftX = -1;
        int nTopLeftY = -1;
        if (colIndex > 0 && rowIndex >= 0) {
            int[] nTopLeft = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex - 1];
            nTopLeftWidth = nTopLeft[1];
            nTopLeftStyle = nTopLeft[0];
            nTopLeftX = nTopLeft[3];
            nTopLeftY = nTopLeft[4];
        }
        int nTopRightWidth = 0;
        int nTopRightStyle = 0;
        int nTopRightX = -1;
        int nTopRightY = -1;
        if (colIndex >= 0 && rowIndex >= 0) {
            int[] nTopRight = this.borderData[rowIndex * (2 * this.colCount + 1) + colIndex];
            nTopRightWidth = nTopRight[1];
            nTopRightStyle = nTopRight[0];
            nTopRightX = nTopRight[3];
            nTopRightY = nTopRight[4];
        }
        int nBottomLeftWidth = 0;
        int nBottomLeftStyle = 0;
        int nBottomLeftX = -1;
        int nBottomLeftY = -1;
        if (colIndex > 0 && rowIndex <= this.rowCount - 1) {
            int[] nBottomLeft = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex - 1];
            nBottomLeftWidth = nBottomLeft[1];
            nBottomLeftStyle = nBottomLeft[0];
            nBottomLeftX = nBottomLeft[3];
            nBottomLeftY = nBottomLeft[4];
        }
        int nBottomRightWidth = 0;
        int nBottomRightStyle = 0;
        int nBottomRightX = -1;
        int nBottomRightY = -1;
        if (colIndex >= 0 && rowIndex <= this.rowCount - 1) {
            int[] nBottomRight = this.borderData[(rowIndex + 1) * (2 * this.colCount + 1) + colIndex];
            nBottomRightWidth = nBottomRight[1];
            nBottomRightStyle = nBottomRight[0];
            nBottomRightX = nBottomRight[3];
            nBottomRightY = nBottomRight[4];
        }
        int ntexWidth = Math.max(nTopLeftWidth, nTopRightWidth);
        boolean exTop = false;
        boolean exBottom = false;
        int ry = rowIndex == 0 ? y + ntexWidth : y + ntexWidth / 2;
        int n = rh = rowIndex == 0 ? h - ntexWidth : h - ntexWidth / 2;
        if (TableBorderCollisionArbiter.canExtend((int[])data, (int)nTopWidth, (int)nTopStyle, (int)nTopLeftWidth, (int)nTopLeftStyle, (int)nTopLeftX, (int)nTopLeftY, (int)nTopRightWidth, (int)nTopRightStyle, (int)nTopRightX, (int)nTopRightY, (boolean)true, (boolean)true) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nTopWidth, (int)nTopStyle, (int)nTopX, (int)nTopY, (int)nTopLeftWidth, (int)nTopLeftStyle, (int)nTopLeftX, (int)nTopLeftY, (int)nTopRightWidth, (int)nTopRightStyle, (int)nTopRightX, (int)nTopRightY, (boolean)true, (boolean)true) || data[3] == -2) {
            ry = rowIndex == 0 ? y : y - ntexWidth / 2 - ntexWidth % 2;
            rh = rowIndex == 0 ? h : h + ntexWidth / 2 + ntexWidth % 2;
            exTop = true;
        }
        int nbexWidth = Math.max(nBottomLeftWidth, nBottomRightWidth);
        if (TableBorderCollisionArbiter.canExtend((int[])data, (int)nBottomWidth, (int)nBottomStyle, (int)nBottomRightWidth, (int)nBottomRightStyle, (int)nBottomRightX, (int)nBottomRightY, (int)nBottomLeftWidth, (int)nBottomLeftStyle, (int)nBottomLeftX, (int)nBottomLeftY, (boolean)false, (boolean)true) || TableBorderCollisionArbiter.isBrotherWin((int[])data, (int)nBottomWidth, (int)nBottomStyle, (int)nBottomX, (int)nBottomY, (int)nBottomRightWidth, (int)nBottomRightStyle, (int)nBottomRightX, (int)nBottomRightY, (int)nBottomLeftWidth, (int)nBottomLeftStyle, (int)nBottomLeftX, (int)nBottomLeftY, (boolean)false, (boolean)true) || data[3] == -2 && rowIndex == this.rowCount - 1) {
            rh += rowIndex == this.rowCount - 1 ? 0 : nbexWidth / 2;
            exBottom = true;
        } else {
            rh -= rowIndex == this.rowCount - 1 ? nbexWidth : nbexWidth / 2 + nbexWidth % 2;
        }
        int direction = 2;
        int[] nArray = new int[4];
        nArray[2] = data[1];
        int[] widths = nArray;
        if (data[3] == nTopLeftX && data[4] == nTopLeftY && data[3] == nBottomLeftX && data[4] == nBottomLeftY) {
            direction = 3;
            widths[0] = exTop ? nTopLeftWidth : 0;
            widths[1] = exBottom ? nBottomLeftWidth : 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nTopLeftX && data[4] == nTopLeftY) {
            direction = 3;
            widths[0] = exTop ? nTopLeftWidth : 0;
            widths[1] = 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nBottomLeftX && data[4] == nBottomLeftY) {
            direction = 3;
            widths[0] = 0;
            widths[1] = exBottom ? nBottomLeftWidth : 0;
            widths[2] = 0;
            widths[3] = data[1];
        } else if (data[3] == nTopRightX && data[4] == nTopRightY && data[3] == nBottomRightX && data[4] == nBottomRightY) {
            widths[0] = exTop ? nTopRightWidth : 0;
            widths[1] = exBottom ? nBottomRightWidth : 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] == nTopRightX && data[4] == nTopRightY) {
            widths[0] = exTop ? nTopRightWidth : 0;
            widths[1] = 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] == nBottomRightX && data[4] == nBottomRightY) {
            widths[0] = 0;
            widths[1] = exBottom ? nBottomRightWidth : 0;
            widths[2] = data[1];
            widths[3] = 0;
        } else if (data[3] != rowIndex || data[4] != colIndex) {
            direction = 2;
            widths[0] = 0;
            widths[1] = 0;
            widths[2] = data[1];
            widths[3] = 0;
        }
        Rectangle r = new Rectangle(x - data[1] / 2, ry, data[1], rh);
        if (colIndex == 0) {
            r.x = x;
        }
        if (data[0] != 0) {
            g.setForegroundColor(ColorManager.getColor((int)data[2]));
            BorderUtil.drawBorderLine(g, direction, data[0], widths, r);
        } else if (data[1] > 0) {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, direction, r);
        }
    }
}

