/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.bpel.fnmeta.model.Argument;
import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.expressions.Functions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class FunctionTemplatesContentAssistProcessor
extends TemplateCompletionProcessor {
    static final String XPATH_FUNCTIONS = "xpath.functions";
    TemplateContextType fTemplateContextType;
    Template[] fTemplates = new Template[0];
    EObject fModel;

    public void setModel(Object model) {
        assert (model instanceof EObject) : "argument is not an EObject";
        this.fModel = (EObject)model;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        if (this.fTemplateContextType == null) {
            this.fTemplateContextType = new TemplateContextType(XPATH_FUNCTIONS, "XPath functions");
        }
        return this.fTemplateContextType;
    }

    protected Image getImage(Template template) {
        return BPELUIPlugin.INSTANCE.getImage("obj16/function.gif");
    }

    protected Template[] getTemplates(String contextTypeId) {
        if (XPATH_FUNCTIONS.equals(contextTypeId) && this.fTemplates.length == 0) {
            Map<String, Function> fnMap = Functions.getInstance("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0").getFunctions();
            ArrayList<Template> list = new ArrayList<Template>(fnMap.size());
            for (Function fn : fnMap.values()) {
                String ns = fn.getNamespace();
                if (BPELUtils.isEmptyOrWhitespace((String)ns) || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(ns)) {
                    list.add(new Template(fn.getName(), fn.getHelp(), contextTypeId, this.getPattern(fn), true));
                    continue;
                }
                String pfx = this.getPrefix(ns, fn.getPrefix());
                if (pfx == null) continue;
                list.add(new Template(String.valueOf(pfx) + ":" + fn.getName(), fn.getHelp(), contextTypeId, this.getPattern(fn), true));
            }
            this.fTemplates = list.toArray(this.fTemplates);
            if (this.fTemplates.length > 1) {
                Arrays.sort(this.fTemplates, new Comparator<Template>(){

                    @Override
                    public int compare(Template o1, Template o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
        }
        return this.fTemplates;
    }

    String getPrefix(String ns, String preferredPrefix) {
        String pfx = BPELUtils.getNamespacePrefix((EObject)this.fModel, (String)ns);
        if (!BPELUtils.isEmptyOrWhitespace((String)pfx)) {
            return pfx;
        }
        pfx = preferredPrefix;
        if (BPELUtils.isValidPrefixName((String)pfx)) {
            return null;
        }
        return pfx;
    }

    String getPattern(Function fn) {
        StringBuilder builder = new StringBuilder(128);
        String ns = fn.getNamespace();
        if (!BPELUtils.isEmptyOrWhitespace((String)ns) && !"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(ns)) {
            String pfx = this.getPrefix(ns, fn.getPrefix());
            assert (pfx != null) : "Prefix for ns=" + ns + " cannot be null here";
            builder.append(pfx).append(":");
        }
        builder.append(fn.getName()).append("(");
        int argCount = fn.getArguments().size();
        for (Argument a : fn.getArguments()) {
            builder.append("${").append(a.getName()).append("}");
            switch (a.getOptionality()) {
                case OPTIONAL: {
                    builder.append("?");
                    break;
                }
                case OPTIONAL_MANY: {
                    builder.append("*");
                    break;
                }
            }
            builder.append(", ");
        }
        if (argCount > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append(")");
        return builder.toString();
    }
}

