/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.ICodanMarkerResolution;
import org.eclipse.cdt.codan.ui.ICodanMarkerResolutionExtension;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class CodanProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final String EXTENSION_POINT_NAME = "codanMarkerResolution";
    private static final Map<String, Collection<ConditionalResolution>> conditionalResolutions = new HashMap<String, Collection<ConditionalResolution>>();
    private static final List<IMarkerResolution> universalResolutions = new ArrayList<IMarkerResolution>();
    private static boolean resolutionsLoaded;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String id;
        if (!resolutionsLoaded) {
            CodanProblemMarkerResolutionGenerator.readExtensions();
        }
        if ((id = marker.getAttribute("id", null)) == null && conditionalResolutions.get(id) == null) {
            return new IMarkerResolution[0];
        }
        Collection<ConditionalResolution> candidates = conditionalResolutions.get(id);
        ArrayList resolutions = new ArrayList();
        if (candidates != null) {
            candidates.stream().filter(candidate -> candidate.isApplicableFor(marker)).peek(candidate -> candidate.setMarkerArguments(marker)).map(ConditionalResolution::getResolution).forEach(resolutions::add);
        }
        universalResolutions.stream().filter(res -> !(res instanceof ICodanMarkerResolution) || ((ICodanMarkerResolution)res).isApplicable(marker)).forEach(resolutions::add);
        return (IMarkerResolution[])resolutions.stream().peek(res -> {
            if (res instanceof ICodanMarkerResolutionExtension) {
                ((ICodanMarkerResolutionExtension)res).prepareFor(marker);
            }
        }).toArray(IMarkerResolution[]::new);
    }

    private static synchronized void readExtensions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.ui", EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        try {
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configurationElement = elements[i];
                CodanProblemMarkerResolutionGenerator.processResolution(configurationElement);
                ++i;
            }
        }
        finally {
            resolutionsLoaded = true;
        }
    }

    private static void processResolution(IConfigurationElement configurationElement) {
        String elementName = configurationElement.getName();
        if (elementName.equals("resolution")) {
            String id = configurationElement.getAttribute("problemId");
            String messagePattern = configurationElement.getAttribute("messagePattern");
            if (id == null && messagePattern == null) {
                CodanUIActivator.log("Extension for codanMarkerResolution problemId is not defined");
                return;
            }
            ConditionalResolution candidate = ConditionalResolution.createFrom(configurationElement);
            if (candidate == null) {
                return;
            }
            CodanProblemMarkerResolutionGenerator.addResolution(id, candidate);
        } else if (elementName.equals("universalResolution")) {
            universalResolutions.add(CodanProblemMarkerResolutionGenerator.instantiateResolution(configurationElement));
        }
    }

    private static IMarkerResolution instantiateResolution(IConfigurationElement element) {
        try {
            return (IMarkerResolution)element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CodanUIActivator.log(e);
            return null;
        }
    }

    private static void addResolution(String id, ConditionalResolution res) {
        Collection<ConditionalResolution> candidates = conditionalResolutions.get(id);
        if (candidates == null) {
            candidates = new ArrayList<ConditionalResolution>();
            conditionalResolutions.put(id, candidates);
        }
        candidates.add(res);
    }

    static class ConditionalResolution {
        private final Pattern messagePattern;
        private final IMarkerResolution resolutionInstance;

        public static ConditionalResolution createFrom(IConfigurationElement configurationElement) {
            String rawPattern = configurationElement.getAttribute("messagePattern");
            try {
                return new ConditionalResolution(configurationElement, rawPattern != null ? Pattern.compile(rawPattern) : null);
            }
            catch (PatternSyntaxException e) {
                CodanUIActivator.log("Invalid message pattern: " + rawPattern);
                return null;
            }
        }

        private ConditionalResolution(IConfigurationElement resolutionElement, Pattern messagePattern) {
            this.messagePattern = messagePattern;
            this.resolutionInstance = CodanProblemMarkerResolutionGenerator.instantiateResolution(resolutionElement);
        }

        public boolean isApplicableFor(IMarker marker) {
            if (this.resolutionInstance instanceof ICodanMarkerResolution && !((ICodanMarkerResolution)this.resolutionInstance).isApplicable(marker)) {
                return false;
            }
            return this.messagePattern == null || this.messagePattern.matcher(marker.getAttribute("message", "")).matches();
        }

        public IMarkerResolution getResolution() {
            return this.resolutionInstance;
        }

        public Pattern getMessagePattern() {
            return this.messagePattern;
        }

        public void setMarkerArguments(IMarker marker) {
            if (this.messagePattern == null) {
                return;
            }
            String message = marker.getAttribute("message", "");
            Matcher matcher = this.messagePattern.matcher(message);
            int n = matcher.groupCount();
            if (n == 0) {
                return;
            }
            if (!matcher.matches()) {
                return;
            }
            Object[] res = new String[n];
            int i = 0;
            while (i < n) {
                res[i] = matcher.group(i + 1);
                ++i;
            }
            Object[] old = CodanProblemMarker.getProblemArguments((IMarker)marker);
            if (!Arrays.deepEquals(res, old)) {
                try {
                    CodanProblemMarker.setProblemArguments((IMarker)marker, (String[])res);
                }
                catch (CoreException e) {
                    CodanUIActivator.log(e);
                }
            }
        }
    }
}

