/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructorSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFieldTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPartiallySpecializable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableTemplate;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPAliasTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPAliasTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecializationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredVariableInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumerationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUsingDeclarationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariableInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariableSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariableTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariableTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredVariableInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TemplateArgumentDeduction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeInstantiationRequest;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfUnknownMember;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CPPTemplates {
    static final int PACK_SIZE_DEFER = -1;
    static final int PACK_SIZE_FAIL = -2;
    static final int PACK_SIZE_NOT_FOUND = Integer.MAX_VALUE;
    private static final int TEMPLATE_INSTANTIATION_DEPTH_LIMIT = 128;
    private static final ThreadLocal<Integer> fTemplateInstantiationDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final ThreadLocal<Set<TypeInstantiationRequest>> instantiationsInProgress = new ThreadLocal<Set<TypeInstantiationRequest>>(){

        @Override
        protected Set<TypeInstantiationRequest> initialValue() {
            return new HashSet<TypeInstantiationRequest>();
        }
    };

    public static IBinding instantiate(ICPPPartiallySpecializable template, ICPPTemplateArgument[] args) {
        return CPPTemplates.instantiate(template, args, false, false);
    }

    private static IBinding instantiate(ICPPPartiallySpecializable template, ICPPTemplateArgument[] args, boolean isDefinition, boolean isExplicitSpecialization) {
        try {
            IBinding result;
            CPPTemplateParameterMap map;
            ICPPTemplateArgument[] arguments = SemanticUtil.getSimplifiedArguments(args);
            arguments = CPPTemplates.addDefaultArguments(template, arguments);
            if (arguments == null) {
                return CPPTemplates.createProblem(template, 15);
            }
            if (template instanceof ICPPTemplateTemplateParameter || CPPTemplates.hasDependentArgument(arguments)) {
                return CPPTemplates.deferredInstance(template, arguments);
            }
            if (template instanceof ICPPClassTemplatePartialSpecialization) {
                return CPPTemplates.instantiatePartialSpecialization((ICPPClassTemplatePartialSpecialization)template, arguments, isDefinition, null);
            }
            if (arguments == args) {
                arguments = (ICPPTemplateArgument[])args.clone();
            }
            if ((map = CPPTemplates.createParameterMap(template, arguments)) == null) {
                return CPPTemplates.createProblem(template, 15);
            }
            ICPPTemplateInstance prim = CPPTemplates.getInstance(template, arguments, isDefinition);
            if (prim != null && (isExplicitSpecialization || prim.isExplicitSpecialization())) {
                return prim;
            }
            if (!isExplicitSpecialization && (result = CPPTemplates.selectSpecialization(template, arguments, isDefinition)) != null) {
                return result;
            }
            return CPPTemplates.instantiatePrimaryTemplate(template, arguments, new InstantiationContext(map), isDefinition);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    public static IBinding instantiateAliasTemplate(ICPPAliasTemplate aliasTemplate, ICPPTemplateArgument[] args) {
        try {
            args = CPPTemplates.addDefaultArguments(aliasTemplate, args);
            if (args == null) {
                return CPPTemplates.createProblem(aliasTemplate, 15);
            }
            CPPTemplateParameterMap parameterMap = CPPTemplates.createParameterMap(aliasTemplate, args);
            if (parameterMap == null) {
                return CPPTemplates.createProblem(aliasTemplate, 15);
            }
            IType aliasedType = aliasTemplate.getType();
            IBinding owner = aliasTemplate.getOwner();
            return CPPTemplates.createAliasTemplateInstance(aliasTemplate, args, parameterMap, aliasedType, owner);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    private static IBinding createProblem(ICPPTemplateDefinition template, int id) {
        return new ProblemBinding(CPPSemantics.getCurrentLookupPoint(), id, template.getNameCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBinding isUsedInClassTemplateScope(ICPPClassTemplate ct, IASTName name) {
        try {
            IScope scope = null;
            IASTNode node = name;
            while (node != null) {
                if (node.getPropertyInParent() == IASTCompositeTypeSpecifier.TYPE_NAME) {
                    return null;
                }
                if (node instanceof IASTFunctionDefinition) {
                    IASTName functionName = ASTQueries.findInnermostDeclarator(((IASTFunctionDefinition)node).getDeclarator()).getName().getLastName();
                    if (functionName.getParent() instanceof ICPPASTQualifiedName && ASTQueries.isAncestorOf(functionName.getParent(), name)) {
                        return null;
                    }
                    scope = CPPVisitor.getContainingScope(functionName);
                    break;
                }
                if (node instanceof ICPPASTCompositeTypeSpecifier) {
                    scope = ((ICPPASTCompositeTypeSpecifier)node).getScope();
                    break;
                }
                node = node.getParent();
            }
            while (scope != null) {
                if (scope instanceof ISemanticProblem) {
                    return null;
                }
                if (scope instanceof ICPPClassScope) {
                    ICPPClassSpecialization specialization;
                    ICPPClassType b = ((ICPPClassScope)scope).getClassType();
                    if (b != null && ct.isSameType(b)) {
                        return ct;
                    }
                    if (b instanceof ICPPClassTemplatePartialSpecialization) {
                        ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)b;
                        if (ct.isSameType(pspec.getPrimaryClassTemplate())) {
                            return pspec;
                        }
                    } else if (b instanceof ICPPClassSpecialization && ct.isSameType((specialization = (ICPPClassSpecialization)b).getSpecializedBinding())) {
                        return specialization;
                    }
                }
                if (scope instanceof IASTInternalScope) {
                    IASTInternalScope internalScope = (IASTInternalScope)scope;
                    IASTNode physicalNode = internalScope.getPhysicalNode();
                    if (physicalNode instanceof ICPPASTCompositeTypeSpecifier && ((ICPPASTCompositeTypeSpecifier)physicalNode).getName() instanceof ICPPASTQualifiedName) {
                        scope = scope.getParent();
                        continue;
                    }
                    scope = CPPVisitor.getContainingScope(physicalNode);
                    if (scope != internalScope) continue;
                    return null;
                }
                scope = scope.getParent();
            }
            return null;
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private static IBinding instantiateFunctionTemplate(ICPPFunctionTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap tpMap) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, tpMap, arguments);
        if (instance instanceof ICPPFunction && SemanticUtil.isValidType(((ICPPFunction)((Object)instance)).getType())) {
            CPPTemplates.addInstance(template, arguments, instance);
        }
        return instance;
    }

    private static IBinding instantiatePartialSpecialization(ICPPPartialSpecialization partialSpec, ICPPTemplateArgument[] args, boolean isDef, CPPTemplateParameterMap tpMap) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(partialSpec, args, isDef);
        if (instance != null) {
            return instance;
        }
        if (tpMap == null) {
            tpMap = new CPPTemplateParameterMap(args.length);
            if (!TemplateArgumentDeduction.fromTemplateArguments(partialSpec.getTemplateParameters(), partialSpec.getTemplateArguments(), args, tpMap)) {
                return null;
            }
        }
        instance = CPPTemplates.createInstance(partialSpec.getOwner(), partialSpec, tpMap, args);
        CPPTemplates.addInstance(partialSpec, args, instance);
        return instance;
    }

    private static IBinding instantiatePrimaryTemplate(ICPPPartiallySpecializable template, ICPPTemplateArgument[] arguments, InstantiationContext context, boolean isDef) throws DOMException {
        assert (!(template instanceof ICPPClassTemplatePartialSpecialization));
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, isDef);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, context.getParameterMap(), arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateInstance getInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, boolean forDefinition) {
        if (template instanceof ICPPInstanceCache) {
            ICPPTemplateInstance result = ((ICPPInstanceCache)((Object)template)).getInstance(args);
            if (forDefinition && result instanceof IIndexBinding) {
                return null;
            }
            if (result != null && !result.isExplicitSpecialization()) {
                ICPPTemplateArgument[] instanceArgs = result.getTemplateArguments();
                int i = 0;
                while (i < args.length) {
                    if (!(args[i].getTypeValue() instanceof IIndexType) && instanceArgs[i].getTypeValue() instanceof IIndexType) {
                        return null;
                    }
                    ++i;
                }
            }
            return result;
        }
        return null;
    }

    private static void addInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, ICPPTemplateInstance instance) {
        if (template instanceof ICPPInstanceCache) {
            ((ICPPInstanceCache)((Object)template)).addInstance(args, instance);
        }
    }

    private static IBinding deferredInstance(ICPPPartiallySpecializable template, ICPPTemplateArgument[] arguments) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments, false);
        if (instance != null) {
            return instance;
        }
        if (template instanceof ICPPClassTemplate) {
            instance = new CPPDeferredClassInstance((ICPPClassTemplate)template, arguments);
            CPPTemplates.addInstance(template, arguments, instance);
        }
        if (template instanceof ICPPVariableTemplate) {
            instance = new CPPDeferredVariableInstance((ICPPVariableTemplate)template, arguments);
            CPPTemplates.addInstance(template, arguments, instance);
        }
        return instance;
    }

    private static ICPPTemplateArgument[] addDefaultArguments(ICPPTemplateDefinition template, ICPPTemplateArgument[] arguments) throws DOMException {
        int argCount;
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return arguments;
        }
        boolean havePackExpansion = false;
        int i = 0;
        while (i < arguments.length) {
            ICPPTemplateArgument arg = arguments[i];
            if (arg.isPackExpansion()) {
                if (i != arguments.length - 1) {
                    return arguments;
                }
                havePackExpansion = true;
            }
            ++i;
        }
        ICPPTemplateParameter[] tpars = template.getTemplateParameters();
        int tparCount = tpars.length;
        if (tparCount == (argCount = arguments.length)) {
            return arguments;
        }
        if (tparCount == 0) {
            return null;
        }
        if (tparCount < argCount) {
            if (tpars[tparCount - 1].isParameterPack()) {
                return arguments;
            }
            if (havePackExpansion && tparCount + 1 == argCount) {
                return arguments;
            }
            return null;
        }
        if (havePackExpansion) {
            return arguments;
        }
        if (tpars[tparCount - 1].isParameterPack()) {
            --tparCount;
        }
        if (tparCount == argCount) {
            return arguments;
        }
        ICPPTemplateArgument[] completeArgs = new ICPPTemplateArgument[tparCount];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(tparCount);
        InstantiationContext context = new InstantiationContext(map);
        int i2 = 0;
        while (i2 < tparCount) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter tpar = tpars[i2];
            if (tpar.isParameterPack()) {
                return null;
            }
            if (i2 < argCount) {
                arg = arguments[i2];
            } else {
                ICPPTemplateArgument defaultArg = tpar.getDefaultValue();
                if (defaultArg == null && template instanceof ICPPInternalClassTemplate) {
                    defaultArg = ((ICPPInternalClassTemplate)((Object)template)).getDefaultArgFromIndex(i2);
                }
                if (defaultArg == null) {
                    return null;
                }
                arg = CPPTemplates.instantiateArgument(defaultArg, context);
                if (!CPPTemplates.isValidArgument(arg = SemanticUtil.getSimplifiedArgument(arg))) {
                    return null;
                }
            }
            context.addToParameterMap(tpar, arg);
            completeArgs[i2] = arg;
            ++i2;
        }
        return completeArgs;
    }

    public static ICPPDeferredClassInstance createDeferredInstance(ICPPClassTemplate ct) {
        ICPPTemplateArgument[] args = ct instanceof ICPPClassTemplatePartialSpecialization ? ((ICPPClassTemplatePartialSpecialization)ct).getTemplateArguments() : CPPTemplates.templateParametersAsArguments(ct);
        return new CPPDeferredClassInstance(ct, args, (ICPPScope)ct.getCompositeScope());
    }

    public static ICPPTemplateArgument[] templateParametersAsArguments(ICPPClassTemplate template) {
        ICPPTemplateParameter[] tpars = template.getTemplateParameters();
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[tpars.length];
        int i = 0;
        while (i < tpars.length) {
            ICPPTemplateParameter tp = tpars[i];
            if (tp instanceof IType) {
                IType t = (IType)((Object)tp);
                if (tp.isParameterPack()) {
                    t = new CPPParameterPackType(t);
                }
                args[i] = new CPPTemplateTypeArgument(t);
            } else if (tp instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nttp = (ICPPTemplateNonTypeParameter)tp;
                args[i] = new CPPTemplateNonTypeArgument(DependentValue.create(template, nttp), nttp.getType());
            } else assert (false);
            ++i;
        }
        return args;
    }

    public static IASTName getTemplateParameterName(ICPPASTTemplateParameter param) {
        if (param instanceof ICPPASTSimpleTypeTemplateParameter) {
            return ((ICPPASTSimpleTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return ((ICPPASTTemplatedTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTParameterDeclaration) {
            return ASTQueries.findInnermostDeclarator(((ICPPASTParameterDeclaration)param).getDeclarator()).getName();
        }
        return null;
    }

    public static ICPPTemplateDefinition getContainingTemplate(ICPPASTTemplateParameter param) {
        IASTNode parent = param.getParent();
        IBinding binding = null;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            ICPPASTTemplateDeclaration[] templates = new ICPPASTTemplateDeclaration[]{(ICPPASTTemplateDeclaration)parent};
            while (parent.getParent() instanceof ICPPASTTemplateDeclaration) {
                parent = parent.getParent();
                templates = ArrayUtil.append(ICPPASTTemplateDeclaration.class, templates, (ICPPASTTemplateDeclaration)parent);
            }
            templates = ArrayUtil.trim(ICPPASTTemplateDeclaration.class, templates);
            ICPPASTTemplateDeclaration templateDeclaration = templates[0];
            IASTDeclaration decl = templateDeclaration.getDeclaration();
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            IASTName name = null;
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                if (dtors.length == 0) {
                    IASTDeclSpecifier spec = simpleDecl.getDeclSpecifier();
                    if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                        name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                    } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                        name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                    }
                } else {
                    IASTDeclarator dtor = dtors[0];
                    dtor = ASTQueries.findInnermostDeclarator(dtor);
                    name = dtor.getName();
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                name = dtor.getName();
            } else if (decl instanceof ICPPASTAliasDeclaration) {
                name = ((ICPPASTAliasDeclaration)decl).getAlias();
            }
            if (name == null) {
                return null;
            }
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTNameSpecifier[] qualifier;
                int idx = templates.length;
                int i = 0;
                ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = qualifier = ((ICPPASTQualifiedName)name).getQualifier();
                int n = qualifier.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTNameSpecifier element = iCPPASTNameSpecifierArray[n2];
                    if (element instanceof ICPPASTTemplateId && ++i == idx) {
                        binding = ((ICPPASTTemplateId)element).resolveBinding();
                        break;
                    }
                    ++n2;
                }
                if (binding == null) {
                    binding = name.getLastName().resolveBinding();
                }
            } else {
                binding = name.resolveBinding();
            }
        } else if (parent instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedParam = (ICPPASTTemplatedTypeTemplateParameter)parent;
            binding = templatedParam.getName().resolveBinding();
        }
        return binding instanceof ICPPTemplateDefinition ? (ICPPTemplateDefinition)binding : null;
    }

    public static IBinding createBinding(ICPPASTTemplateParameter tp) {
        if (tp instanceof ICPPASTSimpleTypeTemplateParameter) {
            return new CPPTemplateTypeParameter(((ICPPASTSimpleTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        if (tp instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return new CPPTemplateTemplateParameter(((ICPPASTTemplatedTypeTemplateParameter)tp).getName(), tp.isParameterPack());
        }
        assert (tp instanceof ICPPASTParameterDeclaration);
        ICPPASTDeclarator dtor = ((ICPPASTParameterDeclaration)tp).getDeclarator();
        return new CPPTemplateNonTypeParameter(ASTQueries.findInnermostDeclarator(dtor).getName());
    }

    public static IBinding createBinding(ICPPASTTemplateId id) {
        IASTNode declaration;
        if (!CPPTemplates.isClassTemplate(id)) {
            IBinding result = CPPVisitor.createBinding(id);
            IASTName templateName = id.getTemplateName();
            if (result instanceof ICPPClassTemplate || result instanceof ICPPAliasTemplate || result instanceof ICPPVariableTemplate) {
                templateName.setBinding(result);
                id.setBinding(null);
            } else {
                if (result instanceof ICPPTemplateInstance) {
                    templateName.setBinding(((ICPPTemplateInstance)result).getTemplateDefinition());
                } else {
                    templateName.setBinding(result);
                }
                return result;
            }
        }
        IASTNode parentOfName = id.getParent();
        boolean isLastName = true;
        if (parentOfName instanceof ICPPASTQualifiedName) {
            isLastName = ((ICPPASTQualifiedName)parentOfName).getLastName() == id;
            parentOfName = parentOfName.getParent();
        }
        boolean isDeclaration = false;
        boolean isDefinition = false;
        boolean isExplicitSpecialization = false;
        if (isLastName && parentOfName != null && (declaration = parentOfName.getParent()) instanceof IASTSimpleDeclaration) {
            if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier) {
                isDeclaration = true;
            } else if (parentOfName instanceof ICPPASTCompositeTypeSpecifier) {
                isDefinition = true;
            } else if (parentOfName instanceof ICPPASTDeclarator) {
                isDeclaration = true;
            }
            if (isDeclaration || isDefinition) {
                IASTNode parentOfDeclaration = declaration.getParent();
                if (parentOfDeclaration instanceof ICPPASTExplicitTemplateInstantiation) {
                    isDeclaration = false;
                } else if (parentOfDeclaration instanceof ICPPASTTemplateSpecialization) {
                    isExplicitSpecialization = true;
                }
            }
        }
        CPPSemantics.pushLookupPoint(id);
        try {
            ICPPASTTemplateDeclaration tdecl;
            IBinding result = null;
            IASTName templateName = id.getTemplateName();
            IBinding template = templateName.resolvePreBinding();
            while (template instanceof CPPTypedefSpecialization) {
                template = ((CPPTypedefSpecialization)template).getSpecializedBinding();
            }
            if (template instanceof ICPPAliasTemplate) {
                ICPPAliasTemplate aliasTemplate = (ICPPAliasTemplate)template;
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                IBinding iBinding = CPPTemplates.instantiateAliasTemplate(aliasTemplate, args);
                return iBinding;
            }
            if (template instanceof ICPPConstructor) {
                template = template.getOwner();
            }
            if (template instanceof ICPPUnknownMemberClass) {
                IType owner = ((ICPPUnknownMemberClass)template).getOwnerType();
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                args = SemanticUtil.getSimplifiedArguments(args);
                CPPUnknownClassInstance cPPUnknownClassInstance = new CPPUnknownClassInstance(owner, id.getSimpleID(), args);
                return cPPUnknownClassInstance;
            }
            if (!(template instanceof ICPPPartiallySpecializable) || template instanceof ICPPClassTemplatePartialSpecialization) {
                ProblemBinding problemBinding = new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
                return problemBinding;
            }
            ICPPPartiallySpecializable classTemplate = (ICPPPartiallySpecializable)template;
            ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
            if (CPPTemplates.hasDependentArgument(args) && (tdecl = CPPTemplates.getTemplateDeclaration(id)) != null) {
                if (CPPTemplates.argsAreTrivial(classTemplate.getTemplateParameters(), args)) {
                    result = classTemplate;
                } else {
                    if ((args = CPPTemplates.addDefaultArguments(classTemplate, args)) == null) {
                        ProblemBinding problemBinding = new ProblemBinding((IASTNode)id, 15, templateName.toCharArray());
                        return problemBinding;
                    }
                    ICPPPartialSpecialization partialSpec = CPPTemplates.findPartialSpecialization(classTemplate, args);
                    ICPPClassTemplatePartialSpecialization indexSpec = null;
                    if ((isDeclaration || isDefinition) && partialSpec instanceof ICPPClassTemplatePartialSpecialization) {
                        indexSpec = (ICPPClassTemplatePartialSpecialization)partialSpec;
                        partialSpec = null;
                    }
                    if (partialSpec == null) {
                        if (isDeclaration || isDefinition) {
                            if (template instanceof ICPPClassTemplate) {
                                partialSpec = new CPPClassTemplatePartialSpecialization(id, args);
                                if (indexSpec != null) {
                                    SemanticUtil.recordPartialSpecialization(indexSpec, (ICPPClassTemplatePartialSpecialization)partialSpec, id);
                                } else if (template instanceof ICPPInternalClassTemplate) {
                                    ((ICPPInternalClassTemplate)template).addPartialSpecialization((ICPPClassTemplatePartialSpecialization)partialSpec);
                                }
                            } else if (template instanceof ICPPVariableTemplate) {
                                partialSpec = template instanceof ICPPFieldTemplate ? new CPPFieldTemplatePartialSpecialization(id, args) : new CPPVariableTemplatePartialSpecialization(id, args);
                                if (template instanceof CPPVariableTemplate) {
                                    ((CPPVariableTemplate)template).addPartialSpecialization(partialSpec);
                                }
                            }
                            ICPPPartialSpecialization iCPPPartialSpecialization = partialSpec;
                            return iCPPPartialSpecialization;
                        }
                        ProblemBinding problemBinding = new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
                        return problemBinding;
                    }
                    result = partialSpec;
                }
            }
            if (result == null && (result = CPPTemplates.instantiate(classTemplate, args, isDefinition, isExplicitSpecialization)) instanceof ICPPInternalBinding) {
                if (isDeclaration) {
                    ASTInternal.addDeclaration(result, id);
                } else if (isDefinition) {
                    ASTInternal.addDefinition(result, id);
                }
            }
            IBinding iBinding = CPPSemantics.postResolution(result, id);
            return iBinding;
        }
        catch (DOMException e) {
            IProblemBinding iProblemBinding = e.getProblem();
            return iProblemBinding;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    private static IBinding createAliasTemplateInstance(ICPPAliasTemplate aliasTemplate, ICPPTemplateArgument[] args, ICPPTemplateParameterMap parameterMap, IType aliasedType, IBinding owner) {
        InstantiationContext context = CPPTemplates.createInstantiationContext(parameterMap, owner);
        IType instantiatedType = CPPTemplates.instantiateType(aliasedType, context);
        return new CPPAliasTemplateInstance(aliasTemplate, instantiatedType, owner, parameterMap, args);
    }

    static boolean isClassTemplate(ICPPASTTemplateId id) {
        IASTNode parentOfName = id.getParent();
        if (parentOfName instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)parentOfName).getLastName() != id) {
                return true;
            }
            parentOfName = parentOfName.getParent();
        }
        if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier || parentOfName instanceof ICPPASTNamedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentOfName instanceof IASTDeclarator) {
            IASTDeclarator rel = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)parentOfName);
            return !(rel instanceof IASTFunctionDeclarator);
        }
        return false;
    }

    public static ICPPTemplateInstance createInstance(IBinding owner, ICPPTemplateDefinition template, ICPPTemplateParameterMap tpMap, ICPPTemplateArgument[] args) {
        ICPPTemplateParameterMap map;
        if (owner instanceof ICPPSpecialization && (map = ((ICPPSpecialization)owner).getTemplateParameterMap()) != null) {
            ((CPPTemplateParameterMap)tpMap).putAll(map);
        }
        ICPPTemplateInstance instance = null;
        if (template instanceof ICPPClassType) {
            instance = new CPPClassInstance((ICPPClassType)((Object)template), owner, tpMap, args);
        } else if (template instanceof ICPPFunction) {
            ICPPFunction func = (ICPPFunction)((Object)template);
            InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
            ICPPFunctionType type = (ICPPFunctionType)CPPTemplates.instantiateType(func.getType(), context);
            IType[] exceptionSpecs = CPPTemplates.instantiateTypes(func.getExceptionSpecification(), context);
            CPPFunctionInstance spec = owner instanceof ICPPClassType && template instanceof ICPPMethod ? (template instanceof ICPPConstructor ? new CPPConstructorInstance((ICPPConstructor)((Object)template), (ICPPClassType)owner, context.getParameterMap(), args, type, exceptionSpecs) : new CPPMethodInstance((ICPPMethod)((Object)template), (ICPPClassType)owner, context.getParameterMap(), args, type, exceptionSpecs)) : new CPPFunctionInstance((ICPPFunction)((Object)template), owner, tpMap, args, type, exceptionSpecs);
            spec.setParameters(CPPTemplates.specializeParameters(func.getParameters(), spec, context, 25));
            instance = spec;
        } else if (template instanceof ICPPVariable) {
            ICPPVariable var = (ICPPVariable)((Object)template);
            InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
            IType type = CPPTemplates.instantiateType(var.getType(), context);
            IASTNode point = CPPSemantics.getCurrentLookupPoint();
            ICPPASTDeclarator decl = ASTQueries.findAncestorWithType(point, ICPPASTDeclarator.class);
            IValue value = point instanceof IASTName && ((IASTName)point).getRoleOfName(false) == 2 && decl != null && decl.getInitializer() != null ? SemanticUtil.getValueOfInitializer(decl.getInitializer(), type) : CPPTemplates.instantiateValue(var.getInitialValue(), context, 25);
            instance = template instanceof ICPPField ? new CPPFieldInstance(template, owner, tpMap, args, type, value) : new CPPVariableInstance(template, owner, tpMap, args, type, value);
        }
        return instance;
    }

    public static ICPPParameter[] specializeParameters(ICPPParameter[] parameters, ICPPFunction functionSpec, InstantiationContext context, int maxdepth) {
        if (parameters.length == 0) {
            return parameters;
        }
        IType[] specializedParameterTypes = functionSpec.getType().getParameterTypes();
        int length = specializedParameterTypes.length;
        ICPPParameter par = null;
        ICPPParameter[] result = new ICPPParameter[length];
        int i = 0;
        while (i < length) {
            if (i < parameters.length) {
                par = parameters[i];
            }
            IValue defaultValue = par.getDefaultValue();
            IValue specializedValue = CPPTemplates.instantiateValue(defaultValue, context, maxdepth);
            result[i] = new CPPParameterSpecialization(par, functionSpec, specializedParameterTypes[i], specializedValue, context.getParameterMap());
            ++i;
        }
        return result;
    }

    public static ICPPVariable createVariableSpecialization(InstantiationContext context, ICPPVariable variable) {
        IType type = variable.getType();
        IType newType = CPPTemplates.instantiateType(type, context);
        IValue value = variable.getInitialValue();
        IValue newValue = CPPTemplates.instantiateValue(value, context, 25);
        if (type == newType && value == newValue) {
            return variable;
        }
        CPPVariableSpecialization newVariable = new CPPVariableSpecialization(variable, context.getContextSpecialization(), context.getParameterMap(), newType, newValue);
        context.putInstantiatedLocal(variable, newVariable);
        return newVariable;
    }

    public static IBinding createSpecialization(ICPPSpecialization owner, IBinding decl) {
        IBinding spec;
        block40: {
            spec = null;
            ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
            ICPPClassSpecialization classOwner = owner instanceof ICPPClassSpecialization ? (ICPPClassSpecialization)owner : null;
            int instantiationDepth = fTemplateInstantiationDepth.get();
            if (instantiationDepth > 128) {
                return CPPClassSpecialization.RecursionResolvingBinding.createFor(decl);
            }
            fTemplateInstantiationDepth.set(instantiationDepth + 1);
            try {
                try {
                    if (decl instanceof ICPPClassTemplatePartialSpecialization && classOwner != null) {
                        try {
                            ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)decl;
                            ICPPClassTemplate template = pspec.getPrimaryClassTemplate();
                            ICPPTemplateArgument[] args = pspec.getTemplateArguments();
                            template = (ICPPClassTemplate)classOwner.specializeMember(template);
                            InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                            args = CPPTemplates.instantiateArguments(args, context, false);
                            spec = new CPPClassTemplatePartialSpecializationSpecialization(pspec, tpMap, template, args);
                        }
                        catch (DOMException pspec) {}
                        break block40;
                    }
                    if (decl instanceof ICPPClassTemplate && classOwner != null) {
                        ICPPClassTemplate template = (ICPPClassTemplate)decl;
                        CPPClassTemplateSpecialization classTemplateSpec = new CPPClassTemplateSpecialization(template, classOwner, tpMap);
                        classTemplateSpec.setTemplateParameters(CPPTemplates.specializeTemplateParameters(classTemplateSpec, (ICPPScope)classTemplateSpec.getScope(), template.getTemplateParameters(), classOwner));
                        spec = classTemplateSpec;
                        break block40;
                    }
                    if (decl instanceof ICPPClassType && classOwner != null) {
                        IBinding oldOwner = decl.getOwner();
                        spec = oldOwner instanceof IType && classOwner.getSpecializedBinding().isSameType((IType)((Object)oldOwner)) ? new CPPClassSpecialization((ICPPClassType)decl, (IBinding)owner, tpMap) : new CPPClassSpecialization((ICPPClassType)decl, oldOwner, tpMap);
                        break block40;
                    }
                    if (decl instanceof ICPPField && classOwner != null) {
                        ICPPField field = (ICPPField)decl;
                        InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                        IType type = CPPTemplates.instantiateType(field.getType(), context);
                        IValue value = CPPTemplates.instantiateValue(field.getInitialValue(), context, 25);
                        if (decl instanceof ICPPFieldTemplate) {
                            CPPFieldTemplateSpecialization fieldTempSpec = new CPPFieldTemplateSpecialization(decl, classOwner, tpMap, type, value);
                            ICPPTemplateParameter[] params = CPPTemplates.specializeTemplateParameters(fieldTempSpec, (ICPPScope)fieldTempSpec.getScope(), ((ICPPFieldTemplate)decl).getTemplateParameters(), classOwner);
                            fieldTempSpec.setTemplateParameters(params);
                            spec = fieldTempSpec;
                        } else {
                            spec = new CPPFieldSpecialization(decl, classOwner, tpMap, type, value);
                        }
                        break block40;
                    }
                    if (decl instanceof ICPPFunction) {
                        ICPPFunction func = (ICPPFunction)decl;
                        InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                        ICPPFunctionType type = (ICPPFunctionType)CPPTemplates.instantiateType(func.getType(), context);
                        IType[] exceptionSpecs = CPPTemplates.instantiateTypes(func.getExceptionSpecification(), context);
                        CPPFunctionSpecialization functionSpec = null;
                        if (decl instanceof ICPPFunctionTemplate) {
                            if (decl instanceof ICPPMethod && classOwner != null) {
                                CPPMethodTemplateSpecialization methodSpec = decl instanceof ICPPConstructor ? new CPPConstructorTemplateSpecialization((ICPPConstructor)decl, classOwner, tpMap, type, exceptionSpecs) : new CPPMethodTemplateSpecialization((ICPPMethod)decl, classOwner, tpMap, type, exceptionSpecs);
                                methodSpec.setTemplateParameters(CPPTemplates.specializeTemplateParameters(methodSpec, (ICPPScope)methodSpec.getScope(), ((ICPPFunctionTemplate)decl).getTemplateParameters(), classOwner));
                                functionSpec = methodSpec;
                            } else {
                                IBinding oldOwner = decl.getOwner();
                                functionSpec = new CPPFunctionTemplateSpecialization((ICPPFunctionTemplate)decl, oldOwner, tpMap, type, exceptionSpecs);
                            }
                        } else if (decl instanceof ICPPConstructor && classOwner != null) {
                            functionSpec = new CPPConstructorSpecialization((ICPPConstructor)decl, (ICPPClassType)classOwner, tpMap, type, exceptionSpecs);
                        } else if (decl instanceof ICPPMethod && classOwner != null) {
                            functionSpec = new CPPMethodSpecialization((ICPPMethod)decl, classOwner, tpMap, type, exceptionSpecs);
                        } else if (decl instanceof ICPPFunction) {
                            if (type.isSameType(func.getType())) {
                                spec = func;
                            } else {
                                IBinding oldOwner = decl.getOwner();
                                functionSpec = new CPPFunctionSpecialization(func, oldOwner, tpMap, type, exceptionSpecs);
                            }
                        }
                        if (functionSpec != null) {
                            functionSpec.setParameters(CPPTemplates.specializeParameters(func.getParameters(), functionSpec, context, 25));
                            spec = functionSpec;
                        }
                        break block40;
                    }
                    if (decl instanceof ITypedef) {
                        InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                        IType type = CPPTemplates.instantiateType(((ITypedef)decl).getType(), context);
                        spec = new CPPTypedefSpecialization(decl, owner, tpMap, type);
                        break block40;
                    }
                    if (decl instanceof ICPPAliasTemplate) {
                        ICPPAliasTemplate aliasTemplate = (ICPPAliasTemplate)decl;
                        InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                        IType type = CPPTemplates.instantiateType(aliasTemplate.getType(), context);
                        CPPAliasTemplateSpecialization aliasSpec = new CPPAliasTemplateSpecialization(aliasTemplate, owner, tpMap, type);
                        aliasSpec.setTemplateParameters(CPPTemplates.specializeTemplateParameters(aliasSpec, (ICPPScope)aliasSpec.getScope(), aliasTemplate.getTemplateParameters(), classOwner));
                        spec = aliasSpec;
                        break block40;
                    }
                    if (decl instanceof ICPPEnumeration && classOwner != null) {
                        spec = CPPEnumerationSpecialization.createInstance((ICPPEnumeration)decl, classOwner, tpMap);
                        break block40;
                    }
                    if (decl instanceof IEnumerator && classOwner != null) {
                        IEnumerator enumerator = (IEnumerator)decl;
                        ICPPEnumeration enumeration = (ICPPEnumeration)enumerator.getOwner();
                        IBinding enumSpec = classOwner.specializeMember(enumeration);
                        if (enumSpec instanceof ICPPEnumerationSpecialization) {
                            spec = ((ICPPEnumerationSpecialization)enumSpec).specializeEnumerator(enumerator);
                        }
                        break block40;
                    }
                    if (!(decl instanceof ICPPUsingDeclaration)) break block40;
                    IBinding[] delegates = ((ICPPUsingDeclaration)decl).getDelegates();
                    ArrayList<IBinding> result = new ArrayList<IBinding>();
                    InstantiationContext context = CPPTemplates.createInstantiationContext(tpMap, owner);
                    IBinding[] iBindingArray = delegates;
                    int n = delegates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBinding delegate = iBindingArray[n2];
                        try {
                            if (delegate instanceof ICPPUnknownBinding) {
                                delegate = CPPTemplates.resolveUnknown((ICPPUnknownBinding)delegate, context);
                            }
                            if (delegate instanceof CPPFunctionSet) {
                                ICPPFunction[] iCPPFunctionArray = ((CPPFunctionSet)delegate).getBindings();
                                int n3 = iCPPFunctionArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ICPPFunction b = iCPPFunctionArray[n4];
                                    result.add(b);
                                    ++n4;
                                }
                            } else if (delegate != null) {
                                result.add(delegate);
                            }
                        }
                        catch (DOMException dOMException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    delegates = result.toArray(new IBinding[result.size()]);
                    spec = new CPPUsingDeclarationSpecialization((ICPPUsingDeclaration)decl, owner, tpMap, delegates);
                }
                catch (DOMException e) {
                    CCorePlugin.log(e);
                    fTemplateInstantiationDepth.set(instantiationDepth);
                }
            }
            finally {
                fTemplateInstantiationDepth.set(instantiationDepth);
            }
        }
        return spec;
    }

    private static InstantiationContext createInstantiationContext(ICPPTemplateParameterMap tpMap, IBinding owner) {
        return new InstantiationContext(tpMap, CPPTemplates.getSpecializationContext(owner));
    }

    public static ICPPClassSpecialization getSpecializationContext(IBinding owner) {
        ICPPClassSpecialization within = InstantiationContext.getContextClassSpecialization(owner);
        if (within == null) {
            return null;
        }
        ICPPClassType orig = within.getSpecializedBinding();
        while (true) {
            IBinding o1 = within.getOwner();
            IBinding o2 = orig.getOwner();
            if (!(o1 instanceof ICPPClassSpecialization) || !(o2 instanceof ICPPClassType)) {
                return within;
            }
            orig = (ICPPClassType)o2;
            ICPPClassSpecialization nextWithin = (ICPPClassSpecialization)o1;
            if (orig.isSameType(nextWithin)) {
                return within;
            }
            within = nextWithin;
        }
    }

    public static IValue instantiateValue(IValue value, InstantiationContext context, int maxDepth) {
        if (value == null) {
            return null;
        }
        ICPPEvaluation evaluation = value.getEvaluation();
        if (evaluation == null) {
            return value;
        }
        ICPPEvaluation instantiated = evaluation.instantiate(context, maxDepth);
        if (instantiated == evaluation) {
            return value;
        }
        return instantiated.getValue();
    }

    public static boolean containsParameterPack(IType type) {
        return CPPTemplates.determinePackSize(type, (ICPPTemplateParameterMap)CPPTemplateParameterMap.EMPTY) == -1;
    }

    static int determinePackSize(IType type, ICPPTemplateParameterMap tpMap) {
        IArrayType at;
        IValue asize;
        if (type instanceof ICPPFunctionType) {
            IType[] ps;
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType rt = ft.getReturnType();
            int r = CPPTemplates.determinePackSize(rt, tpMap);
            if (r < 0) {
                return r;
            }
            IType[] iTypeArray = ps = ft.getParameterTypes();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IType pt = iTypeArray[n2];
                if ((r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(pt, tpMap))) < 0) {
                    return r;
                }
                ++n2;
            }
            return r;
        }
        if (type instanceof TypeOfDependentExpression) {
            return ((TypeOfDependentExpression)type).getEvaluation().determinePackSize(tpMap);
        }
        if (type instanceof ICPPUnknownBinding) {
            return CPPTemplates.determinePackSize((ICPPUnknownBinding)((Object)type), tpMap);
        }
        if (type instanceof ICPPParameterPackType) {
            return Integer.MAX_VALUE;
        }
        int r = Integer.MAX_VALUE;
        if (type instanceof IArrayType && (r = CPPTemplates.determinePackSize(asize = (at = (IArrayType)type).getSize(), tpMap)) < 0) {
            return r;
        }
        if (type instanceof ITypeContainer) {
            if (type instanceof ICPPAliasTemplateInstance) {
                ICPPTemplateArgument[] args;
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = args = ((ICPPAliasTemplateInstance)type).getTemplateArguments();
                int n = args.length;
                int n3 = 0;
                while (n3 < n) {
                    ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n3];
                    if ((r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap))) < 0) {
                        return r;
                    }
                    ++n3;
                }
            }
            ITypeContainer typeContainer = (ITypeContainer)type;
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(typeContainer.getType(), tpMap));
        }
        return r;
    }

    static int determinePackSize(ICPPUnknownBinding binding, ICPPTemplateParameterMap tpMap) {
        IBinding ownerBinding;
        if (binding instanceof ICPPTemplateParameter) {
            ICPPTemplateParameter tpar = (ICPPTemplateParameter)((Object)binding);
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] args = tpMap.getPackExpansion(tpar);
                if (args != null) {
                    return args.length;
                }
                return -1;
            }
            return Integer.MAX_VALUE;
        }
        int r = Integer.MAX_VALUE;
        if (binding instanceof ICPPDeferredClassInstance) {
            ICPPTemplateArgument[] args;
            ICPPDeferredClassInstance dcl = (ICPPDeferredClassInstance)binding;
            if (dcl.getClassTemplate() instanceof ICPPTemplateTemplateParameter) {
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize((ICPPUnknownBinding)((Object)dcl.getClassTemplate()), tpMap));
            }
            ICPPTemplateArgument[] iCPPTemplateArgumentArray = args = dcl.getTemplateArguments();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
                if ((r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(arg, tpMap))) < 0) {
                    return r;
                }
                ++n2;
            }
        }
        if ((ownerBinding = binding.getOwner()) instanceof IType) {
            r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize((IType)((Object)ownerBinding), tpMap));
        }
        return r;
    }

    static int determinePackSize(IValue value, ICPPTemplateParameterMap tpMap) {
        ICPPEvaluation eval = value.getEvaluation();
        if (eval == null) {
            return Integer.MAX_VALUE;
        }
        return ((CPPEvaluation)eval).determinePackSize(tpMap);
    }

    static int determinePackSize(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap) {
        if (arg.isTypeValue()) {
            return CPPTemplates.determinePackSize(arg.getTypeValue(), tpMap);
        }
        return CPPTemplates.determinePackSize(arg.getNonTypeValue(), tpMap);
    }

    static int combinePackSize(int ps1, int ps2) {
        if (ps1 < 0 || ps2 == Integer.MAX_VALUE) {
            return ps1;
        }
        if (ps2 < 0 || ps1 == Integer.MAX_VALUE) {
            return ps2;
        }
        if (ps1 != ps2) {
            return -2;
        }
        return ps1;
    }

    public static IType[] instantiateTypes(IType[] types, InstantiationContext context) {
        if (types == null) {
            return null;
        }
        IType[] result = types;
        int j = 0;
        int i = 0;
        while (i < types.length) {
            block11: {
                IType newType;
                IType origType;
                block9: {
                    block7: {
                        int packSize;
                        IType innerType;
                        block10: {
                            block8: {
                                origType = types[i];
                                if (!(origType instanceof ICPPParameterPackType)) break block7;
                                innerType = ((ICPPParameterPackType)origType).getType();
                                packSize = CPPTemplates.determinePackSize(innerType, context.getParameterMap());
                                if (packSize != -2 && packSize != Integer.MAX_VALUE) break block8;
                                newType = new ProblemBinding(CPPSemantics.getCurrentLookupPoint(), 5, types[i] instanceof IBinding ? ((IBinding)((Object)types[i])).getNameCharArray() : null);
                                break block9;
                            }
                            if (packSize != -1) break block10;
                            newType = CPPTemplates.instantiateType(origType, context);
                            break block9;
                        }
                        IType[] newResult = new IType[result.length + packSize - 1];
                        System.arraycopy(result, 0, newResult, 0, j);
                        result = newResult;
                        context.setExpandPack(true);
                        int oldPackOffset = context.getPackOffset();
                        int k = 0;
                        while (k < packSize) {
                            context.setPackOffset(k);
                            IType instantiated = CPPTemplates.instantiateType(innerType, context);
                            if (context.isPackExpanded() && instantiated != null) {
                                instantiated = new CPPParameterPackType(instantiated);
                            }
                            result[j++] = instantiated;
                            ++k;
                        }
                        context.setPackOffset(oldPackOffset);
                        context.setExpandPack(false);
                        break block11;
                    }
                    newType = CPPTemplates.instantiateType(origType, context);
                }
                if (result != types) {
                    result[j++] = newType;
                } else {
                    if (newType != origType) {
                        result = new IType[types.length];
                        System.arraycopy(types, 0, result, 0, i);
                        result[j] = newType;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, InstantiationContext context, boolean strict) throws DOMException {
        ICPPTemplateArgument[] result = args;
        int resultShift = 0;
        int i = 0;
        while (i < args.length) {
            block19: {
                ICPPTemplateArgument newArg;
                ICPPTemplateArgument origArg;
                block18: {
                    block16: {
                        int packSize;
                        ICPPTemplateArgument pattern;
                        block17: {
                            origArg = args[i];
                            if (!origArg.isPackExpansion()) break block16;
                            pattern = origArg.getExpansionPattern();
                            packSize = CPPTemplates.determinePackSize(pattern, context.getParameterMap());
                            if (packSize == -2 || packSize == Integer.MAX_VALUE) {
                                throw new DOMException(new ProblemBinding(CPPSemantics.getCurrentLookupPoint(), 15, null));
                            }
                            if (packSize != -1) break block17;
                            newArg = CPPTemplates.instantiateArgument(origArg, context);
                            if (!CPPTemplates.isValidArgument(newArg)) {
                                if (strict) {
                                    return null;
                                }
                                newArg = origArg;
                            }
                            break block18;
                        }
                        int shift = packSize - 1;
                        ICPPTemplateArgument[] newResult = new ICPPTemplateArgument[args.length + resultShift + shift];
                        System.arraycopy(result, 0, newResult, 0, i + resultShift);
                        context.setExpandPack(true);
                        int oldPackOffset = context.getPackOffset();
                        int j = 0;
                        while (j < packSize) {
                            context.setPackOffset(j);
                            newArg = CPPTemplates.instantiateArgument(pattern, context);
                            if (!CPPTemplates.isValidArgument(newArg)) {
                                if (strict) {
                                    return null;
                                }
                                result[i + resultShift] = origArg;
                                newResult = result;
                                shift = 0;
                                break;
                            }
                            if (context.isPackExpanded()) {
                                IType type = newArg.getTypeValue();
                                if (type != null) {
                                    type = new CPPParameterPackType(type);
                                    newArg = new CPPTemplateTypeArgument(type);
                                }
                                context.setPackExpanded(false);
                            }
                            newResult[i + resultShift + j] = newArg;
                            ++j;
                        }
                        context.setPackOffset(oldPackOffset);
                        context.setExpandPack(false);
                        result = newResult;
                        resultShift += shift;
                        break block19;
                    }
                    newArg = CPPTemplates.instantiateArgument(origArg, context);
                    if (!CPPTemplates.isValidArgument(newArg)) {
                        if (strict) {
                            return null;
                        }
                        newArg = origArg;
                    }
                }
                if (result != args) {
                    result[i + resultShift] = newArg;
                } else if (newArg != origArg) {
                    assert (resultShift == 0);
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    static ICPPTemplateArgument instantiateArgument(ICPPTemplateArgument arg, InstantiationContext context) {
        IType inst;
        if (arg == null) {
            return null;
        }
        if (arg.isNonTypeValue()) {
            ICPPEvaluation newEval;
            ICPPEvaluation eval = arg.getNonTypeEvaluation();
            if (eval == (newEval = eval.instantiate(context, 25))) {
                return arg;
            }
            return new CPPTemplateNonTypeArgument(newEval);
        }
        IType origType = arg.getOriginalTypeValue();
        IType type = origType instanceof ICPPAliasTemplateInstance ? origType : arg.getTypeValue();
        if (type == (inst = CPPTemplates.instantiateType(type, context))) {
            return arg;
        }
        return new CPPTemplateTypeArgument(inst);
    }

    private static CPPTemplateParameterMap instantiateArgumentMap(ICPPTemplateParameterMap orig, InstantiationContext context) {
        Integer[] positions = orig.getAllParameterPositions();
        CPPTemplateParameterMap newMap = new CPPTemplateParameterMap(positions.length);
        Integer[] integerArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            ICPPTemplateArgument arg = orig.getArgument(key);
            if (arg != null) {
                ICPPTemplateArgument newArg = CPPTemplates.instantiateArgument(arg, context);
                if (!CPPTemplates.isValidArgument(newArg)) {
                    newArg = arg;
                }
                newMap.put((int)key, newArg);
            } else {
                ICPPTemplateArgument[] args = orig.getPackExpansion(key);
                if (args != null) {
                    try {
                        newMap.put((int)key, CPPTemplates.instantiateArguments(args, context, false));
                    }
                    catch (DOMException e) {
                        newMap.put((int)key, args);
                    }
                }
            }
            ++n2;
        }
        return newMap;
    }

    public static IType instantiateType(IType type, InstantiationContext context) {
        if (context.getParameterMap() == null) {
            return type;
        }
        TypeInstantiationRequest instantiationRequest = new TypeInstantiationRequest(type, context);
        if (!instantiationsInProgress.get().add(instantiationRequest)) {
            return type instanceof ICPPFunctionType ? ProblemFunctionType.RECURSION_IN_LOOKUP : ProblemType.RECURSION_IN_LOOKUP;
        }
        try {
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                IType[] ps = ft.getParameterTypes();
                IType[] params = CPPTemplates.instantiateTypes(ps, context);
                IType r = ft.getReturnType();
                IType ret = CPPTemplates.instantiateType(r, context);
                if (ret == r && params == ps) {
                    IType iType = type;
                    return iType;
                }
                int i = 0;
                while (i < params.length) {
                    IType p = params[i];
                    if (!CPPTemplates.isDependentType(p)) {
                        params[i] = CPPVisitor.adjustParameterType(p, true);
                    }
                    ++i;
                }
                CPPFunctionType cPPFunctionType = new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile(), ft.hasRefQualifier(), ft.isRValueReference(), ft.takesVarArgs());
                return cPPFunctionType;
            }
            if (type instanceof ICPPTemplateParameter) {
                IType iType = CPPTemplates.resolveTemplateTypeParameter((ICPPTemplateParameter)((Object)type), context);
                return iType;
            }
            if (type instanceof ICPPUnknownBinding) {
                if (type instanceof TypeOfDependentExpression) {
                    TypeOfDependentExpression dependentType = (TypeOfDependentExpression)type;
                    ICPPEvaluation eval = dependentType.getEvaluation();
                    ICPPEvaluation instantiated = eval.instantiate(context, 25);
                    if (instantiated != eval) {
                        if (dependentType.isForDecltype()) {
                            IType iType = CPPSemantics.getDeclTypeForEvaluation(instantiated);
                            return iType;
                        }
                        IType iType = instantiated.getType();
                        return iType;
                    }
                } else {
                    IBinding binding;
                    if (type instanceof TypeOfUnknownMember) {
                        binding = CPPTemplates.resolveUnknown(((TypeOfUnknownMember)type).getUnknownMember(), context);
                        if (binding instanceof IType) {
                            IType iType = (IType)((Object)binding);
                            return iType;
                        }
                        if (binding instanceof IVariable) {
                            IType iType = ((IVariable)binding).getType();
                            return iType;
                        }
                        if (binding instanceof IFunction) {
                            IFunctionType iFunctionType = ((IFunction)binding).getType();
                            return iFunctionType;
                        }
                        IType iType = type;
                        return iType;
                    }
                    binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)type), context);
                    if (binding instanceof IType) {
                        IType iType = (IType)((Object)binding);
                        return iType;
                    }
                    IType iType = type;
                    return iType;
                }
            }
            if (context.getContextTypeSpecialization() != null && type instanceof IBinding) {
                IType unwound = SemanticUtil.getNestedType(type, 1);
                ICPPClassSpecialization withinClass = context.getContextClassSpecialization();
                if (unwound instanceof ICPPClassType && unwound.isSameType(withinClass.getSpecializedBinding()) && (withinClass instanceof ICPPClassTemplate || !(unwound instanceof ICPPClassTemplate))) {
                    ICPPClassSpecialization iCPPClassSpecialization = withinClass;
                    return iCPPClassSpecialization;
                }
                IBinding typeAsBinding = (IBinding)((Object)type);
                IBinding owner = typeAsBinding.getOwner();
                if (owner instanceof IType) {
                    IType ownerAsType = SemanticUtil.getNestedType((IType)((Object)owner), 1);
                    Object newOwner = owner;
                    newOwner = ownerAsType instanceof ICPPClassType && ownerAsType.isSameType(withinClass.getSpecializedBinding()) ? withinClass : CPPTemplates.instantiateType(ownerAsType, context);
                    if (newOwner != owner && newOwner instanceof ICPPClassSpecialization) {
                        IType iType = (IType)((Object)((ICPPClassSpecialization)newOwner).specializeMember(typeAsBinding));
                        return iType;
                    }
                }
            }
            if (type instanceof ICPPAliasTemplateInstance) {
                IType result = CPPTemplates.getCachedInstantiation(instantiationRequest);
                if (result != null) {
                    IType iType = result;
                    return iType;
                }
                ICPPAliasTemplateInstance instance = (ICPPAliasTemplateInstance)type;
                ICPPAliasTemplate template = instance.getTemplateDefinition();
                ICPPTemplateArgument[] args = instance.getTemplateArguments();
                ICPPTemplateArgument[] newArgs = CPPTemplates.instantiateArguments(args, context, true);
                if (newArgs == null) {
                    result = (IType)((Object)CPPTemplates.createProblem(template, 15));
                } else if (args != newArgs) {
                    IType target = CPPTemplates.instantiateType(instance.getType(), context);
                    CPPTemplateParameterMap map = CPPTemplates.createParameterMap(template, newArgs);
                    result = map == null ? (IType)((Object)CPPTemplates.createProblem(template, 15)) : new CPPAliasTemplateInstance(template, target, instance.getOwner(), map, newArgs);
                } else {
                    result = type;
                }
                CPPTemplates.putCachedInstantiation(instantiationRequest, result);
                IType iType = result;
                return iType;
            }
            if (type instanceof ITypeContainer) {
                IValue newSize;
                IArrayType at;
                IValue asize;
                ITypeContainer typeContainer = (ITypeContainer)type;
                IType nestedType = typeContainer.getType();
                IType newNestedType = CPPTemplates.instantiateType(nestedType, context);
                if (typeContainer instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)((Object)typeContainer);
                    IType memberOfClass = ptm.getMemberOfClass();
                    IType newMemberOfClass = CPPTemplates.instantiateType(memberOfClass, context);
                    IType classType = SemanticUtil.getNestedType(newMemberOfClass, 9);
                    if (!(classType instanceof ICPPClassType || classType instanceof UniqueType || classType instanceof ICPPUnknownBinding)) {
                        ProblemType problemType = new ProblemType(5);
                        return problemType;
                    }
                    if (newNestedType != nestedType || newMemberOfClass != memberOfClass) {
                        CPPPointerToMemberType cPPPointerToMemberType = new CPPPointerToMemberType(newNestedType, newMemberOfClass, ptm.isConst(), ptm.isVolatile(), ptm.isRestrict());
                        return cPPPointerToMemberType;
                    }
                    ITypeContainer iTypeContainer = typeContainer;
                    return iTypeContainer;
                }
                if (typeContainer instanceof IArrayType && (asize = (at = (IArrayType)((Object)typeContainer)).getSize()) != null && (newSize = CPPTemplates.instantiateValue(asize, context, 25)) != asize) {
                    CPPArrayType cPPArrayType = new CPPArrayType(newNestedType, newSize);
                    return cPPArrayType;
                }
                if (newNestedType != nestedType) {
                    IType iType = SemanticUtil.replaceNestedType(typeContainer, newNestedType);
                    return iType;
                }
                ITypeContainer iTypeContainer = typeContainer;
                return iTypeContainer;
            }
            if (type instanceof ICPPUnaryTypeTransformation) {
                ICPPUnaryTypeTransformation typeTransformation = (ICPPUnaryTypeTransformation)type;
                IType operand = CPPTemplates.instantiateType(typeTransformation.getOperand(), context);
                switch (typeTransformation.getOperator()) {
                    case underlying_type: {
                        IType iType = TypeTraits.underlyingType(operand);
                        return iType;
                    }
                }
                return null;
            }
            if (type instanceof CPPClosureType) {
                CPPClosureType cPPClosureType = ((CPPClosureType)type).instantiate(context);
                return cPPClosureType;
            }
            IType iType = type;
            return iType;
        }
        catch (DOMException e) {
            IProblemBinding iProblemBinding = e.getProblem();
            return iProblemBinding;
        }
        finally {
            instantiationsInProgress.get().remove(instantiationRequest);
        }
    }

    public static ICPPTemplateParameter specializeTemplateParameter(ICPPSpecialization owner, ICPPScope scope, ICPPTemplateParameter specialized, ICPPClassSpecialization within) {
        if (specialized == null) {
            return null;
        }
        ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
        InstantiationContext context = new InstantiationContext(tpMap, 0, within);
        ICPPTemplateArgument defaultValue = CPPTemplates.instantiateArgument(specialized.getDefaultValue(), context);
        if (specialized instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateNonTypeParameter spec = (ICPPTemplateNonTypeParameter)specialized;
            IType type = CPPTemplates.instantiateType(spec.getType(), context);
            return new CPPTemplateNonTypeParameterSpecialization(owner, scope, spec, defaultValue, type);
        }
        if (specialized instanceof ICPPTemplateTypeParameter) {
            return new CPPTemplateTypeParameterSpecialization(owner, scope, (ICPPTemplateTypeParameter)specialized, defaultValue);
        }
        if (specialized instanceof ICPPTemplateTemplateParameter) {
            return new CPPTemplateTemplateParameterSpecialization(owner, scope, (ICPPTemplateTemplateParameter)specialized, defaultValue);
        }
        return null;
    }

    public static ICPPTemplateParameter[] specializeTemplateParameters(ICPPSpecialization owner, ICPPScope scope, ICPPTemplateParameter[] specialized, ICPPClassSpecialization within) {
        ICPPTemplateParameter[] result = new ICPPTemplateParameter[specialized.length];
        int i = 0;
        while (i < specialized.length) {
            result[i] = CPPTemplates.specializeTemplateParameter(owner, scope, specialized[i], within);
            ++i;
        }
        return result;
    }

    public static IBinding instantiateBinding(IBinding binding, InstantiationContext context, int maxDepth) throws DOMException {
        ICPPTemplateArgument[] newArgs;
        ICPPVariableInstance origInstance;
        ICPPTemplateArgument[] origArgs;
        if (binding instanceof ICPPClassTemplate) {
            binding = CPPTemplates.createDeferredInstance((ICPPClassTemplate)binding);
        }
        if (binding instanceof ICPPUnknownBinding) {
            return CPPTemplates.resolveUnknown((ICPPUnknownBinding)binding, context);
        }
        if (binding instanceof ICPPMethod || binding instanceof ICPPField || binding instanceof ICPPEnumeration || binding instanceof ICPPClassType) {
            IBinding owner = binding.getOwner();
            if (!(owner instanceof ICPPSpecialization)) {
                owner = CPPTemplates.instantiateBinding(owner, context, maxDepth);
            }
            if (owner instanceof ICPPClassSpecialization) {
                return ((ICPPClassSpecialization)owner).specializeMember(binding);
            }
        } else if (binding instanceof IEnumerator) {
            IBinding owner = binding.getOwner();
            ICPPTypeSpecialization within = context.getContextTypeSpecialization();
            if (within instanceof ICPPEnumerationSpecialization && within.getSpecializedBinding().equals(owner)) {
                owner = within;
            } else if (!(owner instanceof ICPPSpecialization)) {
                owner = CPPTemplates.instantiateBinding(owner, context, maxDepth);
            }
            if (owner instanceof ICPPEnumerationSpecialization) {
                return ((ICPPEnumerationSpecialization)owner).specializeEnumerator((IEnumerator)binding);
            }
        } else if (binding instanceof ICPPFunctionInstance) {
            ICPPTemplateArgument[] newArgs2;
            ICPPFunctionInstance origInstance2 = (ICPPFunctionInstance)binding;
            ICPPTemplateArgument[] origArgs2 = origInstance2.getTemplateArguments();
            if (origArgs2 != (newArgs2 = CPPTemplates.instantiateArguments(origArgs2, context, false))) {
                CPPTemplateParameterMap newMap = CPPTemplates.instantiateArgumentMap(origInstance2.getTemplateParameterMap(), context);
                IType newType = CPPTemplates.instantiateType(origInstance2.getType(), context);
                IType[] newExceptionSpecs = CPPTemplates.instantiateTypes(origInstance2.getExceptionSpecification(), context);
                CPPFunctionInstance result = new CPPFunctionInstance((ICPPFunction)((Object)origInstance2.getTemplateDefinition()), origInstance2.getOwner(), newMap, newArgs2, (ICPPFunctionType)newType, newExceptionSpecs);
                result.setParameters(CPPTemplates.specializeParameters(origInstance2.getParameters(), result, context, maxDepth));
                return result;
            }
        } else if (binding instanceof ICPPVariableInstance && (origArgs = (origInstance = (ICPPVariableInstance)binding).getTemplateArguments()) != (newArgs = CPPTemplates.instantiateArguments(origArgs, context, false))) {
            CPPTemplateParameterMap newMap = CPPTemplates.instantiateArgumentMap(origInstance.getTemplateParameterMap(), context);
            IType newType = CPPTemplates.instantiateType(origInstance.getType(), context);
            IValue newValue = CPPTemplates.instantiateValue(origInstance.getInitialValue(), context, 25);
            return new CPPVariableInstance(origInstance.getTemplateDefinition(), origInstance.getOwner(), newMap, newArgs, newType, newValue);
        }
        return binding;
    }

    public static IType resolveTemplateTypeParameter(ICPPTemplateParameter tpar, InstantiationContext context) {
        IType t;
        ICPPTemplateArgument arg = null;
        if (tpar.isParameterPack()) {
            if (context.hasPackOffset()) {
                IType type;
                ICPPTemplateArgument[] args = context.getPackExpansion(tpar);
                if (args != null) {
                    if (context.getPackOffset() >= args.length) {
                        return new ProblemBinding(CPPSemantics.getCurrentLookupPoint(), 5, tpar.getNameCharArray());
                    }
                    arg = args[context.getPackOffset()];
                }
                if (context.shouldExpandPack() && arg != null && (type = arg.getTypeValue()) instanceof ICPPParameterPackType) {
                    arg = new CPPTemplateTypeArgument(((ICPPParameterPackType)type).getType());
                    context.setPackExpanded(true);
                }
            }
        } else {
            arg = context.getArgument(tpar);
        }
        if (arg != null && (t = arg.getOriginalTypeValue()) != null) {
            return t;
        }
        return (IType)((Object)tpar);
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTName name) {
        if (name == null) {
            return null;
        }
        ICPPASTInternalTemplateDeclaration tdecl = CPPTemplates.getInnerTemplateDeclaration(name);
        if (tdecl == null) {
            return null;
        }
        IASTNode parent = (name = name.getLastName()).getParent();
        if (!(parent instanceof ICPPASTQualifiedName)) {
            if (parent instanceof ICPPASTTemplateId) {
                return null;
            }
            return tdecl;
        }
        ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
        IASTName lastName = qname.getLastName();
        boolean lastIsTemplate = tdecl.isAssociatedWithLastName();
        if (name == lastName) {
            if (lastIsTemplate) {
                return tdecl;
            }
            return null;
        }
        if (!(name instanceof ICPPASTTemplateId)) {
            return null;
        }
        if (lastIsTemplate) {
            tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
        }
        ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
        int i = qualifier.length - 1;
        while (tdecl != null && i >= 0) {
            ICPPASTNameSpecifier n = qualifier[i];
            if (n == name) {
                return tdecl;
            }
            if (n instanceof ICPPASTTemplateId) {
                tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
            }
            --i;
        }
        return null;
    }

    public static void associateTemplateDeclarations(ICPPASTInternalTemplateDeclaration tdecl) {
        int nestingLevel;
        IASTDeclaration decl = tdecl.getDeclaration();
        while (decl instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = (ICPPASTInternalTemplateDeclaration)decl;
            decl = tdecl.getDeclaration();
        }
        ICPPASTInternalTemplateDeclaration innerMostTDecl = tdecl;
        IASTName declName = CPPTemplates.getNameForDeclarationInTemplateDeclaration(decl);
        int instDeclCount = 0;
        int tdeclCount = 0;
        IASTNode node = tdecl;
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = node;
            node = node.getParent();
            instDeclCount = tdecl.getTemplateParameters().length == 0 ? ++instDeclCount : 0;
            ++tdeclCount;
        }
        ICPPASTInternalTemplateDeclaration outerMostTDecl = tdecl;
        int paramTDeclCount = tdeclCount - instDeclCount;
        boolean lastIsTemplate = true;
        if (declName instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)declName;
            CharArraySet tparnames = CPPTemplates.collectTemplateParameterNames(outerMostTDecl);
            int depIDCount = 0;
            IBinding owner = null;
            ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
            int i = 0;
            while (i < qualifier.length) {
                ICPPASTNameSpecifier n = qualifier[i];
                if (n instanceof ICPPASTTemplateId && (depIDCount > 0 || CPPTemplates.usesTemplateParameter((ICPPASTTemplateId)n, tparnames))) {
                    ++depIDCount;
                }
                if (depIDCount == 0) {
                    owner = n.resolveBinding();
                }
                ++i;
            }
            if (qname.getLastName() instanceof ICPPASTTemplateId || paramTDeclCount > depIDCount || qualifier.length < 1) {
                lastIsTemplate = true;
                ++depIDCount;
            } else {
                lastIsTemplate = false;
            }
            nestingLevel = 0;
            if (owner != null) {
                IType t;
                int consumesTDecl = 0;
                IBinding b = owner;
                if (b instanceof IType && (t = SemanticUtil.getNestedType((IType)((Object)b), 1)) instanceof IBinding) {
                    b = (IBinding)((Object)t);
                }
                while (b != null) {
                    if (b instanceof ICPPTemplateInstance) {
                        ++nestingLevel;
                        if (!((ICPPTemplateInstance)b).isExplicitSpecialization()) {
                            ++consumesTDecl;
                        }
                    } else if (b instanceof ICPPClassTemplate || b instanceof ICPPClassTemplatePartialSpecialization) {
                        ++nestingLevel;
                        ++consumesTDecl;
                    }
                    b = b.getOwner();
                }
                if (depIDCount > 0) {
                    nestingLevel += depIDCount;
                } else if (consumesTDecl < tdeclCount && !lastIsTemplate) {
                    ++nestingLevel;
                    lastIsTemplate = true;
                }
            } else {
                nestingLevel += depIDCount;
                node = outerMostTDecl.getParent();
                while (node != null) {
                    if (node instanceof ICPPASTInternalTemplateDeclaration) {
                        nestingLevel += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                        break;
                    }
                    node = node.getParent();
                }
            }
        } else {
            nestingLevel = 1;
            lastIsTemplate = true;
            if (!CPPTemplates.isFriendFunctionDeclaration(innerMostTDecl.getDeclaration())) {
                node = outerMostTDecl.getParent();
                while (node != null) {
                    if (node instanceof ICPPASTInternalTemplateDeclaration) {
                        nestingLevel += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                        break;
                    }
                    node = node.getParent();
                }
            }
        }
        node = innerMostTDecl;
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            if (--nestingLevel < 0) {
                nestingLevel = 0;
            }
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
            tdecl.setNestingLevel((short)nestingLevel);
            tdecl.setAssociatedWithLastName(false);
            node = tdecl.getParent();
        }
        innerMostTDecl.setAssociatedWithLastName(lastIsTemplate);
    }

    private static boolean isFriendFunctionDeclaration(IASTDeclaration declaration) {
        IASTDeclarator[] dtors;
        IASTSimpleDeclaration sdecl;
        ICPPASTDeclSpecifier declspec;
        while (declaration instanceof ICPPASTTemplateDeclaration) {
            declaration = ((ICPPASTTemplateDeclaration)declaration).getDeclaration();
        }
        return declaration instanceof IASTSimpleDeclaration && (declspec = (ICPPASTDeclSpecifier)(sdecl = (IASTSimpleDeclaration)declaration).getDeclSpecifier()).isFriend() && (dtors = sdecl.getDeclarators()).length == 1 && ASTQueries.findTypeRelevantDeclarator(dtors[0]) instanceof IASTFunctionDeclarator;
    }

    private static CharArraySet collectTemplateParameterNames(ICPPASTTemplateDeclaration tdecl) {
        CharArraySet set = new CharArraySet(4);
        while (true) {
            ICPPASTTemplateParameter[] pars;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = pars = tdecl.getTemplateParameters();
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter par = iCPPASTTemplateParameterArray[n2];
                IASTName name = CPPTemplates.getTemplateParameterName(par);
                if (name != null) {
                    set.put(name.getLookupKey());
                }
                ++n2;
            }
            IASTDeclaration next = tdecl.getDeclaration();
            if (!(next instanceof ICPPASTTemplateDeclaration)) break;
            tdecl = (ICPPASTTemplateDeclaration)next;
        }
        return set;
    }

    private static boolean usesTemplateParameter(ICPPASTTemplateId id, final CharArraySet names) {
        final boolean[] result = new boolean[1];
        ASTVisitor v = new ASTVisitor(false){
            {
                super($anonymous0);
                this.shouldVisitNames = true;
                this.shouldVisitAmbiguousNodes = true;
            }

            @Override
            public int visit(IASTName name) {
                if (name instanceof ICPPASTTemplateId) {
                    return 3;
                }
                if (name instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
                    if (qname.isFullyQualified()) {
                        return 1;
                    }
                    return 3;
                }
                if (names.containsKey(name.getLookupKey())) {
                    IASTNode parent = name.getParent();
                    if (parent instanceof ICPPASTQualifiedName) {
                        ICPPASTNameSpecifier[] qualifier = ((ICPPASTQualifiedName)parent).getQualifier();
                        if (qualifier.length > 0 && qualifier[0] != name) {
                            return 3;
                        }
                        result[0] = true;
                        return 2;
                    }
                    if (parent instanceof IASTIdExpression || parent instanceof ICPPASTNamedTypeSpecifier) {
                        result[0] = true;
                        return 2;
                    }
                }
                return 3;
            }

            @Override
            public int visit(ASTAmbiguousNode node) {
                IASTNode[] alternatives;
                IASTNode[] iASTNodeArray = alternatives = node.getNodes();
                int n = alternatives.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode alt = iASTNodeArray[n2];
                    if (!alt.accept(this)) {
                        return 2;
                    }
                    ++n2;
                }
                return 3;
            }
        };
        id.accept(v);
        return result[0];
    }

    private static IASTName getNameForDeclarationInTemplateDeclaration(IASTDeclaration decl) {
        IASTName name = null;
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            IASTDeclarator[] dtors = sdecl.getDeclarators();
            if (dtors != null && dtors.length > 0) {
                name = ASTQueries.findInnermostDeclarator(dtors[0]).getName();
            } else {
                IASTDeclSpecifier declspec = sdecl.getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    name = ((IASTCompositeTypeSpecifier)declspec).getName();
                } else if (declspec instanceof IASTElaboratedTypeSpecifier) {
                    name = ((IASTElaboratedTypeSpecifier)declspec).getName();
                }
            }
        } else if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            name = ASTQueries.findInnermostDeclarator(fdef.getDeclarator()).getName();
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private static ICPPASTInternalTemplateDeclaration getInnerTemplateDeclaration(IASTName name) {
        block5: {
            parent = name.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTDeclSpecifier)) ** GOTO lbl11
            if (!(parent instanceof IASTCompositeTypeSpecifier) && !(parent instanceof IASTElaboratedTypeSpecifier)) {
                return null;
            }
            parent = parent.getParent();
            break block5;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl11:
                // 2 sources

                ** while (parent instanceof IASTDeclarator)
            }
        }
        if (!(parent instanceof IASTDeclaration)) {
            return null;
        }
        if ((parent = parent.getParent()) instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    private static ICPPASTInternalTemplateDeclaration getDirectlyEnclosingTemplateDeclaration(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTNode parent = tdecl.getParent();
        if (parent instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    public static IASTName getTemplateName(ICPPASTTemplateDeclaration templateDecl) {
        if (templateDecl == null) {
            return null;
        }
        ICPPASTTemplateDeclaration decl = templateDecl;
        while (decl.getParent() instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)decl.getParent();
        }
        IASTDeclaration nestedDecl = templateDecl.getDeclaration();
        while (nestedDecl instanceof ICPPASTTemplateDeclaration) {
            nestedDecl = ((ICPPASTTemplateDeclaration)nestedDecl).getDeclaration();
        }
        IASTName name = null;
        if (nestedDecl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)nestedDecl;
            if (simple.getDeclarators().length == 1) {
                IASTDeclarator dtor = simple.getDeclarators()[0];
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                name = dtor.getName();
            } else if (simple.getDeclarators().length == 0) {
                IASTDeclSpecifier spec = simple.getDeclSpecifier();
                if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                    name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                    name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                }
            }
        } else if (nestedDecl instanceof IASTFunctionDefinition) {
            IASTDeclarator declarator = ((IASTFunctionDefinition)nestedDecl).getDeclarator();
            declarator = ASTQueries.findInnermostDeclarator(declarator);
            name = declarator.getName();
        } else if (nestedDecl instanceof ICPPASTAliasDeclaration) {
            name = ((ICPPASTAliasDeclaration)nestedDecl).getAlias();
        }
        if (name != null) {
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTNameSpecifier[] qualifier = ((ICPPASTQualifiedName)name).getQualifier();
                IASTDeclaration currDecl = decl;
                ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = qualifier;
                int n = qualifier.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTNameSpecifier segment = iCPPASTNameSpecifierArray[n2];
                    if (segment instanceof ICPPASTTemplateId) {
                        if (currDecl == templateDecl) {
                            return (IASTName)((Object)segment);
                        }
                        if (!(currDecl instanceof ICPPASTTemplateDeclaration)) {
                            return null;
                        }
                        currDecl = currDecl.getDeclaration();
                    }
                    ++n2;
                }
                if (currDecl == templateDecl) {
                    return name.getLastName();
                }
            } else {
                return name;
            }
        }
        return null;
    }

    public static boolean areSameArguments(ICPPTemplateArgument[] args, ICPPTemplateArgument[] specArgs) {
        if (args.length != specArgs.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (!specArgs[i].isSameValue(args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ICPPTemplateArgument[] createTemplateArgumentArray(ICPPASTTemplateId id) throws DOMException {
        ICPPTemplateArgument[] result = ICPPTemplateArgument.EMPTY_ARGUMENTS;
        if (id != null) {
            IASTNode[] args = id.getTemplateArguments();
            result = new ICPPTemplateArgument[args.length];
            int i = 0;
            while (i < args.length) {
                IASTNode arg = args[i];
                if (arg instanceof IASTTypeId) {
                    result[i] = new CPPTemplateTypeArgument(CPPVisitor.createType((IASTTypeId)arg));
                } else if (arg instanceof ICPPASTExpression) {
                    ICPPASTExpression expr = (ICPPASTExpression)arg;
                    CPPSemantics.pushLookupPoint(expr);
                    try {
                        result[i] = new CPPTemplateNonTypeArgument(expr.getEvaluation());
                    }
                    finally {
                        CPPSemantics.popLookupPoint();
                    }
                } else {
                    if (arg instanceof ICPPASTAmbiguousTemplateArgument) {
                        ProblemBinding problem = new ProblemBinding(id, 15);
                        throw new DOMException(problem);
                    }
                    throw new IllegalArgumentException("Unexpected type: " + arg.getClass().getName());
                }
                ++i;
            }
        }
        return result;
    }

    static ICPPFunction[] instantiateForFunctionCall(ICPPFunction[] fns, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg) {
        boolean requireTemplate = tmplArgs != null;
        boolean haveTemplate = false;
        ICPPFunction[] iCPPFunctionArray = fns;
        int n = fns.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction func = iCPPFunctionArray[n2];
            if (func instanceof ICPPConstructor || func instanceof ICPPMethod && ((ICPPMethod)func).isDestructor()) {
                requireTemplate = false;
            }
            if (func instanceof ICPPFunctionTemplate) {
                if (CPPTemplates.containsDependentType(fnArgs)) {
                    return new ICPPFunction[]{CPPDeferredFunction.createForCandidates(fns)};
                }
                if (requireTemplate && CPPTemplates.hasDependentArgument(tmplArgs)) {
                    return new ICPPFunction[]{CPPDeferredFunction.createForCandidates(fns)};
                }
                haveTemplate = true;
                break;
            }
            ++n2;
        }
        if (!haveTemplate && !requireTemplate) {
            return fns;
        }
        ArrayList<ICPPFunction> result = new ArrayList<ICPPFunction>(fns.length);
        ICPPFunction[] iCPPFunctionArray2 = fns;
        int n3 = fns.length;
        n = 0;
        while (n < n3) {
            ICPPFunction fn = iCPPFunctionArray2[n];
            if (fn != null) {
                if (fn instanceof ICPPFunctionTemplate) {
                    ICPPFunctionTemplate fnTmpl = (ICPPFunctionTemplate)fn;
                    ICPPFunction inst = CPPTemplates.instantiateForFunctionCall(fnTmpl, tmplArgs, fnArgs, argCats, withImpliedObjectArg);
                    if (inst != null) {
                        result.add(inst);
                    }
                } else if (!requireTemplate || fn instanceof ICPPUnknownBinding) {
                    result.add(fn);
                }
            }
            ++n;
        }
        return result.toArray(new ICPPFunction[result.size()]);
    }

    private static ICPPFunction instantiateForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, boolean withImpliedObjectArg) {
        if (withImpliedObjectArg && template instanceof ICPPMethod) {
            fnArgs = fnArgs.subList(1, fnArgs.size());
            argCats = argCats.subList(1, argCats.size());
        }
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(fnArgs.size());
        try {
            ICPPFunction f;
            IBinding instance;
            ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForFunctionCall(template, tmplArgs, fnArgs, argCats, map);
            if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction && CPPTemplates.isValidFunctionType((f = (ICPPFunction)instance).getType()) && fnArgs.size() >= f.getRequiredArgumentCount()) {
                return f;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isValidFunctionType(IFunctionType type) {
        if (!SemanticUtil.isValidType(type)) {
            return false;
        }
        IType t = type.getReturnType();
        if ((t = SemanticUtil.getNestedType(t, 21)) instanceof IPointerType) {
            t = ((IPointerType)t).getType();
        }
        return !(t instanceof FunctionSetType);
    }

    static ICPPFunction[] instantiateConversionTemplates(ICPPFunction[] functions, IType conversionType) {
        boolean checkedForDependentType = false;
        ICPPFunction[] result = functions;
        int i = 0;
        boolean done = false;
        ICPPFunction[] iCPPFunctionArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction f;
            ICPPFunction inst = f = iCPPFunctionArray[n2];
            if (f instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)f;
                inst = null;
                if (!checkedForDependentType) {
                    if (CPPTemplates.isDependentType(conversionType)) {
                        inst = CPPDeferredFunction.createForCandidates(functions);
                        done = true;
                    }
                    checkedForDependentType = true;
                }
                CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
                try {
                    IBinding instance;
                    ICPPTemplateArgument[] args = TemplateArgumentDeduction.deduceForConversion(template, conversionType, map);
                    if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction) {
                        inst = (ICPPFunction)instance;
                    }
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
            if (result != functions || f != inst) {
                if (result == functions) {
                    result = new ICPPFunction[functions.length];
                    System.arraycopy(functions, 0, result, 0, i);
                }
                result[i++] = inst;
            }
            if (done) break;
            ++n2;
        }
        return result;
    }

    static ICPPFunction instantiateForFunctionDeclaration(ICPPFunctionTemplate template, ICPPTemplateArgument[] args, ICPPFunctionType functionType) {
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
        try {
            IBinding instance;
            args = TemplateArgumentDeduction.deduceForDeclaration(template, args, functionType, map);
            if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction) {
                return (ICPPFunction)instance;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    static ICPPFunction instantiateForAddressOfFunction(ICPPFunctionTemplate template, IFunctionType target, ICPPTemplateArgument[] args) {
        try {
            IBinding instance;
            CPPTemplateParameterMap map;
            if (target != null && CPPTemplates.isDependentType(target)) {
                return CPPDeferredFunction.createForCandidates(template);
            }
            if (template instanceof ICPPConstructor || args == null) {
                args = ICPPTemplateArgument.EMPTY_ARGUMENTS;
            }
            if ((args = TemplateArgumentDeduction.deduceForAddressOf(template, args, target, map = new CPPTemplateParameterMap(4))) != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args, map)) instanceof ICPPFunction) {
                return (ICPPFunction)instance;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    static int disambiguateTrailingParameterPack(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, int nExplicitArgs) {
        ICPPTemplateParameter[] f1params = f1.getTemplateParameters();
        ICPPTemplateParameter[] f2params = f2.getTemplateParameters();
        boolean f1hasTrailingPack = f1params[f1params.length - 1].isParameterPack();
        boolean f2hasTrailingPack = f2params[f2params.length - 1].isParameterPack();
        if (f1hasTrailingPack && f1params.length > nExplicitArgs && !f2hasTrailingPack) {
            return -1;
        }
        if (f2hasTrailingPack && f2params.length > nExplicitArgs && !f1hasTrailingPack) {
            return 1;
        }
        return 0;
    }

    static int orderFunctionTemplates(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode, int nExplicitArgs) throws DOMException {
        int s2;
        if (f1 == f2) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        int s1 = CPPTemplates.compareSpecialization(f1, f2, mode, nExplicitArgs);
        if (s1 == (s2 = CPPTemplates.compareSpecialization(f2, f1, mode, nExplicitArgs))) {
            return CPPTemplates.disambiguateTrailingParameterPack(f1, f2, nExplicitArgs);
        }
        if (s1 < 0 || s2 > 0) {
            return -1;
        }
        assert (s2 < 0 || s1 > 0);
        return 1;
    }

    static int orderFunctionTemplates(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode) throws DOMException {
        return CPPTemplates.orderFunctionTemplates(f1, f2, mode, Integer.MAX_VALUE);
    }

    private static ICPPFunction transferFunctionTemplate(ICPPFunctionTemplate f) throws DOMException {
        ICPPTemplateParameter[] tpars = f.getTemplateParameters();
        int argLen = tpars.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argLen];
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(argLen);
        int i = 0;
        while (i < argLen) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter tpar = tpars[i];
            args[i] = arg = CPPTemplates.uniqueArg(tpar);
            if (tpar.isParameterPack()) {
                map.put(tpar, new ICPPTemplateArgument[]{arg});
            } else {
                map.put(tpar, arg);
            }
            ++i;
        }
        IBinding result = CPPTemplates.instantiateFunctionTemplate(f, args, map);
        if (result instanceof ICPPFunction) {
            return (ICPPFunction)result;
        }
        return null;
    }

    private static ICPPTemplateArgument uniqueArg(ICPPTemplateParameter tpar) throws DOMException {
        ICPPTemplateArgument arg = tpar instanceof ICPPTemplateNonTypeParameter ? new CPPTemplateNonTypeArgument(IntegralValue.unique(), ((ICPPTemplateNonTypeParameter)tpar).getType()) : new CPPTemplateTypeArgument(new UniqueType(tpar.isParameterPack()));
        return arg;
    }

    private static ICPPFunctionType getFunctionTypeIgnoringParametersWithoutExplicitArguments(ICPPFunction function, int nExplicitArgs) {
        ICPPFunctionType originalType = function.getType();
        if (nExplicitArgs < function.getParameters().length) {
            IType[] parameterTypesWithExplicitArguments = Arrays.copyOf(originalType.getParameterTypes(), nExplicitArgs);
            return new CPPFunctionType(originalType.getReturnType(), parameterTypesWithExplicitArguments, originalType.isConst(), originalType.isVolatile(), originalType.hasRefQualifier(), originalType.isRValueReference(), originalType.takesVarArgs());
        }
        return originalType;
    }

    private static int compareSpecialization(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2, TypeSelection mode, int nExplicitArgs) throws DOMException {
        IType[] args;
        IType[] pars;
        ICPPFunction transF1 = CPPTemplates.transferFunctionTemplate(f1);
        if (transF1 == null) {
            return -1;
        }
        ICPPFunctionType ft2 = f2.getType();
        ICPPFunctionType transFt1 = CPPTemplates.getFunctionTypeIgnoringParametersWithoutExplicitArguments(transF1, nExplicitArgs);
        switch (mode) {
            case RETURN_TYPE: {
                pars = new IType[]{ft2.getReturnType()};
                args = new IType[]{transFt1.getReturnType()};
                break;
            }
            case PARAMETERS_AND_RETURN_TYPE: {
                pars = SemanticUtil.concatTypes(ft2.getReturnType(), ft2.getParameterTypes());
                args = SemanticUtil.concatTypes(transFt1.getReturnType(), transFt1.getParameterTypes());
                break;
            }
            default: {
                pars = ft2.getParameterTypes();
                args = transFt1.getParameterTypes();
                boolean nonStaticMember1 = CPPTemplates.isNonStaticMember(f1);
                boolean nonStaticMember2 = CPPTemplates.isNonStaticMember(f2);
                if (nonStaticMember1 == nonStaticMember2) break;
                if (nonStaticMember1) {
                    args = SemanticUtil.addImplicitParameterType(args, (ICPPMethod)((Object)f1));
                    break;
                }
                pars = SemanticUtil.addImplicitParameterType(pars, (ICPPMethod)((Object)f2));
            }
        }
        return TemplateArgumentDeduction.deduceForPartialOrdering(f2.getTemplateParameters(), pars, args);
    }

    private static boolean isNonStaticMember(ICPPFunctionTemplate f) {
        return f instanceof ICPPMethod && !((ICPPMethod)((Object)f)).isStatic();
    }

    private static ICPPPartialSpecialization findPartialSpecialization(ICPPPartiallySpecializable template, ICPPTemplateArgument[] args) throws DOMException {
        ICPPPartialSpecialization[] pspecs = template.getPartialSpecializations();
        if (pspecs != null && pspecs.length > 0) {
            String argStr = ASTTypeUtil.getArgumentListString(args, true);
            ICPPPartialSpecialization[] iCPPPartialSpecializationArray = pspecs;
            int n = pspecs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPPartialSpecialization pspec = iCPPPartialSpecializationArray[n2];
                if (argStr.equals(ASTTypeUtil.getArgumentListString(pspec.getTemplateArguments(), true))) {
                    return pspec;
                }
                ++n2;
            }
        }
        return null;
    }

    static IBinding selectSpecialization(ICPPPartiallySpecializable template, ICPPTemplateArgument[] args, boolean isDef) throws DOMException {
        if (template == null) {
            return null;
        }
        ICPPPartialSpecialization[] specializations = template.getPartialSpecializations();
        if (specializations == null || specializations.length == 0) {
            return null;
        }
        ICPPPartialSpecialization bestMatch = null;
        CPPTemplateParameterMap bestMap = null;
        boolean bestMatchIsBest = true;
        ICPPPartialSpecialization[] iCPPPartialSpecializationArray = specializations;
        int n = specializations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPPartialSpecialization specialization = iCPPPartialSpecializationArray[n2];
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(args.length);
            ICPPTemplateArgument[] specializationArguments = specialization.getTemplateArguments();
            if (TemplateArgumentDeduction.fromTemplateArguments(specialization.getTemplateParameters(), specializationArguments, args, map) && CPPTemplates.checkInstantiationOfArguments(specializationArguments, map)) {
                int compare = CPPTemplates.orderSpecializations(bestMatch, specialization);
                if (compare == 0) {
                    bestMatchIsBest = false;
                } else if (compare < 0) {
                    bestMatch = specialization;
                    bestMap = map;
                    bestMatchIsBest = true;
                }
            }
            ++n2;
        }
        if (!bestMatchIsBest) {
            return new CPPTemplateDefinition.CPPTemplateProblem(CPPSemantics.getCurrentLookupPoint(), 4, template.getNameCharArray());
        }
        if (bestMatch == null) {
            return null;
        }
        if (bestMatch instanceof ICPPClassTemplatePartialSpecialization) {
            bestMatch = SemanticUtil.mapToAST(bestMatch);
        }
        return CPPTemplates.instantiatePartialSpecialization(bestMatch, args, isDef, bestMap);
    }

    private static boolean checkInstantiationOfArguments(ICPPTemplateArgument[] args, CPPTemplateParameterMap tpMap) throws DOMException {
        return CPPTemplates.instantiateArguments(args, new InstantiationContext(tpMap), true) != null;
    }

    private static int orderSpecializations(ICPPPartialSpecialization spec1, ICPPPartialSpecialization spec2) throws DOMException {
        boolean f2IsAtLeastAsSpecializedAsF1;
        if (spec1 == null) {
            return -1;
        }
        boolean f1IsAtLeastAsSpecializedAsF2 = CPPTemplates.isAtLeastAsSpecializedAs(spec1, spec2);
        if (f1IsAtLeastAsSpecializedAsF2 == (f2IsAtLeastAsSpecializedAsF1 = CPPTemplates.isAtLeastAsSpecializedAs(spec2, spec1))) {
            return 0;
        }
        if (f1IsAtLeastAsSpecializedAsF2) {
            return 1;
        }
        return -1;
    }

    private static boolean isAtLeastAsSpecializedAs(ICPPPartialSpecialization f1, ICPPPartialSpecialization f2) throws DOMException {
        ICPPTemplateParameter[] tpars1 = f1.getTemplateParameters();
        ICPPTemplateParameter[] tpars2 = f2.getTemplateParameters();
        ICPPTemplateArgument[] targs1 = f1.getTemplateArguments();
        ICPPTemplateArgument[] targs2 = f2.getTemplateArguments();
        int tpars1Len = tpars1.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[tpars1Len];
        CPPTemplateParameterMap transferMap = new CPPTemplateParameterMap(tpars1Len);
        int i = 0;
        while (i < tpars1Len) {
            ICPPTemplateArgument arg;
            ICPPTemplateParameter param = tpars1[i];
            args[i] = arg = CPPTemplates.uniqueArg(param);
            if (param.isParameterPack()) {
                transferMap.put(param, new ICPPTemplateArgument[]{arg});
            } else {
                transferMap.put(param, arg);
            }
            ++i;
        }
        ICPPTemplateArgument[] transferredArgs1 = CPPTemplates.instantiateArguments(targs1, new InstantiationContext(transferMap), false);
        CPPTemplateParameterMap deductionMap = new CPPTemplateParameterMap(2);
        return TemplateArgumentDeduction.fromTemplateArguments(tpars2, targs2, transferredArgs1, deductionMap);
    }

    static boolean isValidArgument(ICPPTemplateArgument arg) {
        return arg != null && SemanticUtil.isValidType(arg.isTypeValue() ? arg.getTypeValue() : arg.getTypeOfNonTypeValue());
    }

    /*
     * Unable to fully structure code
     */
    static ICPPTemplateArgument matchTemplateParameterAndArgument(ICPPTemplateDefinition template, ICPPTemplateParameter param, ICPPTemplateArgument arg, CPPTemplateParameterMap map) {
        block17: {
            if (!CPPTemplates.isValidArgument(arg)) {
                return null;
            }
            if (param instanceof ICPPTemplateTypeParameter) {
                t = arg.getTypeValue();
                if (t != null && !(t instanceof ICPPTemplateDefinition)) {
                    return arg;
                }
                return null;
            }
            if (!(param instanceof ICPPTemplateTemplateParameter)) break block17;
            t = arg.getTypeValue();
            if (!(t instanceof ICPPUnknownType)) ** GOTO lbl16
            return arg;
lbl-1000:
            // 1 sources

            {
                if (t instanceof ICPPClassSpecialization) {
                    t = ((ICPPClassSpecialization)t).getSpecializedBinding();
                    continue;
                }
                return null;
lbl16:
                // 2 sources

                ** while (!(t instanceof ICPPTemplateDefinition))
            }
lbl17:
            // 1 sources

            pParams = null;
            aParams = null;
            try {
                pParams = ((ICPPTemplateTemplateParameter)param).getTemplateParameters();
                aParams = ((ICPPTemplateDefinition)t).getTemplateParameters();
                if (!CPPTemplates.matchTemplateTemplateParameters(pParams, aParams)) {
                    return null;
                }
            }
            catch (DOMException e) {
                return null;
            }
            return arg;
        }
        if (param instanceof ICPPTemplateNonTypeParameter) {
            if (!arg.isNonTypeValue()) {
                return null;
            }
            argType = arg.getTypeOfNonTypeValue();
            try {
                pType = ((ICPPTemplateNonTypeParameter)param).getType();
                if (pType instanceof ICPPParameterPackType) {
                    pType = ((ICPPParameterPackType)pType).getType();
                }
                if (map != null && pType != null) {
                    pType = CPPTemplates.instantiateType(pType, new InstantiationContext(map));
                }
                if (argType instanceof ICPPParameterPackType) {
                    argType = ((ICPPParameterPackType)argType).getType();
                }
                if (argType instanceof ICPPUnknownType) {
                    return new CPPTemplateNonTypeArgument(arg.getNonTypeValue(), pType);
                }
                return CPPTemplates.convertNonTypeTemplateArgument(template, pType, arg);
            }
            catch (DOMException e) {
                return null;
            }
        }
        if (!CPPTemplates.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private static boolean matchTemplateTemplateParameters(ICPPTemplateParameter[] pParams, ICPPTemplateParameter[] aParams) throws DOMException {
        int pi = 0;
        int ai = 0;
        while (pi < pParams.length && ai < aParams.length) {
            ICPPTemplateParameter pp = pParams[pi];
            ICPPTemplateParameter ap = aParams[ai];
            if (ap.isParameterPack() && !pp.isParameterPack()) {
                return false;
            }
            boolean pb = pp instanceof ICPPTemplateTypeParameter;
            boolean ab = ap instanceof ICPPTemplateTypeParameter;
            if (pb != ab) {
                return false;
            }
            if (!pb) {
                pb = pp instanceof ICPPTemplateNonTypeParameter;
                ab = ap instanceof ICPPTemplateNonTypeParameter;
                if (pb != ab) {
                    return false;
                }
                if (!pb) {
                    if (!(pp instanceof ICPPTemplateTemplateParameter) || !(ap instanceof ICPPTemplateTemplateParameter)) {
                        assert (false);
                        return false;
                    }
                    if (!CPPTemplates.matchTemplateTemplateParameters(((ICPPTemplateTemplateParameter)pp).getTemplateParameters(), ((ICPPTemplateTemplateParameter)ap).getTemplateParameters())) {
                        return false;
                    }
                }
            }
            if (!pp.isParameterPack()) {
                ++pi;
            }
            ++ai;
        }
        if (pi < pParams.length) {
            return pi == pParams.length - 1 && pParams[pi].isParameterPack();
        }
        return ai == aParams.length;
    }

    private static ICPPTemplateArgument convertNonTypeTemplateArgument(ICPPTemplateDefinition template, IType paramType, ICPPTemplateArgument arg) throws DOMException {
        TypeOfDependentExpression type;
        IType p;
        IType a = arg.getTypeOfNonTypeValue();
        if (a instanceof ICPPParameterPackType) {
            a = ((ICPPParameterPackType)a).getType();
        }
        if (paramType instanceof IFunctionType) {
            p = new CPPPointerType(paramType);
        } else if (paramType instanceof IArrayType) {
            p = new CPPPointerType(((IArrayType)paramType).getType());
        } else {
            p = paramType;
            if (p != null && p.isSameType(a)) {
                return arg;
            }
        }
        if (a instanceof FunctionSetType) {
            if (p instanceof IPointerType) {
                p = ((IPointerType)p).getType();
            }
            if (p instanceof IFunctionType) {
                CPPFunctionSet functionSet = ((FunctionSetType)a).getFunctionSet();
                ICPPFunction[] iCPPFunctionArray = functionSet.getBindings();
                int n = iCPPFunctionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPFunction f = iCPPFunctionArray[n2];
                    if (p.isSameType(f.getType())) {
                        functionSet.applySelectedFunction(f);
                        return new CPPTemplateNonTypeArgument(new EvalBinding((IBinding)f, null, template));
                    }
                    ++n2;
                }
            }
            return null;
        }
        if (paramType instanceof TypeOfDependentExpression && (type = (TypeOfDependentExpression)paramType).isForTemplateAuto()) {
            return arg;
        }
        Cost cost = Conversions.checkImplicitConversionSequence(p, a, IASTExpression.ValueCategory.LVALUE, Conversions.UDCMode.FORBIDDEN, Conversions.Context.ORDINARY);
        if (cost == null || !cost.converts()) {
            ICPPEvaluation eval = arg.getNonTypeEvaluation();
            ICPPEvaluation newEval = CPPEvaluation.maybeApplyConversion(eval, p, false);
            if (newEval == EvalFixed.INCOMPLETE && newEval != eval) {
                return null;
            }
            return new CPPTemplateNonTypeArgument(newEval);
        }
        return new CPPTemplateNonTypeArgument(arg.getNonTypeValue(), paramType);
    }

    static boolean argsAreTrivial(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] args) {
        if (pars.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            ICPPTemplateParameter par = pars[i];
            ICPPTemplateArgument arg = args[i];
            if (par instanceof IType) {
                if (arg.isNonTypeValue()) {
                    return false;
                }
                IType argType = arg.getTypeValue();
                if (argType == null) {
                    return false;
                }
                if (par.isParameterPack()) {
                    if (!(argType instanceof ICPPParameterPackType)) {
                        return false;
                    }
                    if ((argType = ((ICPPParameterPackType)argType).getType()) == null) {
                        return false;
                    }
                }
                if (!argType.isSameType((IType)((Object)par))) {
                    return false;
                }
            } else {
                if (arg.isTypeValue()) {
                    return false;
                }
                if (par.isParameterPack() != arg.isPackExpansion()) {
                    return false;
                }
                int parpos = IntegralValue.isTemplateParameter(arg.getNonTypeValue());
                if (parpos != par.getParameterID()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean hasDependentArgument(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (CPPTemplates.isDependentArgument(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentArgument(ICPPTemplateArgument arg) {
        if (arg.isTypeValue()) {
            return CPPTemplates.isDependentType(arg.getTypeValue());
        }
        ICPPEvaluation evaluation = arg.getNonTypeEvaluation();
        return evaluation.isTypeDependent() || evaluation.isValueDependent();
    }

    public static boolean containsDependentType(List<IType> ts) {
        for (IType t : ts) {
            if (!CPPTemplates.isDependentType(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDependentType(IType[] ts) {
        IType[] iTypeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (CPPTemplates.isDependentType(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentType(IType t) {
        while (true) {
            IValue asize;
            if (t instanceof ICPPUnknownType) {
                return true;
            }
            if (t instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)t;
                if (CPPTemplates.containsDependentType(ft.getParameterTypes())) {
                    return true;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType ptmt = (ICPPPointerToMemberType)t;
                if (CPPTemplates.isDependentType(ptmt.getMemberOfClass())) {
                    return true;
                }
                t = ptmt.getType();
                continue;
            }
            if (t instanceof ICPPParameterPackType) {
                return true;
            }
            if (!(t instanceof ITypeContainer)) break;
            if (t instanceof IArrayType && (asize = ((IArrayType)t).getSize()) != null && IntegralValue.isDependentValue(asize)) {
                return true;
            }
            t = ((ITypeContainer)t).getType();
        }
        if (t instanceof InitializerListType) {
            return ((InitializerListType)t).getEvaluation().isTypeDependent();
        }
        if (t instanceof IBinding) {
            IBinding owner = ((IBinding)((Object)t)).getOwner();
            if (owner instanceof IFunction) {
                if (owner instanceof ICPPFunctionTemplate) {
                    return true;
                }
                owner = owner.getOwner();
            }
            if (owner instanceof ICPPClassTemplate) {
                return true;
            }
            return owner instanceof IType && owner != t && CPPTemplates.isDependentType((IType)((Object)owner));
        }
        return false;
    }

    public static boolean containsDependentArg(ObjectMap tpMap) {
        Object[] objectArray = tpMap.valueArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (CPPTemplates.isDependentType((IType)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IBinding resolveUnknown(ICPPUnknownBinding unknown, InstantiationContext context) throws DOMException {
        IType type;
        if (unknown instanceof ICPPDeferredClassInstance) {
            return CPPTemplates.resolveDeferredClassInstance((ICPPDeferredClassInstance)unknown, context);
        }
        if (unknown instanceof ICPPDeferredVariableInstance) {
            return CPPTemplates.resolveDeferredVariableInstance((ICPPDeferredVariableInstance)unknown, context);
        }
        if (unknown instanceof ICPPUnknownMember) {
            return CPPTemplates.resolveUnknownMember((ICPPUnknownMember)unknown, context);
        }
        if (unknown instanceof ICPPTemplateParameter && unknown instanceof IType && (type = CPPTemplates.resolveTemplateTypeParameter((ICPPTemplateParameter)((Object)unknown), context)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        if (unknown instanceof TypeOfDependentExpression && (type = CPPTemplates.instantiateType((IType)((Object)unknown), context)) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return unknown;
    }

    private static IBinding resolveUnknownMember(ICPPUnknownMember unknown, InstantiationContext context) throws DOMException {
        IType ot0 = unknown.getOwnerType();
        if (ot0 == null) {
            return unknown;
        }
        IBinding result = unknown;
        IType ot1 = CPPTemplates.instantiateType(ot0, context);
        if (ot1 != null) {
            if ((ot1 = SemanticUtil.getUltimateType(ot1, false)) instanceof ICPPUnknownType) {
                if (unknown instanceof ICPPUnknownMemberClassInstance) {
                    ICPPTemplateArgument[] args1;
                    ICPPUnknownMemberClassInstance ucli = (ICPPUnknownMemberClassInstance)unknown;
                    ICPPTemplateArgument[] args0 = ucli.getArguments();
                    if (args0 != (args1 = CPPTemplates.instantiateArguments(args0, context, false)) || !ot1.isSameType(ot0)) {
                        args1 = SemanticUtil.getSimplifiedArguments(args1);
                        result = new CPPUnknownClassInstance(ot1, ucli.getNameCharArray(), args1);
                    }
                } else if (!ot1.isSameType(ot0)) {
                    result = unknown instanceof ICPPUnknownMemberClass ? new CPPUnknownMemberClass(ot1, unknown.getNameCharArray()) : new CPPUnknownMethod(ot1, unknown.getNameCharArray());
                }
            } else if (ot1 instanceof ICPPClassType) {
                IScope s = ((ICPPClassType)ot1).getCompositeScope();
                if (s != null) {
                    result = CPPSemantics.resolveUnknownName(s, unknown);
                    if (unknown instanceof ICPPUnknownMemberClassInstance && (result instanceof ICPPTemplateDefinition || result instanceof ICPPAliasTemplateInstance)) {
                        ICPPTemplateArgument[] args1 = CPPTemplates.instantiateArguments(((ICPPUnknownMemberClassInstance)unknown).getArguments(), context, false);
                        if (result instanceof ICPPClassTemplate) {
                            result = CPPTemplates.instantiate((ICPPClassTemplate)result, args1);
                        } else if (result instanceof ICPPAliasTemplate) {
                            result = CPPTemplates.instantiateAliasTemplate((ICPPAliasTemplate)result, args1);
                        }
                    }
                }
            } else if (ot1 != ot0) {
                return new ProblemBinding((IASTName)new CPPASTName(unknown.getNameCharArray()), CPPSemantics.getCurrentLookupPoint(), 10);
            }
        }
        return result;
    }

    private static IBinding resolveDeferredClassInstance(ICPPDeferredClassInstance dci, InstantiationContext context) {
        IBinding inst;
        ICPPTemplateArgument[] newArgs;
        ICPPClassTemplate classTemplate = dci.getClassTemplate();
        ICPPTemplateArgument[] arguments = dci.getTemplateArguments();
        try {
            newArgs = CPPTemplates.instantiateArguments(arguments, context, true);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (newArgs == null) {
            return CPPTemplates.createProblem(classTemplate, 15);
        }
        boolean changed = arguments != newArgs;
        IType classTemplateSpecialization = CPPTemplates.instantiateType(classTemplate, context);
        if (classTemplateSpecialization != classTemplate) {
            if (classTemplateSpecialization instanceof ICPPClassTemplate) {
                classTemplate = (ICPPClassTemplate)classTemplateSpecialization;
                changed = true;
            } else if (classTemplateSpecialization instanceof ICPPAliasTemplate && (inst = CPPTemplates.instantiateAliasTemplate((ICPPAliasTemplate)classTemplateSpecialization, newArgs)) != null) {
                return inst;
            }
        }
        if (changed && (inst = CPPTemplates.instantiate(classTemplate, newArgs)) != null) {
            return inst;
        }
        return dci;
    }

    private static IBinding resolveDeferredVariableInstance(ICPPDeferredVariableInstance dvi, InstantiationContext context) {
        IBinding inst;
        ICPPTemplateArgument[] newArgs;
        ICPPVariableTemplate variableTemplate = dvi.getTemplateDefinition();
        ICPPTemplateArgument[] arguments = dvi.getTemplateArguments();
        try {
            newArgs = CPPTemplates.instantiateArguments(arguments, context, true);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        if (newArgs == null) {
            return CPPTemplates.createProblem(variableTemplate, 15);
        }
        if (arguments != newArgs && (inst = CPPTemplates.instantiate(variableTemplate, newArgs)) != null) {
            return inst;
        }
        return dvi;
    }

    public static boolean haveSameArguments(ICPPTemplateInstance i1, ICPPTemplateInstance i2) {
        ICPPTemplateArgument[] m1 = i1.getTemplateArguments();
        ICPPTemplateArgument[] m2 = i2.getTemplateArguments();
        if (m1 == null || m2 == null || m1.length != m2.length) {
            return false;
        }
        String s1 = ASTTypeUtil.getArgumentListString(m1, true);
        String s2 = ASTTypeUtil.getArgumentListString(m2, true);
        return s1.equals(s2);
    }

    private static CPPTemplateParameterMap createParameterMap(ICPPTemplateDefinition template, ICPPTemplateArgument[] arguments) {
        ICPPTemplateParameter[] parameters = template.getTemplateParameters();
        int numArgs = arguments.length;
        int numParams = parameters.length;
        int length = Math.max(numArgs, numParams);
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(numParams);
        boolean isPack = false;
        ICPPTemplateParameter param = null;
        int i = 0;
        while (i < length) {
            if (!isPack || param == null) {
                if (i >= numParams) {
                    return null;
                }
                param = parameters[i];
                isPack = param.isParameterPack();
            }
            if (i < numArgs) {
                ICPPTemplateArgument arg = arguments[i];
                ICPPTemplateArgument newArg = CPPTemplates.matchTemplateParameterAndArgument(template, param, arg, map);
                if (newArg == null) {
                    return null;
                }
                if (newArg != arg) {
                    arguments[i] = newArg;
                }
                if (!isPack) {
                    map.put(param, newArg);
                }
            } else assert (isPack);
            ++i;
        }
        if (isPack) {
            int packOffset = numParams - 1;
            int packSize = numArgs - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(arguments, packOffset, pack, 0, packSize);
            map.put(param, pack);
        }
        return map;
    }

    public static IBinding findDeclarationForSpecialization(IBinding binding) {
        while (binding instanceof ICPPSpecialization) {
            if (ASTInternal.hasDeclaration(binding)) {
                return binding;
            }
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            if (original == null) {
                return binding;
            }
            binding = original;
        }
        return binding;
    }

    public static ICPPExecution instantiateFunctionBody(ICPPFunctionSpecialization f) {
        ICPPFunction spec = (ICPPFunction)f.getSpecializedBinding();
        ICPPExecution exec = null;
        if (spec instanceof ICPPComputableFunction && (exec = ((ICPPComputableFunction)((Object)spec)).getFunctionBodyExecution()) != null) {
            InstantiationContext context = new InstantiationContext(f.getTemplateParameterMap(), f);
            CPPTemplates.addInstantiatedParameters(context, f);
            exec = exec.instantiate(context, 25);
        }
        return exec;
    }

    private static void addInstantiatedParameters(InstantiationContext context, ICPPFunctionSpecialization spec) {
        ICPPFunction specialized = (ICPPFunction)spec.getSpecializedBinding();
        ICPPParameter[] paramSpecs = spec.getParameters();
        ICPPParameter[] specializedParams = specialized.getParameters();
        int i = 0;
        while (i < paramSpecs.length) {
            ICPPParameter paramSpecialization = paramSpecs[i];
            ICPPParameter specializedParam = specializedParams[i];
            context.putInstantiatedLocal(specializedParam, paramSpecialization);
            if (specializedParam.isParameterPack()) break;
            ++i;
        }
    }

    public static ICPPExecution instantiateConstructorChain(ICPPConstructorSpecialization f) {
        ICPPConstructor spec = (ICPPConstructor)f.getSpecializedBinding();
        ICPPExecution exec = null;
        if (spec != null && (exec = spec.getConstructorChainExecution()) != null) {
            InstantiationContext context = new InstantiationContext(f.getTemplateParameterMap(), f);
            exec = exec.instantiate(context, 25);
        }
        return exec;
    }

    public static String unwrapDestructorName(char[] name) {
        if (name == null || name.length == 0 || name[0] != '~') {
            return null;
        }
        return new String(name).substring(1).trim();
    }

    public static char[] instantiateName(char[] name, InstantiationContext context, IBinding enclosingTemplate) {
        String typename = CPPTemplates.unwrapDestructorName(name);
        if (typename == null) {
            return name;
        }
        ICPPTemplateParameterMap map = context.getParameterMap();
        IBinding enclosing = enclosingTemplate;
        while (enclosing != null) {
            if (enclosing instanceof ICPPTemplateDefinition) {
                ICPPTemplateParameter[] iCPPTemplateParameterArray = ((ICPPTemplateDefinition)enclosing).getTemplateParameters();
                int n = iCPPTemplateParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPTemplateArgument arg;
                    ICPPTemplateParameter param = iCPPTemplateParameterArray[n2];
                    if (param instanceof ICPPTemplateTypeParameter && param.getName().equals(typename) && (arg = map.getArgument(param)) instanceof CPPTemplateTypeArgument) {
                        IType argType = arg.getTypeValue();
                        if ((argType = SemanticUtil.getNestedType(argType, 9)) instanceof ICPPClassType) {
                            StringBuilder result = new StringBuilder();
                            result.append('~');
                            result.append(((ICPPClassType)argType).getName());
                            return result.toString().toCharArray();
                        }
                        if (argType instanceof ICPPBasicType) {
                            StringBuilder result = new StringBuilder();
                            result.append('~');
                            ASTTypeUtil.appendType(argType, true, result);
                            return result.toString().toCharArray();
                        }
                    }
                    ++n2;
                }
            }
            enclosing = enclosing.getOwner();
        }
        return name;
    }

    public static boolean isFullyInstantiated(IBinding binding) {
        while (binding != null) {
            if ((binding = binding.getOwner()) instanceof ICPPTemplateDefinition) {
                return false;
            }
            if (!(binding instanceof ICPPClassType)) break;
        }
        return true;
    }

    private static Map<TypeInstantiationRequest, IType> getInstantiationCache() {
        IASTTranslationUnit tu;
        IASTNode lookupPoint = CPPSemantics.getCurrentLookupPoint();
        if (lookupPoint != null && (tu = lookupPoint.getTranslationUnit()) instanceof CPPASTTranslationUnit) {
            return ((CPPASTTranslationUnit)tu).getInstantiationCache();
        }
        return null;
    }

    private static IType getCachedInstantiation(TypeInstantiationRequest instantiationRequest) {
        Map<TypeInstantiationRequest, IType> cache = CPPTemplates.getInstantiationCache();
        return cache != null ? cache.get(instantiationRequest) : null;
    }

    private static void putCachedInstantiation(TypeInstantiationRequest instantiationRequest, IType result) {
        Map<TypeInstantiationRequest, IType> cache = CPPTemplates.getInstantiationCache();
        if (cache != null) {
            cache.put(instantiationRequest, result);
        }
    }

    static enum TypeSelection {
        PARAMETERS,
        RETURN_TYPE,
        PARAMETERS_AND_RETURN_TYPE;

    }
}

