/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.CompositeValue;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.AggregateInitialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.core.runtime.CoreException;

public class EvalTypeId
extends CPPDependentEvaluation {
    public static final ICPPFunction AGGREGATE_INITIALIZATION = new CPPFunction(null){

        @Override
        public String toString() {
            return "AGGREGATE_INITIALIZATION";
        }
    };
    private final IType fInputType;
    private final ICPPEvaluation[] fArguments;
    private final boolean fRepresentsNewExpression;
    private boolean fUsesBracedInitList;
    private IType fOutputType;
    private ICPPFunction fConstructor = CPPFunction.UNINITIALIZED_FUNCTION;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalTypeId(IType type, IASTNode pointOfDefinition, boolean usesBracedInitList, ICPPEvaluation ... arguments) {
        this(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), false, usesBracedInitList, arguments);
    }

    public EvalTypeId(IType type, IBinding templateDefinition, boolean forNewExpression, boolean usesBracedInitList, ICPPEvaluation ... arguments) {
        super(templateDefinition);
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        if (!CPPTemplates.isDependentType(type)) {
            type = SemanticUtil.getNestedType(type, 1);
        }
        this.fInputType = type;
        this.fArguments = arguments;
        this.fRepresentsNewExpression = forNewExpression;
        this.fUsesBracedInitList = usesBracedInitList;
    }

    public static EvalTypeId createForNewExpression(IType type, IASTNode pointOfDefinition, boolean usesBracedInitList, ICPPEvaluation ... arguments) {
        return new EvalTypeId(type, EvalTypeId.findEnclosingTemplate(pointOfDefinition), true, usesBracedInitList, arguments);
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    public boolean representsNewExpression() {
        return this.fRepresentsNewExpression;
    }

    public boolean usesBracedInitList() {
        return this.fUsesBracedInitList;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public IType getType() {
        if (this.fOutputType == null) {
            this.fOutputType = this.computeType();
        }
        return this.fOutputType;
    }

    private IType computeType() {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        IType type = ExpressionTypes.typeFromReturnType(this.fInputType);
        if (this.fRepresentsNewExpression) {
            return new CPPPointerType(type);
        }
        return type;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        if (this.isTypeDependent()) {
            return DependentValue.create(this);
        }
        if (this.fRepresentsNewExpression) {
            return IntegralValue.UNKNOWN;
        }
        IType inputType = SemanticUtil.getNestedType(this.fInputType, 8);
        if (inputType instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)inputType;
            ICPPFunction ctor = this.getConstructor();
            if (EvalUtil.isCompilerGeneratedCtor(ctor)) {
                return CompositeValue.create(classType);
            }
            if (ctor == AGGREGATE_INITIALIZATION) {
                return CompositeValue.create(new EvalInitList(this.fArguments, this.getTemplateDefinition()), classType);
            }
            if (ctor != null) {
                EvalConstructor evalCtor = new EvalConstructor((IType)classType, (ICPPConstructor)ctor, this.fArguments, this.getTemplateDefinition());
                ICPPEvaluation computedEvalCtor = evalCtor.computeForFunctionCall(new ActivationRecord(), new ICPPEvaluation.ConstexprEvaluationContext());
                return computedEvalCtor.getValue();
            }
            return IntegralValue.ERROR;
        }
        if ((this.fArguments.length == 0 || this.isEmptyInitializerList(this.fArguments)) && inputType instanceof ICPPBasicType) {
            switch (((ICPPBasicType)inputType).getKind()) {
                case eChar: 
                case eWChar: 
                case eInt: 
                case eFloat: 
                case eDouble: 
                case eBoolean: 
                case eChar16: 
                case eChar32: 
                case eNullPtr: 
                case eInt128: 
                case eFloat128: {
                    return IntegralValue.create(0L);
                }
            }
            return IntegralValue.UNKNOWN;
        }
        if (this.fArguments.length == 1) {
            Long val;
            IValue argVal = this.fArguments[0].getValue();
            if (argVal instanceof IntegralValue && argVal.numberValue() != null && (val = Long.valueOf(argVal.numberValue().longValue())) < 0L && inputType instanceof ICPPBasicType && ((ICPPBasicType)inputType).isUnsigned()) {
                long sizeof = SizeofCalculator.getSizeAndAlignment((IType)inputType).size;
                if (sizeof > 4L) {
                    sizeof = 4L;
                }
                long range = 1L << (int)(sizeof * 8L - 1L);
                val = val + range;
                return IntegralValue.create(val);
            }
            return argVal;
        }
        return IntegralValue.UNKNOWN;
    }

    private boolean isEmptyInitializerList(ICPPEvaluation[] arguments) {
        return arguments.length == 1 && arguments[0] instanceof EvalInitList && ((EvalInitList)arguments[0]).getClauses().length == 0;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fInputType) || EvalTypeId.containsDependentType(this.fArguments);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (CPPTemplates.isDependentType(this.fInputType)) {
            return true;
        }
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        return !this.fRepresentsNewExpression && EvalTypeId.areAllConstantExpressions(this.fArguments) && EvalTypeId.isNullOrConstexprFunc(this.getConstructor());
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalTypeId)) {
            return false;
        }
        EvalTypeId o = (EvalTypeId)other;
        return this.fInputType.isSameType(o.fInputType) && EvalTypeId.areEquivalentEvaluations(this.fArguments, o.fArguments) && this.fRepresentsNewExpression == o.fRepresentsNewExpression && this.fUsesBracedInitList == o.fUsesBracedInitList;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return ExpressionTypes.valueCategoryFromReturnType(this.fInputType);
    }

    public ICPPFunction getConstructor() {
        if (this.fConstructor == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fConstructor = this.computeConstructor();
        }
        return this.fConstructor;
    }

    private static boolean allConstructorsAreCompilerGenerated(ICPPConstructor[] constructors) {
        ICPPConstructor[] iCPPConstructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor constructor = iCPPConstructorArray[n2];
            if (!EvalUtil.isCompilerGeneratedCtor(constructor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private ICPPFunction computeConstructor() {
        if (this.isTypeDependent()) {
            return null;
        }
        IType simplifiedType = SemanticUtil.getNestedType(this.fInputType, 9);
        if (simplifiedType instanceof ICPPClassType) {
            ICPPClassType classType = (ICPPClassType)simplifiedType;
            ICPPEvaluation[] arguments = this.fArguments;
            ICPPFunction[] constructors = classType.getConstructors();
            if (arguments.length == 1 && arguments[0] instanceof EvalInitList && !this.fUsesBracedInitList) {
                ICPPConstructor ctor;
                if (TypeTraits.isAggregateClass(classType)) {
                    return this.findDefaultConstructor(classType, (ICPPConstructor[])constructors);
                }
                if (((EvalInitList)arguments[0]).getClauses().length == 0 && (ctor = this.findDefaultConstructor(classType, (ICPPConstructor[])constructors)) != null) {
                    return ctor;
                }
                ICPPConstructor[] ctors = this.getInitializerListConstructors((ICPPConstructor[])constructors);
                if (ctors.length != 0) {
                    constructors = ctors;
                } else {
                    arguments = ((EvalInitList)arguments[0]).getClauses();
                }
            }
            LookupData data = new LookupData(classType.getNameCharArray(), null, CPPSemantics.getCurrentLookupPoint());
            data.foundItems = constructors;
            data.setFunctionArguments(false, arguments);
            try {
                IBinding binding = CPPSemantics.resolveFunction(data, constructors, true, false);
                if (binding instanceof ICPPFunction) {
                    return (ICPPFunction)binding;
                }
                if (this.fUsesBracedInitList && EvalTypeId.allConstructorsAreCompilerGenerated((ICPPConstructor[])constructors)) {
                    Cost cost = AggregateInitialization.check(classType, new EvalInitList(arguments, this.getTemplateDefinition()));
                    if (cost.converts()) {
                        return AGGREGATE_INITIALIZATION;
                    }
                    return new CPPFunction.CPPFunctionProblem(null, 1, classType.getNameCharArray());
                }
                if (binding instanceof IProblemBinding && !(binding instanceof ICPPFunction)) {
                    return new CPPFunction.CPPFunctionProblem(null, ((IProblemBinding)binding).getID(), classType.getNameCharArray());
                }
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    private ICPPConstructor findDefaultConstructor(ICPPClassType classType, ICPPConstructor[] constructors) {
        ICPPConstructor[] iCPPConstructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.isImplicit() && ClassTypeHelper.getMethodKind(classType, ctor) == ClassTypeHelper.MethodKind.DEFAULT_CTOR) {
                return ctor;
            }
            ++n2;
        }
        return null;
    }

    private ICPPConstructor[] getInitializerListConstructors(ICPPConstructor[] constructors) {
        ICPPConstructor[] result = ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        ICPPClassTemplate template = CPPVisitor.get_initializer_list();
        if (template == null) {
            return result;
        }
        ICPPConstructor[] iCPPConstructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding specialized;
            IType type;
            IType[] parameterTypes;
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.getRequiredArgumentCount() <= 1 && (parameterTypes = ctor.getType().getParameterTypes()).length != 0 && (type = parameterTypes[0]) instanceof ICPPSpecialization && (specialized = ((ICPPSpecialization)((Object)type)).getSpecializedBinding()) instanceof ICPPClassTemplate && template.isSameType((IType)((Object)specialized))) {
                result = ArrayUtil.append(result, ctor);
            }
            ++n2;
        }
        return ArrayUtil.trim(result);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 14;
        if (this.fRepresentsNewExpression) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fUsesBracedInitList) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fInputType);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType type = buffer.unmarshalType();
        ICPPEvaluation[] args = null;
        int len = buffer.getInt();
        args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        boolean forNewExpression = (firstBytes & 0x20) != 0;
        boolean usesBracedInitList = (firstBytes & 0x40) != 0;
        EvalTypeId result = new EvalTypeId(type, templateDefinition, forNewExpression, usesBracedInitList, args);
        return result;
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPFunction constructor;
        IType simplifiedType;
        ICPPEvaluation[] args = EvalTypeId.instantiateExpressions(this.fArguments, context, maxDepth);
        IType type = CPPTemplates.instantiateType(this.fInputType, context);
        if (args == this.fArguments && type == this.fInputType) {
            return this;
        }
        EvalTypeId result = new EvalTypeId(type, this.getTemplateDefinition(), this.fRepresentsNewExpression, this.fUsesBracedInitList, args);
        if (!result.isTypeDependent() && (simplifiedType = SemanticUtil.getNestedType(type, 1)) instanceof ICPPClassType && ((constructor = result.getConstructor()) == null || constructor instanceof IProblemBinding || constructor.isDeleted())) {
            return EvalFixed.INCOMPLETE;
        }
        return result;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPFunction constructor = this.getConstructor();
        if (constructor != null && constructor instanceof ICPPConstructor) {
            return new EvalConstructor(this.fInputType, (ICPPConstructor)constructor, this.fArguments, this.getTemplateDefinition()).computeForFunctionCall(record, context);
        }
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(record, context.recordStep());
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        EvalTypeId evalTypeId = new EvalTypeId(this.fInputType, this.getTemplateDefinition(), this.fRepresentsNewExpression, this.fUsesBracedInitList, args);
        return evalTypeId;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = CPPTemplates.determinePackSize(this.fInputType, tpMap);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

