/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IMoveToLineTarget;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class MoveToLineActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IWorkbenchPart fActivePart = null;
    private IMoveToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.moveToLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fActivePart.getSite().getWorkbenchWindow().getShell(), (String)ActionMessages.getString("MoveToLineActionDelegate.1"), (String)ActionMessages.getString("MoveToLineActionDelegate.2"), (IStatus)e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ISelectionProvider selectionProvider;
                IWorkbenchPartSite site;
                boolean enabled = false;
                if (MoveToLineActionDelegate.this.fPartTarget != null && MoveToLineActionDelegate.this.fTargetElement != null && (site = MoveToLineActionDelegate.this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
                    ISelection selection = selectionProvider.getSelection();
                    enabled = MoveToLineActionDelegate.this.fTargetElement.isSuspended() && MoveToLineActionDelegate.this.fPartTarget.canMoveToLine(MoveToLineActionDelegate.this.fActivePart, selection, MoveToLineActionDelegate.this.fTargetElement);
                }
                MoveToLineActionDelegate.this.fAction.setEnabled(enabled);
            }
        };
        CDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        this.bindTo((IWorkbenchPart)targetEditor);
    }

    public void init(IViewPart view) {
        this.bindTo((IWorkbenchPart)view);
    }

    private void bindTo(IWorkbenchPart part) {
        IDebugContextManager manager = DebugUITools.getDebugContextManager();
        if (this.fActivePart != null && !this.fActivePart.equals(part)) {
            manager.getContextService(this.fActivePart.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        }
        this.fPartTarget = null;
        this.fActivePart = part;
        if (part != null) {
            IAdapterManager adapterManager;
            IWorkbenchWindow workbenchWindow = part.getSite().getWorkbenchWindow();
            IDebugContextService service = manager.getContextService(workbenchWindow);
            service.addDebugContextListener((IDebugContextListener)this.fContextListener);
            this.fPartTarget = (IMoveToLineTarget)part.getAdapter(IMoveToLineTarget.class);
            if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)part, IMoveToLineTarget.class.getName())) {
                this.fPartTarget = (IMoveToLineTarget)adapterManager.loadAdapter((Object)part, IMoveToLineTarget.class.getName());
            }
            ISelection activeContext = service.getActiveContext();
            this.fContextListener.contextActivated(activeContext);
        }
        this.update();
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IStructuredSelection ss;
            MoveToLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                MoveToLineActionDelegate.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            MoveToLineActionDelegate.this.update();
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

