/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.launch;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewGenericTargetWizardPage
extends WizardPage {
    private final ILaunchTarget launchTarget;
    private Text nameText;
    private Text osText;
    private Text archText;

    public NewGenericTargetWizardPage(ILaunchTarget launchTarget) {
        super(NewGenericTargetWizardPage.class.getName());
        this.setTitle("Generic Target");
        this.setDescription("Enter name and properties for the target.");
        this.launchTarget = launchTarget;
    }

    public void createControl(Composite parent) {
        String arch;
        String os;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comp, 0);
        label.setText("Name:");
        this.nameText = new Text(comp, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.launchTarget != null) {
            this.nameText.setText(this.launchTarget.getId());
        }
        label = new Label(comp, 0);
        label.setText("Operating System:");
        this.osText = new Text(comp, 2048);
        this.osText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.launchTarget != null && (os = this.launchTarget.getAttribute("os", null)) != null) {
            this.osText.setText(os);
        }
        label = new Label(comp, 0);
        label.setText("CPU Architecture:");
        this.archText = new Text(comp, 2048);
        this.archText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.launchTarget != null && (arch = this.launchTarget.getAttribute("arch", null)) != null) {
            this.archText.setText(arch);
        }
        this.setControl((Control)comp);
    }

    public String getTargetName() {
        return this.nameText.getText().trim();
    }

    public String getOS() {
        String os = this.osText.getText().trim();
        return !os.isEmpty() ? os : null;
    }

    public String getArch() {
        String arch = this.archText.getText().trim();
        return !arch.isEmpty() ? arch : null;
    }
}

