/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractExecutionContextVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExecutionContextLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StateChangedEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

public abstract class AbstractThreadVMNode
extends AbstractExecutionContextVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private IElementLabelProvider fLabelProvider = this.createLabelProvider();

    public AbstractThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new ExecutionContextLabelText(MessagesForLaunchVM.AbstractThreadVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id", "is_suspended", "state_change_reason_known", "state_change_reason", "state_change_details_known", "state_change_details"}), new LabelText(MessagesForLaunchVM.AbstractThreadVMNode_No_columns__Error__label, new String[0]), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"))}));
        return provider;
    }

    @Override
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IContainerDMContext contDmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (runControl == null || contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        runControl.getExecutionContexts(contDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    AbstractThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                AbstractThreadVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractThreadVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException e) {
                var6_3 = updates;
                var5_4 = updates.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                update = var6_3[var4_5];
                this.handleFailedUpdate(update);
                ++var4_5;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IRunControl service = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (service == null) {
                this.handleFailedUpdate(update);
            } else {
                IRunControl.IExecutionDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
                if (dmc == null) {
                    this.handleFailedUpdate(update);
                } else {
                    update.setProperty("is_suspended", service.isSuspended(dmc));
                    update.setProperty("is_stepping", service.isStepping(dmc));
                    service.getExecutionData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            AbstractThreadVMNode.this.fillExecutionDataProperties(update, (IRunControl.IExecutionDMData)this.getData());
                            update.done();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected void fillExecutionDataProperties(IPropertiesUpdate update, IRunControl.IExecutionDMData data) {
        String details;
        IRunControl.StateChangeReason reason = data.getStateChangeReason();
        if (reason != null) {
            update.setProperty("state_change_reason", data.getStateChangeReason().name());
        }
        if (data instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)data).getDetails()) != null) {
            update.setProperty("state_change_details", details);
        }
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerResumedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else {
            if (e instanceof SteppingController.SteppingTimedOutEvent && ((SteppingController.SteppingTimedOutEvent)((Object)e)).getDMContext() instanceof IRunControl.IContainerDMContext) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
                rm.done();
                return;
            }
            if (e instanceof FullStackRefreshEvent && ((FullStackRefreshEvent)((Object)e)).getDMContext() instanceof IRunControl.IContainerDMContext) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
                rm.done();
                return;
            }
            if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
                this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            rm.setData((Object)new IVMContext[]{((VMContextInfo)this.getData()).fVMContext});
                        } else {
                            rm.setData((Object)new IVMContext[0]);
                        }
                        rm.done();
                    }
                });
                return;
            }
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    private void getThreadVMCForModelProxyInstallEvent(VMDelta parentDelta, final DataRequestMonitor<VMContextInfo> rm) {
        this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                try {
                    AbstractThreadVMNode.this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRunControl runControl = (IRunControl)AbstractThreadVMNode.this.getServicesTracker().getService(IRunControl.class);
                            if (runControl != null) {
                                int vmcIdx = -1;
                                int suspendedVmcIdx = -1;
                                int i = 0;
                                while (i < ((List)this.getData()).size()) {
                                    IDMVMContext vmc;
                                    IRunControl.IExecutionDMContext execDmc;
                                    if (((List)this.getData()).get(i) instanceof IDMVMContext && (execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(vmc = (IDMVMContext)((List)this.getData()).get(i)).getDMContext(), IRunControl.IExecutionDMContext.class)) != null) {
                                        int n = vmcIdx = vmcIdx < 0 ? i : vmcIdx;
                                        if (runControl.isSuspended(execDmc)) {
                                            suspendedVmcIdx = suspendedVmcIdx < 0 ? i : suspendedVmcIdx;
                                        }
                                    }
                                    ++i;
                                }
                                if (suspendedVmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(suspendedVmcIdx), suspendedVmcIdx, true));
                                } else if (vmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(vmcIdx), vmcIdx, false));
                                } else {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "No threads available", null));
                                }
                                rm.done();
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "No threads available", null));
                                rm.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
                    rm.done();
                }
            }
        }));
    }

    @Override
    public int getDeltaFlags(Object e) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (dmc instanceof IRunControl.IContainerDMContext) {
            return 0;
        }
        if (e instanceof IRunControl.IResumedDMEvent && ((IRunControl.IResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
            return 1024;
        }
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0;
        }
        if (e instanceof SteppingController.SteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            return 0x300000;
        }
        if (e instanceof StateChangedEvent) {
            return 2048;
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (dmc instanceof IRunControl.IContainerDMContext) {
            rm.done();
        } else if (e instanceof IRunControl.IResumedDMEvent) {
            if (((IRunControl.IResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                parentDelta.addNode(this.createVMContext(dmc), 1024);
            }
            rm.done();
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            rm.done();
        } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
            parentDelta.addNode(this.createVMContext(dmc), 1024);
            rm.done();
        } else if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        parentDelta.addNode((Object)((VMContextInfo)this.getData()).fVMContext, nodeOffset + ((VMContextInfo)this.getData()).fIndex, 0x100000 | (((VMContextInfo)this.getData()).fIsSuspended ? 0 : 0x200000));
                    }
                    rm.done();
                }
            });
        } else if (e instanceof StateChangedEvent) {
            parentDelta.addNode(this.createVMContext(dmc), 2048);
            rm.done();
        } else {
            rm.done();
        }
    }

    private static class VMContextInfo {
        final IVMContext fVMContext;
        final int fIndex;
        final boolean fIsSuspended;

        VMContextInfo(IVMContext vmContext, int index, boolean isSuspended) {
            this.fVMContext = vmContext;
            this.fIndex = index;
            this.fIsSuspended = isSuspended;
        }
    }
}

