/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.CopySelectedMessagesAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.OpenInEditorAction;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestLocation;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class MessagesViewer {
    private TableViewer tableViewer;
    private IViewSite viewSite;
    private OpenInEditorAction openInEditorAction;
    private Action copyAction;
    private boolean showFailedOnly = false;
    private boolean showFileNameOnly = false;
    private Set<ITestMessage.Level> acceptedMessageLevels = new HashSet<ITestMessage.Level>();
    private boolean orderingMode = false;

    public MessagesViewer(Composite parent, TestingSessionsManager sessionsManager, IWorkbench workbench, IViewSite viewSite, Clipboard clipboard) {
        this.viewSite = viewSite;
        this.tableViewer = new TableViewer(parent, 770);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MessagesLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MessagesContentProvider());
        this.tableViewer.addFilter((ViewerFilter)new MessageLevelFilter());
        this.initContextMenu(viewSite, sessionsManager, workbench, clipboard);
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MessagesViewer.this.openInEditorAction.run();
            }
        });
    }

    private void initContextMenu(IViewSite viewSite, TestingSessionsManager sessionsManager, IWorkbench workbench, Clipboard clipboard) {
        this.openInEditorAction = new OpenInEditorAction(this.tableViewer, sessionsManager, workbench);
        this.copyAction = new CopySelectedMessagesAction(this.tableViewer, clipboard);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MessagesViewer.this.handleMenuAboutToShow(manager);
            }
        });
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        menuMgr.add((IAction)this.openInEditorAction);
        menuMgr.add((IAction)this.copyAction);
        this.configureCopy();
    }

    private void configureCopy() {
        this.getTableViewer().getTable().addFocusListener(new FocusListener(){
            IAction viewCopyHandler;

            public void focusLost(FocusEvent e) {
                if (this.viewCopyHandler != null) {
                    this.switchTo(this.viewCopyHandler);
                }
            }

            public void focusGained(FocusEvent e) {
                this.switchTo((IAction)MessagesViewer.this.copyAction);
            }

            private void switchTo(IAction copyAction) {
                IActionBars actionBars = MessagesViewer.this.viewSite.getActionBars();
                this.viewCopyHandler = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
                actionBars.updateActionBars();
            }
        });
    }

    private void handleMenuAboutToShow(IMenuManager manager) {
        ISelection selection = this.tableViewer.getSelection();
        this.openInEditorAction.setEnabled(!selection.isEmpty());
        this.copyAction.setEnabled(!selection.isEmpty());
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void showItemsMessages(ITestItem[] testItems) {
        this.tableViewer.setInput((Object)testItems);
    }

    private void forceRecollectMessages() {
        this.tableViewer.setInput(this.tableViewer.getInput());
    }

    public boolean getShowFailedOnly() {
        return this.showFailedOnly;
    }

    public void setShowFailedOnly(boolean showFailedOnly) {
        if (this.showFailedOnly != showFailedOnly) {
            this.showFailedOnly = showFailedOnly;
            this.forceRecollectMessages();
        }
    }

    public boolean getShowFileNameOnly() {
        return this.showFileNameOnly;
    }

    public void setShowFileNameOnly(boolean showFileNameOnly) {
        if (this.showFileNameOnly != showFileNameOnly) {
            this.showFileNameOnly = showFileNameOnly;
            this.forceRecollectMessages();
        }
    }

    public boolean getOrderingMode() {
        return this.orderingMode;
    }

    public void setOrderingMode(boolean orderingMode) {
        if (this.orderingMode != orderingMode) {
            this.orderingMode = orderingMode;
            this.forceRecollectMessages();
        }
    }

    public void addLevelFilter(LevelFilter levelFilter, boolean refresh) {
        ITestMessage.Level[] levelArray = levelFilter.getLevels();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestMessage.Level level = levelArray[n2];
            this.acceptedMessageLevels.add(level);
            ++n2;
        }
        if (refresh) {
            this.tableViewer.refresh();
        }
    }

    public void removeLevelFilter(LevelFilter levelFilter) {
        ITestMessage.Level[] levelArray = levelFilter.getLevels();
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestMessage.Level level = levelArray[n2];
            this.acceptedMessageLevels.remove((Object)level);
            ++n2;
        }
        this.tableViewer.refresh();
    }

    public static enum LevelFilter {
        Info("IMG_OBJS_INFO_TSK", ITestMessage.Level.Info, ITestMessage.Level.Message),
        Warning("IMG_OBJS_WARN_TSK", ITestMessage.Level.Warning),
        Error("IMG_OBJS_ERROR_TSK", ITestMessage.Level.Error, ITestMessage.Level.FatalError, ITestMessage.Level.Exception);

        private String imageId;
        private ITestMessage.Level[] includedLevels;

        private LevelFilter(String imageId, ITestMessage.Level ... includedLevels) {
            this.imageId = imageId;
            this.includedLevels = includedLevels;
        }

        public String getImageId() {
            return this.imageId;
        }

        public ITestMessage.Level[] getLevels() {
            return this.includedLevels;
        }

        public boolean isIncluded(ITestMessage.Level messageLevel) {
            ITestMessage.Level[] levelArray = this.includedLevels;
            int n = this.includedLevels.length;
            int n2 = 0;
            while (n2 < n) {
                ITestMessage.Level currLevel = levelArray[n2];
                if (currLevel.equals((Object)messageLevel)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private class MessageLevelFilter
    extends ViewerFilter {
        private MessageLevelFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return MessagesViewer.this.acceptedMessageLevels.contains((Object)((ITestMessage)element).getLevel());
        }
    }

    private class MessagesContentProvider
    implements IStructuredContentProvider {
        ITestMessage[] testMessages;

        private MessagesContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.collectMessages((ITestItem[])newInput);
            } else {
                this.testMessages = new ITestMessage[0];
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.testMessages;
        }

        private TreeSet<ITestMessage> createMessagesSet() {
            return new TreeSet<ITestMessage>(new Comparator<ITestMessage>(){

                @Override
                public int compare(ITestMessage message1, ITestMessage message2) {
                    ITestLocation location1 = message1.getLocation();
                    ITestLocation location2 = message2.getLocation();
                    if (location1 != null && location2 != null) {
                        int line2;
                        String file2;
                        String file1 = location1.getFile();
                        int fileResult = file1.compareTo(file2 = location2.getFile());
                        if (fileResult != 0) {
                            return fileResult;
                        }
                        int line1 = location1.getLine();
                        if (line1 < (line2 = location2.getLine())) {
                            return -1;
                        }
                        if (line1 > line2) {
                            return 1;
                        }
                    } else {
                        if (location1 == null && location2 != null) {
                            return -1;
                        }
                        if (location1 != null && location2 == null) {
                            return 1;
                        }
                    }
                    String text1 = message1.getText();
                    String text2 = message2.getText();
                    return text1.compareTo(text2);
                }
            });
        }

        private ArrayList<ITestMessage> createMessagesList() {
            return new ArrayList<ITestMessage>();
        }

        private Collection<ITestMessage> createMessagesCollection() {
            return MessagesViewer.this.orderingMode ? this.createMessagesSet() : this.createMessagesList();
        }

        private void collectMessages(ITestItem[] testItems) {
            Collection<ITestMessage> testMessagesCollection = this.createMessagesCollection();
            ITestItem[] iTestItemArray = testItems;
            int n = testItems.length;
            int n2 = 0;
            while (n2 < n) {
                ITestItem testItem = iTestItemArray[n2];
                testItem.visit(new MessagesCollector(testMessagesCollection));
                ++n2;
            }
            this.testMessages = testMessagesCollection.toArray(new ITestMessage[testMessagesCollection.size()]);
        }

        class MessagesCollector
        implements IModelVisitor {
            Collection<ITestMessage> collectedTestMessages;
            boolean collect = true;

            MessagesCollector(Collection<ITestMessage> testMessages) {
                this.collectedTestMessages = testMessages;
            }

            @Override
            public void visit(ITestMessage testMessage) {
                if (this.collect) {
                    this.collectedTestMessages.add(testMessage);
                }
            }

            @Override
            public void visit(ITestCase testCase) {
                this.collect = !MessagesViewer.this.showFailedOnly || testCase.getStatus().isError();
            }

            @Override
            public void visit(ITestSuite testSuite) {
            }

            @Override
            public void leave(ITestSuite testSuite) {
            }

            @Override
            public void leave(ITestCase testCase) {
            }

            @Override
            public void leave(ITestMessage testMessage) {
            }
        }
    }

    private class MessagesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MessagesLabelProvider() {
        }

        private String getLocationFile(ITestLocation location) {
            String filePath = location.getFile();
            if (MessagesViewer.this.showFileNameOnly) {
                return new File(filePath).getName();
            }
            return filePath;
        }

        public String getColumnText(Object obj, int index) {
            ITestMessage message = (ITestMessage)obj;
            ITestLocation location = message.getLocation();
            String locationString = "";
            if (location != null) {
                locationString = MessageFormat.format(UIViewMessages.MessagesViewer_location_format, this.getLocationFile(location), location.getLine());
            }
            return MessageFormat.format(UIViewMessages.MessagesViewer_message_format, new Object[]{locationString, message.getLevel(), message.getText()});
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            ITestMessage.Level level = ((ITestMessage)obj).getLevel();
            String imageId = "IMG_OBJ_ELEMENTS";
            LevelFilter[] levelFilterArray = LevelFilter.values();
            int n = levelFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                LevelFilter levelFilter = levelFilterArray[n2];
                if (levelFilter.isIncluded(level)) {
                    imageId = levelFilter.getImageId();
                    break;
                }
                ++n2;
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageId);
        }
    }
}

