/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCDatabase;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogSchema;
import org.eclipse.datatools.enablement.mysql.catalog.loaders.MySqlAuthorizationIdentifierLoader;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;

public class MySqlCatalogDatabase
extends JDBCDatabase {
    private Boolean schemasLoaded = Boolean.FALSE;
    private Boolean catalogsLoaded = Boolean.FALSE;
    private Boolean authorizationIdsLoaded = Boolean.FALSE;
    private transient SoftReference authorizationIdLoaderRef;

    public MySqlCatalogDatabase(Connection connection) {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (this.schemasLoaded.booleanValue()) {
                this.schemasLoaded = Boolean.FALSE;
            }
        }
        bl = this.catalogsLoaded;
        synchronized (bl) {
            if (this.catalogsLoaded.booleanValue()) {
                this.catalogsLoaded = Boolean.FALSE;
            }
        }
        bl = this.authorizationIdsLoaded;
        synchronized (bl) {
            if (this.authorizationIdsLoaded.booleanValue()) {
                this.authorizationIdsLoaded = Boolean.FALSE;
            }
        }
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSchemas() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (!this.schemasLoaded.booleanValue()) {
                if (this.schemas == null) {
                    this.schemas = new EObjectWithInverseResolvingEList(Schema.class, (InternalEObject)this, 10, 12);
                    MySqlCatalogSchema schema = new MySqlCatalogSchema();
                    schema.setName(this.getName());
                    this.schemas.add((Object)schema);
                    this.schemasLoaded = Boolean.TRUE;
                }
                return this.schemas;
            }
        }
        return super.getSchemas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getCatalogs() {
        Boolean bl = this.catalogsLoaded;
        synchronized (bl) {
            if (!this.catalogsLoaded.booleanValue() && this.catalogs == null) {
                this.catalogs = new EObjectWithInverseResolvingEList(Schema.class, (InternalEObject)this, 12, 12);
                this.catalogsLoaded = Boolean.TRUE;
            }
        }
        return this.catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAuthorizationIds() {
        Boolean bl = this.authorizationIdsLoaded;
        synchronized (bl) {
            if (!this.authorizationIdsLoaded.booleanValue()) {
                this.loadAuthorizationIdentifiers();
            }
        }
        return super.getAuthorizationIds();
    }

    private void loadAuthorizationIdentifiers() {
        boolean deliver = this.eDeliver();
        try {
            try {
                EList container = super.getAuthorizationIds();
                ArrayList existingAuthorizationIds = new ArrayList(container);
                this.eSetDeliver(false);
                container.clear();
                this.getAuthorizationIdentifierLoader().loadAuthorizationIdentifiers((List)container, existingAuthorizationIds);
                this.getAuthorizationIdentifierLoader().clearAuthorizationIdentifiers(existingAuthorizationIds);
                this.authorizationIdsLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    protected final MySqlAuthorizationIdentifierLoader getAuthorizationIdentifierLoader() {
        if (this.authorizationIdLoaderRef == null || this.authorizationIdLoaderRef.get() == null) {
            this.authorizationIdLoaderRef = new SoftReference<MySqlAuthorizationIdentifierLoader>(this.createAuthorizationIdentifierLoader());
        }
        return (MySqlAuthorizationIdentifierLoader)((Object)this.authorizationIdLoaderRef.get());
    }

    private MySqlAuthorizationIdentifierLoader createAuthorizationIdentifierLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLAccessControlPackage.eINSTANCE.getAuthorizationIdentifier().getInstanceClassName());
        if (loader != null) {
            MySqlAuthorizationIdentifierLoader authorizationIdLoader = (MySqlAuthorizationIdentifierLoader)loader;
            authorizationIdLoader.setCatalogObject((ICatalogObject)this);
            return authorizationIdLoader;
        }
        return new MySqlAuthorizationIdentifierLoader((ICatalogObject)this);
    }
}

