/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.core.IResourceValidator;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorChangedListener;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.IValidatorPredicate;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.Messages;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.validators.internal.core.ValidatorManager;
import org.eclipse.dltk.validators.internal.core.ValidatorsCore;
import org.xml.sax.InputSource;

public final class ValidatorRuntime {
    public static final String PREF_VALIDATOR_XML = "org.eclipse.dltk.validators.core.PREF_VALIDATOR_XML";
    public static final String PREF_CONFIGURATION = "org.eclipse.dltk.validators.core.configuration";
    private static final Object fgValidatorLock = new Object();
    private static boolean fgInitializingValidators = false;
    private static boolean isInitialized = false;
    private static final ListenerList<IValidatorChangedListener> fgValidatorListeners = new ListenerList(1);
    public static final String ANY_NATURE = "#";
    @Deprecated
    public static final IValidatorPredicate AUTOMATIC = validator -> validator.isAutomatic();
    public static final IValidatorPredicate ALL = validator -> true;

    private ValidatorRuntime() {
    }

    public static IValidatorType getValidatorType(String id) {
        IValidatorType[] types = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getID().equals(id)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IValidatorType[] getValidatorTypes() {
        ValidatorRuntime.initializeValidators();
        try {
            return ValidatorManager.getAllValidatorTypes();
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static IValidatorType[] getValidatorTypes(String nature) {
        ValidatorRuntime.initializeValidators();
        try {
            return ValidatorManager.getValidators(nature);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void saveValidatorConfiguration() throws CoreException {
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        if (vals == null || vals.length == 0) {
            return;
        }
        try {
            String xml = ValidatorRuntime.getValidatorsAsXML();
            ValidatorRuntime.getPreferences().setValue(PREF_VALIDATOR_XML, xml);
            ValidatorRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.validators.core", 0, Messages.ValidatorRuntime_exceptionOccurred, (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.validators.core", 0, Messages.ValidatorRuntime_exceptionOccurred, (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.validators.core", 0, Messages.ValidatorRuntime_exceptionOccurred, (Throwable)e));
        }
    }

    private static String getValidatorsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        IValidatorType[] validatorTypes = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < validatorTypes.length) {
            container.addValidators(validatorTypes[i].getValidators());
            ++i;
        }
        return container.getAsXML();
    }

    private static boolean addPersistedValidators(ValidatorDefinitionsContainer interpreterDefs) throws IOException {
        String validatorXMLString = ValidatorRuntime.getPreferences().getString(PREF_VALIDATOR_XML);
        if (validatorXMLString.length() > 0) {
            try {
                interpreterDefs.parseXML(new InputSource(new StringReader(validatorXMLString)));
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public static Preferences getPreferences() {
        return ValidatorsCore.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        ValidatorsCore.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeValidators() {
        ValidatorDefinitionsContainer validatorDefs = null;
        boolean setPref = false;
        Object object = fgValidatorLock;
        synchronized (object) {
            if (isInitialized) {
                return;
            }
            isInitialized = true;
            try {
                fgInitializingValidators = true;
                try {
                    validatorDefs = new ValidatorDefinitionsContainer();
                    setPref = ValidatorRuntime.addPersistedValidators(validatorDefs);
                }
                catch (IOException iOException) {}
            }
            finally {
                fgInitializingValidators = false;
            }
        }
        if (validatorDefs != null) {
            IValidatorType[] validatorTypes = null;
            try {
                validatorTypes = ValidatorManager.getAllValidatorTypes();
            }
            catch (CoreException e1) {
                return;
            }
            block14: for (IValidator validator : validatorDefs.getValidatorList()) {
                String typeId = validator.getValidatorType().getID();
                int j = 0;
                while (j < validatorTypes.length) {
                    IValidatorType validatorType = validatorTypes[j];
                    if (typeId.equals(validatorType.getID())) {
                        if (validatorType.findValidator(validator.getID()) != null) continue block14;
                        validatorType.addValidator(validator);
                        continue block14;
                    }
                    ++j;
                }
            }
            if (setPref) {
                try {
                    String xml = validatorDefs.getAsXML();
                    ValidatorRuntime.getPreferences().setValue(PREF_VALIDATOR_XML, xml);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                }
                catch (IOException iOException) {
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
        }
    }

    public static void addValidatorChangedListener(IValidatorChangedListener listener) {
        fgValidatorListeners.add((Object)listener);
    }

    public static void removeValidatorChangedListener(IValidatorChangedListener listener) {
        fgValidatorListeners.remove((Object)listener);
    }

    public static void fireValidatorChanged(IValidator validator) {
        for (IValidatorChangedListener iValidatorChangedListener : fgValidatorListeners) {
        }
    }

    public static void fireValidatorAdded(IValidator Interpreter) {
        if (!fgInitializingValidators) {
            for (IValidatorChangedListener iValidatorChangedListener : fgValidatorListeners) {
            }
        }
    }

    public static void fireValidatorRemoved(IValidator Interpreter) {
        for (IValidatorChangedListener iValidatorChangedListener : fgValidatorListeners) {
        }
    }

    public static IValidatorType[] getPossibleValidatorTypes() {
        ArrayList<IValidatorType> possible = new ArrayList<IValidatorType>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            if (!vals[i].isBuiltin()) {
                possible.add(vals[i]);
            }
            ++i;
        }
        return possible.toArray(new IValidatorType[possible.size()]);
    }

    public static IValidator[] getAllValidators() {
        ArrayList<IValidator> possible = new ArrayList<IValidator>();
        IValidatorType[] vals = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < vals.length) {
            IValidator[] v = vals[i].getValidators();
            int j = 0;
            while (j < v.length) {
                if (!possible.contains(v[j])) {
                    possible.add(v[j]);
                }
                ++j;
            }
            ++i;
        }
        return possible.toArray(new IValidator[possible.size()]);
    }

    private static ISourceModule[] filterModulesForValidator(List elements, IValidator v, IProgressMonitor monitor) {
        ArrayList<ISourceModule> result = new ArrayList<ISourceModule>();
        String nature = v.getValidatorType().getNature();
        for (IModelElement el : elements) {
            if (!(el instanceof ISourceModule)) continue;
            ISourceModule module = (ISourceModule)el;
            IDLTKLanguageToolkit toolkit = null;
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module);
            if ((toolkit == null || !toolkit.getNatureId().equals(nature)) && !nature.equals(ANY_NATURE)) continue;
            result.add(module);
        }
        return result.toArray(new ISourceModule[result.size()]);
    }

    public static void executeCleanAllValidatorsWithConsole(List elements, List resources) {
        ValidatorRuntime.executeCleanAllValidatorsWithConsole(elements, resources);
    }

    public static IValidator[] getProjectValidators(IScriptProject project, Class validatorType, IValidatorPredicate predicate) {
        String[] natureIds;
        try {
            natureIds = project.getProject().getDescription().getNatureIds();
        }
        catch (CoreException e) {
            ValidatorsCore.log(e.getStatus());
            natureIds = new String[]{};
        }
        ArrayList<IValidator> result = new ArrayList<IValidator>();
        IValidatorType[] types = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < types.length) {
            IValidatorType type = types[i];
            if (ValidatorRuntime.checkValidatorTypeNature(type, natureIds) && type.supports(validatorType)) {
                IValidator[] validators = type.getValidators();
                int j = 0;
                while (j < validators.length) {
                    IValidator validator = validators[j];
                    if (predicate.evaluate(validator) && validator.isValidatorValid(project)) {
                        result.add(validator);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IValidator[result.size()]);
    }

    private static boolean checkValidatorTypeNature(IValidatorType type, String[] natureIds) {
        String natureId = type.getNature();
        if (ANY_NATURE.equals(natureId)) {
            return true;
        }
        int i = 0;
        while (i < natureIds.length) {
            if (natureId.equals(natureIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IStatus executeSourceModuleValidators(IScriptProject project, List sourceModules, IValidatorOutput output, IValidatorPredicate predicate, IProgressMonitor monitor) {
        IValidator[] validators = ValidatorRuntime.getProjectValidators(project, ISourceModuleValidator.class, predicate);
        if (validators.length != 0) {
            return ValidatorRuntime.executeSourceModuleValidators(project, sourceModules, output, validators, monitor);
        }
        return Status.OK_STATUS;
    }

    public static IStatus executeSourceModuleValidators(IScriptProject project, List sourceModules, IValidatorOutput output, IValidator[] validators, IProgressMonitor monitor) {
        monitor.beginTask(Messages.ValidatorRuntime_runningValidators, validators.length * 100);
        int i = 0;
        while (i < validators.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IValidator validator = validators[i];
            ISourceModuleValidator mValidator = (ISourceModuleValidator)validator.getValidator(project, ISourceModuleValidator.class);
            if (mValidator != null) {
                ISourceModule[] mArray = ValidatorRuntime.filterModulesForValidator(sourceModules, validator, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 100);
                if (mArray.length != 0) {
                    mValidator.validate(mArray, output, (IProgressMonitor)submonitor);
                }
                submonitor.done();
            }
            ++i;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public static IStatus executeAutomaticResourceValidators(IScriptProject project, List resources, IValidatorOutput output, IProgressMonitor monitor) {
        return ValidatorRuntime.executeResourceValidators(project, resources, output, new AutomaticValidatorPredicate(project), monitor);
    }

    public static IStatus executeResourceValidators(IScriptProject project, List resources, IValidatorOutput output, IValidatorPredicate predicate, IProgressMonitor monitor) {
        IValidator[] validators = ValidatorRuntime.getProjectValidators(project, IResourceValidator.class, predicate);
        if (validators.length != 0) {
            IResource[] resArray = resources.toArray(new IResource[resources.size()]);
            monitor.beginTask(Messages.ValidatorRuntime_runningValidators, validators.length * 100);
            int i = 0;
            while (i < validators.length) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IValidator validator = validators[i];
                IResourceValidator resourceValidator = (IResourceValidator)validator.getValidator(project, IResourceValidator.class);
                if (resourceValidator != null) {
                    SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 100);
                    resourceValidator.validate(resArray, output, (IProgressMonitor)submonitor);
                    submonitor.done();
                }
                ++i;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public static void cleanAll(IScriptProject project, ISourceModule[] modules, IResource[] resources, IProgressMonitor monitor) {
        IValidatorType[] types = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < types.length) {
            IValidatorType type = types[i];
            IValidator[] validators = type.getValidators();
            int j = 0;
            while (j < validators.length) {
                IResourceValidator rValidator;
                IValidator validator = validators[j];
                ISourceModuleValidator smValidator = (ISourceModuleValidator)validator.getValidator(project, ISourceModuleValidator.class);
                if (smValidator != null) {
                    smValidator.clean(modules);
                }
                if ((rValidator = (IResourceValidator)validator.getValidator(project, IResourceValidator.class)) != null) {
                    rValidator.clean(resources);
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireValidatorChanged() {
        Object object = fgValidatorLock;
        synchronized (object) {
            isInitialized = false;
        }
        Object[] listeners = fgValidatorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IValidatorChangedListener listener = (IValidatorChangedListener)listeners[i];
            listener.validatorChanged();
            ++i;
        }
    }

    public static class AutomaticValidatorPredicate
    implements IValidatorPredicate {
        private final IScriptProject project;

        public AutomaticValidatorPredicate(IScriptProject project) {
            this.project = project;
        }

        public boolean evaluate(IValidator validator) {
            return validator.isAutomatic(this.project);
        }
    }
}

