/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.internal.mylyn.ui.commit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.internal.mylyn.ui.EGitMylynUI;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;

public class TaskReferenceFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_TYPES = new Class[]{AbstractTaskReference.class};
    private static final String BUGTRACK_SECTION = "bugtracker";
    private static final String BUGTRACK_URL = "url";

    public Class[] getAdapterList() {
        Class[] c = new Class[ADAPTER_TYPES.length];
        System.arraycopy(ADAPTER_TYPES, 0, c, 0, c.length);
        return c;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!AbstractTaskReference.class.equals((Object)adapterType)) {
            return null;
        }
        return this.adaptFromObject(adaptableObject);
    }

    private AbstractTaskReference adaptFromObject(Object element) {
        RevCommit commit = TaskReferenceFactory.getCommitForElement(element);
        if (commit != null) {
            return this.adaptFromRevCommit(commit);
        }
        return null;
    }

    private AbstractTaskReference adaptFromRevCommit(RevCommit commit) {
        Repository[] repositories;
        Repository[] repositoryArray = repositories = Activator.getDefault().getRepositoryCache().getAllRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                Repository r = repositoryArray[n2];
                String repoUrl = null;
                String message = null;
                long timestamp = 0L;
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try (RevWalk revWalk = new RevWalk(r);){
                        RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commit);
                        repoUrl = TaskReferenceFactory.getRepoUrl(r);
                        message = revCommit.getFullMessage();
                        timestamp = (long)revCommit.getCommitTime() * 1000L;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    break block16;
                }
                catch (RuntimeException e) {
                    break block16;
                }
                if (message != null && message.trim().length() != 0) {
                    TaskRepository repository;
                    String taskRepositoryUrl = null;
                    if (repoUrl != null && (repository = this.getTaskRepositoryByGitRepoURL(repoUrl)) != null) {
                        taskRepositoryUrl = repository.getRepositoryUrl();
                    }
                    return new LinkedTaskInfo(taskRepositoryUrl, null, null, message, timestamp);
                }
            }
            ++n2;
        }
        return null;
    }

    private static RevCommit getCommitForElement(Object element) {
        RevCommit commit = null;
        if (element instanceof RevCommit) {
            commit = (RevCommit)element;
        } else if (element instanceof GitModelCommit) {
            GitModelCommit modelCommit = (GitModelCommit)element;
            if (!(modelCommit.getParent() instanceof GitModelRepository)) {
                return null;
            }
            GitModelRepository parent = (GitModelRepository)modelCommit.getParent();
            Repository repo = parent.getRepository();
            AbbreviatedObjectId id = modelCommit.getCachedCommitObj().getId();
            Throwable throwable = null;
            Object var7_8 = null;
            try (RevWalk rw = new RevWalk(repo);){
                commit = rw.lookupCommit((AnyObjectId)id.toObjectId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return commit;
    }

    private TaskRepository getTaskRepositoryByGitRepoURL(String repoUrl) {
        if (repoUrl == null) {
            return null;
        }
        try {
            return this.getTaskRepositoryByHost(new URIish(repoUrl).getHost());
        }
        catch (Exception ex) {
            EGitMylynUI.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.egit.mylyn.ui", "failed to get repo url", (Throwable)ex));
            return null;
        }
    }

    private static String getRepoUrl(Repository repo) {
        String configuredUrl = repo.getConfig().getString(BUGTRACK_SECTION, null, BUGTRACK_URL);
        String originUrl = repo.getConfig().getString("remote", "origin", BUGTRACK_URL);
        return configuredUrl != null ? configuredUrl : originUrl;
    }

    private TaskRepository getTaskRepositoryByHost(String host) {
        List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
        if (repositories == null || repositories.isEmpty()) {
            return null;
        }
        if (repositories.size() == 1) {
            return (TaskRepository)repositories.iterator().next();
        }
        for (TaskRepository repository : repositories) {
            if (repository.isOffline()) continue;
            try {
                URL url = new URL(repository.getRepositoryUrl());
                if (!this.isSameHosts(host, url.getHost())) continue;
                return repository;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isSameHosts(String name1, String name2) {
        String resolvedHostName;
        String hostname2;
        String hostname1 = name1 == null ? "" : name1.trim();
        String string = hostname2 = name2 == null ? "" : name2.trim();
        if (hostname1.equals(hostname2)) {
            return true;
        }
        String localHost = "localhost";
        try {
            resolvedHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            resolvedHostName = localHost;
        }
        if (hostname1.length() == 0) {
            hostname1 = resolvedHostName;
        }
        if (hostname2.length() == 0) {
            hostname2 = resolvedHostName;
        }
        if (hostname1.equals(hostname2)) {
            return true;
        }
        return hostname1.equals(localHost) && hostname2.equals(resolvedHostName) || hostname1.equals(resolvedHostName) && hostname2.equals(localHost);
    }
}

