/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CDOFeatureType {
    NONE{

        public boolean matches(EStructuralFeature feature) {
            return false;
        }
    }
    ,
    ALL{

        public boolean matches(EStructuralFeature feature) {
            return true;
        }
    }
    ,
    ATTRIBUTE{

        public boolean matches(EStructuralFeature feature) {
            return feature instanceof EAttribute;
        }
    }
    ,
    REFERENCE{

        public boolean matches(EStructuralFeature feature) {
            return feature instanceof EReference;
        }
    }
    ,
    CONTAINER{

        public boolean matches(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainer();
            }
            return false;
        }
    }
    ,
    CONTAINMENT{

        public boolean matches(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return reference.isContainment();
            }
            return false;
        }
    }
    ,
    XREF{

        public boolean matches(EStructuralFeature feature) {
            if (feature instanceof EReference) {
                EReference reference = (EReference)feature;
                return !reference.isContainer() && !reference.isContainment();
            }
            return false;
        }
    };


    private CDOFeatureType() {
    }

    public abstract boolean matches(EStructuralFeature var1);

    public static boolean matchesCombination(EStructuralFeature feature, Collection<CDOFeatureType> featureTypes) {
        if (featureTypes != null) {
            for (CDOFeatureType featureType : featureTypes) {
                if (!featureType.matches(feature)) continue;
                return true;
            }
        }
        return false;
    }

    public static CDOFeatureType read(String str) {
        if (str != null) {
            str = str.trim().toUpperCase();
            try {
                return CDOFeatureType.valueOf(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NONE;
    }

    public static Set<CDOFeatureType> readCombination(String str) {
        if (str != null) {
            str = str.replace(' ', '|').replace(',', '|').replace(';', '|');
            HashSet<CDOFeatureType> result = new HashSet<CDOFeatureType>();
            String[] stringArray = str.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                CDOFeatureType featureType = CDOFeatureType.read(token);
                if (featureType != NONE) {
                    result.add(featureType);
                }
                ++n2;
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static String writeCombination(Collection<CDOFeatureType> featureTypes) {
        if (featureTypes != null) {
            if (!(featureTypes instanceof Set)) {
                featureTypes = new HashSet<CDOFeatureType>(featureTypes);
            }
            if (featureTypes.contains((Object)ALL)) {
                return ALL.toString();
            }
            if (featureTypes.contains((Object)REFERENCE)) {
                featureTypes.remove((Object)CONTAINER);
                featureTypes.remove((Object)CONTAINMENT);
                featureTypes.remove((Object)XREF);
            }
            featureTypes.remove((Object)NONE);
            ArrayList<CDOFeatureType> list = new ArrayList<CDOFeatureType>(featureTypes);
            Collections.sort(list);
            StringBuilder result = new StringBuilder();
            for (CDOFeatureType featureType : list) {
                if (result.length() != 0) {
                    result.append("|");
                }
                result.append((Object)featureType);
            }
            return result.toString();
        }
        return "";
    }

    /* synthetic */ CDOFeatureType(String string, int n, CDOFeatureType cDOFeatureType) {
        this();
    }
}

